<?php $__env->startSection('pageTitle'); ?>
    <title><?php echo e(Lang::get('main.home_page_title')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('contentHeader'); ?>
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="<?php echo e(URL('/admin')); ?>"><?php echo e(Lang::get('main.dashboard')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="<?php echo e(URL('/admin/users')); ?>"><?php echo e(Lang::get('main.users')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span><?php echo e(Lang::get('main.edit')); ?></span>
            </li>
            <li>
                <span><?php echo e($post->name); ?></span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> <?php echo e(Lang::get('main.users')); ?>

        <small><?php echo e(Lang::get('main.edit')); ?></small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase"><?php echo e(Lang::get('main.users')); ?></span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                <?php echo Form::open(['method'=>'PUT','url'=>'admin/users/'.$post->id,'id'=>'addUsersEditForm','class'=>"form-horizontal"]); ?>

                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        <?php echo e(Lang::get('main.form_validation_error')); ?>

                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        <?php echo e(Lang::get('main.form_validation_success')); ?>

                    </div>
                    <div class="form-group col-lg-12">
                        <label for="profile_id"><?php echo e(Lang::get('main.profiles')); ?></label>
                        <select style="width: 100%;" id="profile_id" class="form-control sel2" name="profile_id">
                            <?php $__currentLoopData = $profiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $profile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option <?php if($post->profile_id==$profile->id): ?> selected="selected" <?php endif; ?> value="<?php echo e($profile->id); ?>"><?php echo e($profile->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group col-lg-9">
                        <label class="control-label" for="name"><?php echo e(Lang::get('main.name')); ?>  <span class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="<?php echo e($post->name); ?>" id="name" name="name" data-required="1" placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.name')); ?>">
                        </div>
                    </div>
                    <div class="form-group col-lg-3 text-center" style="margin-top:25px;">
                        <input type="checkbox" class="make-switch" name="active" value="1" <?php if($post->active==1): ?> checked <?php endif; ?> data-size="small" data-on-color="success" data-on-text="<?php echo e(Lang::get('main.active')); ?>" data-off-color="default" data-off-text="<?php echo e(Lang::get('main.inActive')); ?>">
                    </div>
                    <div class="clearfix"></div>
                    <div class="form-group col-lg-12">
                        <label class=" control-label" for="website"><?php echo e(Lang::get('main.email')); ?>  <span class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="email" class="form-control" id="email" value="<?php echo e($post->email); ?>" name="email" data-required="1" placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.email')); ?>">
                        </div>
                    </div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="username"><?php echo e(Lang::get('main.username')); ?>  <span class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" id="username" value="<?php echo e($post->username); ?>" name="username"  data-required="1" placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.username')); ?>">
                        </div>
                    </div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="password"><?php echo e(Lang::get('main.password')); ?>  <span class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="password" class="form-control" id="password" name="password" data-required="1" placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.password')); ?>">
                        </div>
                    </div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="confirm_password"><?php echo e(Lang::get('main.confirm_password')); ?>  <span class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="password" class="form-control" id="confirm_password" name="confirm_password" data-required="1" placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.confirm_password')); ?>">
                        </div>
                    </div>
                    <div class="text-center">
                        <div class="fileinput fileinput-new" data-provides="fileinput">
                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px; border: none">
                                <img src="<?php echo e(asset($post->img_dir.$post->img)); ?>" alt="" /> </div>
                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"> </div>
                            <div >
                                <span class="btn default btn-file">
                                    <span class="fileinput-new"> <?php echo e(Lang::get('main.select_image')); ?> </span>
                                    <span class="fileinput-exists"> <?php echo e(Lang::get('main.change')); ?> </span>
                                    <input type="file" name="image"> </span>
                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> <?php echo e(Lang::get('main.remove')); ?> </a>
                            </div>
                        </div>
                    </div>
                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green"><?php echo e(Lang::get('main.save')); ?></button>
                    </div>
                </div>
                <div class="clearfix" style="height: 30px"></div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scriptCode'); ?>
    <script>
        $(document).ready(function(){
            $(document).on('change','#all_projects',function(){
                if($(this).is(':checked')){
                    $("#projects_ids").attr('disabled','disabled');
                }else{
                    $("#projects_ids").removeAttr('disabled')
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('auth.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ebacademy/public_html/e3melbusiness.org/adminResources/resources/views/auth/users/edit.blade.php ENDPATH**/ ?>