<?php $__env->startSection('pageTitle'); ?>
    <title><?php echo e(Lang::get('main.home_page_title')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contentHeader'); ?>
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="<?php echo e(URL('/admin')); ?>"><?php echo e(Lang::get('main.dashboard')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="<?php echo e(URL('/admin/courses')); ?>"><?php echo e(Lang::get('main.courses')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span><?php echo e(Lang::get('main.edit')); ?></span>
            </li>

        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> <?php echo e(Lang::get('main.courses')); ?>

        <small><?php echo e(Lang::get('main.edit')); ?></small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <style>
        .form-group {
            margin-left: 0px !important;
            margin-right: 0px !important;
        }
    </style>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase"><?php echo e(Lang::get('main.courses')); ?></span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                <?php echo Form::open(['method'=>'PUT','url'=>'admin/courses/'.$course->id,'class'=>"form-horizontal",'files'=>true]); ?>

                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        <?php echo e(Lang::get('main.form_validation_error')); ?>

                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        <?php echo e(Lang::get('main.form_validation_success')); ?>

                    </div>
                </div>

                <div id="messages"></div>
                <div class="form-group col-lg-7">
                    <label class="control-label" for="name"><?php echo e(Lang::get('main.name')); ?> <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($course->name); ?>" name="name"
                               data-required="1"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.name')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-2">
                    <label for="direction"><?php echo e(Lang::get('main.direction')); ?></label>
                    <select id="direction" name="direction" class="form-control">
                        <option value="rtl" <?php if($course->direction == 'rtl'): ?> selected <?php endif; ?>>Arabic</option>
                        <option value="ltr" <?php if($course->direction == 'ltr'): ?> selected <?php endif; ?>>English</option>
                    </select>
                </div>
                <div class="form-group col-lg-3 text-center" style="margin-top:25px;">
                    <input type="checkbox" class="make-switch" name="published" value="yes"
                           <?php if($course->published=="yes"): ?> checked <?php endif; ?> data-size="small" data-on-color="success"
                           data-on-text="<?php echo e(Lang::get('main.published')); ?>" data-off-color="default" data-off-text="<?php echo e(Lang::get('main.unpublished')); ?>">
                </div>
                <div class="clearfix"></div>
                <div class="form-group col-lg-6">
                    <label class="control-label"
                           for="short_description"><?php echo e(Lang::get('main.short_description')); ?></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($course->short_description); ?>"
                               name="short_description"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.short_description')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="lectures"><?php echo e(Lang::get('main.lectures')); ?></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($course->lectures); ?>" name="lectures"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.lectures')); ?>">
                    </div>
                </div>

                <?php echo $__env->make('auth/description',['selectors'=>'.description,.get_from_course,.references', 'labels'=>[Lang::get('main.description'),Lang::get('main.get_from_course'),Lang::get('main.references')], 'posts'=>[$course->description,$course->get_from_course,$course->references] ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="form-group col-lg-12">
                    <label class="control-label"><?php echo e(Lang::get('main.image')); ?></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <img style="width:20%;" src="<?php echo e(assetURL($course->image)); ?>">
                    </div>
                </div>

                <div class="form-group col-lg-6">
                    <label class="control-label"
                           for="image"><?php echo e(Lang::get('main.replace')); ?> <?php echo e(Lang::get('main.image')); ?></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="file" class="form-control" value="" accept="image/*"
                               name="image" placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.image')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="length"><?php echo e(Lang::get('main.length')); ?></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($course->length); ?>" name="length"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.length')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="url"><?php echo e(Lang::get('main.url')); ?> <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($course->url); ?>" name="url" data-required="1"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.url')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="code"><?php echo e(Lang::get('main.code')); ?> <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($course->code); ?>" name="code" data-required="1"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.code')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="egy_price"><?php echo e(Lang::get('main.egy_price')); ?> <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($course->egy_price); ?>" name="egy_price"
                               data-required="1"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.egy_price')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="ksa_price"><?php echo e(Lang::get('main.ksa_price')); ?> <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($course->ksa_price); ?>" name="ksa_price"
                               data-required="1"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.ksa_price')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="intro_video"><?php echo e(Lang::get('main.intro_video')); ?> <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($course->intro_vedio); ?>" name="intro_video"
                               data-required="1"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.intro_video')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="meta_description"><?php echo e(Lang::get('main.meta_description')); ?> <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($course->meta_description); ?>"
                               name="meta_description" data-required="1"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.meta_description')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label"
                           for="curriculum_number"><?php echo e(Lang::get('main.curriculum_number')); ?></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($course->curriculum_number); ?>"
                               name="curriculum_number"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.curriculum_number')); ?>">
                    </div>
                </div>

                <div class="form-group col-lg-6">
                    <label class="control-label" for="en_name"><?php echo e(Lang::get('main.en_name')); ?> <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($course->en_name); ?>" name="en_name"
                               data-required="1"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.en_name')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label for="instructor"><?php echo e(Lang::get('main.instructor')); ?><span
                                class="required"> * </span></label>
                    <select name="instructor" class="module_name sel2 form-control form-filter">
                        <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.instructor')); ?></option>
                        <?php $__currentLoopData = $instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id=>$name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php if($course->instractor==$id): ?> selected="selected"
                                    <?php endif; ?> value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="form-group col-lg-6">
                    <label for="type"><?php echo e(Lang::get('main.isclose')); ?><span
                                class="required"> * </span></label>
                    <select name="isclose" class="module_name sel2 form-control form-filter">
                        <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.isclose')); ?></option>
                        <option <?php if($course->isclose==1): ?> selected="selected" <?php endif; ?> value="1">Yes</option>
                        <option <?php if($course->isclose==0): ?> selected="selected" <?php endif; ?> value="0">No</option>
                    </select>
                </div>
                
                    
                                
                    
                        
                        
                        
                    
                
                <div class="form-group col-lg-6">
                    <label for="location"><?php echo e(Lang::get('main.location')); ?></label>
                    <select name="location" class="module_name sel2 form-control form-filter">
                        <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.location')); ?></option>
                        <option <?php if($course->location=='egy'): ?> selected="selected" <?php endif; ?> value="egy">egy</option>
                        <option <?php if($course->location=='ksa'): ?> selected="selected" <?php endif; ?> value="ksa">ksa</option>
                        <option <?php if($course->location=='onlyeg'): ?> selected="selected" <?php endif; ?> value="onlyeg">onlyeg
                        </option>
                    </select>
                </div>

                <div class="form-group col-lg-6">
                    <label for="course_type"><?php echo e(Lang::get('main.course_type')); ?></label>
                    <select name="course_type" class="module_name sel2 form-control form-filter">
                        <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.course_type')); ?></option>
                        <option <?php if($course->course_type=='paid'): ?> selected="selected" <?php endif; ?> value="paid">paid</option>
                        <option <?php if($course->course_type=='free'): ?> selected="selected" <?php endif; ?> value="free">free</option>
                    </select>
                </div>
                <div class="form-group col-lg-6">
                    <label for="category"><?php echo e(Lang::get('main.all_category')); ?></label>
                    <select id="category" name="category" class="module_name sel2 form-control form-filter">
                        <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.all_category')); ?></option>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id=>$name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php if($course->category_id==$id): ?> selected="selected"
                                    <?php endif; ?> value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group col-lg-6">
                    <label for="sub_category"><?php echo e(Lang::get('main.sub_category')); ?></label>
                    <select id="sub_category" name="sub_category" class="module_name sel2 form-control form-filter">
                        <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.sub_category')); ?></option>
                        <?php $__currentLoopData = $sub_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id=>$name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php if($course->sup_category_id==$id): ?> selected="selected"
                                    <?php endif; ?> value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group col-lg-6">
                    <label for="show_on"><?php echo e(Lang::get('main.show_on')); ?></label>
                    <select name="show_on" class="module_name sel2 form-control form-filter">
                        <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.show_on')); ?></option>
                        <option <?php if($course->show_on=='courses'): ?> selected="selected" <?php endif; ?> value="courses">courses
                        </option>


                        <option <?php if($course->show_on=='diplomas_mba'): ?> selected="selected" <?php endif; ?> value="diplomas_mba">
                            diplomas_mba
                        </option>

                        <?php if(!PerUser('remove_medical')): ?>{
                        <option <?php if($course->show_on=='medical'): ?> selected="selected" <?php endif; ?> value="medical">medical
                        <?php endif; ?>
                        </option>

                        <option <?php if($course->show_on=='diplomas_mba_training_program'): ?> selected="selected" <?php endif; ?> value = "diplomas_mba_training_program" >diplomas_mba_training_program</option>

                        <option <?php if($course->show_on=='training_program'): ?> selected="selected" <?php endif; ?> value = "training_program" >training_program</option>
                        <option <?php if($course->show_on=='dba'): ?> selected="selected" <?php endif; ?> value = "dba" >dba</option>
                        <option <?php if($course->show_on=='dba_diplomas_mba'): ?> selected="selected" <?php endif; ?> value = "dba_diplomas_mba" >dba & diplomas &mba</option>

                        <option <?php if($course->show_on=='all'): ?> selected="selected" <?php endif; ?> value="all">all</option>
                    </select>
                </div>

                <div class="form-group col-lg-6">
                    <label class="control-label" for="sort"><?php echo e(Lang::get('main.sort')); ?> <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($course->sort); ?>" name="sort" data-required="1"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.sort')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="hours_numbers"><?php echo e(Lang::get('main.hours_numbers')); ?> <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa fa-sort-numeric-asc"></i>
                        <input type="number" class="form-control" value="<?php echo e($course->hours_numbers); ?>" name="hours_numbers" placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.hours_numbers')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label for="statues"><?php echo e(Lang::get('main.statues')); ?> <span
                                class="required"> * </span></label>
                    <select name="statues" class="module_name sel2 form-control form-filter">
                        <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.statues')); ?></option>
                        <option <?php if($course->statues!='old'): ?> selected="selected" <?php endif; ?> value="new">new</option>
                        <option <?php if($course->statues=='old'): ?> selected="selected" <?php endif; ?> value="old">old</option>
                    </select>
                </div>

                <div class="clearfix"></div>
                <div class="text-center col-lg-12">
                    <button type="submit" class="btn green"><?php echo e(Lang::get('main.save')); ?></button>
                </div>
                <div class="clearfix"></div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scriptCode'); ?>
    <script>
        $(document).ready(function () {
            $('#category').change(function () {
                $.ajax({
                    type: "POST",
                    url: "<?php echo e(URL('admin/courses/getSubCategoriesByCategoryId')); ?>",
                    data: {"category_id": $(this).val(), "_token": "<?php echo e(csrf_token()); ?>"},
                    success: function (options) {
                        $('#sub_category').empty().append(options);
                    }
                });
            })

        })

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('auth.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ebacademy/public_html/e3melbusinessyottacourses.elbazdev.com/adminResources/resources/views/auth/courses/edit.blade.php ENDPATH**/ ?>