<?php $__env->startSection('pageTitle'); ?>
    <title><?php echo e(Lang::get('main.home_page_title')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('contentHeader'); ?>
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="<?php echo e(URL('/admin')); ?>"><?php echo e(Lang::get('main.dashboard')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span><?php echo e(Lang::get('main.courses')); ?></span>
            </li>
        </ul>

    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> <?php echo e(Lang::get('main.courses')); ?>

        <small><?php echo e(Lang::get('main.view')); ?></small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<style>
    td {
        word-wrap: break-word;
        overflow-wrap: break-word;
    }
</style>
    <?php if(PerUser('courses_add')): ?>
        <div class="row">
            <div class="col-md-12">
                <div class="btn-group pull-right">
                    <a href="<?php echo e(URL('admin/courses/create')); ?>" id="sample_editable_1_new" class="btn green">
                        <?php echo e(Lang::get('main.add_new')); ?>

                        <i class="fa fa-plus"></i>
                    </a>
                    <form action="<?php echo e(URL('admin/courses_search')); ?>" id="exportForm" method="POST">
                        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                        <button class="btn btn-success" name="export" value="true" type="submit">Export</button>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <?php if(PerUser('courses_view')): ?>
        <div class="row">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-users font-dark"></i>
                        <span class="caption-subject bold uppercase"><?php echo e(Lang::get('main.courses')); ?></span>
                    </div>
                    <div class="tools"></div>
                    <div class="clearfix"></div>
                    <div class="form-group">
                        <div class="mt-checkbox-list">
                            <label class="mt-checkbox mt-checkbox-outline">
                                <input type="checkbox" id="section_not_published" name="section_not_published" value="1"> Sections not published OR no Sections
                                <span></span>
                            </label>
                        </div>
                        <div class="mt-checkbox-list">
                            <label class="mt-checkbox mt-checkbox-outline">
                                <input type="checkbox" id="curriculum_not_published" name="curriculum_not_published" value="1"> Curriculum not published OR no Curriculum
                                <span></span>
                            </label>
                        </div>
                    </div>

                </div>
                <div class="portlet-body">
                    <table style=" table-layout: fixed;width: 100%;" class="table table-striped table-bordered table-hover table-checkable" width="100%"
                           id="datatable_ajax">
                        <thead>
                        <tr role="row" class="heading">
                            <th> #</th>
                            <th><?php echo e(Lang::get('main.name')); ?></th>
                            <th><?php echo e(Lang::get('main.url')); ?></th>
                            <th><?php echo e(Lang::get('main.instructor')); ?></th>
                            <th><?php echo e(Lang::get('main.en_name')); ?></th>
                            <th><?php echo e(Lang::get('main.rating')); ?></th>
                            <th><?php echo e(Lang::get('main.rating_count')); ?></th>
                            <th><?php echo e(Lang::get('main.view')); ?></th>
                            <th><?php echo e(Lang::get('main.sent')); ?></th>
                            <th><?php echo e(Lang::get('main.certificate_increment')); ?></th>
                            <th><?php echo e(Lang::get('main.show_on')); ?></th>
                            <th><?php echo e(Lang::get('main.sort')); ?></th>
                            <th><?php echo e(Lang::get('main.created_time')); ?></th>
                            <th><?php echo e(Lang::get('main.published')); ?></th>
                            <th></th>
                        </tr>
                        <tr role="row" class="filter">
                            <td>
                                <input type="hidden" id="_token" name="_token" value="<?php echo e(csrf_token()); ?>">
                                <input type="number" min="1" class="form-control form-filter input-sm" name="id">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="course_name">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="url">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="instructor_name">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="en_name">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="rating">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="rating_count">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="view">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="sent">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="certificate_increment">
                            </td>
                            <td>
                                <select name="show_on" class="module_name sel2 form-control form-filter">
                                    <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.show_on')); ?></option>
                                    <option value="courses">courses</option>

                                    <option value="diplomas_mba">diplomas_mba</option>


                                    <option value = "diplomas_mba_training_program" >diplomas_mba_training_program</option>

                                    <option value = "training_program" >training_program</option>
                                    <option value = "dba" >dba</option>
                                    <option value = "dba_diplomas_mba" >dba & diplomas &mba</option>


                                <?php if(!PerUser('remove_medical')): ?>{
                                    <option value="medical">medical</option>
                                    <?php endif; ?>
                                    <option value="all">all</option>
                                </select>
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="sort">
                            </td>
                            <td>
                                <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                    <input type="text" class="form-control form-filter input-sm"
                                           name="created_time_from" placeholder="<?php echo e(Lang::get('main.from')); ?>">
                                    <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                </div>
                                <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                    <input type="text" class="form-control form-filter input-sm"
                                           name="created_time_to" placeholder="<?php echo e(Lang::get('main.to')); ?>">
                                    <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                </div>
                            </td>
                            <td>
                                <select name="published" class="module_name sel2 form-control form-filter">
                                    <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.published')); ?></option>
                                    <option value="yes">Yes</option>
                                    <option value="no">No</option>
                                </select>
                            </td>
                            <td>
                                <div class="margin-bottom-5">
                                    <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                        <i class="fa fa-search"></i> <?php echo e(Lang::get('main.search')); ?></button>
                                </div>
                                <button class="btn btn-sm red btn-outline filter-cancel">
                                    <i class="fa fa-times"></i> <?php echo e(Lang::get('main.reset')); ?></button>
                            </td>

                        </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- Modal -->
        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
             aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><?php echo e(Lang::get('main.confirmation')); ?>!!</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <?php echo e(Lang::get('main.are_you_sure_you_want_to_delete')); ?>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal"><?php echo e(Lang::get('main.cancel')); ?></button>
                        <button type="button" class="btn btn-primary confirm_deletion"
                                data-dismiss="modal"><?php echo e(LAng::get('main.delete')); ?></button>
                    </div>
                </div>
            </div>
        </div>
        <!-- reset password modal -->
        <div class="modal fade" id="resetPasswordModal" tabindex="-1" role="dialog" aria-labelledby="resetPasswordModalLabel"
             aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="resetPasswordModalLabel"><?php echo e(Lang::get('main.confirmation')); ?>!!</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <?php echo e(Lang::get('main.are_you_sure_you_want_to_reset_password')); ?>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal"><?php echo e(Lang::get('main.cancel')); ?></button>
                        <button type="button" class="btn btn-primary confirm_reset_password"
                                data-dismiss="modal"><?php echo e(Lang::get('main.reset_password')); ?></button>
                    </div>
                </div>
            </div>
        </div>

        <div class="clearfix"></div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scriptCode'); ?>

    <script>
        $(document).ready(function () {
            var token = "<?php echo e(csrf_token()); ?>";
            $('.form-filter').each(function(){
                $("#exportForm").append('<input type="hidden" name="'+$(this).attr('name')+'"/>');
            });
            $("#exportForm").append('<input type="hidden" name="section_not_published" value="'+($('#curriculum_not_published').is(':checked')?1:0)+'"/>');
            $("#exportForm").append('<input type="hidden" name="curriculum_not_published" value="'+($('#curriculum_not_published').is(':checked')?1:0)+'"/>');
            $(document).on('click','.filter-submit,.filter-cancel',function(){
                $('.form-filter').each(function(){
                    $("#exportForm "+"[name='"+$(this).attr('name')+"']").val($(this).val());
                })
                $("#exportForm "+"[name='section_not_published']").val($("#exportForm [name='section_not_published']").is(':checked')?1:0);
                $("#exportForm "+"[name='curriculum_not_published']").val($("#exportForm [name='curriculum_not_published']").is(':checked')?1:0);
            });
            $(document).on('change','[name="section_not_published"],[name="curriculum_not_published"]',function(){
                grid.getDataTable().ajax.reload()
            });
            $(".menu-toggler.sidebar-toggler").trigger('click');
            <?php if(PerUser('courses_publish')): ?>
            $(document).on('change', '.changeStatues', function () {
                var statues = $(this).is(':checked');
                var id = $(this).attr('data-id');
                if (statues) {
                    $.ajax({
                        type: "POST",
                        url: "<?php echo e(URL('admin/courses/publish')); ?>",
                        data: {"published": "yes", "id": id, _token: token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                } else {
                    $.ajax({
                        type: "POST",
                        url: "<?php echo e(URL('admin/courses/publish')); ?>",
                        data: {"published": "no", "id": id, _token: token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }
            });
            <?php endif; ?>
            $('.fromToDate').datepicker({
                rtl: App.isRTL(),
                autoclose: true
            });
            var grid = new Datatable();
            grid.setAjaxParam("_token", "<?php echo e(csrf_token()); ?>");
            // console.log(grid._token)
            grid.init({
                src: $("#datatable_ajax"),
                onSuccess: function (grid, response) {
                    // grid:        grid object
                    // response:    json object of server side ajax response
                    // execute some code after table records loaded
                },
                onError: function (grid) {
                    // execute some code on network or other general error
                },
                onDataLoad: function (grid) {
                },
                loadingMessage: '<?php echo e(Lang::get('main.loading')); ?>',
                dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options
                    // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                    // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                    // So when dropdowns used the scrollable div should be removed.
                    //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                    "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                    "lengthMenu": [
                        [10, 20, 50, 100, 150, <?php if(PerUser('view_all_rows')): ?> -1 <?php endif; ?>],
                        [10, 20, 50, 100, 150, <?php if(PerUser('view_all_rows')): ?> "All" <?php endif; ?>] // change per page values here
                    ],
                    "pageLength": 10, // default record count per page
                    "ajax": {
                        "url": "<?php echo e(URL('admin/courses_search')); ?>", // ajax source
                        data:function(data){
                            data.section_not_published=$('[name="section_not_published"]').is(':checked')?1:0;
                            data.curriculum_not_published=$('[name="curriculum_not_published"]').is(':checked')?1:0;
                        }
                    },
                    <?php if(getUserSystem('backend_lang')=='ar'): ?> "language": {"url": "<?php echo e(asset('assets/layouts/layout/datatables-arabic.json')); ?>"},<?php endif; ?> "columnDefs": [{
                        "targets": [0], // column or columns numbers
                        "orderable": true  // set orderable for selected columns

                    }],
                    "order": [
                        [0, "desc"]
                    ],// set first column as a default sort by asc
                    dom: 'Blfrtip',
                    buttons: [
                        {extend: 'print', className: 'btn dark btn-outline'},
                        {extend: 'pdf', className: 'btn green btn-outline'},
                        {extend: 'csv', className: 'btn purple btn-outline '}
                    ],
                }
            });
            <?php if(PerUser('courses_delete')): ?>
            $(document).on('click', '.delete_this', function (event) {

                var deleted_id = $(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '<?php echo e(Lang::get('main.delete').lang::get('main.course')); ?>',
                    message: '<?php echo e(Lang::get('main.delete_this').lang::get('main.course')); ?> ?',
                    buttons: [
                        {
                            label: '<?php echo e(Lang::get('main.yes')); ?>',
                            cssClass: 'btn-primary',
                            action: function (dialogItself) {
                                $.ajax({
                                    type: "DELETE",
                                    url: "<?php echo e(URL('admin/courses')); ?>/" + deleted_id,
                                    data: {"id": deleted_id, _token: token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $("#single-order-" + deleted_id).parent().parent().remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '<?php echo e(Lang::get('main.no')); ?>',
                            action: function (dialogItself) {
                                dialogItself.close();
                            }
                        }]
                });
            });
            <?php endif; ?>
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('auth.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ebacademy/public_html/e3melbusiness.org/adminResources/resources/views/auth/courses/view.blade.php ENDPATH**/ ?>