<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/***************************************************/

use App\Models\FuturexIntegrationCourse;
use \App\Models\Courses;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
Route::group(['prefix' => 'FUTCHER_X'], function () {
    Route::get('saveLearners',[\App\Http\Controllers\FutcherXController::class,'saveLearners']);
    Route::get('saveLearnersEnrollment',[\App\Http\Controllers\FutcherXController::class,'saveLearnersEnrollment']);
    Route::get('saveLearnersCertificates',[\App\Http\Controllers\FutcherXController::class,'saveLearnersCertificates']);
});
Route::get('futcherXSendCourse/{course_id}',function ($course_id){
   $course=Courses::find($course_id);
    $futurexCourse=FuturexIntegrationCourse::where('course_id',$course_id)->first();
    return createCourseInFutureX($course,$futurexCourse,true);
});
Route::get('updateFutcherXCourses',function(){
   foreach (FuturexIntegrationCourse::take(request('take')??100)->skip(request('skip')??0)->get() as $futurexCourse){
       $course=Courses::find($futurexCourse->course_id);
       if($course){
           createCourseInFutureX($course,$futurexCourse);
       }
   }
});
Route::get('futcherXLearners',function(){

});
Route::get('futcherXCreateLearners',function(){
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://futurex.nelc.gov.sa/oauth/token',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_id=67138905-38fe-42c8-9f75-5a744040818c&client_secret=A3rN76IYTwcN&=',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $response=json_decode($response);
    $access_token=$response->access_token;
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://futurex.nelc.gov.sa/create-learner?_format=json',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>json_encode([]),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$access_token
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    dd(json_decode($response));
});
Route::get('futcherXGetLearners/{id}',function($id){
    $curl = curl_init();

    $access_token_url='https://futurex.nelc.gov.sa/oauth/token';
//    $access_token_url='https://futurex.nelc.gov.sa/oauth/token';
    curl_setopt_array($curl, array(
        CURLOPT_URL => $access_token_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_id=67138905-38fe-42c8-9f75-5a744040818c&client_secret=A3rN76IYTwcN&=',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $response=json_decode($response);
    $access_token=$response->access_token;
//    dd($response);
    $curl = curl_init();
    $url= 'https://futurex.nelc.gov.sa/api/v1/providers/'.$id.'/learners?_format=json';
//    $url= 'https://futurex.nelc.gov.sa/api/v1/providers/'.$id.'/learners?_format=json';
    curl_setopt_array($curl, array(
        CURLOPT_URL =>$url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$access_token
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    return [
        'response'=>json_decode($response),
        'url'=>$url,
    ];
});
Route::get('futcherXEnrole/{user_id}/{course_id}',function($user_id,$course_id){
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://futurex.nelc.gov.sa/oauth/token',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_id=67138905-38fe-42c8-9f75-5a744040818c&client_secret=A3rN76IYTwcN&=',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $response=json_decode($response);
    $access_token=$response->access_token;
    $curl = curl_init();
$json='{
    "courseId": "'.$course_id.'",
    "userId": '.$user_id.',
    "approxTotalCourseHrs": 3,
    "overallProgress": 8.3333333333333,
    "membershipState": "MEMBER",
    "programId": "d2aVmqVIEeiAAwqXDFpUIA",
    "enrolledAt": 1563647032211,
    "isCompleted": false
}';
$url='https://futurex.nelc.gov.sa/enrollment-progress?_format=json';
    curl_setopt_array($curl, array(
        CURLOPT_URL =>$url ,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>$json,
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$access_token
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $response=json_decode($response);
    return [
        'url'=>$url,
        'response'=>$response,
        'data'=>json_decode($json),
    ];
});
Route::get('futcherXin',[\App\Http\Controllers\Admin\FuturexIntegrationController::class,'testUpdateCourse']);
Route::get('futcherXCreateCourseIntegration',function(){
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://futurex.nelc.gov.sa/oauth/token',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_id=67138905-38fe-42c8-9f75-5a744040818c&client_secret=A3rN76IYTwcN&=',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $response=json_decode($response);
    $access_token=$response->access_token;


    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://futurex.nelc.gov.sa/create-course?_format=json',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => '{
    "courseId": "W_mOXCrdEeeNPQ68_4aPpAtest11",
    "name": "Testing course222",
    "summary": "this is a summary for testing course",
    "description": "this is the full description for testing course",
    "pacing": "self learning",
    "courseCategory": 77,
    "estimatedLearningTime": 47153,
    "courseUrl": "https://futurex.nelc.gov.sa",
    "startsAt": "2021-11-06",
    "endsAt": "2021-12-06",
    "promoPhoto": "https://futurex.nelc.gov.sa/sites/default/files/styles/programs_land/public/2021-10/Rectangle%20766%402x_2.png",
    "courseLevel": 272,
    "coursePricing": null,
    "cost": 6000,
    "price": 1000,
    "language": 190,
    "certificateType": null,
    "prerequisites": [
        {
            "value": "prerequisites 1"
        }
    ],
    "skills": [
        {
            "id": 290
        },
        {
            "id": 291
        }
    ],
    "translations": [
        {
            "id": 190
        },
        {
            "id": 195
        }
    ],
    "instructors": [
        {
            "name": "Ahmed",
            "title": "Ahmed is a student at Wageningen University & Research and developing and teaching this online course.",
            "photoUrl": "https://futurex.nelc.gov.sa/sites/default/files/styles/thumbnail/public/pictures/2021-09/128_0.png"
        }
    ],
    "courseObjectives" : [
        {
            "value": "objective 1"
        },
        {
            "value": "objective 2"
        }
    ],
    "coursePlans" : [
        {
            "title": "plan title",
            "description": "plan description"
        },
        {
            "title": "plan title 2",
            "description": "plan description 2"
        }
    ],
    "tags": [
        {
            "id": 220
        },
        {
            "id": 221
        }
    ]
}',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$access_token
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    dd(json_decode($response));


});
Route::get('futcherXIntegration',function(){
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://futurex.nelc.gov.sa/oauth/token',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_id='.config('futcherx.client_id').'&client_secret='.config('futcherx.client_secret'),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $response=json_decode($response);
    $access_token=$response->access_token;


    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://futurex.nelc.gov.sa/field-options/vocabulary/course_level?_format=json',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$access_token
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $response=json_decode($response);
    foreach ($response->content as $content){
        if(!DB::connection('mysql2')->table('futurex_course_level')->where('id',$content->id)->count()){
            DB::connection('mysql2')->table('futurex_course_level')->insert((array)$content);
        }
    }

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://futurex.nelc.gov.sa/field-options/vocabulary/course_category?_format=json&items_per_page=103',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$access_token
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $response=json_decode($response);
//    dd($response);
    foreach ($response->content as $content){
        if(!DB::connection('mysql2')->table('futurex_course_category')->where('id',$content->id)->count()){
            DB::connection('mysql2')->table('futurex_course_category')->insert((array)$content);
        }
    }

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://futurex.nelc.gov.sa/field-options/vocabulary/skills?_format=json&items_per_page=2386',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$access_token
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $response=json_decode($response);
    // dd($response);
    foreach ($response->content as $content){
        if(!DB::connection('mysql2')->table('futurex_skills')->where('id',$content->id)->count()){
            DB::connection('mysql2')->table('futurex_skills')->insert((array)$content);
        }
    }

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://futurex.nelc.gov.sa/field-options/vocabulary/tags?_format=json&items_per_page=9628',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$access_token
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $response=json_decode($response);
//    dd($response);
    foreach ($response->content as $content){
        if(!DB::connection('mysql2')->table('futurex_tags')->where('id',$content->id)->count()){
            DB::connection('mysql2')->table('futurex_tags')->insert((array)$content);
        }
    }

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://futurex.nelc.gov.sa/field-options/vocabulary/language?_format=json&items_per_page=9628',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$access_token
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $response=json_decode($response);
//    dd($response);
    foreach ($response->content as $content){
        if(!DB::connection('mysql2')->table('futurex_language')->where('id',$content->id)->count()){
            DB::connection('mysql2')->table('futurex_language')->insert((array)$content);
        }
    }


    // $curl = curl_init();
    // curl_setopt_array($curl, array(
    //     CURLOPT_URL => 'https://futurex.nelc.gov.sa/field-options/vocabulary/certificate_types?_format=json&items_per_page=9628',
    //     CURLOPT_RETURNTRANSFER => true,
    //     CURLOPT_ENCODING => '',
    //     CURLOPT_MAXREDIRS => 10,
    //     CURLOPT_TIMEOUT => 0,
    //     CURLOPT_FOLLOWLOCATION => true,
    //     CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    //     CURLOPT_CUSTOMREQUEST => 'GET',
    //     CURLOPT_HTTPHEADER => array(
    //         'Content-Type: application/json',
    //         'Authorization: Bearer '.$access_token
    //     ),
    // ));

    // $response = curl_exec($curl);

    // curl_close($curl);
    // $response=json_decode($response);
    // dd($response);
    // foreach ($response->content as $content){
    //     if(!DB::connection('mysql2')->table('futurex_certificate_types')->where('id',$content->id)->count()){
    //         DB::connection('mysql2')->table('futurex_certificate_types')->insert((array)$content);
    //     }
    // }




});
if(version_compare(PHP_VERSION, '7.2.0', '>=')) {
    error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
}
use Illuminate\Support\Facades\Storage;

/************************************************/
Route::get('fixBooksFileName',function (){
    foreach (\App\Books::whereRaw('book!=new_book')->get() as $book){
        //$newName=strReplaceFileName($book->book);
        file_put_contents(filePath().$book->new_book,file_get_contents(filePath().$book->book));
        $book->old_book=$book->book;
        $book->book=$book->new_book;
        $book->save();
//
    }
});
Route::get('fixCoursesResourcesFileName',function (){
//    foreach (\App\CourseResource::get() as $item){
//        $newName=strReplaceFileName($item->file);
//        $item->new_file=$newName;
//        $item->save();
//    }
    foreach (\App\CourseResource::whereRaw('file!=new_file')->get() as $item){
        file_put_contents(filePath().$item->new_file,file_get_contents(filePath().$item->file));
        $item->old_file=$item->file;
        $item->file=$item->new_file;
        $item->save();
    }


});
Route::get('/db', function() {
//  $result= DB::connection('mysql2')->select("select courses.*,ifnull(users_course_view_completed.completed,0) AS completed,courses.id AS related_courses,instractors.name AS instractor_name,instractors.id AS instractor_id,new_mba_module_courses.module_id from new_mba_module_courses INNER JOIN new_mba on module_id=new_mba.id
// INNER JOIN courses on courses.id=new_mba_module_courses.related_course
//  INNER JOIN new_mba_courses_user_plan on courses.id=new_mba_courses_user_plan.related_course
//  AND new_mba_courses_user_plan.module_id=new_mba.id
//   LEFT JOIN users_course_view_completed ON users_course_view_completed.user_id='5733'
//   AND users_course_view_completed.course_id=courses.id LEFT JOIN instractors on courses.instractor =instractors.id where new_mba_courses_user_plan.user_id='5733' AND new_mba_module_courses.part='Part One' and new_mba.url='Financial-Market-and-Institutions' ");

//    $result= DB::connection('mysql2')->statement("ALTER TABLE `rating` ADD `rating_question1` INT(11) NULL AFTER `rating_userid`, ADD `rating_question2` INT(11) NULL AFTER `rating_question1`, ADD `rating_question3` INT(11) NULL AFTER `rating_question2`, ADD `rating_question4` INT(11) NULL AFTER `rating_question3`, ADD `comment` VARCHAR(255) NULL AFTER `rating_question4`");
//    foreach ($result as $data){
//        $data_num=preg_replace('/[^0-9]/', '', $data->serial_number);
//        $data_num = $data_num + 1;
//        switch(strlen($data_num)){
//            case 3:
//                print_r( 'MBA-000'.$data_num);
//                break;
//            case 4:
//                print_r('MBA-00'.$data_num);
//                break;
//            case 5:
//                print_r('MBA-0'.$data_num);
//                break;
//            case 6:
//                print_r('MBA-'.$data_num);
//                break;
//        }
//    }


//    $result= DB::connection('mysql2')->statement("
//ALTER TABLE `accreditation_images` CHANGE `type` `type` ENUM('diploma','course','mba','dba','new_mba','training_program','international_diploma') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL;");
//    $result= DB::connection('mysql2')->insert("insert into  new_mba_exams (`module_id`,`type`) VALUES (25,'Part One') ");
//    $result= DB::connection('mysql2')->select("select * from Info rmation_schema.columns
//where Table_name like 'diplomas'");
//    $result= DB::connection('mysql2')->statement("ALTER TABLE `news` CHANGE `description` `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL;");
//    $result= DB::connection('mysql2')->statement("DELETE FROM `new_mba_modules_users_summary` where user_id='655149' and id='3756' and module_id='25'");
//    $result= DB::connection('mysql2')->statement("ALTER TABLE `new_mba_modules_trainings_questions` ADD `hide_date` TIMESTAMP NULL AFTER `deleted_at`, ADD `hide_by` INT(11) NOT NULL DEFAULT '0' AFTER `hide_date`;");
//    $result= DB::connection('mysql2')->statement("ALTER TABLE `rating` ADD `rating_sub1_question1` INT(11) NULL AFTER `rating_question1`, ADD `rating_sub2_question1` INT(11) NULL AFTER `rating_sub1_question1`;");
//    $result= DB::connection('m6ysql2')->statement("ALTER TABLE `training_program` ADD `brochure_file` VARCHAR(255) NULL AFTER `banner`;");
//   $result= DB::connection('mysql2')->update("ALTER TABLE `dba` ADD   `brochure_file` VARCHAR(255) NULL AFTER `intro`;");
//

//        foreach ($result as $data){
//        $data_num=preg_replace('/[^0-9]/', '', $data->serial_number);
//
//$data_num = $data_num + 1;
//            echo $data_num;
//        switch(strlen($data_num)){
//            case 1:
//                print_r( 'NEW-MBA-00000'.$data_num);
//                break;
//            case 2:
//                print_r( 'NEW-MBA-0000'.$data_num);
//                break;
//            case 3:
//                print_r( 'NEW-MBA-000'.$data_num);
//                break;
//            case 4:
//                print_r('NEW-MBA-00'.$data_num);
//                break;
//            case 5:
//                print_r('NEW-MBA-0'.$data_num);
//                break;
//            case 6:
//                print_r('NEW-MBA-'.$data_num);
//                break;
//        }
//    }
//    $result= DB::connection('mysql2')->select("select * from modules_users_projects where id='9067' ");
    $result= DB::connection('mysql2')->statement("ALTER TABLE `accreditation_partners_countries_categories` ADD `sort` INT(11) NULL AFTER `url`;
");
    print_r($result);
});

Route::get('sendNotification',function (){
    $token='coo84cSYQFus0yFySIs3j5:APA91bE-H89Eo6hOM3xI_90lPkM6HRqKENj_OuGG5R7l0fEhhPqoL3y1aQsUHlPIEVmZkvlVQtaDPdVUmF-Epy30fxRA-3U8VFOLblhtCaIMA77lBCau4G6vaEpMf5gNHObQ1okMXJNn';
    dd(fcm()
        ->to([$token]) // $recipients must an array
        ->data([
            'title' =>'خطتك التدريبية ',
            'body' =>'نذكرك بموعد دراسة كورس ',
            'sound'=>'default',
        ])
        ->notification([
            'title' =>'خطتك التدريبية ',
            'body' =>'نذكرك بموعد دراسة كورس ',
            'sound'=>'default',
        ])
        ->send());
});
Route::get('sendNotification/{token}',function ($token){
    dd(fcm()
        ->to([$token]) // $recipients must an array
        ->data([
            'title' =>'test title',
            'body' =>'test body',
            'sound'=>'default',
        ])
        ->notification([
            'title' =>'test title',
            'body' =>'test body ',
            'sound'=>'default',
        ])
        ->send());
});
Route::get('sendStudyPlanNotification',function (){
    $date=date('Y-m-d H:i:s');
    $notifications=DB::connection('mysql2')->table("users_courses_study_plan_details")->selectRaw("users_courses_study_plan_details.*,
       users_courses_study_plan.notify_type,users_courses_study_plan.name,
       users.FullName AS user_name,
       users.Email AS user_email,
       users.platform_token,
       courses.name AS course_name,
       courses.url AS course_url,
       courses.image AS course_image")
        ->join('users','users.id','=','users_courses_study_plan_details.user_id')
        ->join('users_courses_study_plan','users_courses_study_plan.id','=','users_courses_study_plan_details.plan_id')
        ->join('courses','courses.id','=','users_courses_study_plan_details.course_id')
        ->where('users_courses_study_plan_details.notify_at','<=',$date)
        ->whereNull('push_notification_at')
        ->whereRaw("users.platform_token IS NOT NULL AND users.platform_token!=?",[''])
        ->get();
    ;
    foreach ($notifications as $notification){
        $sendings[]=fcm()
            ->to([$notification->platform_token]) // $recipients must an array
            ->data([
                'title' =>'خطتك التدريبية '.$notification->name,
                'body' =>'نذكرك بموعد دراسة كورس '.$notification->course_name,
                'sound'=>'default',
            ])
            ->notification([
                'title' =>'خطتك التدريبية '.$notification->name,
                'body' =>'نذكرك بموعد دراسة كورس '.$notification->course_name,
                'sound'=>'default',
            ])
            ->send();
        DB::connection('mysql2')->table('users_courses_study_plan_details')->where('id',$notification->id)->update(['push_notification_at'=>$date]);
    }
    dd($sendings);
});

Route::get('/clear-cache', function() {
    $exitCode = Artisan::call('cache:clear');
    return '<h1>Cache facade value cleared</h1>';
});

//Reoptimized class loader:
Route::get('/optimize', function() {
    $exitCode = Artisan::call('optimize');
    return '<h1>Reoptimized class loader</h1>';
});

//Route cache:
Route::get('/route-cache', function() {
    $exitCode = Artisan::call('route:cache');
    return '<h1>Routes cached</h1>';
});

//Clear Route cache:
Route::get('/route-clear', function() {
    $exitCode = Artisan::call('route:clear');
    return '<h1>Route cache cleared</h1>';
});

//Clear View cache:
Route::get('/view-clear', function() {
    $exitCode = Artisan::call('view:clear');
    return '<h1>View cache cleared</h1>';
});

//Clear Config cache:
Route::get('/config-cache', function() {
    $exitCode = Artisan::call('config:cache');
    return '<h1>Clear Config cleared</h1>';
});

//Clear Config cache:
Route::get('/config-clear', function() {
    $exitCode = Artisan::call('config:clear');
    return '<h1>Clear Config cleared</h1>';
});
Route::get('loginWithUserID/{userid}',function($userid){
    Auth::logout();
    Auth::loginUsingId($userid);
    return Redirect::to('/admin');
});
Route::post('/APINotifications/saveTokenNumber', 'APINotificationsController@saveTokenNumber');
Route::post('/APINotifications/sendNotifications', 'APINotificationsController@sendNotifications');


Route::get('/', function () {
    // dd($_SERVER);
    return Redirect::to('/admin');
    //return view('welcome');
});
Route::get('updateAcademyChargeTransaction', function () {
    // dd($_SERVER);
    updateAcademyChargeTransaction(5733);
    //return view('welcome');
});
/*auth routes*/
Route::get('admin/login',function(){
    return redirect()->to(route('login'));
});
Auth::routes();
/*authentication routes*/
Route::group(['middleware' => 'PermissionsAuth'], function () {
    /*home page admin route*/
    Route::get('/admin', '\App\Http\Controllers\Admin\AdminController@home');
    Route::group(['prefix' => 'admin'], function () {
        Route::get('run_query', ['uses' => '\App\Http\Controllers\Admin\TestController@run_sql_file', 'as' => 'users_view'] );
        /*users routes*/
        Route::resource('users', '\App\Http\Controllers\Admin\UsersController', ['names' => ['create' => 'users_add', 'store' => 'users_add', 'index' => 'users', 'edit' => 'users_edit', 'update' => 'users_edit', 'destroy' => 'users_delete']]);
        Route::post('users_search', ['uses' => '\App\Http\Controllers\Admin\UsersController@search', 'as' => 'users_view']);
        Route::post('users/activation', ['uses' => '\App\Http\Controllers\Admin\UsersController@activation', 'as' => 'users_active']);
        Route::get('users_suspend', ['uses' => '\App\Http\Controllers\Admin\UserssuspendController@index', 'as' => 'users_suspend']);
        Route::post('users_suspend_search', ['uses' => '\App\Http\Controllers\Admin\UserssuspendController@search', 'as' => 'users_suspend_view']);



        Route::resource('unihance', '\App\Http\Controllers\Admin\UnihanceController', ['names' => ['create' => 'unihance_add', 'store' => 'unihance_add', 'index' => 'unihance', 'edit' => 'unihance_edit', 'update' => 'unihance_edit', 'destroy' => 'unihance_delete']]);
        Route::post('unihance_search', ['uses' => '\App\Http\Controllers\Admin\UnihanceController@search', 'as' => 'unihance_view']);


        /*profiles permission routes*/
        Route::resource('mba_progress', '\App\Http\Controllers\Admin\MbaProgressController', ['names' => ['create' => 'mba_progress', 'store' => 'mba_progress', 'index' => 'mba_progress' ]]);
        Route::post('mba_progress_search', ['uses' => '\App\Http\Controllers\Admin\MbaProgressController@search', 'as' => 'mba_progress']);
        Route::get('mba_progress_export', ['uses' => '\App\Http\Controllers\Admin\MbaProgressController@export', 'as' => 'mba_progress']);

        Route::post('mba_emails_search', ['uses' => '\App\Http\Controllers\Admin\MbaProgressController@emails_search', 'as' => 'mba_progress']);
        Route::get('mba_emails', ['uses' => '\App\Http\Controllers\Admin\MbaProgressController@emails', 'as' => 'mba_progress']);


        Route::resource('profiles', '\App\Http\Controllers\Admin\ProfilesController', ['names' => ['create' => 'profiles_add', 'store' => 'profiles_add', 'index' => 'profiles', 'edit' => 'profiles_edit', 'update' => 'profiles_edit', 'destroy' => 'profiles_delete']]);
        Route::post('profiles_search', ['uses' => '\App\Http\Controllers\Admin\ProfilesController@search', 'as' => 'profiles_view']);
        Route::post('profiles/activation', ['uses' => '\App\Http\Controllers\Admin\ProfilesController@activation', 'as' => 'profiles_active']);

        // working with resources
        Route::resource('courses_resources', '\App\Http\Controllers\Admin\CoursesResourcesController', ['names' => ['create' => 'courses_resources_add', 'store' => 'courses_resources_add', 'index' => 'courses_resources', 'edit' => 'courses_resources_edit', 'update' => 'courses_resources_edit', 'destroy' => 'courses_resources_delete']]);
        Route::post('courses_resources_search', ['uses' => '\App\Http\Controllers\Admin\CoursesResourcesController@search', 'as' => 'courses_resources_view']);
        Route::post('courses_resources/publish', ['uses' => '\App\Http\Controllers\Admin\CoursesResourcesController@publish', 'as' => 'courses_resources_publish']);
//        Route::post('course_resources_update/{id}', ['uses' => '\App\Http\Controllers\Admin\CoursesResourcesController@getUpdate', 'as' => 'courses_resources']);
        //Route::post('course_resources_download', ['uses' => '\App\Http\Controllers\Admin\CoursesResourcesController@downloadFile', 'as' => 'courses_resources_edit']);
        Route::get('course_resources_download/{file}', ['uses' => '\App\Http\Controllers\Admin\CoursesResourcesController@downloadFile', 'as' => 'courses_resources_edit']);

        // working with webinars
        Route::resource('webinar_resources', '\App\Http\Controllers\Admin\WebinarResourcesController', ['names' => ['create' => 'webinar_resources_add', 'store' => 'webinar_resources_add', 'index' => 'webinar_resources', 'edit' => 'webinar_resources_edit', 'update' => 'webinar_resources_edit', 'destroy' => 'webinar_resources_delete']]);
        Route::post('webinar_resources_search', ['uses' => '\App\Http\Controllers\Admin\WebinarResourcesController@search', 'as' => 'webinar_resources_view']);
//        Route::post('webinar_resources_update/{id}', ['uses' => '\App\Http\Controllers\Admin\WebinarResourcesController@getUpdate', 'as' => 'webinars_resources_edit']);

        // working with courses
        Route::resource('courses', '\App\Http\Controllers\Admin\CoursesController', ['names' => ['create' => 'courses_add', 'store' => 'courses_add', 'index' => 'courses', 'edit' => 'courses_edit', 'update' => 'courses_edit', 'destroy' => 'courses_delete']]);


        Route::get('courses_delete_form', ['uses' => '\App\Http\Controllers\Admin\CoursesController@coursesDeleteForm', 'as' => 'courses_delete_form']);
        Route::post('courses_delete_form', ['uses' => '\App\Http\Controllers\Admin\CoursesController@coursesDeleteFormPost', 'as' => 'courses_delete_form']);
        Route::post('courses_delete_form_get_data', ['uses' => '\App\Http\Controllers\Admin\CoursesController@coursesDeleteForm', 'as' => 'courses_delete_form']);




        Route::post('courses_search', ['uses' => '\App\Http\Controllers\Admin\CoursesController@search', 'as' => 'courses_view']);
        Route::post('courses/publish', ['uses' => '\App\Http\Controllers\Admin\CoursesController@publish', 'as' => 'courses_publish']);
        Route::post('courses/getSubCategoriesByCategoryId', ['uses' => '\App\Http\Controllers\Admin\AllCategoryController@getSubCategoriesByCategoryId', 'as' => 'courses_add']);
        Route::post('courses/delete_image',['uses'=>'\App\Http\Controllers\Admin\CoursesController@deleteImage','as'=>'courses_edit']);


//        Route::resource('modules_questions', '\App\Http\Controllers\Admin\ModulesQuestionsController', ['names' => ['create' => 'modules_questions_add', 'store' => 'modules_questions_add', 'index' => 'modules_questions', 'edit' => 'modules_questions_edit', 'update' => 'modules_questions_edit', 'destroy' => 'modules_questions_delete']]);
//        Route::post('modules_questions/getModulesQuestionsAJAX', ['uses' => '\App\Http\Controllers\Admin\ModulesQuestionsController@getModulesQuestionsAJAX', 'as' => 'modules_questions_view']);
//        Route::get('get_module_questions/{id}', ['uses' => '\App\Http\Controllers\Admin\ModulesQuestionsController@getModuleQuestions', 'as' => 'modules_questions_edit']);
//        Route::get('search_module_question', ['uses' => '\App\Http\Controllers\Admin\ModulesQuestionsController@searchModuleQuestions', 'as' => 'modules_questions_edit']);
//        Route::post('import_module_questions', ['uses' => '\App\Http\Controllers\Admin\ModulesQuestionsController@importModuleQuestions', 'as' => 'modules_questions_edit']);

        /* New version of Modules Questions */
        Route::resource('modules_questions2', '\App\Http\Controllers\Admin\ModulesQuestions2Controller', [
                'names' => [
                    'create'  => 'modules_questions_add',
                    'store'   => 'modules_questions_add',
                    'index'   => 'modules_questions',
                    'edit'    => 'modules_questions_edit',
                    'update'  => 'modules_questions_edit',
                    'destroy' => 'modules_questions_delete'
                ]
            ]
        );

        Route::GET('modules_questions2/{type}/{id}', [
            'uses' => '\App\Http\Controllers\Admin\ModulesQuestions2Controller@show', 'as' => 'modules_questions_edit'
        ]);
        Route::post('modules_questions2/hide/{id}', ['uses' => '\App\Http\Controllers\Admin\ModulesQuestions2Controller@hide', 'as' => 'modules_questions_edit']);

        Route::post('modules_questions2/getModulesQuestionsAJAX', [
            'uses' => '\App\Http\Controllers\Admin\ModulesQuestions2Controller@getModulesQuestionsAJAX', 'as' => 'modules_questions_view'
        ]);
        Route::get('get_module_questions2/{id}', [
            'uses' => '\App\Http\Controllers\Admin\ModulesQuestions2Controller@getModuleQuestions', 'as'  => 'modules_questions_edit'
        ]);
        Route::get('get_module_questions2_by_type/{type}', [
            'uses' => '\App\Http\Controllers\Admin\ImportQuestionsController@getModuleQuestionsbytype', 'as'  => 'modules_questions_edit'
        ]);
        Route::get('search_module_question2', [
            'uses' => '\App\Http\Controllers\Admin\ModulesQuestions2Controller@searchModuleQuestions', 'as' => 'modules_questions_edit'
        ]);
        Route::post('import_module_questions2', [
            'uses' => '\App\Http\Controllers\Admin\ModulesQuestions2Controller@importModuleQuestions', 'as' => 'modules_questions_edit'
        ]);
        Route::post('module_questions2_fetch', [
            'uses' => '\App\Http\Controllers\Admin\ModulesQuestions2Controller@fetchQuestions', 'as' => 'modules_questions_edit'
        ]);
        Route::post('questions_fetch', [
            'uses' => '\App\Http\Controllers\Admin\ImportQuestionsController@fetchQuestions', 'as' => 'new_modules_questions_edit'
        ]);

        /* Start New Modules Questions Routes */

        Route::resource('new_modules_questions2', '\App\Http\Controllers\Admin\NewModulesQuestions2Controller', [
                'names' => [
                    'create'  => 'new_modules_questions_add',
                    'store'   => 'new_modules_questions_add',
                    'index'   => 'new_modules_questions',
                    'edit'    => 'new_modules_questions_edit',
                    'update'  => 'new_modules_questions_edit',
                    'destroy' => 'new_modules_questions_delete'
                ]
            ]
        );
        Route::GET('new_modules_questions2/filter/{id}', [
            'uses' => '\App\Http\Controllers\Admin\NewModulesQuestions2Controller@Filter', 'as' => 'new_modules_questions_edit'
        ]);
        Route::GET('new_modules_questions2/{type}/{id}', [
            'uses' => '\App\Http\Controllers\Admin\NewModulesQuestions2Controller@show', 'as' => 'new_modules_questions_edit'
        ]);

        Route::post('new_modules_questions2/hide/{id}', ['uses' => '\App\Http\Controllers\Admin\NewModulesQuestions2Controller@hide', 'as' => 'new_modules_questions_edit']);

        Route::post('new_modules_questions2/getModulesQuestionsAJAX', [
            'uses' => '\App\Http\Controllers\Admin\NewModulesQuestions2Controller@getModulesQuestionsAJAX', 'as' => 'new_modules_questions_view'
        ]);
        Route::get('new_get_module_questions2/{id}/{type}', [
            'uses' => '\App\Http\Controllers\Admin\NewModulesQuestions2Controller@getModuleQuestions', 'as'  => 'new_modules_questions_edit'
        ]);
        Route::get('new_search_module_question2', [
            'uses' => '\App\Http\Controllers\Admin\NewModulesQuestions2Controller@searchModuleQuestions', 'as' => 'new_modules_questions_edit'
        ]);
        Route::post('new_import_module_questions2', [
            'uses' => '\App\Http\Controllers\Admin\NewModulesQuestions2Controller@importModuleQuestions', 'as' => 'new_modules_questions_edit'
        ]);
        Route::post('new_module_questions2_fetch', [
            'uses' => '\App\Http\Controllers\Admin\NewModulesQuestions2Controller@fetchQuestions', 'as' => 'new_modules_questions_edit'
        ]);

        /* End New Modules Questions Routes */

        /* New version of Modules Trainings Questions */
        Route::resource('modules_trainings_questions2', '\App\Http\Controllers\Admin\ModulesTrainingsQuestions2Controller', [
                'names' => [
                    'create'  => 'modules_trainings_questions_add',
                    'store'   => 'modules_trainings_questions_add',
                    'index'   => 'modules_trainings_questions',
                    'edit'    => 'modules_trainings_questions_edit',
                    'update'  => 'modules_trainings_questions_edit',
                    'destroy' => 'modules_trainings_questions_delete'
                ]
            ]
        );

        Route::GET('modules_trainings_questions2/{type}/{id}', [
            'uses' => '\App\Http\Controllers\Admin\ModulesTrainingsQuestions2Controller@show', 'as' => 'modules_trainings_questions_edit'
        ]);
        Route::post('modules_trainings_questions2/hide/{id}', ['uses' => '\App\Http\Controllers\Admin\ModulesTrainingsQuestions2Controller@hide', 'as' => 'modules_trainings_questions_edit']);

        Route::post('modules_trainings_questions2/getModulesTrainingsQuestionsAJAX', [
            'uses' => '\App\Http\Controllers\Admin\ModulesTrainingsQuestions2Controller@getModuleTrainingsQuestionsAJAX', 'as' => 'modules_trainings_questions_view'
        ]);
        Route::get('get_module_training_questions2/{id}', [
            'uses' => '\App\Http\Controllers\Admin\ModulesTrainingsQuestions2Controller@getTrainingQuestions', 'as'  => 'modules_trainings_questions_edit'
        ]);
        Route::get('search_module_training_question2', [
            'uses' => '\App\Http\Controllers\Admin\ModulesTrainingsQuestions2Controller@searchTrainingQuestions', 'as' => 'modules_trainings_questions_edit'
        ]);
        Route::post('import_module_training_questions2', [
            'uses' => '\App\Http\Controllers\Admin\ModulesTrainingsQuestions2Controller@importTrainingQuestions', 'as' => 'modules_trainings_questions_edit'
        ]);
        Route::post('module_training_questions2_fetch', [
            'uses' => '\App\Http\Controllers\Admin\ModulesTrainingsQuestions2Controller@fetchQuestions', 'as' => 'modules_trainings_questions_edit'
        ]);

        /* Start New Modules Trainings Questions Routes */

        Route::resource('new_modules_trainings_questions2', '\App\Http\Controllers\Admin\NewModulesTrainingsQuestions2Controller', [
                'names' => [
                    'create'  => 'new_modules_trainings_questions_add',
                    'store'   => 'new_modules_trainings_questions_add',
                    'index'   => 'new_modules_trainings_questions',
                    'edit'    => 'new_modules_trainings_questions_edit',
                    'update'  => 'new_modules_trainings_questions_edit',
                    'destroy' => 'new_modules_trainings_questions_delete'
                ]
            ]
        );

        Route::GET('new_modules_trainings_questions2/{type}/{id}', [
            'uses' => '\App\Http\Controllers\Admin\NewModulesTrainingsQuestions2Controller@show', 'as' => 'new_modules_trainings_questions_edit'
        ]);
        Route::post('new_modules_trainings_questions2/hide/{id}', ['uses' => '\App\Http\Controllers\Admin\NewModulesTrainingsQuestions2Controller@hide', 'as' => 'new_modules_trainings_questions_edit']);

        Route::post('new_modules_trainings_questions2/getModulesTrainingsQuestionsAJAX', [
            'uses' => '\App\Http\Controllers\Admin\NewModulesTrainingsQuestions2Controller@getModuleTrainingsQuestionsAJAX', 'as' => 'new_modules_trainings_questions_view'
        ]);
        Route::get('new_get_module_training_questions2/{id}', [
            'uses' => '\App\Http\Controllers\Admin\NewModulesTrainingsQuestions2Controller@getTrainingQuestions', 'as'  => 'new_modules_trainings_questions_edit'
        ]);
        Route::get('new_search_module_training_question2', [
            'uses' => '\App\Http\Controllers\Admin\NewModulesTrainingsQuestions2Controller@searchTrainingQuestions', 'as' => 'new_modules_trainings_questions_edit'
        ]);
        Route::post('new_import_module_training_questions2', [
            'uses' => '\App\Http\Controllers\Admin\NewModulesTrainingsQuestions2Controller@importTrainingQuestions', 'as' => 'new_modules_trainings_questions_edit'
        ]);
        Route::post('new_module_training_questions2_fetch', [
            'uses' => '\App\Http\Controllers\Admin\NewModulesTrainingsQuestions2Controller@fetchQuestions', 'as' => 'new_modules_trainings_questions_edit'
        ]);

        /* End New Modules Trainings Questions Routes */

        /*profile routes*/
        Route::get('profile', ['uses' => '\App\Http\Controllers\Admin\AdminController@profile', 'as' => 'profile']);
        Route::post('profile', ['uses' => '\App\Http\Controllers\Admin\AdminController@profilePost', 'as' => 'profile']);
        /*profile routes*/
        Route::get('system', ['uses' => '\App\Http\Controllers\Admin\AdminController@system', 'as' => 'system']);
        Route::post('system', ['uses' => '\App\Http\Controllers\Admin\AdminController@systemPost', 'as' => 'system']);

        Route::get('app_settings', ['uses' => '\App\Http\Controllers\Admin\AdminController@AppSettings', 'as' => 'app_settings_edit']);
        Route::put('app_settings', ['uses' => '\App\Http\Controllers\Admin\AdminController@AppSettingsEdit', 'as' => 'app_settings_edit']);
        Route::get('delete_file', ['uses' => '\App\Http\Controllers\Admin\AdminController@delete_file', 'as' => 'app_settings_edit']);
        Route::get('delete_website_file', ['uses' => '\App\Http\Controllers\Admin\AdminController@delete_website_file', 'as' => 'app_settings_edit']);


        Route::get('seo_sitemap', ['uses' => '\App\Http\Controllers\Admin\AdminController@SEOStieMap', 'as' => 'seo_sitemap_edit']);
        Route::put('seo_sitemap', ['uses' => '\App\Http\Controllers\Admin\AdminController@SEOStieMapEdit', 'as' => 'seo_sitemap_edit']);

        Route::get('subscription_prices', ['uses' => '\App\Http\Controllers\Admin\AdminController@subscriptionPrices', 'as' => 'subscription_prices_edit']);
        Route::put('subscription_prices', ['uses' => '\App\Http\Controllers\Admin\AdminController@subscriptionPricesEdit', 'as' => 'subscription_prices_edit']);

        //our_products
        Route::resource('our_products', '\App\Http\Controllers\Admin\OurProductsController', ['names' => ['create' => 'our_products_add', 'store' => 'our_products_add', 'index' => 'our_products', 'edit' => 'our_products_edit', 'update' => 'our_products_edit', 'destroy' => 'our_products_delete']]);
        Route::post('our_products/getOurProductsAJAX', ['uses' => '\App\Http\Controllers\Admin\OurProductsController@getOurProductsAJAX', 'as' => 'our_products_view']);
        Route::post('our_products/publish', ['uses' => '\App\Http\Controllers\Admin\OurProductsController@publish', 'as' => 'our_products_publish']);


        //our_products_courses
        Route::resource('our_products_courses', '\App\Http\Controllers\Admin\OurProductsCoursesController', ['names' => ['create' => 'our_products_courses_add', 'store' => 'our_products_courses_add', 'index' => 'our_products_courses', 'edit' => 'our_products_courses_edit', 'update' => 'our_products_courses_edit', 'destroy' => 'our_products_courses_delete']]);
        Route::post('our_products_courses/getOurProductsCoursesAJAX', ['uses' => '\App\Http\Controllers\Admin\OurProductsCoursesController@getOurProductsCoursesAJAX', 'as' => 'our_products_courses_view']);
        Route::post('our_products_courses/activation', ['uses' => '\App\Http\Controllers\Admin\OurProductsCoursesController@activation', 'as' => 'our_products_courses_active']);
        //modules_trainings
        Route::resource('modules_trainings', '\App\Http\Controllers\Admin\ModulesTrainingsController', ['names' => ['create' => 'modules_trainings_add', 'store' => 'modules_trainings_add', 'index' => 'modules_trainings', 'edit' => 'modules_trainings_edit', 'update' => 'modules_trainings_edit', 'destroy' => 'modules_trainings_delete']]);
        Route::post('modules_trainings/getModulesTrainingsAJAX', ['uses' => '\App\Http\Controllers\Admin\ModulesTrainingsController@getModulesTrainingsAJAX', 'as' => 'modules_trainings_view']);
        Route::post('modules_trainings/activation', ['uses' => '\App\Http\Controllers\Admin\ModulesTrainingsController@activation', 'as' => 'modules_trainings_active']);

        /* Start New Modules Training Routes */
        Route::resource('new_modules_trainings', '\App\Http\Controllers\Admin\NewModulesTrainingsController', ['names' => ['create' => 'new_modules_trainings_add', 'store' => 'new_modules_trainings_add', 'index' => 'new_modules_trainings', 'edit' => 'new_modules_trainings_edit', 'update' => 'new_modules_trainings_edit', 'destroy' => 'new_modules_trainings_delete']]);
        Route::post('new_modules_trainings/getModulesTrainingsAJAX', ['uses' => '\App\Http\Controllers\Admin\NewModulesTrainingsController@getModulesTrainingsAJAX', 'as' => 'new_modules_trainings_view']);
        Route::post('new_modules_trainings/activation', ['uses' => '\App\Http\Controllers\Admin\NewModulesTrainingsController@activation', 'as' => 'new_modules_trainings_active']);
        /* End New Modules Training Routes */

        //modules_trainings_questions
//        Route::resource('modules_trainings_questions', '\App\Http\Controllers\Admin\ModulesTrainingsQuestionsController', ['names' => ['create' => 'modules_trainings_questions_add', 'store' => 'modules_trainings_questions_add', 'index' => 'modules_trainings_questions', 'edit' => 'modules_trainings_questions_edit', 'update' => 'modules_trainings_questions_edit', 'destroy' => 'modules_trainings_questions_delete']]);
//        Route::post('modules_trainings_questions/getModuleTrainingsQuestionsAJAX', ['uses' => '\App\Http\Controllers\Admin\ModulesTrainingsQuestionsController@getModuleTrainingsQuestionsAJAX', 'as' => 'modules_trainings_questions_view']);
//        Route::post('modules_trainings_questions/activation', ['uses' => '\App\Http\Controllers\Admin\ModulesTrainingsQuestionsController@activation', 'as' => 'modules_trainings_questions_active']);
//
//        Route::get('get_module_training/{id}', ['uses' => '\App\Http\Controllers\Admin\ModulesTrainingsQuestionsController@getModuleTraining', 'as' => 'modules_trainings_questions_edit']);
//        Route::get('get_training_questions/{id}', ['uses' => '\App\Http\Controllers\Admin\ModulesTrainingsQuestionsController@getTrainingQuestions', 'as' => 'modules_trainings_questions_edit']);
//        Route::get('search_training_question', ['uses' => '\App\Http\Controllers\Admin\ModulesTrainingsQuestionsController@searchTrainingQuestions', 'as' => 'modules_trainings_questions_edit']);
//        Route::post('import_training_questions', ['uses' => '\App\Http\Controllers\Admin\ModulesTrainingsQuestionsController@importTrainingQuestions', 'as' => 'modules_trainings_questions_edit']);

        Route::resource('modules', '\App\Http\Controllers\Admin\ModulesController', ['names' => ['create' => 'modules_add', 'store' => 'modules_add', 'index' => 'modules', 'edit' => 'modules_edit', 'update' => 'modules_edit', 'destroy' => 'modules_delete']]);
        Route::post('modules_search', ['uses' => '\App\Http\Controllers\Admin\ModulesController@search', 'as' => 'modules_view']);
        Route::post('modules/activation', ['uses' => '\App\Http\Controllers\Admin\ModulesController@activation', 'as' => 'modules_active']);
        Route::post('modules/delete_image',['uses'=>'\App\Http\Controllers\Admin\ModulesController@deleteImage','as'=>'modules_edit']);


        /* Start New Modules Routes */
        Route::resource('new_modules', '\App\Http\Controllers\Admin\NewModulesController', ['names' => ['create' => 'new_modules_add', 'store' => 'new_modules_add', 'index' => 'new_modules', 'edit' => 'new_modules_edit', 'update' => 'new_modules_edit', 'destroy' => 'new_modules_delete']]);
        Route::post('new_modules_search', ['uses' => '\App\Http\Controllers\Admin\NewModulesController@search', 'as' => 'new_modules_view']);
        Route::post('new_modules/activation', ['uses' => '\App\Http\Controllers\Admin\NewModulesController@activation', 'as' => 'new_modules_active']);
        Route::post('new_modules/delete_image',['uses'=>'\App\Http\Controllers\Admin\NewModulesController@deleteImage','as'=>'new_modules_edit']);
        /* End New Modules Routes */

//        Route::resource('courses_questions', '\App\Http\Controllers\Admin\CoursesQuestionsController', [
//            'names' => [
//                'create' => 'courses_questions_add',
//                'store' => 'courses_questions_add',
//                'index' => 'courses_questions',
//                'edit' => 'courses_questions_edit',
//                'update' => 'courses_questions_edit',
//                'destroy' => 'courses_questions_delete'
//            ]
//        ]);

        /* Courses Questions V3 */

        // Start Export Courses Questions
        Route::get('export_course_data/{curriculum_id}', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions3Controller@exportCourseData', 'as' => 'export_courses_questions']);
        // End Export Courses Questions



        Route::resource('courses_questions3', '\App\Http\Controllers\Admin\CoursesQuestions3Controller', [
            'names' => [
                'create' => 'courses_questions_add',
                'store' => 'courses_questions_add',
                'index' => 'courses_questions',
                'show' => 'courses_questions_edit',
                'edit' => 'courses_questions_edit',
                'update' => 'courses_questions_edit',
                'destroy' => 'courses_questions_delete'
            ]
        ]);

        Route::GET('courses_questions3/{type}/{id}', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions3Controller@show', 'as' => 'courses_questions_edit']);
        Route::post('courses_questions3/hide/{id}', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions3Controller@hide', 'as' => 'courses_questions_edit']);
        Route::post('courses_questions3_search', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions3Controller@search', 'as' => 'courses_questions_view']);
        Route::post('courses_questions3_fetch', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions3Controller@fetchQuestions', 'as' => 'courses_questions_edit']);
        //Route::get('courses_questions3_export', '\App\Http\Controllers\Admin\CoursesQuestions3Controller@export')->name('courses_questions3_export');


//        Route::post('courses_questions_search', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestionsController@search', 'as' => 'courses_questions_view']);
        Route::get('get_course_curriculum/{id}', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestionsController@getCourseCurriculums', 'as' => 'courses_questions_edit']);
////        Route::get('get_curriculum_questions/{id}', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestionsController@getCurriculumQuestions', 'as' => 'courses_questions_edit']);
//        Route::get('search_question', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestionsController@searchCurriculumQuestions', 'as' => 'courses_questions_edit']);
//        Route::post('import_course_questions', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestionsController@importCourseQuestions', 'as' => 'courses_questions_edit']);

        Route::resource('courses_questions2', '\App\Http\Controllers\Admin\CoursesQuestions2Controller', ['names' => ['create' => 'courses_questions_add', 'store' => 'courses_questions_add', 'index' => 'courses_questions', 'edit' => 'courses_questions_edit', 'update' => 'courses_questions_edit', 'destroy' => 'courses_questions_delete']]);
        Route::post('courses_questions_search2', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions2Controller@search', 'as' => 'courses_questions_view']);
        Route::get('get_course_curriculum2/{id}', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions2Controller@getCourseCurriculums', 'as' => 'courses_questions_edit']);
//        Route::get('get_curriculum_questions/{id}', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions2Controller@getCurriculumQuestions', 'as' => 'courses_questions_edit']);
        Route::get('get_curriculum_questions/{id}', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions3Controller@getCurriculumQuestions', 'as' => 'courses_questions_edit']);
        Route::get('search_question2', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions2Controller@searchCurriculumQuestions', 'as' => 'courses_questions_edit']);
        Route::post('import_course_questions2', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions2Controller@importCourseQuestions', 'as' => 'courses_questions_edit']);
        Route::post('add_new_question', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions2Controller@addNewQuestion', 'as' => 'courses_questions_add']);
        Route::post('import_question', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions2Controller@importQuestion', 'as' => 'courses_questions_edit']);
        Route::post('remove_question', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions2Controller@removeQuestion', 'as' => 'courses_questions_delete']);
        Route::post('question-image-upload', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions2Controller@imageUpload', 'as' => 'courses_questions_edit']);
        Route::post('remove-question-image', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions2Controller@imageRemove', 'as' => 'courses_questions_edit']);
        Route::post('delete-unsaved-questions', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestions2Controller@deleteUnsavedQuestions', 'as' => 'courses_questions_edit']);


        //modules_projects
        Route::resource('modules_projects', '\App\Http\Controllers\Admin\ModulesProjectsController', ['names' => ['create' => 'modules_projects_add', 'store' => 'modules_projects_add', 'index' => 'modules_projects', 'edit' => 'modules_projects_edit', 'update' => 'modules_projects_edit', 'destroy' => 'modules_projects_delete']]);
        Route::post('modules_projects_search', ['uses' => '\App\Http\Controllers\Admin\ModulesProjectsController@search', 'as' => 'modules_projects_view']);
        Route::post('modules_projects/activation', ['uses' => '\App\Http\Controllers\Admin\ModulesProjectsController@activation', 'as' => 'modules_projects_active']);

        /* Start New Modules Projects Routes */

        Route::resource('new_modules_projects', '\App\Http\Controllers\Admin\NewModulesProjectsController', ['names' => ['create' => 'new_modules_projects_add', 'store' => 'new_modules_projects_add', 'index' => 'new_modules_projects', 'edit' => 'new_modules_projects_edit', 'update' => 'new_modules_projects_edit', 'destroy' => 'new_modules_projects_delete']]);
        Route::post('new_modules_projects_search', ['uses' => '\App\Http\Controllers\Admin\NewModulesProjectsController@search', 'as' => 'new_modules_projects_view']);
        Route::post('new_modules_projects/activation', ['uses' => '\App\Http\Controllers\Admin\NewModulesProjectsController@activation', 'as' => 'new_modules_projects_active']);

        /* Start New Modules Category Projects Routes */

        Route::resource('new_mba_category_projects', '\App\Http\Controllers\Admin\NewMbaCategoryProjectsController', ['names' => ['create' => 'new_mba_category_projects_add', 'store' => 'new_mba_category_projects_add', 'index' => 'new_mba_category_projects', 'edit' => 'new_mba_category_projects_edit', 'update' => 'new_mba_category_projects_edit', 'destroy' => 'new_mba_category_projects_delete']]);
        Route::post('new_mba_category_projects_search', ['uses' => '\App\Http\Controllers\Admin\NewMbaCategoryProjectsController@search', 'as' => 'new_mba_category_projects_view']);
        Route::post('new_mba_category_projects/activation', ['uses' => '\App\Http\Controllers\Admin\NewMbaCategoryProjectsController@activation', 'as' => 'new_mba_category_projects_active']);

        /* End New Modules Projects Routes */

        Route::resource('modules_courses', '\App\Http\Controllers\Admin\ModulesCoursesController', ['names' => ['create' => 'modules_courses_add', 'store' => 'modules_courses_add', 'index' => 'modules_courses', 'edit' => 'modules_courses_edit', 'update' => 'modules_courses_edit', 'destroy' => 'modules_courses_delete']]);
        Route::post('modules_courses_search', ['uses' => '\App\Http\Controllers\Admin\ModulesCoursesController@search', 'as' => 'modules_courses_view']);
        Route::post('modules_courses/activation', ['uses' => '\App\Http\Controllers\Admin\ModulesCoursesController@activation', 'as' => 'modules_courses_active']);

        /* Start New Modules Courses */
        Route::resource('new_modules_courses', '\App\Http\Controllers\Admin\NewModulesCoursesController', ['names' => ['create' => 'new_modules_courses_add', 'store' => 'new_modules_courses_add', 'index' => 'new_modules_courses', 'edit' => 'new_modules_courses_edit', 'update' => 'new_modules_courses_edit', 'destroy' => 'new_modules_courses_delete']]);
        Route::post('new_modules_courses_search', ['uses' => '\App\Http\Controllers\Admin\NewModulesCoursesController@search', 'as' => 'new_modules_courses_view']);
        Route::post('new_modules_courses/activation', ['uses' => '\App\Http\Controllers\Admin\NewModulesCoursesController@activation', 'as' => 'new_modules_courses_active']);
        /* End New Modules Courses */

        Route::resource('modules_helper_courses', '\App\Http\Controllers\Admin\ModulesHelperCoursesController', ['names' => ['create' => 'modules_helper_courses_add', 'store' => 'modules_helper_courses_add', 'index' => 'modules_helper_courses', 'edit' => 'modules_helper_courses_edit', 'update' => 'modules_helper_courses_edit', 'destroy' => 'modules_helper_courses_delete']]);
        Route::post('modules_helper_courses_search', ['uses' => '\App\Http\Controllers\Admin\ModulesHelperCoursesController@search', 'as' => 'modules_helper_courses_view']);
        Route::post('modules_helper_courses/activation', ['uses' => '\App\Http\Controllers\Admin\ModulesHelperCoursesController@activation', 'as' => 'modules_helper_courses_active']);

        /* Start New Modules Helper Courses Routes */
        Route::resource('new_modules_helper_courses', '\App\Http\Controllers\Admin\NewModulesHelperCoursesController', ['names' => ['create' => 'new_modules_helper_courses_add', 'store' => 'new_modules_helper_courses_add', 'index' => 'new_modules_helper_courses', 'edit' => 'new_modules_helper_courses_edit', 'update' => 'new_modules_helper_courses_edit', 'destroy' => 'new_modules_helper_courses_delete']]);
        Route::post('new_modules_helper_courses_search', ['uses' => '\App\Http\Controllers\Admin\NewModulesHelperCoursesController@search', 'as' => 'new_modules_helper_courses_view']);
        Route::post('new_modules_helper_courses/activation', ['uses' => '\App\Http\Controllers\Admin\NewModulesHelperCoursesController@activation', 'as' => 'new_modules_helper_courses_active']);
        /* End New Modules Helper Courses Routes */

        Route::delete('modules_users_projects/remove_correction', ['uses' => '\App\Http\Controllers\Admin\ModulesUsersProjectsController@removeCorrection', 'as' => 'modules_users_projects_edit']);
        Route::resource('modules_users_projects', '\App\Http\Controllers\Admin\ModulesUsersProjectsController', ['names' => ['create' => 'modules_users_projects_add', 'store' => 'modules_users_projects_add', 'index' => 'modules_users_projects', 'edit' => 'modules_users_projects_edit', 'update' => 'modules_users_projects_edit', 'destroy' => 'modules_users_projects_delete']]);
        Route::post('modules_users_projects_search', ['uses' => '\App\Http\Controllers\Admin\ModulesUsersProjectsController@search', 'as' => 'modules_projects_view']);
        Route::put('modules_users_projects/{id}/editProjectStatus', ['uses' => '\App\Http\Controllers\Admin\ModulesUsersProjectsController@editProjectStatus', 'as' => 'modules_users_projects_edit']);
        Route::put('modules_users_projects/{id}/editProjectResult', ['uses' => '\App\Http\Controllers\Admin\ModulesUsersProjectsController@editProjectResult', 'as' => 'modules_users_projects_edit']);
        Route::post('modules_users_projects/upload_correction', ['uses' => '\App\Http\Controllers\Admin\ModulesUsersProjectsController@uploadCorrection', 'as' => 'modules_users_projects_edit']);
        Route::get('modules_users_projects/download_file/{id}', ['uses' => '\App\Http\Controllers\Admin\ModulesUsersProjectsController@downloadFile', 'as' => 'modules_projects_view']);

        /* Start New Modules Users Projects Routes */
        Route::resource('new_modules_users_projects', '\App\Http\Controllers\Admin\NewModulesUsersProjectsController', ['names' => ['create' => 'new_modules_users_projects_add', 'store' => 'new_modules_users_projects_add', 'index' => 'new_modules_users_projects', 'edit' => 'new_modules_users_projects_edit', 'update' => 'new_modules_users_projects_edit', 'destroy' => 'new_modules_users_projects_delete']]);
        Route::post('new_modules_users_projects_search', ['uses' => '\App\Http\Controllers\Admin\NewModulesUsersProjectsController@search', 'as' => 'new_modules_projects_view']);
        Route::put('new_modules_users_projects/{id}/editProjectStatus', ['uses' => '\App\Http\Controllers\Admin\NewModulesUsersProjectsController@editProjectStatus', 'as' => 'new_modules_users_projects_edit']);
        Route::put('new_modules_users_projects/{id}/editProjectResult', ['uses' => '\App\Http\Controllers\Admin\NewModulesUsersProjectsController@editProjectResult', 'as' => 'new_modules_users_projects_edit']);
        Route::post('new_modules_users_projects/upload_correction', ['uses' => '\App\Http\Controllers\Admin\NewModulesUsersProjectsController@uploadCorrection', 'as' => 'new_modules_users_projects_edit']);
        Route::get('new_modules_users_projects/download_file/{id}', ['uses' => '\App\Http\Controllers\Admin\NewModulesUsersProjectsController@downloadFile', 'as' => 'new_modules_users_projects_view']);
        /* End New Modules Users Projects Routes */

        /* Start dba_users_doctor_files Routes */
        Route::resource('dba_users_doctor_files', '\App\Http\Controllers\Admin\DBAUsersDoctorFilesController', ['names' => ['create' => 'dba_users_doctor_files_add', 'store' => 'dba_users_doctor_files_add', 'index' => 'dba_users_doctor_files', 'edit' => 'dba_users_doctor_files_edit', 'update' => 'dba_users_doctor_files_edit', 'destroy' => 'dba_users_doctor_files_delete']]);
        Route::post('dba_users_doctor_files_search', ['uses' => '\App\Http\Controllers\Admin\DBAUsersDoctorFilesController@search', 'as' => 'new_modules_projects_view']);
        Route::put('dba_users_doctor_files/{id}/editProjectStatus', ['uses' => '\App\Http\Controllers\Admin\DBAUsersDoctorFilesController@editProjectStatus', 'as' => 'dba_users_doctor_files_edit']);
        Route::put('dba_users_doctor_files/{id}/editProjectResult', ['uses' => '\App\Http\Controllers\Admin\DBAUsersDoctorFilesController@editProjectResult', 'as' => 'dba_users_doctor_files_edit']);
        Route::post('dba_users_doctor_files/upload_correction', ['uses' => '\App\Http\Controllers\Admin\DBAUsersDoctorFilesController@uploadCorrection', 'as' => 'dba_users_doctor_files_edit']);
        Route::get('dba_users_doctor_files/download_file/{id}', ['uses' => '\App\Http\Controllers\Admin\DBAUsersDoctorFilesController@downloadFile', 'as' => 'dba_users_doctor_files_view']);
        /* End dba_users_doctor_files Routes */

        /* Start New Modules Category Users Projects Routes */
        Route::resource('new_mba_category_users_projects', '\App\Http\Controllers\Admin\NewMbaCategoryUsersProjectsController', ['names' => ['create' => 'new_mba_category_users_projects_add', 'store' => 'new_mba_category_users_projects_add', 'index' => 'new_mba_category_users_projects', 'edit' => 'new_mba_category_users_projects_edit', 'update' => 'new_mba_category_users_projects_edit', 'destroy' => 'new_mba_category_users_projects_delete']]);
        Route::post('new_mba_category_users_projects_search', ['uses' => '\App\Http\Controllers\Admin\NewMbaCategoryUsersProjectsController@search', 'as' => 'new_modules_projects_view']);
        Route::put('new_mba_category_users_projects/{id}/editProjectStatus', ['uses' => '\App\Http\Controllers\Admin\NewMbaCategoryUsersProjectsController@editProjectStatus', 'as' => 'new_mba_category_users_projects_edit']);
        Route::put('new_mba_category_users_projects/{id}/editProjectResult', ['uses' => '\App\Http\Controllers\Admin\NewMbaCategoryUsersProjectsController@editProjectResult', 'as' => 'new_mba_category_users_projects_edit']);
        Route::post('new_mba_category_users_projects/upload_correction', ['uses' => '\App\Http\Controllers\Admin\NewMbaCategoryUsersProjectsController@uploadCorrection', 'as' => 'new_mba_category_users_projects_edit']);
        Route::get('new_mba_category_users_projects/download_file/{id}', ['uses' => '\App\Http\Controllers\Admin\NewMbaCategoryUsersProjectsController@downloadFile', 'as' => 'new_modules_projects_view']);
        /* End New Modules Category Users Projects Routes */

        Route::resource('instructors', '\App\Http\Controllers\Admin\InstructorsController', ['names' => ['create' => 'instructors_add', 'store' => 'instructors_add', 'index' => 'instructors', 'edit' => 'instructors_edit', 'update' => 'instructors_edit', 'destroy' => 'instructors_delete']]);
        Route::post('instructors_search', ['uses' => '\App\Http\Controllers\Admin\InstructorsController@search', 'as' => 'instructors_view']);
        Route::post('instructors/publish', ['uses' => '\App\Http\Controllers\Admin\InstructorsController@publish', 'as' => 'instructors_publish']);


        Route::post('academy_alumni/import', ['uses' => '\App\Http\Controllers\Admin\AcademyAlumniController@import', 'as' => 'academy_alumni_add']);
        Route::resource('academy_alumni', '\App\Http\Controllers\Admin\AcademyAlumniController', ['names' => ['create' => 'academy_alumni_add', 'store' => 'academy_alumni_add', 'index' => 'academy_alumni', 'edit' => 'academy_alumni_edit', 'update' => 'academy_alumni_edit', 'destroy' => 'academy_alumni_delete']]);
        Route::post('academy_alumni_search', ['uses' => '\App\Http\Controllers\Admin\AcademyAlumniController@search', 'as' => 'academy_alumni_view']);
        Route::post('academy_alumni/publish', ['uses' => '\App\Http\Controllers\Admin\AcademyAlumniController@publish', 'as' => 'academy_alumni_publish']);


        Route::resource('website_banners', '\App\Http\Controllers\Admin\WebsiteBannersController', ['names' => ['create' => 'website_banners_add', 'store' => 'website_banners_add', 'index' => 'website_banners', 'edit' => 'website_banners_edit', 'update' => 'website_banners_edit', 'destroy' => 'website_banners_delete']]);
        Route::post('website_banners_search', ['uses' => '\App\Http\Controllers\Admin\WebsiteBannersController@search', 'as' => 'website_banners_view']);
        Route::post('website_banners/publish', ['uses' => '\App\Http\Controllers\Admin\WebsiteBannersController@publish', 'as' => 'website_banners_publish']);

        Route::resource('blocked_users', '\App\Http\Controllers\Admin\BlockedUsersController', ['names' => ['index' => 'blocked_users']]);
        Route::post('blocked_users_search', ['uses' => '\App\Http\Controllers\Admin\BlockedUsersController@search', 'as' => 'blocked_users_view']);


        Route::get('webinars/{id}/convert', ['uses' => '\App\Http\Controllers\Admin\WebinarsController@convert', 'as' => 'webinars_convert']);
        Route::resource('webinars', '\App\Http\Controllers\Admin\WebinarsController', ['names' => ['create' => 'webinars_add', 'store' => 'webinars_add', 'index' => 'webinars', 'edit' => 'webinars_edit', 'update' => 'webinars_edit', 'destroy' => 'webinars_delete']]);
        Route::post('webinars_search', ['uses' => '\App\Http\Controllers\Admin\WebinarsController@search', 'as' => 'webinars_view']);
        Route::post('webinars/activation', ['uses' => '\App\Http\Controllers\Admin\WebinarsController@activation', 'as' => 'webinars_active']);


        Route::resource('live', '\App\Http\Controllers\Admin\LiveController', ['names' => ['create' => 'live_add', 'store' => 'live_add', 'index' => 'live', 'edit' => 'live_edit', 'update' => 'live_edit', 'destroy' => 'live_delete']]);
        Route::post('live_search', ['uses' => '\App\Http\Controllers\Admin\LiveController@search', 'as' => 'live_view']);
        Route::post('live/activation', ['uses' => '\App\Http\Controllers\Admin\LiveController@activation', 'as' => 'live_active']);

        Route::resource('old_urls', '\App\Http\Controllers\Admin\OldUrlsController', ['names' => ['create' => 'old_urls_add', 'store' => 'old_urls_add', 'index' => 'old_urls', 'edit' => 'old_urls_edit', 'update' => 'old_urls_edit', 'destroy' => 'old_urls_delete']]);
        Route::post('old_urls_search', ['uses' => '\App\Http\Controllers\Admin\OldUrlsController@search', 'as' => 'old_urls_view']);

        Route::resource('books', '\App\Http\Controllers\Admin\BooksController', ['names' => ['create' => 'books_add', 'store' => 'books_add', 'index' => 'books', 'edit' => 'books_edit', 'update' => 'books_edit', 'destroy' => 'books_delete']]);
        Route::post('books_search', ['uses' => '\App\Http\Controllers\Admin\BooksController@search', 'as' => 'books_view']);
        Route::post('books/publish', ['uses' => '\App\Http\Controllers\Admin\BooksController@publish', 'as' => 'books_publish']);
        Route::get('bookdownload/{book}', ['uses' => '\App\Http\Controllers\Admin\BooksController@download', 'as' => 'books_edit']);

        Route::resource('books_playlist', '\App\Http\Controllers\Admin\BooksPlaylistController', ['names' => ['create' => 'books_playlist_add', 'store' => 'books_playlist_add', 'index' => 'books_playlist', 'edit' => 'books_playlist_edit', 'update' => 'books_playlist_edit', 'destroy' => 'books_playlist_delete']]);
        Route::post('books_playlist_search', ['uses' => '\App\Http\Controllers\Admin\BooksPlaylistController@search', 'as' => 'books_playlist_view']);
        Route::post('books_playlist/publish', ['uses' => '\App\Http\Controllers\Admin\BooksPlaylistController@publish', 'as' => 'books_playlist_publish']);
        Route::get('bookplaylistdownload/{book}', ['uses' => '\App\Http\Controllers\Admin\BooksPlaylistController@download', 'as' => 'books_playlist_edit']);


        /*diplomas_files*/
        Route::resource('diplomas_files', '\App\Http\Controllers\Admin\DiplomasFilesController', ['names' => ['create' => 'diplomas_files', 'store' => 'diplomas_files', 'index' => 'diplomas_files', 'edit' => 'diplomas_files', 'update' => 'diplomas_files', 'destroy' => 'diplomas_files']]);
        Route::post('diplomas_files_search', ['uses' => '\App\Http\Controllers\Admin\DiplomasFilesController@search', 'as' => 'diplomas_files']);
        Route::post('diplomas_files/activation', ['uses' => '\App\Http\Controllers\Admin\DiplomasFilesController@activation', 'as' => 'diplomas_files']);
        Route::get('diplomas_files/delete_file/{id}', ['uses' => '\App\Http\Controllers\Admin\DiplomasFilesController@delete_file', 'as' => 'diplomas_files']);

        /*diplomas_files*/



        Route::resource('diplomas', '\App\Http\Controllers\Admin\DiplomasController', ['names' => ['create' => 'diplomas_add', 'store' => 'diplomas_add', 'index' => 'diplomas', 'edit' => 'diplomas_edit', 'update' => 'diplomas_edit', 'destroy' => 'diplomas_delete']]);
        Route::post('diplomas_search', ['uses' => '\App\Http\Controllers\Admin\DiplomasController@search', 'as' => 'diplomas_view']);
        Route::post('diplomas/activation', ['uses' => '\App\Http\Controllers\Admin\DiplomasController@activation', 'as' => 'diplomas_active']);
        Route::get('diplomas/delete_file/{id}', ['uses' => '\App\Http\Controllers\Admin\DiplomasController@delete_file', 'as' => 'diplomas_delete']);
        Route::post('diplomas/delete_image',['uses'=>'\App\Http\Controllers\Admin\DiplomasController@deleteImage','as'=>'diplomas_edit']);


        Route::resource('packages', '\App\Http\Controllers\Admin\PackagesController', ['names' => ['create' => 'packages_add', 'store' => 'packages_add', 'index' => 'packages', 'edit' => 'packages_edit', 'update' => 'packages_edit', 'destroy' => 'packages_delete']]);
        Route::post('packages_search', ['uses' => '\App\Http\Controllers\Admin\PackagesController@search', 'as' => 'packages_view']);
        Route::post('packages/activation', ['uses' => '\App\Http\Controllers\Admin\PackagesController@activation', 'as' => 'packages_active']);
        Route::get('packages/delete_file/{id}', ['uses' => '\App\Http\Controllers\Admin\PackagesController@delete_file', 'as' => 'packages_delete']);
        Route::post('packages/delete_image',['uses'=>'\App\Http\Controllers\Admin\PackagesController@deleteImage','as'=>'packages_edit']);

        Route::resource('package_courses', '\App\Http\Controllers\Admin\PackageCourseController', ['names' => ['create' => 'package_courses_add', 'store' => 'package_courses_add', 'index' => 'package_courses', 'edit' => 'package_courses_edit', 'update' => 'package_courses_edit', 'destroy' => 'package_courses_delete']]);
        Route::post('package_courses_search', ['uses' => '\App\Http\Controllers\Admin\PackageCourseController@search', 'as' => 'package_courses_view']);
        Route::post('package_courses/publish', ['uses' => '\App\Http\Controllers\Admin\PackageCourseController@publish', 'as' => 'package_courses_publish']);

        Route::resource('package_user_courses', '\App\Http\Controllers\Admin\PackageUserCourseController', ['names' => ['create' => 'package_user_courses_add', 'store' => 'package_user_courses_add', 'index' => 'package_user_courses', 'edit' => 'package_user_courses_edit', 'update' => 'package_user_courses_edit', 'destroy' => 'package_user_courses_delete']]);
        Route::post('package_user_courses_search', ['uses' => '\App\Http\Controllers\Admin\PackageUserCourseController@search', 'as' => 'package_user_courses_view']);
        Route::post('package_user_courses/publish', ['uses' => '\App\Http\Controllers\Admin\PackageUserCourseController@publish', 'as' => 'package_user_courses_publish']);
        Route::post('package_user_courses/delete_all', ['uses' => '\App\Http\Controllers\Admin\PackageUserCourseController@delete_all', 'as' => 'package_user_courses_delete_all']);
        Route::get('package_user_courses/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\PackageUserCourseController@copy', 'as' => 'package_user_courses_copy']);
        Route::post('package_user_courses/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'package_user_courses_add']);

        Route::resource('pctsl', '\App\Http\Controllers\Admin\PackagesChargeTransactionSuspendLogController', ['names' => ['create' => 'packages_charge_transaction_suspend_log_add', 'store' => 'packages_charge_transaction_suspend_log_add', 'index' => 'packages_charge_transaction_suspend_log', 'edit' => 'packages_charge_transaction_suspend_log_edit', 'update' => 'packages_charge_transaction_suspend_log_edit', 'destroy' => 'packages_charge_transaction_suspend_log_delete']]);
        Route::post('pctsl_search', ['uses' => '\App\Http\Controllers\Admin\PackagesChargeTransactionSuspendLogController@search', 'as' => 'packages_charge_transaction_suspend_log_view']);
        Route::post('pctsl/publish', ['uses' => '\App\Http\Controllers\Admin\PackagesChargeTransactionSuspendLogController@publish', 'as' => 'packages_charge_transaction_suspend_log_publish']);
        Route::post('pctsl/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'packages_charge_transaction_suspend_log_add']);

        Route::resource('pct', '\App\Http\Controllers\Admin\PackagesChargeTransactionController', ['names' => ['create' => 'packages_charge_transaction_add', 'store' => 'packages_charge_transaction_add', 'index' => 'packages_charge_transaction', 'edit' => 'packages_charge_transaction_edit', 'update' => 'packages_charge_transaction_edit', 'destroy' => 'packages_charge_transaction_delete']]);
        Route::post('pct_search', ['uses' => '\App\Http\Controllers\Admin\PackagesChargeTransactionController@search', 'as' => 'packages_charge_transaction_view']);
        Route::post('pct/publish', ['uses' => '\App\Http\Controllers\Admin\PackagesChargeTransactionController@publish', 'as' => 'packages_charge_transaction_publish']);
        Route::post('pct/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'packages_charge_transaction_add']);
        Route::get('pct/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\PackagesChargeTransactionController@copy', 'as' => 'packages_charge_transaction_copy']);
        Route::post('pct/add_courses/{id}', ['uses' => '\App\Http\Controllers\Admin\PackagesChargeTransactionController@addCourses', 'as' => 'packages_charge_transaction_add_courses']);


        Route::resource('custom_user_courses', '\App\Http\Controllers\Admin\CustomUserCourseController', ['names' => ['create' => 'custom_user_courses_add', 'store' => 'custom_user_courses_add', 'index' => 'custom_user_courses', 'edit' => 'custom_user_courses_edit', 'update' => 'custom_user_courses_edit', 'destroy' => 'custom_user_courses_delete']]);
        Route::post('custom_user_courses_search', ['uses' => '\App\Http\Controllers\Admin\CustomUserCourseController@search', 'as' => 'custom_user_courses_view']);
        Route::post('custom_user_courses/publish', ['uses' => '\App\Http\Controllers\Admin\CustomUserCourseController@publish', 'as' => 'custom_user_courses_publish']);
        Route::post('custom_user_courses/delete_all', ['uses' => '\App\Http\Controllers\Admin\CustomUserCourseController@delete_all', 'as' => 'custom_user_courses_delete_all']);
        Route::get('custom_user_courses/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\CustomUserCourseController@copy', 'as' => 'custom_user_courses_copy']);
        Route::post('custom_user_courses/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'custom_user_courses_add']);

        Route::resource('custom_ctsl', '\App\Http\Controllers\Admin\CustomChargeTransactionSuspendLogController', ['names' => [ 'index' => 'custom_charge_transaction_suspend_log']]);
        Route::post('custom_ctsl_search', ['uses' => '\App\Http\Controllers\Admin\CustomChargeTransactionSuspendLogController@search', 'as' => 'custom_charge_transaction_suspend_log_view']);
        Route::post('custom_ctsl/publish', ['uses' => '\App\Http\Controllers\Admin\CustomChargeTransactionSuspendLogController@publish', 'as' => 'custom_charge_transaction_suspend_log_publish']);
        Route::post('custom_ctsl/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'custom_charge_transaction_suspend_log_add']);

        Route::resource('custom_ct', '\App\Http\Controllers\Admin\CustomChargeTransactionController', ['names' => ['create' => 'custom_charge_transaction_add', 'store' => 'custom_charge_transaction_add', 'index' => 'custom_charge_transaction', 'edit' => 'custom_charge_transaction_edit', 'update' => 'custom_charge_transaction_edit', 'destroy' => 'custom_charge_transaction_delete']]);
        Route::post('custom_ct_search', ['uses' => '\App\Http\Controllers\Admin\CustomChargeTransactionController@search', 'as' => 'custom_charge_transaction_view']);
        Route::post('custom_ct/publish', ['uses' => '\App\Http\Controllers\Admin\CustomChargeTransactionController@publish', 'as' => 'custom_charge_transaction_publish']);
        Route::post('custom_ct/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'custom_charge_transaction_add']);
        Route::get('custom_ct/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\CustomChargeTransactionController@copy', 'as' => 'custom_charge_transaction_copy']);
        Route::post('custom_ct/add_courses/{id}', ['uses' => '\App\Http\Controllers\Admin\CustomChargeTransactionController@addCourses', 'as' => 'custom_charge_transaction_add_courses']);

        Route::resource('training_program', '\App\Http\Controllers\Admin\trainingProgramController', ['names' => ['create' => 'training_program_add', 'store' => 'training_program_add', 'index' => 'training_program', 'edit' => 'training_program_edit', 'update' => 'training_program_edit', 'destroy' => 'training_program_delete']]);
        Route::post('training_program_search', ['uses' => '\App\Http\Controllers\Admin\trainingProgramController@search', 'as' => 'training_program_view']);
        Route::post('training_program/activation', ['uses' => '\App\Http\Controllers\Admin\trainingProgramController@activation', 'as' => 'training_program_active']);
        Route::get('training_program/delete_file/{id}', ['uses' => '\App\Http\Controllers\Admin\trainingProgramController@delete_file', 'as' => 'training_program_delete']);

        Route::resource('international_diplomas', '\App\Http\Controllers\Admin\InternationalDiplomasController', ['names' => ['create' => 'international_diplomas_add', 'store' => 'international_diplomas_add', 'index' => 'international_diplomas', 'edit' => 'international_diplomas_edit', 'update' => 'international_diplomas_edit', 'destroy' => 'international_diplomas_delete']]);
        Route::post('international_diplomas_search', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomasController@search', 'as' => 'international_diplomas_view']);
        Route::post('international_diplomas/activation', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomasController@activation', 'as' => 'international_diplomas_active']);

        Route::resource('successstories', '\App\Http\Controllers\Admin\SuccessstoriesController', ['names' => ['create' => 'successstories_add', 'store' => 'successstories_add', 'index' => 'successstories', 'edit' => 'successstories_edit', 'update' => 'successstories_edit', 'destroy' => 'successstories_delete']]);
        Route::post('successstories_search', ['uses' => '\App\Http\Controllers\Admin\SuccessstoriesController@search', 'as' => 'successstories_view']);
        Route::post('successstories/publish', ['uses' => '\App\Http\Controllers\Admin\SuccessstoriesController@publish', 'as' => 'successstories_publish']);

        Route::resource('articles', '\App\Http\Controllers\Admin\ArticlesController', ['names' => ['create' => 'articles_add', 'store' => 'articles_add', 'index' => 'articles', 'edit' => 'articles_edit', 'update' => 'articles_edit', 'destroy' => 'articles_delete']]);
        Route::post('articles_search', ['uses' => '\App\Http\Controllers\Admin\ArticlesController@search', 'as' => 'articles_view']);
        Route::post('articles/publish', ['uses' => '\App\Http\Controllers\Admin\ArticlesController@publish', 'as' => 'articles_publish']);
        Route::post('description_upload', ['uses' => '\App\Http\Controllers\Admin\ArticlesController@description_upload', 'as' => 'articles_view']);

        Route::resource('news', '\App\Http\Controllers\Admin\NewsController', ['names' => ['create' => 'news_add', 'store' => 'news_add', 'index' => 'news', 'edit' => 'news_edit', 'update' => 'news_edit', 'destroy' => 'news_delete']]);
        Route::post('news_search', ['uses' => '\App\Http\Controllers\Admin\NewsController@search', 'as' => 'news_view']);
        Route::post('news/publish', ['uses' => '\App\Http\Controllers\Admin\NewsController@publish', 'as' => 'news_publish']);


        Route::resource('initiative_sections', '\App\Http\Controllers\Admin\InitiativeSectionsController', ['names' => ['create' => 'initiative_sections_add', 'store' => 'initiative_sections_add', 'index' => 'initiative_sections', 'edit' => 'initiative_sections_edit', 'update' => 'initiative_sections_edit', 'destroy' => 'initiative_sections_delete']]);
        Route::post('initiative_sections_search', ['uses' => '\App\Http\Controllers\Admin\InitiativeSectionsController@search', 'as' => 'initiative_sections_view']);
        Route::post('initiative_sections/publish', ['uses' => '\App\Http\Controllers\Admin\InitiativeSectionsController@publish', 'as' => 'initiative_sections_publish']);

        Route::resource('initiative_videos', '\App\Http\Controllers\Admin\InitiativeVideosController', ['names' => ['create' => 'initiative_videos_add', 'store' => 'initiative_videos_add', 'index' => 'initiative_videos', 'edit' => 'initiative_videos_edit', 'update' => 'initiative_videos_edit', 'destroy' => 'initiative_videos_delete']]);
        Route::post('initiative_videos_search', ['uses' => '\App\Http\Controllers\Admin\InitiativeVideosController@search', 'as' => 'initiative_videos_view']);
        Route::post('initiative_videos/publish', ['uses' => '\App\Http\Controllers\Admin\InitiativeVideosController@publish', 'as' => 'initiative_videos_publish']);

        Route::resource('initiative_articles', '\App\Http\Controllers\Admin\InitiativeArticlesController', ['names' => ['create' => 'initiative_articles_add', 'store' => 'initiative_articles_add', 'index' => 'initiative_articles', 'edit' => 'initiative_articles_edit', 'update' => 'initiative_articles_edit', 'destroy' => 'initiative_articles_delete']]);
        Route::post('initiative_articles_search', ['uses' => '\App\Http\Controllers\Admin\InitiativeArticlesController@search', 'as' => 'initiative_articles_view']);
        Route::post('initiative_articles/publish', ['uses' => '\App\Http\Controllers\Admin\InitiativeArticlesController@publish', 'as' => 'initiative_articles_publish']);

        Route::resource('medical_categories', '\App\Http\Controllers\Admin\MedicalCategoriesController', ['names' => ['create' => 'medical_categories_add', 'store' => 'medical_categories_add', 'index' => 'medical_categories_view', 'edit' => 'medical_categories_edit', 'update' => 'medical_categories_edit', 'destroy' => 'medical_categories_delete']]);
        Route::post('medical_categories_search', ['uses' => '\App\Http\Controllers\Admin\MedicalCategoriesController@search', 'as' => 'medical_categories_view']);
        Route::post('medical_categories/publish', ['uses' => '\App\Http\Controllers\Admin\MedicalCategoriesController@publish', 'as' => 'medical_categories_publish']);


        Route::resource('medical_sup_categories', '\App\Http\Controllers\Admin\MedicalSupCategoriesController', ['names' => ['create' => 'medical_sup_categories_add', 'store' => 'medical_sup_categories_add', 'index' => 'medical_sup_categories_view', 'edit' => 'medical_sup_categories_edit', 'update' => 'medical_sup_categories_edit', 'destroy' => 'medical_sup_categories_delete']]);
        Route::post('medical_sup_categories_search', ['uses' => '\App\Http\Controllers\Admin\MedicalSupCategoriesController@search', 'as' => 'medical_sup_categories_view']);
        Route::post('medical_sup_categories/publish', ['uses' => '\App\Http\Controllers\Admin\MedicalSupCategoriesController@publish', 'as' => 'medical_sup_categories_publish']);

        Route::resource('mobile_notifications', '\App\Http\Controllers\Admin\MobileNotificationsController', ['names' => ['index' => 'mobile_notifications_add','create' => 'mobile_notifications_add', 'store' => 'mobile_notifications_add']]);
        Route::post('mobile_notifications/users', ['uses' => '\App\Http\Controllers\Admin\MobileNotificationsController@users', 'as' => 'mobile_notifications_add']);

        Route::resource('categories', '\App\Http\Controllers\Admin\CategoriesController', ['names' => ['create' => 'categories_add', 'store' => 'categories_add', 'index' => 'categories', 'edit' => 'categories_edit', 'update' => 'categories_edit', 'destroy' => 'categories_delete']]);
        Route::post('categories_search', ['uses' => '\App\Http\Controllers\Admin\CategoriesController@search', 'as' => 'categories_view']);
        Route::post('categories/publish', ['uses' => '\App\Http\Controllers\Admin\CategoriesController@activation', 'as' => 'categories_active']);

        Route::resource('pdf_templetes', '\App\Http\Controllers\Admin\PdfTempletesController', ['names' => ['create' => 'pdf_templetes_add', 'store' => 'pdf_templetes_add', 'index' => 'pdf_templetes', 'edit' => 'pdf_templetes_edit', 'update' => 'pdf_templetes_edit', 'destroy' => 'pdf_templetes_delete']]);
        Route::post('pdf_templetes_search', ['uses' => '\App\Http\Controllers\Admin\PdfTempletesController@search', 'as' => 'pdf_templetes_view']);
        Route::post('pdf_templetes/publish', ['uses' => '\App\Http\Controllers\Admin\PdfTempletesController@publish', 'as' => 'pdf_templetes_publish']);

        Route::resource('pdf_files', '\App\Http\Controllers\Admin\PdfFilesController', ['names' => ['create' => 'pdf_files_add', 'store' => 'pdf_files_add', 'index' => 'pdf_files', 'edit' => 'pdf_files_edit', 'update' => 'pdf_files_edit', 'destroy' => 'pdf_files_delete']]);
        Route::post('pdf_files_search', ['uses' => '\App\Http\Controllers\Admin\PdfFilesController@search', 'as' => 'pdf_files_view']);
        Route::post('pdf_files/publish', ['uses' => '\App\Http\Controllers\Admin\PdfFilesController@publish', 'as' => 'pdf_files_publish']);


        /* new_mba_categories Routs Start*/
        Route::resource('new_mba_categories', '\App\Http\Controllers\Admin\NewMbaCategoriesController',['names'=>['create'=>'new_mba_categories_add','store'=>'new_mba_categories_add','index'=>'new_mba_categories_view','edit'=>'new_mba_categories_edit','update'=>'new_mba_categories_edit','destroy'=>'new_mba_categories_delete']]);
        Route::post('new_mba_categories/publish',['uses'=>'\App\Http\Controllers\Admin\NewMbaCategoriesController@publish','as'=>'new_mba_categories_active']);
        /* new_mba_categories Routs End*/



        /* new_mba_categories_modules Routs Start*/
        Route::resource('new_mba_categories_modules', '\App\Http\Controllers\Admin\NewMbaCategoriesModulesController',['names'=>['create'=>'new_mba_categories_modules_add','store'=>'new_mba_categories_modules_add','index'=>'new_mba_categories_modules_view','edit'=>'new_mba_categories_modules_edit','update'=>'new_mba_categories_modules_edit','destroy'=>'new_mba_categories_modules_delete']]);
        Route::post('new_mba_categories_modules/publish',['uses'=>'\App\Http\Controllers\Admin\NewMbaCategoriesModulesController@publish','as'=>'new_mba_categories_modules_active']);
        /* new_mba_categories_modules Routs End*/



        Route::resource('author', '\App\Http\Controllers\Admin\AuthorController', ['names' => ['create' => 'author_add', 'store' => 'author_add', 'index' => 'author', 'edit' => 'author_edit', 'update' => 'author_edit', 'destroy' => 'author_delete']]);
        Route::post('author_search', ['uses' => '\App\Http\Controllers\Admin\AuthorController@search', 'as' => 'author_view']);
        Route::post('author/publish', ['uses' => '\App\Http\Controllers\Admin\AuthorController@publish', 'as' => 'author_publish']);


        Route::resource('static_pages', '\App\Http\Controllers\Admin\StaticPageController', ['names' => ['create' => 'static_pages_add', 'store' => 'static_pages_add', 'index' => 'static_pages', 'edit' => 'static_pages_edit', 'update' => 'static_pages_edit', 'destroy' => 'static_pages_delete']]);
        Route::post('static_pages_search', ['uses' => '\App\Http\Controllers\Admin\StaticPageController@search', 'as' => 'static_pages_view']);
        Route::post('static_pages/publish', ['uses' => '\App\Http\Controllers\Admin\StaticPageController@publish', 'as' => 'static_pages_publish']);

        Route::resource('modules_users_summary', '\App\Http\Controllers\Admin\ModulesUsersSummaryController', ['names' => ['index' => 'modules_users_summary', 'edit' => 'modules_users_summary_edit', 'update' => 'modules_users_summary_edit']]);
        Route::post('modules_users_summary_search', ['uses' => '\App\Http\Controllers\Admin\ModulesUsersSummaryController@search', 'as' => 'modules_users_summary_view']);

        /* Start New Modules Users Summary Routes */
        Route::resource('new_modules_users_summary', '\App\Http\Controllers\Admin\NewModulesUsersSummaryController', ['names' => ['index' => 'new_modules_users_summary', 'edit' => 'new_modules_users_summary_edit', 'update' => 'new_modules_users_summary_edit']]);
        Route::post('new_modules_users_summary_search', ['uses' => '\App\Http\Controllers\Admin\NewModulesUsersSummaryController@search', 'as' => 'new_modules_users_summary_view']);
        /* End New Modules Users Summary Routes */

        Route::resource('courses_QandA', '\App\Http\Controllers\Admin\CoursesQuestionsAndAnswersController', ['names' => ['index' => 'courses_QandA', 'edit' => 'courses_QandA_edit', 'update' => 'courses_QandA_edit']]);
        Route::post('courses_QandA_search', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestionsAndAnswersController@search', 'as' => 'courses_QandA_view']);
        Route::get('courses_QandA_file_delete/{id}', ['uses' => '\App\Http\Controllers\Admin\CoursesQuestionsAndAnswersController@delete_file', 'as' => 'courses_QandA_edit']);



        Route::resource('recruitment_jobs', '\App\Http\Controllers\Admin\RecruitmentJobController', ['names' => ['create' => 'recruitment_jobs_add', 'store' => 'recruitment_jobs_add', 'index' => 'recruitment_jobs', 'edit' => 'recruitment_jobs_edit', 'update' => 'recruitment_jobs_edit', 'destroy' => 'recruitment_jobs_delete']]);
        Route::post('recruitment_jobs_search', ['uses' => '\App\Http\Controllers\Admin\RecruitmentJobController@search', 'as' => 'recruitment_jobs_view']);
        Route::post('recruitment_jobs/publish', ['uses' => '\App\Http\Controllers\Admin\RecruitmentJobController@publish', 'as' => 'recruitment_jobs_publish']);
        Route::post('recruitment_jobs/autoCompleteCountries', ['uses' => '\App\Http\Controllers\Admin\CountryController@autoCompleteCountries', 'as' => 'recruitment_jobs_add']);
        Route::post('recruitment_jobs/autoCompleteCities', ['uses' => '\App\Http\Controllers\Admin\CityController@autoCompleteCities', 'as' => 'recruitment_jobs_add']);
        Route::post('recruitment_jobs/autoCompleteStates', ['uses' => '\App\Http\Controllers\Admin\StateController@autoCompleteStates', 'as' => 'recruitment_jobs_add']);

        Route::resource('recruitment_industries', '\App\Http\Controllers\Admin\RecruitmentIndustryController', ['names' => ['create' => 'recruitment_industries_add', 'store' => 'recruitment_industries_add', 'index' => 'recruitment_industries', 'edit' => 'recruitment_industries_edit', 'update' => 'recruitment_industries_edit', 'destroy' => 'recruitment_industries_delete']]);
        Route::post('recruitment_industries_search', ['uses' => '\App\Http\Controllers\Admin\RecruitmentIndustryController@search', 'as' => 'recruitment_industries_view']);
        Route::post('recruitment_industries/publish', ['uses' => '\App\Http\Controllers\Admin\RecruitmentIndustryController@publish', 'as' => 'recruitment_industries_publish']);

        Route::resource('recruitment_job_types', '\App\Http\Controllers\Admin\RecruitmentJobTypesController', ['names' => ['create' => 'recruitment_job_types_add', 'store' => 'recruitment_job_types_add', 'index' => 'recruitment_job_types', 'edit' => 'recruitment_job_types_edit', 'update' => 'recruitment_job_types_edit', 'destroy' => 'recruitment_job_types_delete']]);
        Route::post('recruitment_job_types_search', ['uses' => '\App\Http\Controllers\Admin\RecruitmentJobTypesController@search', 'as' => 'recruitment_job_types_view']);
        Route::post('recruitment_job_types/publish', ['uses' => '\App\Http\Controllers\Admin\RecruitmentJobTypesController@publish', 'as' => 'recruitment_job_types_publish']);

        Route::resource('recruitment_currencies', '\App\Http\Controllers\Admin\RecruitmentCurrencyController', ['names' => ['create' => 'recruitment_currencies_add', 'store' => 'recruitment_currencies_add', 'index' => 'recruitment_currencies', 'edit' => 'recruitment_currencies_edit', 'update' => 'recruitment_currencies_edit', 'destroy' => 'recruitment_currencies_delete']]);
        Route::post('recruitment_currencies_search', ['uses' => '\App\Http\Controllers\Admin\RecruitmentCurrencyController@search', 'as' => 'recruitment_currencies_view']);
        Route::post('recruitment_currencies/publish', ['uses' => '\App\Http\Controllers\Admin\RecruitmentCurrencyController@publish', 'as' => 'recruitment_currencies_publish']);

        Route::resource('recruitment_jobs_types', '\App\Http\Controllers\Admin\RecruitmentJobsTypesController', ['names' => ['create' => 'recruitment_jobs_types_add', 'store' => 'recruitment_jobs_types_add', 'index' => 'recruitment_jobs_types', 'edit' => 'recruitment_jobs_types_edit', 'update' => 'recruitment_jobs_types_edit', 'destroy' => 'recruitment_jobs_types_delete']]);
        Route::post('recruitment_jobs_types_search', ['uses' => '\App\Http\Controllers\Admin\RecruitmentJobsTypesController@search', 'as' => 'recruitment_jobs_types_view']);
        Route::post('recruitment_jobs_types/publish', ['uses' => '\App\Http\Controllers\Admin\RecruitmentJobsTypesController@publish', 'as' => 'recruitment_jobs_types_publish']);

        Route::resource('recruitment_job_roles', '\App\Http\Controllers\Admin\RecruitmentJobRolesController', ['names' => ['create' => 'recruitment_job_roles_add', 'store' => 'recruitment_job_roles_add', 'index' => 'recruitment_job_roles', 'edit' => 'recruitment_job_roles_edit', 'update' => 'recruitment_job_roles_edit', 'destroy' => 'recruitment_job_roles_delete']]);
        Route::post('recruitment_job_roles_search', ['uses' => '\App\Http\Controllers\Admin\RecruitmentJobRolesController@search', 'as' => 'recruitment_job_roles_view']);
        Route::post('recruitment_job_roles/publish', ['uses' => '\App\Http\Controllers\Admin\RecruitmentJobRolesController@publish', 'as' => 'recruitment_job_roles_publish']);

        Route::resource('recruitment_jobs_roles', '\App\Http\Controllers\Admin\RecruitmentJobsRolesController', ['names' => ['create' => 'recruitment_jobs_roles_add', 'store' => 'recruitment_jobs_roles_add', 'index' => 'recruitment_jobs_roles', 'edit' => 'recruitment_jobs_roles_edit', 'update' => 'recruitment_jobs_roles_edit', 'destroy' => 'recruitment_jobs_roles_delete']]);
        Route::post('recruitment_jobs_roles_search', ['uses' => '\App\Http\Controllers\Admin\RecruitmentJobsRolesController@search', 'as' => 'recruitment_jobs_roles_view']);
        Route::post('recruitment_jobs_roles/publish', ['uses' => '\App\Http\Controllers\Admin\RecruitmentJobsRolesController@publish', 'as' => 'recruitment_jobs_roles_publish']);

        Route::resource('partner_requests', '\App\Http\Controllers\Admin\PartnerRequestController', ['names' => ['create' => 'partner_requests_add', 'store' => 'partner_requests_add', 'index' => 'partner_requests', 'edit' => 'partner_requests_edit', 'update' => 'partner_requests_edit', 'destroy' => 'partner_requests_delete']]);
        Route::post('partner_requests_search', ['uses' => '\App\Http\Controllers\Admin\PartnerRequestController@search', 'as' => 'partner_requests_view']);
        Route::post('partner_requests/publish', ['uses' => '\App\Http\Controllers\Admin\PartnerRequestController@publish', 'as' => 'partner_requests_publish']);

        Route::resource('become_instructor', '\App\Http\Controllers\Admin\BecomeInstructorController', ['names' => ['create' => 'become_instructor_add', 'store' => 'become_instructor_add', 'index' => 'become_instructor', 'edit' => 'become_instructor_edit', 'update' => 'become_instructor_edit', 'destroy' => 'become_instructor_delete']]);
        Route::post('become_instructor_search', ['uses' => '\App\Http\Controllers\Admin\BecomeInstructorController@search', 'as' => 'become_instructor_view']);
        Route::post('become_instructor/publish', ['uses' => '\App\Http\Controllers\Admin\BecomeInstructorController@publish', 'as' => 'become_instructor_publish']);
        Route::get('become_instructor/download_file/{id}/{type}', ['uses' => '\App\Http\Controllers\Admin\BecomeInstructorController@downloadFile', 'as' => 'become_instructor_view']);

        Route::resource('testimonials', '\App\Http\Controllers\Admin\TestimonialController', ['names' => ['create' => 'testimonials_add', 'store' => 'testimonials_add', 'index' => 'testimonials', 'edit' => 'testimonials_edit', 'update' => 'testimonials_edit', 'destroy' => 'testimonials_delete']]);
        Route::post('testimonials_search', ['uses' => '\App\Http\Controllers\Admin\TestimonialController@search', 'as' => 'testimonials_view']);
        Route::post('testimonials/publish', ['uses' => '\App\Http\Controllers\Admin\TestimonialController@publish', 'as' => 'testimonials_publish']);

        Route::resource('gallery', '\App\Http\Controllers\Admin\GalleryController', ['names' => ['create' => 'gallery_add', 'store' => 'gallery_add', 'index' => 'gallery', 'edit' => 'gallery_edit', 'update' => 'gallery_edit', 'destroy' => 'gallery_delete']]);
        Route::post('gallery_search', ['uses' => '\App\Http\Controllers\Admin\GalleryController@search', 'as' => 'gallery_view']);
        Route::post('gallery/publish', ['uses' => '\App\Http\Controllers\Admin\GalleryController@publish', 'as' => 'gallery_publish']);

        Route::resource('mba_charge_transaction', '\App\Http\Controllers\Admin\MbaChargeTransactionController', ['names' => ['create' => 'mba_charge_transaction_add', 'store' => 'mba_charge_transaction_add', 'index' => 'mba_charge_transaction', 'edit' => 'mba_charge_transaction_edit', 'update' => 'mba_charge_transaction_edit', 'destroy' => 'mba_charge_transaction_delete']]);
        Route::post('mba_charge_transaction_search', ['uses' => '\App\Http\Controllers\Admin\MbaChargeTransactionController@search', 'as' => 'mba_charge_transaction_view']);
        Route::post('mba_charge_transaction/publish', ['uses' => '\App\Http\Controllers\Admin\MbaChargeTransactionController@publish', 'as' => 'mba_charge_transaction_publish']);
        Route::get('mba_charge_transaction/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\MbaChargeTransactionController@copy', 'as' => 'mba_charge_transaction_copy']);
        Route::post('mba_charge_transaction/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'mba_charge_transaction_add']);

        /* Start New MBA Charge Transaction Routes */
        Route::resource('new_mba_charge_transaction', '\App\Http\Controllers\Admin\NewMbaChargeTransactionController', ['names' => ['create' => 'new_mba_charge_transaction_add', 'store' => 'new_mba_charge_transaction_add', 'index' => 'new_mba_charge_transaction', 'edit' => 'new_mba_charge_transaction_edit', 'update' => 'new_mba_charge_transaction_edit', 'destroy' => 'new_mba_charge_transaction_delete']]);
        Route::post('new_mba_charge_transaction_search', ['uses' => '\App\Http\Controllers\Admin\NewMbaChargeTransactionController@search', 'as' => 'new_mba_charge_transaction_view']);
        Route::post('new_mba_charge_transaction/publish', ['uses' => '\App\Http\Controllers\Admin\NewMbaChargeTransactionController@publish', 'as' => 'new_mba_charge_transaction_publish']);
        Route::get('new_mba_charge_transaction/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\NewMbaChargeTransactionController@copy', 'as' => 'new_mba_charge_transaction_copy']);
        Route::post('new_mba_charge_transaction/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'new_mba_charge_transaction_add']);
        /* End New MBA Charge Transaction Routes */

        Route::resource('employee', '\App\Http\Controllers\Admin\EmployeeController', ['names' => ['create' => 'employee_add', 'store' => 'employee_add', 'index' => 'employee', 'edit' => 'employee_edit', 'update' => 'employee_edit', 'destroy' => 'employee_delete']]);
        Route::post('employee_search', ['uses' => '\App\Http\Controllers\Admin\EmployeeController@search', 'as' => 'employee_view']);
        Route::post('employee/publish', ['uses' => '\App\Http\Controllers\Admin\EmployeeController@publish', 'as' => 'employee_publish']);

        Route::resource('demo_medical_logs', '\App\Http\Controllers\Admin\DemoMedicalLogController', ['names' => ['create' => 'demo_medical_logs_add', 'store' => 'demo_medical_logs_add', 'index' => 'demo_medical_logs', 'edit' => 'demo_medical_logs_edit', 'update' => 'demo_medical_logs_edit', 'destroy' => 'demo_medical_logs_delete']]);
        Route::post('demo_medical_logs_search', ['uses' => '\App\Http\Controllers\Admin\DemoMedicalLogController@search', 'as' => 'demo_medical_logs_view']);
        Route::post('demo_medical_logs/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'demo_medical_logs_add']);

        Route::resource('users_suspend_liteversion', '\App\Http\Controllers\Admin\UsersSuspendLiteversionController', ['names' => ['create' => 'users_suspend_liteversion_add', 'store' => 'users_suspend_liteversion_add', 'index' => 'users_suspend_liteversion', 'edit' => 'users_suspend_liteversion_edit', 'update' => 'users_suspend_liteversion_edit', 'destroy' => 'users_suspend_liteversion_delete']]);
        Route::post('users_suspend_liteversion_search', ['uses' => '\App\Http\Controllers\Admin\UsersSuspendLiteversionController@search', 'as' => 'users_suspend_liteversion_view']);
        Route::post('users_suspend_liteversion/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'users_suspend_liteversion_add']);

        Route::resource('tags', '\App\Http\Controllers\Admin\TagsController', ['names' => ['create' => 'tags_add', 'store' => 'tags_add', 'index' => 'tags', 'edit' => 'tags_edit', 'update' => 'tags_edit', 'destroy' => 'tags_delete']]);
        Route::post('tags_search', ['uses' => '\App\Http\Controllers\Admin\TagsController@search', 'as' => 'tags_view']);

        Route::get('users_cvs', ['uses' =>'\App\Http\Controllers\Admin\UsersCVsController@index', 'as' => 'users_cvs_view']);
        Route::post('users_cvs_search', ['uses' => '\App\Http\Controllers\Admin\UsersCVsController@search', 'as' => 'users_cvs_view']);
        Route::get('cv_download/{id}', ['uses' => '\App\Http\Controllers\Admin\UsersCVsController@cv_download', 'as' => 'users_cvs_download']);

        Route::resource('normal_user', '\App\Http\Controllers\Admin\NormalUserController', ['names' => ['create' => 'normal_user_add', 'store' => 'normal_user_add', 'index' => 'normal_user', 'edit' => 'normal_user_edit', 'update' => 'normal_user_edit', 'destroy' => 'normal_user_delete']]);
        Route::post('normal_user_search', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@search', 'as' => 'normal_user_view']);
        Route::post('normal_user/publish', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@publish', 'as' => 'normal_user_publish']);
        Route::post('normal_user/reset_password', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@resetPassword', 'as' => 'normal_user_reset_password']);

        /* Start Rwaq Users Routes */

        Route::resource('rwaq_user', '\App\Http\Controllers\Admin\RwaqUserController', ['names' => ['create' => 'rwaq_user_add', 'store' => 'rwaq_user_add', 'index' => 'rwaq_user', 'edit' => 'rwaq_user_edit', 'update' => 'rwaq_user_edit', 'destroy' => 'rwaq_user_delete']]);
        Route::post('rwaq_user_search', ['uses' => '\App\Http\Controllers\Admin\RwaqUserController@search', 'as' => 'rwaq_user_view']);
        Route::post('rwaq_user/publish', ['uses' => '\App\Http\Controllers\Admin\RwaqUserController@publish', 'as' => 'rwaq_user_publish']);
        Route::post('rwaq_user/reset_password', ['uses' => '\App\Http\Controllers\Admin\RwaqUserController@resetPassword', 'as' => 'rwaq_user_reset_password']);
        Route::get('rwaq_user_export', ['uses' => '\App\Http\Controllers\Admin\RwaqUserController@export_rwaq_users', 'as' => 'rwaq_user_export']);

        /* End Rwaq Users Routes */

        Route::resource('recruit_users', '\App\Http\Controllers\Admin\RecruitUsersController', ['names' => ['create' => 'recruit_users_add', 'store' => 'recruit_users_add', 'index' => 'recruit_users', 'edit' => 'recruit_users_edit', 'update' => 'recruit_users_edit', 'destroy' => 'recruit_users_delete']]);
        Route::post('recruit_users_search', ['uses' => '\App\Http\Controllers\Admin\RecruitUsersController@search', 'as' => 'recruit_users_view']);
        Route::post('recruit_users/publish', ['uses' => '\App\Http\Controllers\Admin\RecruitUsersController@publish', 'as' => 'recruit_users_publish']);

        Route::resource('all_categories', '\App\Http\Controllers\Admin\AllCategoryController', ['names' => ['create' => 'all_categories_add', 'store' => 'all_categories_add', 'index' => 'all_categories', 'edit' => 'all_categories_edit', 'update' => 'all_categories_edit', 'destroy' => 'all_categories_delete']]);
        Route::post('all_categories_search', ['uses' => '\App\Http\Controllers\Admin\AllCategoryController@search', 'as' => 'all_categories_view']);
        Route::post('all_categories/publish', ['uses' => '\App\Http\Controllers\Admin\AllCategoryController@publish', 'as' => 'all_categories_publish']);

        Route::resource('sub_categories', '\App\Http\Controllers\Admin\SubCategoryController', ['names' => ['create' => 'sub_categories_add', 'store' => 'sub_categories_add', 'index' => 'sub_categories', 'edit' => 'sub_categories_edit', 'update' => 'sub_categories_edit', 'destroy' => 'sub_categories_delete']]);
        Route::post('sub_categories_search', ['uses' => '\App\Http\Controllers\Admin\SubCategoryController@search', 'as' => 'sub_categories_view']);
        Route::post('sub_categories/publish', ['uses' => '\App\Http\Controllers\Admin\SubCategoryController@publish', 'as' => 'sub_categories_publish']);

        Route::resource('courses_categories', '\App\Http\Controllers\Admin\CourseCategoryController', ['names' => ['create' => 'courses_categories_add', 'store' => 'courses_categories_add', 'index' => 'courses_categories', 'edit' => 'courses_categories_edit', 'update' => 'courses_categories_edit', 'destroy' => 'courses_categories_delete']]);
        Route::post('courses_categories_search', ['uses' => '\App\Http\Controllers\Admin\CourseCategoryController@search', 'as' => 'courses_categories_view']);
        Route::post('courses_categories/publish', ['uses' => '\App\Http\Controllers\Admin\CourseCategoryController@publish', 'as' => 'courses_categories_publish']);
        Route::post('courses_categories/getSubCategoriesByCategoryId', ['uses' => '\App\Http\Controllers\Admin\AllCategoryController@getSubCategoriesByCategoryId', 'as' => 'courses_categories_add']);

        Route::resource('books_categories', '\App\Http\Controllers\Admin\BookCategoryController', ['names' => ['create' => 'books_categories_add', 'store' => 'books_categories_add', 'index' => 'books_categories', 'edit' => 'books_categories_edit', 'update' => 'books_categories_edit', 'destroy' => 'books_categories_delete']]);
        Route::post('books_categories_search', ['uses' => '\App\Http\Controllers\Admin\BookCategoryController@search', 'as' => 'books_categories_view']);
        Route::post('books_categories/publish', ['uses' => '\App\Http\Controllers\Admin\BookCategoryController@publish', 'as' => 'books_categories_publish']);
        Route::post('books_categories/getSubCategoriesByCategoryId', ['uses' => '\App\Http\Controllers\Admin\AllCategoryController@getSubCategoriesByCategoryId', 'as' => 'books_categories_add']);

        Route::resource('successtories_categories', '\App\Http\Controllers\Admin\SuccesStoryCategoryController', ['names' => ['create' => 'successtories_categories_add', 'store' => 'successtories_categories_add', 'index' => 'successtories_categories', 'edit' => 'successtories_categories_edit', 'update' => 'successtories_categories_edit', 'destroy' => 'successtories_categories_delete']]);
        Route::post('successtories_categories_search', ['uses' => '\App\Http\Controllers\Admin\SuccesStoryCategoryController@search', 'as' => 'successtories_categories_view']);
        Route::post('successtories_categories/publish', ['uses' => '\App\Http\Controllers\Admin\SuccesStoryCategoryController@publish', 'as' => 'successtories_categories_publish']);
        Route::post('successtories_categories/getSubCategoriesByCategoryId', ['uses' => '\App\Http\Controllers\Admin\AllCategoryController@getSubCategoriesByCategoryId', 'as' => 'books_categories_add']);

        Route::resource('webinars_categories', '\App\Http\Controllers\Admin\WebinarCategoryController', ['names' => ['create' => 'webinars_categories_add', 'store' => 'webinars_categories_add', 'index' => 'webinars_categories', 'edit' => 'webinars_categories_edit', 'update' => 'webinars_categories_edit', 'destroy' => 'webinars_categories_delete']]);
        Route::post('webinars_categories_search', ['uses' => '\App\Http\Controllers\Admin\WebinarCategoryController@search', 'as' => 'webinars_categories_view']);
        Route::post('webinars_categories/publish', ['uses' => '\App\Http\Controllers\Admin\WebinarCategoryController@publish', 'as' => 'webinars_categories_publish']);
        Route::post('webinars_categories/getSubCategoriesByCategoryId', ['uses' => '\App\Http\Controllers\Admin\AllCategoryController@getSubCategoriesByCategoryId', 'as' => 'webinars_categories_add']);

        Route::get('diploma_certificates/{id}/view_exams_result', ['uses' => '\App\Http\Controllers\Admin\DiplomaCertificateController@viewExamsResult', 'as' => 'diploma_certificates_view_exams_result']);
        Route::resource('diploma_certificates', '\App\Http\Controllers\Admin\DiplomaCertificateController', ['names' => ['index' => 'diploma_certificates', 'edit' => 'diploma_certificates_edit', 'update' => 'diploma_certificates_edit','destroy' => 'diploma_certificates_delete']]);
        Route::post('diploma_certificates_search', ['uses' => '\App\Http\Controllers\Admin\DiplomaCertificateController@search', 'as' => 'diploma_certificates_view']);
        Route::post('diploma_certificates/publish', ['uses' => '\App\Http\Controllers\Admin\DiplomaCertificateController@publish', 'as' => 'diploma_certificates_publish']);
        Route::get('diploma_certificates/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\DiplomaCertificateController@copy', 'as' => 'diploma_certificates_copy']);


        Route::get('training_program_certificates/{id}/view_exams_result', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramCertificateController@viewExamsResult', 'as' => 'training_program_certificates_view_exams_result']);
        Route::resource('training_program_certificates', '\App\Http\Controllers\Admin\TrainingProgramCertificateController', ['names' => ['index' => 'training_program_certificates', 'destroy' => 'training_program_certificates_delete']]);
        Route::post('training_program_certificates_search', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramCertificateController@search', 'as' => 'training_program_certificates_view']);
        Route::post('training_program_certificates/publish', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramCertificateController@publish', 'as' => 'training_program_certificates_publish']);
        Route::get('training_program_certificates/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramCertificateController@copy', 'as' => 'training_program_certificates_copy']);



        Route::resource('international_diploma_certificates', '\App\Http\Controllers\Admin\InternationalDiplomaCertificateController', ['names' => ['index' => 'international_diploma_certificates', 'destroy' => 'international_diploma_certificates_delete'],'parameters'
        => ['international_diploma_certificates' => 'int_diploma_certificates']]);
        Route::post('international_diploma_certificates_search', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomaCertificateController@search', 'as' => 'international_diploma_certificates_view','parameters' => ['international_diploma_certificates' => 'int_diploma_certificates']]);
        Route::post('international_diploma_certificates/publish', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomaCertificateController@publish', 'as' => 'international_diploma_certificates_publish','parameters' => ['international_diploma_certificates' => 'int_diploma_certificates']]);
        Route::get('international_diploma_certificates/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomaCertificateController@copy', 'as' => 'international_diploma_certificates_copy','parameters' => ['international_diploma_certificates' => 'int_diploma_certificates']]);

        Route::resource('mlm_requests', '\App\Http\Controllers\Admin\MlmRequestsController', ['names' => ['index' => 'mlm_requests','show' => 'mlm_requests_send']]);
        Route::post('mlm_requests_search', ['uses' => '\App\Http\Controllers\Admin\MlmRequestsController@search', 'as' => 'mlm_requests_view']);
        Route::post('mlm_requests/process', ['uses' => '\App\Http\Controllers\Admin\MlmRequestsController@process', 'as' => 'mlm_requests_send']);
        Route::post('mlm_requests/send', ['uses' => '\App\Http\Controllers\Admin\MlmRequestsController@send', 'as' => 'mlm_requests_send']);

        Route::resource('diploma_courses', '\App\Http\Controllers\Admin\DiplomaCourseController', ['names' => ['create' => 'diploma_courses_add', 'store' => 'diploma_courses_add', 'index' => 'diploma_courses', 'edit' => 'diploma_courses_edit', 'update' => 'diploma_courses_edit', 'destroy' => 'diploma_courses_delete']]);
        Route::post('diploma_courses_search', ['uses' => '\App\Http\Controllers\Admin\DiplomaCourseController@search', 'as' => 'diploma_courses_view']);
        Route::post('diploma_courses/publish', ['uses' => '\App\Http\Controllers\Admin\DiplomaCourseController@publish', 'as' => 'diploma_courses_publish']);



        Route::resource('training_program_courses', '\App\Http\Controllers\Admin\TrainingProgramCourseController', ['names' => ['create' => 'training_program_courses_add', 'store' => 'training_program_courses_add', 'index' => 'training_program_courses', 'edit' => 'training_program_courses_edit', 'update' => 'training_program_courses_edit', 'destroy' => 'training_program_courses_delete']]);
        Route::post('training_program_courses_search', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramCourseController@search', 'as' => 'training_program_courses_view']);
        Route::post('training_program_courses/publish', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramCourseController@publish', 'as' => 'training_program_courses_publish']);



        Route::resource('international_diploma_courses', '\App\Http\Controllers\Admin\InternationalDiplomaCourseController', ['names' => ['create' => 'international_diploma_courses_add', 'store' => 'international_diploma_courses_add', 'index' => 'international_diploma_courses', 'edit' => 'international_diploma_courses_edit', 'update' => 'international_diploma_courses_edit', 'destroy' => 'international_diploma_courses_delete']]);
        Route::post('international_diploma_courses_search', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomaCourseController@search', 'as' => 'international_diploma_courses_view']);
        Route::post('international_diploma_courses/publish', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomaCourseController@publish', 'as' => 'international_diploma_courses_publish']);

        Route::resource('diplomas_targets', '\App\Http\Controllers\Admin\DiplomasTargetsController', ['names' => ['create' => 'diplomas_targets_add', 'store' => 'diplomas_targets_add', 'index' => 'diplomas_targets', 'edit' => 'diplomas_targets_edit', 'update' => 'diplomas_targets_edit', 'destroy' => 'diplomas_targets_delete']]);
        Route::post('diplomas_targets_search', ['uses' => '\App\Http\Controllers\Admin\DiplomasTargetsController@search', 'as' => 'diplomas_targets_view']);
        Route::post('diplomas_targets/publish', ['uses' => '\App\Http\Controllers\Admin\DiplomasTargetsController@publish', 'as' => 'diplomas_targets_publish']);

        Route::resource('training_program_targets', '\App\Http\Controllers\Admin\TrainingProgramTargetsController', ['names' => ['create' => 'training_program_targets_add', 'store' => 'training_program_targets_add', 'index' => 'training_program_targets', 'edit' => 'training_program_targets_edit', 'update' => 'training_program_targets_edit', 'destroy' => 'training_program_targets_delete']]);
        Route::post('training_program_targets_search', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramTargetsController@search', 'as' => 'training_program_targets_view']);
        Route::post('training_program_targets/publish', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramTargetsController@publish', 'as' => 'training_program_targets_publish']);

        Route::resource('diploma_user_courses', '\App\Http\Controllers\Admin\DiplomaUserCourseController', ['names' => ['create' => 'diploma_user_courses_add', 'store' => 'diploma_user_courses_add', 'index' => 'diploma_user_courses', 'edit' => 'diploma_user_courses_edit', 'update' => 'diploma_user_courses_edit', 'destroy' => 'diploma_user_courses_delete']]);
        Route::post('diploma_user_courses_search', ['uses' => '\App\Http\Controllers\Admin\DiplomaUserCourseController@search', 'as' => 'diploma_user_courses_view']);
        Route::post('diploma_user_courses/publish', ['uses' => '\App\Http\Controllers\Admin\DiplomaUserCourseController@publish', 'as' => 'diploma_user_courses_publish']);
        Route::post('diploma_user_courses/delete_all', ['uses' => '\App\Http\Controllers\Admin\DiplomaUserCourseController@delete_all', 'as' => 'diploma_user_courses_delete_all']);
        Route::get('diploma_user_courses/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\DiplomaUserCourseController@copy', 'as' => 'diploma_user_courses_copy']);
        Route::post('diploma_user_courses/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'diploma_user_courses_add']);


        Route::resource('training_program_user_courses', '\App\Http\Controllers\Admin\TrainingProgramUserCourseController', ['names' => ['create' => 'training_program_user_courses_add', 'store' => 'training_program_user_courses_add', 'index' => 'training_program_user_courses', 'edit' => 'training_program_user_courses_edit', 'update' => 'training_program_user_courses_edit', 'destroy' => 'training_program_user_courses_delete']]);
        Route::post('training_program_user_courses_search', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramUserCourseController@search', 'as' => 'training_program_user_courses_view']);
        Route::post('training_program_user_courses/publish', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramUserCourseController@publish', 'as' => 'training_program_user_courses_publish']);
        Route::post('training_program_user_courses/delete_all', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramUserCourseController@delete_all', 'as' => 'training_program_user_courses_delete_all']);
        Route::get('training_program_user_courses/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramUserCourseController@copy', 'as' => 'training_program_user_courses_copy']);
        Route::post('training_program_user_courses/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'training_program_user_courses_add']);



        Route::resource('international_diploma_user_courses', '\App\Http\Controllers\Admin\InternationalDiplomaUserCourseController', ['names' => ['create' => 'international_diploma_user_courses_add', 'store' => 'international_diploma_user_courses_add', 'index' => 'international_diploma_user_courses', 'edit' => 'international_diploma_user_courses_edit', 'update' => 'international_diploma_user_courses_edit', 'destroy' => 'international_diploma_user_courses_delete'],'parameters' => [
            'international_diploma_user_courses' => 'iduc'
        ]]);
        Route::post('international_diploma_user_courses_search', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomaUserCourseController@search', 'as' => 'international_diploma_user_courses_view']);
        Route::post('international_diploma_user_courses/publish', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomaUserCourseController@publish', 'as' => 'international_diploma_user_courses_publish']);
        Route::get('international_diploma_user_courses/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomaUserCourseController@copy', 'as' => 'international_diploma_user_courses_copy']);
        Route::post('international_diploma_user_courses/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'international_diploma_user_courses_add']);

        Route::resource('events', '\App\Http\Controllers\Admin\EventController', ['names' => ['create' => 'events_add', 'store' => 'events_add', 'index' => 'events', 'edit' => 'events_edit', 'update' => 'events_edit', 'destroy' => 'events_delete']]);
        Route::post('events_search', ['uses' => '\App\Http\Controllers\Admin\EventController@search', 'as' => 'events_view']);
        Route::post('events/publish', ['uses' => '\App\Http\Controllers\Admin\EventController@publish', 'as' => 'events_publish']);

        Route::resource('faq', '\App\Http\Controllers\Admin\FaqController', ['names' => ['create' => 'faq_add', 'store' => 'faq_add', 'index' => 'faq', 'edit' => 'faq_edit', 'update' => 'faq_edit', 'destroy' => 'faq_delete']]);
        Route::post('faq_search', ['uses' => '\App\Http\Controllers\Admin\FaqController@search', 'as' => 'faq_view']);
        Route::post('faq/publish', ['uses' => '\App\Http\Controllers\Admin\FaqController@publish', 'as' => 'faq_publish']);

        Route::resource('site_faq', '\App\Http\Controllers\Admin\SiteFaqController', ['names' => ['create' => 'site_faq_add', 'store' => 'site_faq_add', 'index' => 'site_faq', 'edit' => 'site_faq_edit', 'update' => 'site_faq_edit', 'destroy' => 'site_faq_delete']]);
        Route::post('site_faq_search', ['uses' => '\App\Http\Controllers\Admin\SiteFaqController@search', 'as' => 'site_faq_view']);
        Route::post('site_faq/publish', ['uses' => '\App\Http\Controllers\Admin\SiteFaqController@publish', 'as' => 'site_faq_publish']);

        Route::resource('site_faq_type', '\App\Http\Controllers\Admin\SiteFaqTypeController', ['names' => ['create' => 'site_faq_type_add', 'store' => 'site_faq_type_add', 'index' => 'site_faq_type', 'edit' => 'site_faq_type_edit', 'update' => 'site_faq_type_edit', 'destroy' => 'site_faq_type_delete']]);
        Route::post('site_faq_type_search', ['uses' => '\App\Http\Controllers\Admin\SiteFaqTypeController@search', 'as' => 'site_faq_type_view']);
        Route::post('site_faq_type/publish', ['uses' => '\App\Http\Controllers\Admin\SiteFaqTypeController@publish', 'as' => 'site_faq_type_publish']);

        Route::resource('installment_payment', '\App\Http\Controllers\Admin\InstallmentPaymentController', ['names' => ['create' => 'installment_payment_add', 'store' => 'installment_payment_add', 'index' => 'installment_payment', 'edit' => 'installment_payment_edit', 'update' => 'installment_payment_edit', 'destroy' => 'installment_payment_delete']]);
        Route::post('installment_payment_search', ['uses' => '\App\Http\Controllers\Admin\InstallmentPaymentController@search', 'as' => 'installment_payment_view']);
        Route::post('installment_payment/publish', ['uses' => '\App\Http\Controllers\Admin\InstallmentPaymentController@publish', 'as' => 'installment_payment_publish']);

        Route::resource('user_contractid', '\App\Http\Controllers\Admin\UserContractidController', ['names' => ['create' => 'user_contractid_add', 'store' => 'user_contractid_add', 'index' => 'user_contractid', 'edit' => 'user_contractid_edit', 'update' => 'user_contractid_edit', 'destroy' => 'user_contractid_delete']]);
        Route::post('user_contractid_search', ['uses' => '\App\Http\Controllers\Admin\UserContractidController@search', 'as' => 'user_contractid_view']);
        Route::post('user_contractid/publish', ['uses' => '\App\Http\Controllers\Admin\UserContractidController@publish', 'as' => 'user_contractid_publish']);

        Route::resource('user_contractid_notifications', '\App\Http\Controllers\Admin\UserContractidNotificationsController', ['names' => ['create' => 'user_contractid_notifications_add', 'store' => 'user_contractid_notifications_add', 'index' => 'user_contractid_notifications', 'edit' => 'user_contractid_notifications_edit', 'update' => 'user_contractid_notifications_edit', 'destroy' => 'user_contractid_notifications_delete']]);
        Route::post('user_contractid_notifications_search', ['uses' => '\App\Http\Controllers\Admin\UserContractidNotificationsController@search', 'as' => 'user_contractid_notifications_view']);
        Route::post('user_contractid_notifications/publish', ['uses' => '\App\Http\Controllers\Admin\UserContractidNotificationsController@publish', 'as' => 'user_contractid_notifications_publish']);

        Route::resource('company', '\App\Http\Controllers\Admin\CompanyController', ['names' => ['create' => 'company_add', 'store' => 'company_add', 'index' => 'company', 'edit' => 'company_edit', 'update' => 'company_edit', 'destroy' => 'company_delete']]);
        Route::post('company_search', ['uses' => '\App\Http\Controllers\Admin\CompanyController@search', 'as' => 'company_view']);
        Route::post('company/publish', ['uses' => '\App\Http\Controllers\Admin\CompanyController@publish', 'as' => 'company_publish']);

        Route::resource('recruitment_employee_job_apply', '\App\Http\Controllers\Admin\RecruitmentEmployeeJobApplyController', ['names' => ['create' => 'recruitment_employee_job_apply_add', 'store' => 'recruitment_employee_job_apply_add', 'index' => 'recruitment_employee_job_apply', 'edit' => 'recruitment_employee_job_apply_edit', 'update' => 'recruitment_employee_job_apply_edit', 'destroy' => 'recruitment_employee_job_apply_delete']]);
        Route::post('recruitment_employee_job_apply_search', ['uses' => '\App\Http\Controllers\Admin\RecruitmentEmployeeJobApplyController@search', 'as' => 'recruitment_employee_job_apply_view']);
        Route::post('recruitment_employee_job_apply/publish', ['uses' => '\App\Http\Controllers\Admin\RecruitmentEmployeeJobApplyController@publish', 'as' => 'recruitment_employee_job_apply_publish']);

        Route::resource('recruitment_companies', '\App\Http\Controllers\Admin\RecruitmentCompanyController', ['names' => ['create' => 'recruitment_companies_add', 'store' => 'recruitment_companies_add', 'index' => 'recruitment_companies', 'edit' => 'recruitment_companies_edit', 'update' => 'recruitment_companies_edit', 'destroy' => 'recruitment_companies_delete']]);
        Route::post('recruitment_companies_search', ['uses' => '\App\Http\Controllers\Admin\RecruitmentCompanyController@search', 'as' => 'recruitment_companies_view']);
        Route::post('recruitment_companies/publish', ['uses' => '\App\Http\Controllers\Admin\RecruitmentCompanyController@publish', 'as' => 'recruitment_companies_publish']);
        Route::post('recruitment_companies/autoCompleteCountries', ['uses' => '\App\Http\Controllers\Admin\CountryController@autoCompleteCountries', 'as' => 'recruitment_companies_add']);
        Route::post('recruitment_companies/autoCompleteCities', ['uses' => '\App\Http\Controllers\Admin\CityController@autoCompleteCities', 'as' => 'recruitment_companies_add']);
        Route::post('recruitment_companies/autoCompleteStates', ['uses' => '\App\Http\Controllers\Admin\StateController@autoCompleteStates', 'as' => 'recruitment_companies_add']);

        Route::resource('courses_offers', '\App\Http\Controllers\Admin\CoursesOffersController', ['names' => ['create' => 'courses_offers_add', 'store' => 'courses_offers_add', 'index' => 'courses_offers', 'edit' => 'courses_offers_edit', 'update' => 'courses_offers_edit', 'destroy' => 'courses_offers_delete']]);
        Route::post('courses_offers_search', ['uses' => '\App\Http\Controllers\Admin\CoursesOffersController@search', 'as' => 'courses_offers_view']);
        Route::post('courses_offers/publish', ['uses' => '\App\Http\Controllers\Admin\CoursesOffersController@publish', 'as' => 'courses_offers_publish']);

        Route::resource('courses_sections', '\App\Http\Controllers\Admin\CoursesSectionsController', ['names' => ['create' => 'courses_sections_add', 'store' => 'courses_sections_add', 'index' => 'courses_sections', 'edit' => 'courses_sections_edit', 'update' => 'courses_sections_edit', 'destroy' => 'courses_sections_delete']]);
        Route::post('courses_sections_search', ['uses' => '\App\Http\Controllers\Admin\CoursesSectionsController@search', 'as' => 'courses_sections_view']);
        Route::post('courses_sections/publish', ['uses' => '\App\Http\Controllers\Admin\CoursesSectionsController@publish', 'as' => 'courses_sections_publish']);

        Route::resource('course_curriculum', '\App\Http\Controllers\Admin\CourseCurriculumController', ['names' => ['create' => 'course_curriculum_add', 'store' => 'course_curriculum_add', 'index' => 'course_curriculum', 'edit' => 'course_curriculum_edit', 'update' => 'course_curriculum_edit', 'destroy' => 'course_curriculum_delete']]);
        Route::post('course_curriculum_search', ['uses' => '\App\Http\Controllers\Admin\CourseCurriculumController@search', 'as' => 'course_curriculum_view']);
        Route::post('course_curriculum/publish', ['uses' => '\App\Http\Controllers\Admin\CourseCurriculumController@publish', 'as' => 'course_curriculum_publish']);
        Route::post('course_curriculum/getSectionsByCourseId', ['uses' => '\App\Http\Controllers\Admin\CourseCurriculumController@getSectionsByCourseId', 'as' => 'course_curriculum_add']);


        Route::resource('request_courses', '\App\Http\Controllers\Admin\RequestCourseController', ['names' => ['index' => 'request_courses']]);
        Route::post('request_courses_search', ['uses' => '\App\Http\Controllers\Admin\RequestCourseController@search', 'as' => 'request_courses_view']);

        Route::resource('books_requests', '\App\Http\Controllers\Admin\BooksRequestsController', ['names' => ['index' => 'books_requests']]);
        Route::post('books_requests_search', ['uses' => '\App\Http\Controllers\Admin\BooksRequestsController@search', 'as' => 'books_requests_view']);

        Route::resource('company_request', '\App\Http\Controllers\Admin\CompanyRequestController', ['names' => ['index' => 'company_request','create' => 'company_request_add', 'store' => 'company_request_add', 'edit' => 'company_request_edit', 'update' => 'company_request_edit', 'destroy' => 'company_request_delete']]);
        Route::post('company_request_search', ['uses' => '\App\Http\Controllers\Admin\CompanyRequestController@search', 'as' => 'company_request_view']);
        Route::post('company_request/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'company_request_add']);

        Route::resource('session_courses_views', '\App\Http\Controllers\Admin\SessionCoursesViewsController', ['names' => ['create' => 'session_courses_views_add', 'store' => 'session_courses_views_add', 'index' => 'session_courses_views', 'edit' => 'session_courses_views_edit', 'update' => 'session_courses_views_edit', 'destroy' => 'session_courses_views_delete']]);
        Route::post('session_courses_views_search', ['uses' => '\App\Http\Controllers\Admin\SessionCoursesViewsController@search', 'as' => 'session_courses_views_view']);
        Route::post('session_courses_views/publish', ['uses' => '\App\Http\Controllers\Admin\SessionCoursesViewsController@publish', 'as' => 'session_courses_views_publish']);
        Route::post('session_courses_views/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'session_courses_views_add']);

        Route::resource('session_webinars_views', '\App\Http\Controllers\Admin\SessionWebinarsViewsController', ['names' => ['create' => 'session_webinars_views_add', 'store' => 'session_webinars_views_add', 'index' => 'session_webinars_views', 'edit' => 'session_webinars_views_edit', 'update' => 'session_webinars_views_edit', 'destroy' => 'session_webinars_views_delete']]);
        Route::post('session_webinars_views_search', ['uses' => '\App\Http\Controllers\Admin\SessionWebinarsViewsController@search', 'as' => 'session_webinars_views_view']);
        Route::post('session_webinars_views/publish', ['uses' => '\App\Http\Controllers\Admin\SessionWebinarsViewsController@publish', 'as' => 'session_webinars_views_publish']);
        Route::post('session_webinars_views/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'session_webinars_views_add']);

        Route::resource('companies_admins', '\App\Http\Controllers\Admin\CompaniesAdminsController', ['names' => ['create' => 'companies_admins_add', 'store' => 'companies_admins_add', 'index' => 'companies_admins', 'edit' => 'companies_admins_edit', 'update' => 'companies_admins_edit', 'destroy' => 'companies_admins_delete']]);
        Route::post('companies_admins_search', ['uses' => '\App\Http\Controllers\Admin\CompaniesAdminsController@search', 'as' => 'companies_admins_view']);
        Route::post('companies_admins/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'companies_admins_add']);

        Route::resource('apple_users', '\App\Http\Controllers\Admin\AppleUsersController', ['names' => ['create' => 'apple_users_add', 'store' => 'apple_users_add', 'index' => 'apple_users', 'edit' => 'apple_users_edit', 'update' => 'apple_users_edit', 'destroy' => 'apple_users_delete']]);
        Route::post('apple_users_search', ['uses' => '\App\Http\Controllers\Admin\AppleUsersController@search', 'as' => 'apple_users_view']);
        Route::post('apple_users/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'apple_users_add']);

        Route::resource('apple_products', '\App\Http\Controllers\Admin\AppleProductsController', ['names' => ['create' => 'apple_products_add', 'store' => 'apple_products_add', 'index' => 'apple_products', 'edit' => 'apple_products_edit', 'update' => 'apple_products_edit', 'destroy' => 'apple_products_delete']]);
        Route::post('apple_products_search', ['uses' => '\App\Http\Controllers\Admin\AppleProductsController@search', 'as' => 'apple_products_view']);

        Route::resource('apple_users_charge_transactions', '\App\Http\Controllers\Admin\AppleUsersChargeTransactionsController', ['names' => ['create' => 'apple_users_charge_transactions_add', 'store' => 'apple_users_charge_transactions_add', 'index' => 'apple_users_charge_transactions', 'edit' => 'apple_users_charge_transactions_edit', 'update' => 'apple_users_charge_transactions_edit', 'destroy' => 'apple_users_charge_transactions_delete']]);
        Route::post('apple_users_charge_transactions_search', ['uses' => '\App\Http\Controllers\Admin\AppleUsersChargeTransactionsController@search', 'as' => 'apple_users_charge_transactions_view']);
        Route::post('apple_users_charge_transactions/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'companies_admins_add']);

        Route::resource('session_diplomas_views', '\App\Http\Controllers\Admin\SessionDiplomasViewsController', ['names' => ['index' => 'session_diplomas_views']]);
        Route::post('session_diplomas_views_search', ['uses' => '\App\Http\Controllers\Admin\SessionDiplomasViewsController@search', 'as' => 'session_diplomas_views_view']);

        Route::resource('users_sessions', '\App\Http\Controllers\Admin\UsersSessionsController', ['names' => ['index' => 'users_sessions']]);
        Route::post('users_sessions_search', ['uses' => '\App\Http\Controllers\Admin\UsersSessionsController@search', 'as' => 'users_sessions_view']);

        Route::resource('abuse', '\App\Http\Controllers\Admin\AbuseController', ['names' => ['index' => 'abuse']]);
        Route::post('abuse_search', ['uses' => '\App\Http\Controllers\Admin\AbuseController@search', 'as' => 'abuse_view']);

        Route::resource('session_successtories_views', '\App\Http\Controllers\Admin\SessionSuccesstoriesViewsController', ['names' => ['create' => 'session_successtories_views_add', 'store' => 'session_successtories_views_add', 'index' => 'session_successtories_views', 'edit' => 'session_successtories_views_edit', 'update' => 'session_successtories_views_edit', 'destroy' => 'session_successtories_views_delete']]);
        Route::post('session_successtories_views_search', ['uses' => '\App\Http\Controllers\Admin\SessionSuccesstoriesViewsController@search', 'as' => 'session_successtories_views_view']);
        Route::post('session_successtories_views/publish', ['uses' => '\App\Http\Controllers\Admin\SessionSuccesstoriesViewsController@publish', 'as' => 'session_successtories_views_publish']);
        Route::post('session_successtories_views/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'session_successtories_views_add']);

        Route::resource('courses_views', '\App\Http\Controllers\Admin\CoursesViewsController', ['names' => ['create' => 'courses_views_add', 'store' => 'courses_views_add', 'index' => 'courses_views', 'edit' => 'courses_views_edit', 'update' => 'courses_views_edit', 'destroy' => 'courses_views_delete']]);
        Route::post('courses_views_search', ['uses' => '\App\Http\Controllers\Admin\CoursesViewsController@search', 'as' => 'courses_views_view']);
        Route::post('courses_views/publish', ['uses' => '\App\Http\Controllers\Admin\CoursesViewsController@publish', 'as' => 'courses_views_publish']);
        Route::post('courses_views/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'courses_views_add']);

        Route::resource('international_diplomas_views', '\App\Http\Controllers\Admin\InternationalDiplomasViewsController', ['names' => ['create' => 'international_diplomas_views_add', 'store' => 'international_diplomas_views_add', 'index' => 'international_diplomas_views', 'edit' => 'international_diplomas_views_edit', 'update' => 'international_diplomas_views_edit', 'destroy' => 'international_diplomas_views_delete']]);
        Route::post('international_diplomas_views_search', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomasViewsController@search', 'as' => 'international_diplomas_views_view']);
        Route::post('international_diplomas_views/publish', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomasViewsController@publish', 'as' => 'international_diplomas_views_publish']);
        Route::post('international_diplomas_views/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'international_diplomas_views_add']);

        Route::resource('my_courses', '\App\Http\Controllers\Admin\MyCoursesController', ['names' => ['create' => 'my_courses_add', 'store' => 'my_courses_add', 'index' => 'my_courses', 'edit' => 'my_courses_edit', 'update' => 'my_courses_edit', 'destroy' => 'my_courses_delete']]);
        Route::post('my_courses_search', ['uses' => '\App\Http\Controllers\Admin\MyCoursesController@search', 'as' => 'my_courses_view']);
        Route::post('my_courses/publish', ['uses' => '\App\Http\Controllers\Admin\MyCoursesController@publish', 'as' => 'my_courses_publish']);
        Route::post('my_courses/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'my_courses_add']);
        Route::get('my_courses/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\MyCoursesController@copy', 'as' => 'my_courses_copy']);

        Route::resource('automation', '\App\Http\Controllers\Admin\AutomationController', ['names' => ['create' => 'automation_add', 'store' => 'automation_add', 'index' => 'automation', 'edit' => 'automation_edit', 'update' => 'automation_edit', 'destroy' => 'automation_delete']]);
        Route::post('automation_search', ['uses' => '\App\Http\Controllers\Admin\AutomationController@search', 'as' => 'automation_view']);
        Route::post('automation/publish', ['uses' => '\App\Http\Controllers\Admin\AutomationController@publish', 'as' => 'automation_publish']);
        Route::post('automation/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'automation_add']);

        Route::resource('dctsl', '\App\Http\Controllers\Admin\DiplomasChargeTransactionSuspendLogController', ['names' => ['create' => 'diplomas_charge_transaction_suspend_log_add', 'store' => 'diplomas_charge_transaction_suspend_log_add', 'index' => 'diplomas_charge_transaction_suspend_log', 'edit' => 'diplomas_charge_transaction_suspend_log_edit', 'update' => 'diplomas_charge_transaction_suspend_log_edit', 'destroy' => 'diplomas_charge_transaction_suspend_log_delete']]);
        Route::post('dctsl_search', ['uses' => '\App\Http\Controllers\Admin\DiplomasChargeTransactionSuspendLogController@search', 'as' => 'diplomas_charge_transaction_suspend_log_view']);
        Route::post('dctsl/publish', ['uses' => '\App\Http\Controllers\Admin\DiplomasChargeTransactionSuspendLogController@publish', 'as' => 'diplomas_charge_transaction_suspend_log_publish']);
        Route::post('dctsl/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'diplomas_charge_transaction_suspend_log_add']);

        Route::resource('idctsl', '\App\Http\Controllers\Admin\InternationalDiplomasChargeTransactionSuspendLogController', ['names' => ['create' => 'international_diplomas_charge_transaction_suspend_log_add', 'store' => 'international_diplomas_charge_transaction_suspend_log_add', 'index' => 'international_diplomas_charge_transaction_suspend_log', 'edit' => 'international_diplomas_charge_transaction_suspend_log_edit', 'update' => 'international_diplomas_charge_transaction_suspend_log_edit', 'destroy' => 'international_diplomas_charge_transaction_suspend_log_delete']]);
        Route::post('idctsl_search', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomasChargeTransactionSuspendLogController@search', 'as' => 'international_diplomas_charge_transaction_suspend_log_view']);
        Route::post('idctsl/publish', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomasChargeTransactionSuspendLogController@publish', 'as' => 'international_diplomas_charge_transaction_suspend_log_publish']);
        Route::post('idctsl/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'international_diplomas_charge_transaction_suspend_log_add']);

        Route::resource('tpctsl', '\App\Http\Controllers\Admin\TrainingProgramChargeTransactionSuspendLogController', ['names' => ['create' => 'training_programs_charge_transaction_suspend_log_add', 'store' => 'training_programs_charge_transaction_suspend_log_add', 'index' => 'training_programs_charge_transaction_suspend_log', 'edit' => 'training_programs_charge_transaction_suspend_log_edit', 'update' => 'training_programs_charge_transaction_suspend_log_edit', 'destroy' => 'training_programs_charge_transaction_suspend_log_delete']]);
        Route::post('tpctsl_search', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramChargeTransactionSuspendLogController@search', 'as' => 'training_programs_charge_transaction_suspend_log_view']);
        Route::post('tpctsl/publish', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramChargeTransactionSuspendLogController@publish', 'as' => 'training_programs_charge_transaction_suspend_log_publish']);
        Route::post('tpctsl/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'training_programs_charge_transaction_suspend_log_add']);


        Route::resource('mctsl', '\App\Http\Controllers\Admin\MedicalChargeTransactionSuspendLogController', ['names' => ['create' => 'medical_charge_transaction_suspend_log_add', 'store' => 'medical_charge_transaction_suspend_log_add', 'index' => 'medical_charge_transaction_suspend_log', 'edit' => 'medical_charge_transaction_suspend_log_edit', 'update' => 'medical_charge_transaction_suspend_log_edit', 'destroy' => 'medical_charge_transaction_suspend_log_delete']]);
        Route::post('mctsl_search', ['uses' => '\App\Http\Controllers\Admin\MedicalChargeTransactionSuspendLogController@search', 'as' => 'medical_charge_transaction_suspend_log_view']);
        Route::post('mctsl/publish', ['uses' => '\App\Http\Controllers\Admin\MedicalChargeTransactionSuspendLogController@publish', 'as' => 'medical_charge_transaction_suspend_log_publish']);
        Route::post('mctsl/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'medical_charge_transaction_suspend_log_add']);

        Route::resource('courses_curriculum_certificates', '\App\Http\Controllers\Admin\CoursesCurriculumCertificatesController', ['names' => ['create' => 'courses_curriculum_certificates_add', 'store' => 'courses_curriculum_certificates_add', 'index' => 'courses_curriculum_certificates', 'edit' => 'courses_curriculum_certificates_edit', 'update' => 'courses_curriculum_certificates_edit', 'destroy' => 'courses_curriculum_certificates_delete']]);
        Route::post('courses_curriculum_certificates_search', ['uses' => '\App\Http\Controllers\Admin\CoursesCurriculumCertificatesController@search', 'as' => 'courses_curriculum_certificates_view']);
        Route::post('courses_curriculum_certificates/publish', ['uses' => '\App\Http\Controllers\Admin\CoursesCurriculumCertificatesController@publish', 'as' => 'courses_curriculum_certificates_publish']);
        Route::get('courses_curriculum_certificates/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\CoursesCurriculumCertificatesController@copy', 'as' => 'courses_curriculum_certificates_copy']);
        Route::post('courses_curriculum_certificates/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'courses_curriculum_certificates_add']);
        Route::post('courses_curriculum_certificates/autoCompleteAnswersIds', ['uses' => '\App\Http\Controllers\Admin\CoursesCurriculumCertificatesController@autoCompleteAnswersIds', 'as' => 'courses_curriculum_certificates_add']);

        Route::resource('mba_certificates', '\App\Http\Controllers\Admin\MbaCertificatesController', ['names' => ['create' => 'mba_certificates_add', 'store' => 'mba_certificates_add', 'index' => 'mba_certificates', 'edit' => 'mba_certificates_edit', 'update' => 'mba_certificates_edit', 'destroy' => 'mba_certificates_delete']]);
        Route::post('mba_certificates_search', ['uses' => '\App\Http\Controllers\Admin\MbaCertificatesController@search', 'as' => 'mba_certificates_view']);
        Route::post('mba_certificates/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'mba_certificates_add']);

        /* Start New MBA Certificates Routes */

        Route::resource('new_mba_certificates', '\App\Http\Controllers\Admin\NewMbaCertificatesController', ['names' => ['create' => 'new_mba_certificates_add', 'store' => 'new_mba_certificates_add', 'index' => 'new_mba_certificates', 'edit' => 'new_mba_certificates_edit', 'update' => 'new_mba_certificates_edit', 'destroy' => 'new_mba_certificates_delete']]);
        Route::post('new_mba_certificates_search', ['uses' => '\App\Http\Controllers\Admin\NewMbaCertificatesController@search', 'as' => 'new_mba_certificates_view']);
        Route::post('new_mba_certificates/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'new_mba_certificates_add']);

        /* End New MBA Certificates Routes */

        Route::resource('users_curriculum_answers', '\App\Http\Controllers\Admin\UsersCurriculumAnswersController', ['names' => ['create' => 'users_curriculum_answers_add', 'store' => 'users_curriculum_answers_add', 'index' => 'users_curriculum_answers', 'edit' => 'users_curriculum_answers_edit', 'update' => 'users_curriculum_answers_edit', 'destroy' => 'users_curriculum_answers_delete']]);
        Route::post('users_curriculum_answers_search', ['uses' => '\App\Http\Controllers\Admin\UsersCurriculumAnswersController@search', 'as' => 'users_curriculum_answers_view']);
        Route::post('users_curriculum_answers/publish', ['uses' => '\App\Http\Controllers\Admin\UsersCurriculumAnswersController@publish', 'as' => 'users_curriculum_answers_publish']);
        Route::post('users_curriculum_answers/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'users_curriculum_answers_add']);

        Route::resource('recruitment_employees', '\App\Http\Controllers\Admin\RecruitmentEmployeesController', ['names' => ['create' => 'recruitment_employees_add', 'store' => 'recruitment_employees_add', 'index' => 'recruitment_employees', 'edit' => 'recruitment_employees_edit', 'update' => 'recruitment_employees_edit', 'destroy' => 'recruitment_employees_delete']]);
        Route::post('recruitment_employees_search', ['uses' => '\App\Http\Controllers\Admin\RecruitmentEmployeesController@search', 'as' => 'recruitment_employees_view']);
        Route::post('recruitment_employees/publish', ['uses' => '\App\Http\Controllers\Admin\RecruitmentEmployeesController@publish', 'as' => 'recruitment_employees_publish']);
        Route::post('recruitment_employees/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'recruitment_employees_add']);
        Route::post('recruitment_employees/autoCompleteCountries', ['uses' => '\App\Http\Controllers\Admin\CountryController@autoCompleteCountries', 'as' => 'recruitment_employees_add']);
        Route::post('recruitment_employees/autoCompleteCities', ['uses' => '\App\Http\Controllers\Admin\CityController@autoCompleteCities', 'as' => 'recruitment_employees_add']);
        Route::post('recruitment_employees/autoCompleteStates', ['uses' => '\App\Http\Controllers\Admin\StateController@autoCompleteStates', 'as' => 'recruitment_employees_add']);

        Route::resource('recruit', '\App\Http\Controllers\Admin\RecruitController', ['names' => ['create' => 'recruit_add', 'store' => 'recruit_add', 'index' => 'recruit', 'edit' => 'recruit_edit', 'update' => 'recruit_edit', 'destroy' => 'recruit_delete']]);
        Route::post('recruit_search', ['uses' => '\App\Http\Controllers\Admin\RecruitController@search', 'as' => 'recruit_view']);
        Route::post('recruit/publish', ['uses' => '\App\Http\Controllers\Admin\RecruitController@publish', 'as' => 'recruit_publish']);
        Route::post('recruit/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'recruit_add']);
        Route::post('recruit/autoCompleteCountries', ['uses' => '\App\Http\Controllers\Admin\CountryController@autoCompleteCountries', 'as' => 'recruit_add']);
        Route::post('recruit/autoCompleteCities', ['uses' => '\App\Http\Controllers\Admin\CityController@autoCompleteCities', 'as' => 'recruit_add']);
        Route::post('recruit/autoCompleteStates', ['uses' => '\App\Http\Controllers\Admin\StateController@autoCompleteStates', 'as' => 'recruit_add']);


        Route::resource('payment_transaction', '\App\Http\Controllers\Admin\PaymentTransactionController', ['names' => ['create' => 'payment_transaction_add', 'store' => 'payment_transaction_add', 'index' => 'payment_transaction', 'edit' => 'payment_transaction_edit', 'update' => 'payment_transaction_edit', 'destroy' => 'payment_transaction_delete']]);
        Route::post('payment_transaction_search', ['uses' => '\App\Http\Controllers\Admin\PaymentTransactionController@search', 'as' => 'payment_transaction_view']);
        Route::post('payment_transaction/publish', ['uses' => '\App\Http\Controllers\Admin\PaymentTransactionController@publish', 'as' => 'payment_transaction_publish']);

        Route::resource('support_transaction', '\App\Http\Controllers\Admin\SupportTransactionController', ['names' => ['create' => 'support_transaction_add', 'store' => 'support_transaction_add', 'index' => 'support_transaction', 'edit' => 'support_transaction_edit', 'update' => 'support_transaction_edit', 'destroy' => 'support_transaction_delete']]);
        Route::post('support_transaction_search', ['uses' => '\App\Http\Controllers\Admin\SupportTransactionController@search', 'as' => 'support_transaction_view']);
        //Route::post('support_transaction/publish', ['uses' => '\App\Http\Controllers\Admin\SupportTransactionController@publish', 'as' => 'support_transaction_publish']);
        Route::post('support_transaction/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'support_transaction_add']);

        Route::resource('dct', '\App\Http\Controllers\Admin\DiplomasChargeTransactionController', ['names' => ['create' => 'diplomas_charge_transaction_add', 'store' => 'diplomas_charge_transaction_add', 'index' => 'diplomas_charge_transaction', 'edit' => 'diplomas_charge_transaction_edit', 'update' => 'diplomas_charge_transaction_edit', 'destroy' => 'diplomas_charge_transaction_delete']]);
        Route::post('dct_search', ['uses' => '\App\Http\Controllers\Admin\DiplomasChargeTransactionController@search', 'as' => 'diplomas_charge_transaction_view']);
        Route::post('dct/publish', ['uses' => '\App\Http\Controllers\Admin\DiplomasChargeTransactionController@publish', 'as' => 'diplomas_charge_transaction_publish']);
        Route::post('dct/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'diplomas_charge_transaction_add']);
        Route::get('dct/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\DiplomasChargeTransactionController@copy', 'as' => 'diplomas_charge_transaction_copy']);
        Route::post('dct/add_courses/{id}', ['uses' => '\App\Http\Controllers\Admin\DiplomasChargeTransactionController@addCourses', 'as' => 'diplomas_charge_transaction_add_courses']);


        Route::resource('rct', '\App\Http\Controllers\Admin\RwaqUsersDiplomasChargeTransactionController', ['names' => ['create' => 'rwaq_charge_transaction_add', 'store' => 'rwaq_charge_transaction_add', 'index' => 'rwaq_charge_transaction', 'edit' => 'rwaq_charge_transaction_edit', 'update' => 'rwaq_charge_transaction_edit', 'destroy' => 'rwaq_charge_transaction_delete']]);
        Route::post('rct_search', ['uses' => '\App\Http\Controllers\Admin\RwaqUsersDiplomasChargeTransactionController@search', 'as' => 'rwaq_charge_transaction_view']);
        Route::post('rct/publish', ['uses' => '\App\Http\Controllers\Admin\RwaqUsersDiplomasChargeTransactionController@publish', 'as' => 'rwaq_charge_transaction_publish']);
        Route::post('rct/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'rwaq_charge_transaction_add']);
        Route::get('rct/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\RwaqUsersDiplomasChargeTransactionController@copy', 'as' => 'rwaq_charge_transaction_copy']);
        Route::post('rct/add_courses/{id}', ['uses' => '\App\Http\Controllers\Admin\RwaqUsersDiplomasChargeTransactionController@addCourses', 'as' => 'rwaq_charge_transaction_add_courses']);
        Route::get('export_rwaq_charge_transaction', ['uses' => '\App\Http\Controllers\Admin\RwaqUsersDiplomasChargeTransactionController@export_rwaq_charge_transaction', 'as' => 'export_rwaq_charge_transaction']);


        Route::resource('tpct', '\App\Http\Controllers\Admin\TrainingProgramChargeTransactionController', ['names' => ['create' => 'training_programs_charge_transaction_add', 'store' => 'training_programs_charge_transaction_add', 'index' => 'training_programs_charge_transaction', 'edit' => 'training_programs_charge_transaction_edit', 'update' => 'training_programs_charge_transaction_edit', 'destroy' => 'training_programs_charge_transaction_delete']]);
        Route::post('tpct_search', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramChargeTransactionController@search', 'as' => 'training_programs_charge_transaction_view']);
        Route::post('tpct/publish', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramChargeTransactionController@publish', 'as' => 'training_programs_charge_transaction_publish']);
        Route::post('tpct/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'training_programs_charge_transaction_add']);
        Route::get('tpct/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramChargeTransactionController@copy', 'as' => 'training_programs_charge_transaction_copy']);
        Route::post('tpct/add_courses/{id}', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramChargeTransactionController@addCourses', 'as' => 'training_programs_charge_transaction_add_courses']);


        Route::resource('idct', '\App\Http\Controllers\Admin\InternationalDiplomasChargeTransactionController', ['names' => ['create' => 'international_diplomas_charge_transaction_add', 'store' => 'international_diplomas_charge_transaction_add', 'index' => 'international_diplomas_charge_transaction', 'edit' => 'international_diplomas_charge_transaction_edit', 'update' => 'international_diplomas_charge_transaction_edit', 'destroy' => 'international_diplomas_charge_transaction_delete']]);
        Route::post('idct_search', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomasChargeTransactionController@search', 'as' => 'international_diplomas_charge_transaction_view']);
        Route::post('idct/publish', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomasChargeTransactionController@publish', 'as' => 'international_diplomas_charge_transaction_publish']);
        Route::post('idct/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'international_diplomas_charge_transaction_add']);
        Route::get('idct/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomasChargeTransactionController@copy', 'as' => 'international_diplomas_charge_transaction_copy']);
//        Route::post('dct/add_courses/{id}', ['uses' => '\App\Http\Controllers\Admin\DiplomasChargeTransactionController@addCourses', 'as' => 'diplomas_charge_transaction_add_courses']);

        Route::resource('dcct', '\App\Http\Controllers\Admin\DiplomasCompaniesChargeTransactionController', ['names' => ['create' => 'diplomas_companies_charge_transaction_add', 'store' => 'diplomas_companies_charge_transaction_add', 'index' => 'diplomas_companies_charge_transaction', 'edit' => 'diplomas_companies_charge_transaction_edit', 'update' => 'diplomas_companies_charge_transaction_edit', 'destroy' => 'diplomas_companies_charge_transaction_delete']]);
        Route::post('dcct_search', ['uses' => '\App\Http\Controllers\Admin\DiplomasCompaniesChargeTransactionController@search', 'as' => 'diplomas_companies_charge_transaction_view']);
//        Route::post('dct/publish', ['uses' => '\App\Http\Controllers\Admin\DiplomasCompaniesChargeTransactionController@publish', 'as' => 'diplomas_companies_charge_transaction_publish']);
        Route::post('dcct/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'diplomas_companies_charge_transaction_add']);
        Route::get('dcct/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\DiplomasCompaniesChargeTransactionController@copy', 'as' => 'diplomas_companies_charge_transaction_copy']);
        Route::post('dcct/add_courses/{id}', ['uses' => '\App\Http\Controllers\Admin\DiplomasCompaniesChargeTransactionController@addCourses', 'as' => 'diplomas_companies_charge_transaction_add_courses']);


        Route::resource('tpcct', '\App\Http\Controllers\Admin\TrainingProgramCompaniesChargeTransactionController', ['names' => ['create' => 'training_program_companies_charge_transaction_add', 'store' => 'training_program_companies_charge_transaction_add', 'index' => 'training_program_companies_charge_transaction', 'edit' => 'training_program_companies_charge_transaction_edit', 'update' => 'training_program_companies_charge_transaction_edit', 'destroy' => 'training_program_companies_charge_transaction_delete']]);
        Route::post('tpcct_search', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramCompaniesChargeTransactionController@search', 'as' => 'training_program_companies_charge_transaction_view']);
//        Route::post('dct/publish', ['uses' => '\App\Http\Controllers\Admin\DiplomasCompaniesChargeTransactionController@publish', 'as' => 'diplomas_companies_charge_transaction_publish']);
        Route::post('tpcct/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'training_program_companies_charge_transaction_add']);
        Route::get('tpcct/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramCompaniesChargeTransactionController@copy', 'as' => 'training_program_companies_charge_transaction_copy']);
        Route::post('tpcct/add_courses/{id}', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramCompaniesChargeTransactionController@addCourses', 'as' => 'training_program_companies_charge_transaction_add_courses']);


        Route::resource('cct', '\App\Http\Controllers\Admin\CompaniesChargeTransactionController', ['names' => [ 'index' => 'companies_charge_transaction', 'destroy' => 'companies_charge_transaction_delete']]);
        Route::post('cct_search', ['uses' => '\App\Http\Controllers\Admin\CompaniesChargeTransactionController@search', 'as' => 'companies_charge_transaction_view']);

        Route::resource('lcct', '\App\Http\Controllers\Admin\LiteversionCompaniesChargeTransactionController', ['names' => [ 'index' => 'lite_version_companies_charge_transaction', 'destroy' => 'lite_version_companies_charge_transaction_delete']]);
        Route::post('lcct_search', ['uses' => '\App\Http\Controllers\Admin\LiteversionCompaniesChargeTransactionController@search', 'as' => 'lite_version_companies_charge_transaction_view']);

        Route::resource('mcct', '\App\Http\Controllers\Admin\MbaCompaniesChargeTransactionController', ['names' => [ 'index' => 'mba_companies_charge_transaction', 'destroy' => 'mba_companies_charge_transaction_delete']]);
        Route::post('mcct_search', ['uses' => '\App\Http\Controllers\Admin\MbaCompaniesChargeTransactionController@search', 'as' => 'mba_companies_charge_transaction_view']);

        Route::resource('charge_transaction', '\App\Http\Controllers\Admin\ChargeTransactionController', ['names' => ['create' => 'charge_transaction_add', 'store' => 'charge_transaction_add', 'index' => 'charge_transaction', 'edit' => 'charge_transaction_edit', 'update' => 'charge_transaction_edit', 'destroy' => 'charge_transaction_delete']]);
        Route::post('charge_transaction_search', ['uses' => '\App\Http\Controllers\Admin\ChargeTransactionController@search', 'as' => 'charge_transaction_view']);
        Route::post('charge_transaction/publish', ['uses' => '\App\Http\Controllers\Admin\ChargeTransactionController@publish', 'as' => 'charge_transaction_publish']);
        Route::get('charge_transaction/copy/{id}', ['uses' => '\App\Http\Controllers\Admin\ChargeTransactionController@copy', 'as' => 'charge_transaction_copy']);
        Route::post('charge_transaction/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'charge_transaction_add']);

        Route::resource('contactus', '\App\Http\Controllers\Admin\ContactusController', ['names' => ['index' => 'contactus']]);
        Route::post('contactus_search', ['uses' => '\App\Http\Controllers\Admin\ContactusController@search', 'as' => 'contactus_view']);

        Route::resource('webinars_views', '\App\Http\Controllers\Admin\WebinarsViewsController', ['names' => ['create' => 'webinars_views_add', 'store' => 'webinars_views_add', 'index' => 'webinars_views', 'edit' => 'webinars_views_edit', 'update' => 'webinars_views_edit', 'destroy' => 'webinars_views_delete']]);
        Route::post('webinars_views_search', ['uses' => '\App\Http\Controllers\Admin\WebinarsViewsController@search', 'as' => 'webinars_views_view']);
        Route::post('webinars_views/publish', ['uses' => '\App\Http\Controllers\Admin\WebinarsViewsController@publish', 'as' => 'webinars_views_publish']);
        Route::post('webinars_views/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'webinars_views_add']);

        Route::resource('successtories_views', '\App\Http\Controllers\Admin\SuccesstoriesViewsController', ['names' => ['create' => 'successtories_views_add', 'store' => 'successtories_views_add', 'index' => 'successtories_views', 'edit' => 'successtories_views_edit', 'update' => 'successtories_views_edit', 'destroy' => 'successtories_views_delete']]);
        Route::post('successtories_views_search', ['uses' => '\App\Http\Controllers\Admin\SuccesstoriesViewsController@search', 'as' => 'successtories_views_view']);
        Route::post('successtories_views/publish', ['uses' => '\App\Http\Controllers\Admin\SuccesstoriesViewsController@publish', 'as' => 'successtories_views_publish']);
        Route::post('successtories_views/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'successtories_views_add']);

        //our_partner
        Route::resource('our_partner', '\App\Http\Controllers\Admin\OurPartnerController', ['names' => ['create' => 'our_partner_add', 'store' => 'our_partner_add', 'index' => 'our_partner', 'edit' => 'our_partner_edit', 'update' => 'our_partner_edit', 'destroy' => 'our_partner_delete']]);
        Route::post('our_partner_search', ['uses' => '\App\Http\Controllers\Admin\OurPartnerController@search', 'as' => 'our_partner_view']);
        Route::post('our_partner/publish', ['uses' => '\App\Http\Controllers\Admin\OurPartnerController@publish', 'as' => 'our_partner_publish']);

        Route::resource('our_partner_flags', '\App\Http\Controllers\Admin\OurPartnerFlagsController', ['names' => ['create' => 'our_partner_flags_add', 'store' => 'our_partner_flags_add', 'index' => 'our_partner_flags', 'edit' => 'our_partner_flags_edit', 'update' => 'our_partner_flags_edit', 'destroy' => 'our_partner_flags_delete']]);
        Route::post('our_partner_flags_search', ['uses' => '\App\Http\Controllers\Admin\OurPartnerFlagsController@search', 'as' => 'our_partner_flags_view']);
        Route::post('our_partner_flags/publish', ['uses' => '\App\Http\Controllers\Admin\OurPartnerFlagsController@publish', 'as' => 'our_partner_flags_publish']);


        Route::resource('tpay_price_book', '\App\Http\Controllers\Admin\TpayPriceBookController', ['names' => ['create' => 'tpay_price_book_add', 'store' => 'tpay_price_book_add', 'index' => 'tpay_price_book', 'edit' => 'tpay_price_book_edit', 'update' => 'tpay_price_book_edit', 'destroy' => 'tpay_price_book_delete']]);
        Route::post('tpay_price_book_search', ['uses' => '\App\Http\Controllers\Admin\TpayPriceBookController@search', 'as' => 'tpay_price_book_view']);
        Route::post('tpay_price_book/publish', ['uses' => '\App\Http\Controllers\Admin\TpayPriceBookController@publish', 'as' => 'tpay_price_book_publish']);


        Route::resource('user_survey', '\App\Http\Controllers\Admin\UserSurveyController', ['names' => ['index' => 'user_survey']]);
        Route::post('user_survey_search', ['uses' => '\App\Http\Controllers\Admin\UserSurveyController@search', 'as' => 'user_survey_view']);

        Route::resource('survey', '\App\Http\Controllers\Admin\Survey1Controller', ['names' => ['index' => 'survey']]);
        Route::post('survey_search', ['uses' => '\App\Http\Controllers\Admin\Survey1Controller@search', 'as' => 'survey_view']);
        Route::resource('survey_clients', '\App\Http\Controllers\Admin\Survey1ClientsController', ['names' => ['index' => 'survey_clients']]);
        Route::post('survey_clients_search', ['uses' => '\App\Http\Controllers\Admin\Survey1ClientsController@search', 'as' => 'survey_clients_view']);

        Route::resource('feedback', '\App\Http\Controllers\Admin\FeedbackPopupController', ['names' => ['index' => 'feedback', 'edit' => 'feedback_edit', 'update' => 'feedback_edit']]);
        Route::post('feedback_search', ['uses' => '\App\Http\Controllers\Admin\FeedbackPopupController@search', 'as' => 'feedback_view']);

        Route::resource('rating', '\App\Http\Controllers\Admin\RatingPopupController', ['names' => ['index' => 'rating']]);
        Route::post('rating_search', ['uses' => '\App\Http\Controllers\Admin\RatingPopupController@search', 'as' => 'rating_view']);

        Route::resource('courses_rating', '\App\Http\Controllers\Admin\RatingController', ['names' => ['index' => 'courses_rating']]);
        Route::post('courses_rating_search', ['uses' => '\App\Http\Controllers\Admin\RatingController@search', 'as' => 'courses_rating_view']);
        Route::get('courses_rating_export', ['uses' => '\App\Http\Controllers\Admin\RatingController@export', 'as' => 'courses_rating_view']);
        Route::resource('new_courses_rating', '\App\Http\Controllers\Admin\NewRatingController', ['names' => ['index' => 'courses_rating']]);
        Route::post('new_courses_rating_search', ['uses' => '\App\Http\Controllers\Admin\NewRatingController@search', 'as' => 'courses_rating_view']);
        Route::get('new_courses_rating_export', ['uses' => '\App\Http\Controllers\Admin\NewRatingController@export', 'as' => 'courses_rating_view']);


        Route::resource('users_pdf_log', '\App\Http\Controllers\Admin\UserPdfController', ['names' => ['index' => 'users_pdf_log']]);
        Route::post('users_pdf_log_search', ['uses' => '\App\Http\Controllers\Admin\UserPdfController@search', 'as' => 'users_pdf_log_view']);
        Route::get('users_pdf_log_export', ['uses' => '\App\Http\Controllers\Admin\UserPdfController@export', 'as' => 'users_pdf_log_export']);


        Route::resource('users_pdf_templete_log', '\App\Http\Controllers\Admin\UsertemplatesController', ['names' => ['index' => 'users_pdf_templete_log']]);
        Route::post('users_pdf_templete_log_search', ['uses' => '\App\Http\Controllers\Admin\UsertemplatesController@search', 'as' => 'users_pdf_templete_log_view']);
        Route::get('users_pdf_templete_log_export', ['uses' => '\App\Http\Controllers\Admin\UsertemplatesController@export', 'as' => 'users_pdf_templete_log_export']);

        Route::get('courses_quility_views', ['uses' => '\App\Http\Controllers\Admin\RatingController@courseView', 'as' => 'courses_quility_views']);
        Route::post('courses_quility_views', ['uses' => '\App\Http\Controllers\Admin\RatingController@courseView', 'as' => 'courses_quility_views']);
        Route::get('courses_view_export', ['uses' => '\App\Http\Controllers\Admin\RatingController@course_view_export', 'as' => 'courses_quility_views']);

        /*START medical_charge_transactions*/
        Route::resource('medical_charge_transactions', '\App\Http\Controllers\Admin\MedicalChargeTransactionsController', ['names' => ['create' => 'medical_charge_transactions_add', 'store' => 'medical_charge_transactions_add', 'index' => 'medical_charge_transactions', 'edit' => 'medical_charge_transactions_edit', 'update' => 'medical_charge_transactions_edit', 'destroy' => 'medical_charge_transactions_delete']]);
        Route::post('medical_charge_transactions_search', ['uses' => '\App\Http\Controllers\Admin\MedicalChargeTransactionsController@search', 'as' => 'medical_charge_transactions_view']);
        Route::post('medical_charge_transactions/activation', ['uses' => '\App\Http\Controllers\Admin\MedicalChargeTransactionsController@activation', 'as' => 'medical_charge_transactions_active']);
        Route::post('medical_charge_transactions/copy', ['uses' => '\App\Http\Controllers\Admin\MedicalChargeTransactionsController@copy', 'as' => 'medical_charge_transactions_copy']);

        /*END medical_charge_transactions*/

        Route::resource('medical_categories_charge_transactions', '\App\Http\Controllers\Admin\MedicalCategoriesChargeTransactionsController', ['names' => ['create' => 'medical_categories_charge_transactions_add', 'store' => 'medical_categories_charge_transactions_add', 'index' => 'medical_categories_charge_transactions', 'edit' => 'medical_categories_charge_transactions_edit', 'update' => 'medical_categories_charge_transactions_edit', 'destroy' => 'medical_categories_charge_transactions_delete'],'parameters' => [
            'medical_categories_charge_transactions' => 'transaction'
        ]]);
        Route::post('medical_categories_charge_transactions_search', ['uses' => '\App\Http\Controllers\Admin\MedicalCategoriesChargeTransactionsController@search', 'as' => 'medical_categories_charge_transactions_view']);
        Route::post('medical_categories_charge_transactions/activation', ['uses' => '\App\Http\Controllers\Admin\MedicalCategoriesChargeTransactionsController@activation', 'as' => 'medical_categories_charge_transactions_active']);
        Route::post('medical_categories_charge_transactions/copy', ['uses' => '\App\Http\Controllers\Admin\MedicalCategoriesChargeTransactionsController@copy', 'as' => 'medical_categories_charge_transactions_copy']);

        Route::resource('international_categories', '\App\Http\Controllers\Admin\InternationalCategoriesController', ['names' => ['create' => 'international_categories_add', 'store' => 'international_categories_add', 'index' => 'international_categories', 'edit' => 'international_categories_edit', 'update' => 'international_categories_edit', 'destroy' => 'international_categories_delete']]);
        Route::post('international_categories_search', ['uses' => '\App\Http\Controllers\Admin\InternationalCategoriesController@search', 'as' => 'international_categories_view']);
        Route::post('international_categories/publish', ['uses' => '\App\Http\Controllers\Admin\InternationalCategoriesController@publish', 'as' => 'international_categories_publish']);

        /*START lite_version_charge_transaction*/
        Route::resource('lite_version_charge_transaction', '\App\Http\Controllers\Admin\LiteVersionChargeTransactionController', ['names' => ['create' => 'lite_version_charge_transaction_add', 'store' => 'lite_version_charge_transaction_add', 'index' => 'lite_version_charge_transaction', 'edit' => 'lite_version_charge_transaction_edit', 'update' => 'lite_version_charge_transaction_edit', 'destroy' => 'lite_version_charge_transaction_delete']]);
        Route::post('lite_version_charge_transaction_search', ['uses' => '\App\Http\Controllers\Admin\LiteVersionChargeTransactionController@search', 'as' => 'lite_version_charge_transaction_view']);
        Route::post('lite_version_charge_transaction/activation', ['uses' => '\App\Http\Controllers\Admin\LiteVersionChargeTransactionController@activation', 'as' => 'lite_version_charge_transaction_active']);
        /*END lite_version_charge_transaction*/


        /*START diplomas_courses_user_plan*/
        Route::resource('diplomas_courses_user_plan', '\App\Http\Controllers\Admin\DiplomasCoursesUserPlanController', ['names' => ['create' => 'diplomas_courses_user_plan_add', 'store' => 'diplomas_courses_user_plan_add', 'index' => 'diplomas_courses_user_plan', 'edit' => 'diplomas_courses_user_plan_edit', 'update' => 'diplomas_courses_user_plan_edit', 'destroy' => 'diplomas_courses_user_plan_delete']]);
        Route::post('diplomas_courses_user_plan_search', ['uses' => '\App\Http\Controllers\Admin\DiplomasCoursesUserPlanController@search', 'as' => 'diplomas_courses_user_plan_view']);
        Route::post('diplomas_courses_user_plan/activation', ['uses' => '\App\Http\Controllers\Admin\DiplomasCoursesUserPlanController@activation', 'as' => 'diplomas_courses_user_plan_active']);
        Route::post('diplomas_courses_user_plan/delete_all', ['uses' => '\App\Http\Controllers\Admin\DiplomasCoursesUserPlanController@delete_all', 'as' => 'diplomas_courses_user_plan_delete_all']);
        Route::post('diplomas_courses_user_plan/delete_selected', ['uses' => '\App\Http\Controllers\Admin\DiplomasCoursesUserPlanController@delete_selected', 'as' => 'diplomas_courses_user_plan_delete_selected']);
        /*END diplomas_courses_user_plan*/

        Route::resource('training_courses_user_plan', '\App\Http\Controllers\Admin\TrainingProgramCoursesUserPlanController', ['names' => ['create' => 'training_courses_user_plan_add', 'store' => 'training_courses_user_plan_add', 'index' => 'training_courses_user_plan', 'edit' => 'training_courses_user_plan_edit', 'update' => 'training_courses_user_plan_edit', 'destroy' => 'training_courses_user_plan_delete']]);
        Route::post('training_courses_user_plan_search', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramCoursesUserPlanController@search', 'as' => 'training_courses_user_plan_view']);
        Route::post('training_courses_user_plan/activation', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramCoursesUserPlanController@activation', 'as' => 'training_courses_user_plan_active']);
        Route::post('training_courses_user_plan/delete_all', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramCoursesUserPlanController@delete_all', 'as' => 'training_courses_user_plan_delete_all']);
        Route::post('training_courses_user_plan/delete_selected', ['uses' => '\App\Http\Controllers\Admin\TrainingProgramCoursesUserPlanController@delete_selected', 'as' => 'training_courses_user_plan_delete_selected']);


        Route::resource('international_diplomas_courses_user_plan', '\App\Http\Controllers\Admin\InternationalDiplomasCoursesUserPlanController', ['names' => ['create' => 'international_diplomas_courses_user_plan_add', 'store' => 'international_diplomas_courses_user_plan_add', 'index' => 'international_diplomas_courses_user_plan', 'edit' => 'international_diplomas_courses_user_plan_edit', 'update' => 'international_diplomas_courses_user_plan_edit', 'destroy' => 'international_diplomas_courses_user_plan_delete'],'parameters' => [
            'international_diplomas_courses_user_plan' => 'idcup'
        ]]);

        Route::post('international_diplomas_courses_user_plan_search', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomasCoursesUserPlanController@search', 'as' => 'international_diplomas_courses_user_plan_view']);
        Route::post('international_diplomas_courses_user_plan/activation', ['uses' => '\App\Http\Controllers\Admin\InternationalDiplomasCoursesUserPlanController@activation', 'as' => 'international_diplomas_courses_user_plan_active']);
        Route::post('international_diplomas_courses_user_plan/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'international_diplomas_courses_user_plan_add']);

        /*START mba_courses_user_plan*/
        Route::resource('mba_courses_user_plan', '\App\Http\Controllers\Admin\MbaCoursesUserPlanController', ['names' => ['create' => 'mba_courses_user_plan_add', 'store' => 'mba_courses_user_plan_add', 'index' => 'mba_courses_user_plan', 'edit' => 'mba_courses_user_plan_edit', 'update' => 'mba_courses_user_plan_edit', 'destroy' => 'mba_courses_user_plan_delete']]);
        Route::post('mba_courses_user_plan_search', ['uses' => '\App\Http\Controllers\Admin\MbaCoursesUserPlanController@search', 'as' => 'mba_courses_user_plan_view']);
        Route::post('mba_courses_user_plan/activation', ['uses' => '\App\Http\Controllers\Admin\MbaCoursesUserPlanController@activation', 'as' => 'mba_courses_user_plan_active']);
        Route::post('mba_courses_user_plan/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'mba_courses_user_plan_add']);

        /*END mba_courses_user_plan*/

        /* Start New MBA Courses User Plans */

        Route::delete('new_mba_courses_user_plan/delete_milty', ['uses' => '\App\Http\Controllers\Admin\NewMbaCoursesUserPlanController@deleteMilty', 'as' => 'new_mba_courses_user_plan_delete']);
        Route::resource('new_mba_courses_user_plan', '\App\Http\Controllers\Admin\NewMbaCoursesUserPlanController', ['names' => ['create' => 'new_mba_courses_user_plan_add', 'store' => 'new_mba_courses_user_plan_add', 'index' => 'new_mba_courses_user_plan', 'edit' => 'new_mba_courses_user_plan_edit', 'update' => 'new_mba_courses_user_plan_edit', 'destroy' => 'new_mba_courses_user_plan_delete']]);
        Route::post('new_mba_courses_user_plan_search', ['uses' => '\App\Http\Controllers\Admin\NewMbaCoursesUserPlanController@search', 'as' => 'new_mba_courses_user_plan_view']);
        Route::post('new_mba_courses_user_plan/activation', ['uses' => '\App\Http\Controllers\Admin\NewMbaCoursesUserPlanController@activation', 'as' => 'new_mba_courses_user_plan_active']);
        Route::post('new_mba_courses_user_plan/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'new_mba_courses_user_plan_add']);

        /* End New MBA Courses User Plans */


        Route::resource('promotion_code_used', '\App\Http\Controllers\Admin\PromotionCodeUsedController', ['names' => [ 'index' => 'promotion_code_used_view']]);
        Route::get('promotion_code_used_report1',['uses' => '\App\Http\Controllers\Admin\PromotionCodeUsedController@report1', 'as' => 'promotion_code_used_report1'] );
        Route::get('promotion_code_used_report2',['uses' => '\App\Http\Controllers\Admin\PromotionCodeUsedController@report2', 'as' => 'promotion_code_used_report2'] );
        Route::post('promotion_code_used_search', ['uses' => '\App\Http\Controllers\Admin\PromotionCodeUsedController@search', 'as' => 'promotion_code_used_view']);
        Route::post('promotion_code_used_search1', ['uses' => '\App\Http\Controllers\Admin\PromotionCodeUsedController@search1', 'as' => 'promotion_code_used_report1']);
        Route::post('promotion_code_used_search2', ['uses' => '\App\Http\Controllers\Admin\PromotionCodeUsedController@search2', 'as' => 'promotion_code_used_report2']);
        Route::get('promotion_code_used_report1_export', ['uses' => '\App\Http\Controllers\Admin\PromotionCodeUsedController@report1_export', 'as' => 'promotion_code_used_report1']);
        Route::get('promotion_code_used_report2_export', ['uses' => '\App\Http\Controllers\Admin\PromotionCodeUsedController@report2_export', 'as' => 'promotion_code_used_report2']);

        Route::resource('promotion_code', '\App\Http\Controllers\Admin\PromotionCodeController', ['names' => [ 'create' => 'promotion_code_add', 'store' => 'promotion_code_add']]);
        Route::post('promotion_code/getUsers', ['uses' => '\App\Http\Controllers\Admin\PromotionCodeController@getUsers', 'as' => 'promotion_code_add']);
        Route::post('promotion_code/getDiplomasWithType', ['uses' => '\App\Http\Controllers\Admin\PromotionCodeController@getDiplomasWithType', 'as' => 'promotion_code_add']);
        Route::post('promotion_code/getPriceByType', ['uses' => '\App\Http\Controllers\Admin\PromotionCodeController@getPriceByType', 'as' => 'promotion_code_add']);
        Route::post('promotion_code/generateCode', ['uses' => '\App\Http\Controllers\Admin\PromotionCodeController@generateCode', 'as' => 'promotion_code_add']);

        Route::resource('encountersvideos', '\App\Http\Controllers\Admin\EncountersvideosController', ['names' => ['create' => 'encountersvideos_add', 'store' => 'encountersvideos_add', 'index' => 'encountersvideos', 'edit' => 'encountersvideos_edit', 'update' => 'encountersvideos_edit', 'destroy' => 'encountersvideos_delete']]);
        Route::post('encountersvideos_search', ['uses' => '\App\Http\Controllers\Admin\EncountersvideosController@search', 'as' => 'encountersvideos_view']);
        Route::post('encountersvideos/publish', ['uses' => '\App\Http\Controllers\Admin\EncountersvideosController@publish', 'as' => 'encountersvideos_publish']);



        Route::resource('dba', '\App\Http\Controllers\Admin\DBAController', ['names' => ['create' => 'dba_add', 'store' => 'dba_add', 'index' => 'dba', 'edit' => 'dba_edit', 'update' => 'dba_edit', 'destroy' => 'dba_delete']]);
        Route::post('dba_search', ['uses' => '\App\Http\Controllers\Admin\DBAController@search', 'as' => 'dba_view']);
        Route::post('dba/publish', ['uses' => '\App\Http\Controllers\Admin\DBAController@publish', 'as' => 'dba_publish']);
        Route::get('dba/delete_file/{id}', ['uses' => '\App\Http\Controllers\Admin\DBAController@delete_file', 'as' => 'dba_delete']);
        Route::get('dba/download_file/{id}', ['uses' => '\App\Http\Controllers\Admin\DBAController@downloadFile', 'as' => 'dba_view']);
        Route::post('dba/delete_image',['uses'=>'\App\Http\Controllers\Admin\DBAController@deleteImage','as'=>'dba_edit']);





        Route::resource('dba_categories', '\App\Http\Controllers\Admin\DBACategoriesController', ['names' => ['create' => 'dba_categories_add', 'store' => 'dba_categories_add', 'index' => 'dba_categories', 'edit' => 'dba_categories_edit', 'update' => 'dba_categories_edit', 'destroy' => 'dba_categories_delete']]);
        Route::post('dba_categories_search', ['uses' => '\App\Http\Controllers\Admin\DBACategoriesController@search', 'as' => 'dba_categories_view']);


        Route::resource('dba_charge_transaction', '\App\Http\Controllers\Admin\DBAChargeTransactionController', ['names' => ['create' => 'dba_charge_transaction_add', 'store' => 'dba_charge_transaction_add', 'index' => 'dba_charge_transaction', 'edit' => 'dba_charge_transaction_edit', 'update' => 'dba_charge_transaction_edit', 'destroy' => 'dba_charge_transaction_delete']]);
        Route::post('dba_charge_transaction_search', ['uses' => '\App\Http\Controllers\Admin\DBAChargeTransactionController@search', 'as' => 'dba_charge_transaction_view']);
        Route::post('dba_charge_transaction/activation', ['uses' => '\App\Http\Controllers\Admin\DBAChargeTransactionController@activation', 'as' => 'dba_charge_transaction_active']);
        Route::post('dba_charge_transaction/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\DBAChargeTransactionController@autoCompleteUsers', 'as' => 'dba_charge_transaction_add']);



        Route::resource('dba_checklists', '\App\Http\Controllers\Admin\DBAChecklistsController', ['names' => ['create' => 'dba_checklists_add', 'store' => 'dba_checklists_add', 'index' => 'dba_checklists', 'edit' => 'dba_checklists_edit', 'update' => 'dba_checklists_edit', 'destroy' => 'dba_checklists_delete']]);
        Route::post('dba_checklists_search', ['uses' => '\App\Http\Controllers\Admin\DBAChecklistsController@search', 'as' => 'dba_checklists_view']);



        Route::resource('dba_checklists_user_plan', '\App\Http\Controllers\Admin\DBAChecklistsUserPlanController', ['names' => ['create' => 'dba_checklists_user_plan_add', 'store' => 'dba_checklists_user_plan_add', 'index' => 'dba_checklists_user_plan', 'edit' => 'dba_checklists_user_plan_edit', 'update' => 'dba_checklists_user_plan_edit', 'destroy' => 'dba_checklists_user_plan_delete']]);
        Route::post('dba_checklists_user_plan_search', ['uses' => '\App\Http\Controllers\Admin\DBAChecklistsUserPlanController@search', 'as' => 'dba_checklists_user_plan_view']);
        Route::post('dba_checklists_user_plan/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\DBAChecklistsUserPlanController@autoCompleteUsers', 'as' => 'dba_checklists_user_plan_add']);



        Route::resource('dba_faq', '\App\Http\Controllers\Admin\DBAFaqController', ['names' => ['create' => 'dba_faq_add', 'store' => 'dba_faq_add', 'index' => 'dba_faq', 'edit' => 'dba_faq_edit', 'update' => 'dba_faq_edit', 'destroy' => 'dba_faq_delete']]);
        Route::post('dba_faq_search', ['uses' => '\App\Http\Controllers\Admin\DBAFaqController@search', 'as' => 'dba_faq_view']);
        Route::post('dba_faq/publish', ['uses' => '\App\Http\Controllers\Admin\DBAFaqController@publish', 'as' => 'dba_faq_publish']);


        Route::resource('dbapct', '\App\Http\Controllers\Admin\DBAPreliminaryChargeTransactionController', ['names' => ['create' => 'dbapct_add', 'store' => 'dbapct_add', 'index' => 'dbapct', 'edit' => 'dbapct_edit', 'update' => 'dbapct_edit', 'destroy' => 'dbapct_delete']]);
        Route::post('dbapct_search', ['uses' => '\App\Http\Controllers\Admin\DBAPreliminaryChargeTransactionController@search', 'as' => 'dbapct_view']);
        Route::post('dbapct/activation', ['uses' => '\App\Http\Controllers\Admin\DBAPreliminaryChargeTransactionController@activation', 'as' => 'dbapct_active']);
        Route::post('dbapct/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\DBAChargeTransactionController@autoCompleteUsers', 'as' => 'dbapct_add']);


        Route::resource('dba_preliminary_courses', '\App\Http\Controllers\Admin\DBAPreliminaryCourseController', ['names' => ['create' => 'dba_preliminary_courses_add', 'store' => 'dba_preliminary_courses_add', 'index' => 'dba_preliminary_courses', 'edit' => 'dba_preliminary_courses_edit', 'update' => 'dba_preliminary_courses_edit', 'destroy' => 'dba_preliminary_courses_delete']]);
        Route::post('dba_preliminary_courses_search', ['uses' => '\App\Http\Controllers\Admin\DBAPreliminaryCourseController@search', 'as' => 'dba_preliminary_courses_view']);
        Route::post('dba_preliminary_courses/publish', ['uses' => '\App\Http\Controllers\Admin\DBAPreliminaryCourseController@publish', 'as' => 'dba_preliminary_courses_publish']);


        Route::resource('dbapcup', '\App\Http\Controllers\Admin\DBAPreliminaryCoursesUserPlanController', ['names' => ['create' => 'dbapcup_add', 'store' => 'dbapcup_add', 'index' => 'dbapcup', 'edit' => 'dbapcup_edit', 'update' => 'dbapcup_edit', 'destroy' => 'dbapcup_delete']]);
        Route::post('dbapcup_search', ['uses' => '\App\Http\Controllers\Admin\DBAPreliminaryCoursesUserPlanController@search', 'as' => 'dbapcup_view']);
        Route::post('dbapcup/publish', ['uses' => '\App\Http\Controllers\Admin\DBAPreliminaryCoursesUserPlanController@activation', 'as' => 'dbapcup_active']);


        Route::resource('dba_users_questions', '\App\Http\Controllers\Admin\DBAUsersQuestionsController', ['names' => ['index' => 'dba_users_questions', 'edit' => 'dba_users_questions_edit', 'update' => 'dba_users_questions_edit']]);
        Route::post('dba_users_questions_search', ['uses' => '\App\Http\Controllers\Admin\DBAUsersQuestionsController@search', 'as' => 'dba_users_questions_view']);


        Route::resource('dba_certificates', '\App\Http\Controllers\Admin\DBACertificatesController', ['names' => ['create' => 'dba_certificates_add', 'store' => 'dba_certificates_add', 'index' => 'dba_certificates', 'edit' => 'dba_certificates_edit', 'update' => 'dba_certificates_edit', 'destroy' => 'dba_certificates_delete']]);
        Route::post('dba_certificates_search', ['uses' => '\App\Http\Controllers\Admin\DBACertificatesController@search', 'as' => 'dba_certificates_view']);
        Route::post('dba_certificates/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'dba_certificates_add']);



        /*START DiplomasSupplementaryTestsController*/
        Route::resource('supplementary_tests', '\App\Http\Controllers\Admin\DiplomasSupplementaryTestsController', [
            'names' => [
                'create' => 'supplementary_tests_add',
                'store'  => 'supplementary_tests_add',
                'index'  => 'supplementary_tests',
                'show'   => 'supplementary_tests_edit',
                'edit'   => 'supplementary_tests_edit',
                'update' => 'supplementary_tests_edit',
                'destroy'=> 'supplementary_tests_delete'
            ]
        ]);
        Route::post('supplementary_tests_fetch', ['uses' => '\App\Http\Controllers\Admin\DiplomasSupplementaryTestsController@fetchQuestions', 'as' => 'supplementary_tests_edit']);
        Route::post('update_supplementary_tests/{id}',['uses' => '\App\Http\Controllers\Admin\DiplomasSupplementaryTestsController@UpdateSupplementary', 'as' => 'supplementary_tests_edit']);
        Route::post('supplementary_tests_search', ['uses' => '\App\Http\Controllers\Admin\DiplomasSupplementaryTestsController@search', 'as' => 'supplementary_tests_view']);
        Route::GET('supplementary_tests/{type}/{id}', ['uses' => '\App\Http\Controllers\Admin\DiplomasSupplementaryTestsController@show', 'as' => 'supplementary_tests_edit']);
        Route::delete('delete_supplementary_tests/{id}', ['uses' => '\App\Http\Controllers\Admin\DiplomasSupplementaryTestsController@DeleteSupplementaryQuestions', 'as' => 'supplementary_tests_delete']);
        /*END DiplomasSupplementaryTestsController*/

        /*START DiplomasSupplementaryTestsAnswersController*/
        Route::resource('supplementary_tests_answers', '\App\Http\Controllers\Admin\DiplomasSupplementaryTestsAnswersController', [
            'names' => [
                'create' => 'supplementary_tests_answers_add',
                'store'  => 'supplementary_tests_answers_add',
                'index'  => 'supplementary_tests_answers',
                'show'   => 'supplementary_tests_answers_edit',
                'edit'   => 'supplementary_tests_answers_edit',
                'update' => 'supplementary_tests_answers_edit',
                'destroy'=> 'supplementary_tests_answers_delete'
            ]
        ]);
        Route::post('supplementary_tests_answers_search', ['uses' => '\App\Http\Controllers\Admin\DiplomasSupplementaryTestsAnswersController@search', 'as' => 'supplementary_tests_answers_view']);
        Route::post('supplementary_tests_answers/autoCompleteUsers', ['uses' => '\App\Http\Controllers\Admin\NormalUserController@autoCompleteUsers', 'as' => 'supplementary_tests_answers_add']);



        Route::get('website_activity_report',['uses'=>'\App\Http\Controllers\Admin\AdminController@websiteActivityReport','as'=>'website_activity_report']);
        Route::get('admin_activity_report',['uses'=>'\App\Http\Controllers\Admin\AdminController@activityReport','as'=>'admin_activity_report']);
        Route::get('admin_activity_report/details',['uses'=>'\App\Http\Controllers\Admin\AdminController@activityReportDetails','as'=>'admin_activity_report']);


        /* consulting Routs Start*/
        Route::resource('consulting', '\App\Http\Controllers\Admin\ConsultingController',['names'=>['create'=>'consulting_add','store'=>'consulting_add','index'=>'consulting_view','edit'=>'consulting_edit','update'=>'consulting_edit','destroy'=>'consulting_delete']]);
        Route::post('consulting_search', ['uses' => '\App\Http\Controllers\Admin\ConsultingController@search', 'as' => 'consulting_view']);
        Route::post('consulting/publish',['uses'=>'\App\Http\Controllers\Admin\ConsultingController@publish','as'=>'consulting_publish']);
        /* consulting Routs End*/


        /* accreditation_certificates Routs Start*/
        Route::resource('accreditation_certificates', '\App\Http\Controllers\Admin\AccreditationPartnersCertificatesController',['names'=>['create'=>'accreditation_certificates_add','store'=>'accreditation_certificates_add','index'=>'accreditation_certificates_view','edit'=>'accreditation_certificates_edit','update'=>'accreditation_certificates_edit','destroy'=>'accreditation_certificates_delete']]);
        Route::post('accreditation_certificates_search', ['uses' => '\App\Http\Controllers\Admin\AccreditationPartnersCertificatesController@search', 'as' => 'accreditation_certificates_view']);
        Route::post('accreditation_certificates/publish',['uses'=>'\App\Http\Controllers\Admin\AccreditationPartnersCertificatesController@publish','as'=>'accreditation_certificates_publish']);
        /* accreditation_certificates Routs End*/

        /* accreditation_partners_countries Routs Start*/
        Route::resource('accreditation_partners_countries', '\App\Http\Controllers\Admin\AccreditationPartnersCountriesController',['names'=>['create'=>'accreditation_partners_countries_add','store'=>'accreditation_partners_countries_add','index'=>'accreditation_partners_countries_view','edit'=>'accreditation_partners_countries_edit','update'=>'accreditation_partners_countries_edit','destroy'=>'accreditation_partners_countries_delete']]);
        Route::post('accreditation_partners_countries_search', ['uses' => '\App\Http\Controllers\Admin\AccreditationPartnersCountriesController@search', 'as' => 'accreditation_partners_countries_view']);
        Route::post('accreditation_partners_countries/publish',['uses'=>'\App\Http\Controllers\Admin\AccreditationPartnersCountriesController@publish','as'=>'accreditation_partners_countries_publish']);
        /* accreditation_partners_countries Routs End*/

        /* accreditation_partners_countries_categories Routs Start*/
        Route::resource('apcc', '\App\Http\Controllers\Admin\AccreditationPartnersCountriesCategoriesController',['names'=>['create'=>'accreditation_partners_countries_categories_add','store'=>'accreditation_partners_countries_categories_add','index'=>'accreditation_partners_countries_categories_view','edit'=>'accreditation_partners_countries_categories_edit','update'=>'accreditation_partners_countries_categories_edit','destroy'=>'accreditation_partners_countries_categories_delete']]);
        Route::post('apcc_search', ['uses' => '\App\Http\Controllers\Admin\AccreditationPartnersCountriesCategoriesController@search', 'as' => 'accreditation_partners_countries_categories_view']);
        Route::post('apcc/publish',['uses'=>'\App\Http\Controllers\Admin\AccreditationPartnersCountriesCategoriesController@publish','as'=>'accreditation_partners_countries_categories_publish']);
        /* accreditation_partners_countries_categories Routs End*/

        /* accreditation_partners_countries_categories_details Routs Start*/
        Route::resource('apccd', '\App\Http\Controllers\Admin\AccreditationPartnersCountriesCategoriesDetailsController',['names'=>['create'=>'accreditation_partners_countries_categories_details_add','store'=>'accreditation_partners_countries_categories_details_add','index'=>'accreditation_partners_countries_categories_details_view','edit'=>'accreditation_partners_countries_categories_details_edit','update'=>'accreditation_partners_countries_categories_details_edit','destroy'=>'accreditation_partners_countries_categories_details_delete']]);
        Route::post('apccd_search', ['uses' => '\App\Http\Controllers\Admin\AccreditationPartnersCountriesCategoriesDetailsController@search', 'as' => 'accreditation_partners_countries_categories_details_view']);
        Route::post('apccd/publish',['uses'=>'\App\Http\Controllers\Admin\AccreditationPartnersCountriesCategoriesDetailsController@publish','as'=>'accreditation_partners_countries_categories_details_publish']);
        Route::post('/apccd/delete_image',['uses'=>'\App\Http\Controllers\Admin\AccreditationPartnersCountriesCategoriesDetailsController@deleteImage','as'=>'accreditation_partners_countries_categories_details_edit']);
        /* accreditation_partners_countries_categories_details Routs End*/

        /*users routes*/
        Route::resource('instructors_users', '\App\Http\Controllers\Admin\InstructorsUsersController', ['names' => ['create' => 'instructors_users_add', 'store' => 'instructors_users_add', 'index' => 'instructors_users', 'edit' => 'instructors_users_edit', 'update' => 'instructors_users_edit', 'destroy' => 'instructors_users_delete']]);
        Route::post('instructors_users_search', ['uses' => '\App\Http\Controllers\Admin\InstructorsUsersController@search', 'as' => 'instructors_users_view']);

        Route::post('instructors_users/activation', ['uses' => '\App\Http\Controllers\Admin\InstructorsUsersController@activation', 'as' => 'instructors_users_active']);


        /*suggestion_courses*/
        Route::post('suggestion_courses', ['uses' => '\App\Http\Controllers\Admin\SuggestionCoursesController@store', 'as' => 'suggestion_courses']);
        Route::post('sort_suggestion_courses', ['uses' => '\App\Http\Controllers\Admin\SuggestionCoursesController@sort', 'as' => 'suggestion_courses']);
        Route::get('suggestion_courses', ['uses' => '\App\Http\Controllers\Admin\SuggestionCoursesController@index', 'as' => 'suggestion_courses']);
        Route::get('suggestion_courses/{id}', ['uses' => '\App\Http\Controllers\Admin\SuggestionCoursesController@show', 'as' => 'suggestion_courses']);
        Route::delete('suggestion_courses/{id}', ['uses' => '\App\Http\Controllers\Admin\SuggestionCoursesController@destroy', 'as' => 'suggestion_courses']);

        //Route::get('suggestion_courses',[\App\Http\Controllers\\App\Http\Controllers\Admin\SuggestionCoursesController::class,'index'])->name('suggestion_courses');
        /*suggestion_courses*/


        /*new_landing_page*/
        Route::post('new_landing_page_search', ['uses' => '\App\Http\Controllers\Admin\NewLandingPageController@search', 'as' => 'new_landing_page_view']);
        Route::post('new_landing_page/publish', ['uses' => '\App\Http\Controllers\Admin\NewLandingPageController@publish', 'as' => 'new_landing_page_publish']);
        Route::resource('new_landing_page', '\App\Http\Controllers\Admin\NewLandingPageController', ['names' => ['create' => 'new_landing_page_add', 'store' => 'new_landing_page_add', 'index' => 'new_landing_page', 'edit' => 'new_landing_page_edit', 'update' => 'new_landing_page_edit', 'destroy' => 'new_landing_page_delete']]);



        /*marketers*/
        Route::post('marketers/report_details', ['uses' => '\App\Http\Controllers\Admin\MarketersController@reportDetails', 'as' => 'marketers_report']);
        Route::get('marketers/report_details', ['uses' => '\App\Http\Controllers\Admin\MarketersController@reportDetails', 'as' => 'marketers_report']);

        Route::post('marketers/report', ['uses' => '\App\Http\Controllers\Admin\MarketersController@report', 'as' => 'marketers_report']);
        Route::get('marketers/report', ['uses' => '\App\Http\Controllers\Admin\MarketersController@report', 'as' => 'marketers_report']);




        Route::resource('marketers', '\App\Http\Controllers\Admin\MarketersController', ['names' => ['create' => 'marketers_add', 'store' => 'marketers_add', 'index' => 'marketers', 'edit' => 'marketers_edit', 'update' => 'marketers_edit', 'destroy' => 'marketers_delete']]);
        Route::post('marketers_search', ['uses' => '\App\Http\Controllers\Admin\MarketersController@search', 'as' => 'marketers_view']);
        Route::post('marketers/publish', ['uses' => '\App\Http\Controllers\Admin\MarketersController@publish', 'as' => 'marketers_publish']);
        /*marketers*/


        /*stock holders*/
        Route::resource('stockholders', '\App\Http\Controllers\Admin\StockholdersController', ['names' => ['create' => 'stockholders_add', 'store' => 'stockholders_add', 'index' => 'stockholders', 'edit' => 'stockholders_edit', 'update' => 'stockholders_edit', 'destroy' => 'stockholders_delete']]);
        Route::post('stockholders_search', ['uses' => '\App\Http\Controllers\Admin\StockholdersController@search', 'as' => 'stockholders_view']);
        Route::post('stockholders/publish', ['uses' => '\App\Http\Controllers\Admin\StockholdersController@publish', 'as' => 'stockholders_publish']);
        /*stock hlangolders*/

        /*stock holders*/
        Route::resource('suggestion_courses_conditions', '\App\Http\Controllers\Admin\SuggestionCoursesConditionsController', ['names' => ['create' => 'suggestion_courses_conditions_add', 'store' => 'suggestion_courses_conditions_add', 'index' => 'suggestion_courses_conditions', 'edit' => 'suggestion_courses_conditions_edit', 'update' => 'suggestion_courses_conditions_edit', 'destroy' => 'suggestion_courses_conditions_delete']]);
        Route::post('suggestion_courses_conditions_search', ['uses' => '\App\Http\Controllers\Admin\SuggestionCoursesConditionsController@search', 'as' => 'suggestion_courses_conditions_view']);
        Route::post('suggestion_courses_conditions/publish', ['uses' => '\App\Http\Controllers\Admin\SuggestionCoursesConditionsController@publish', 'as' => 'suggestion_courses_conditions_publish']);
        /*stock holders*/
        Route::get('brochures_tracking',['uses' => '\App\Http\Controllers\Admin\BrochuresTrackingController@index', 'as' => 'brochures_tracking']);
        Route::post('brochures_tracking',['uses' => '\App\Http\Controllers\Admin\BrochuresTrackingController@index', 'as' => 'brochures_tracking']);

        /*START PAGES ROUTE*/
        Route::get('pages/{page}/editor', [\App\Http\Controllers\Admin\PagesController::class,'editor'])->name('pages_edit');
        Route::resource('pages', '\App\Http\Controllers\Admin\PagesController', ['names' => ['create' => 'pages_add', 'store' => 'pages_add', 'index' => 'pages', 'edit' => 'pages_edit', 'update' => 'pages_edit', 'destroy' => 'pages_delete']]);
        Route::post('pages_search', ['uses' => '\App\Http\Controllers\Admin\PagesController@search', 'as' => 'pages_view']);
        Route::post('pages/publish', ['uses' => '\App\Http\Controllers\Admin\PagesController@publish', 'as' => 'pages_publish']);

        /*END PAGES ROUTE*/

        Route::post('futurex_integration/sendCourse',[\App\Http\Controllers\Admin\FuturexIntegrationController::class,'sendCourse'])->name('futurex_integration');
        Route::match(['get','post'],'futurex_integration',[\App\Http\Controllers\Admin\FuturexIntegrationController::class,'index'])->name('futurex_integration');
        Route::get('futurex_integration/{course_id}/edit',[\App\Http\Controllers\Admin\FuturexIntegrationController::class,'edit'])->name('futurex_integration');
        Route::put('futurex_integration/{course_id}',[\App\Http\Controllers\Admin\FuturexIntegrationController::class,'update'])->name('futurex_integration');
    });


});

Route::get('survey_result','SurveyResultController@index');
Route::post('survey_result_parse','SurveyResultController@parse');
Route::post('survey_result_export','SurveyResultController@export');

Route::get('export', 'ExportController@index');
Route::post('export', 'ExportController@export');
Route::post('search/export', 'ExportController@search');
Route::get('exportCoursesPercentage', 'ExportController@exportCoursesPercentage');

Route::get('admin/get_sections/{id}', ['uses' => '\App\Http\Controllers\Admin\CoursesResourcesController@get_sections', 'as' => 'get_sections']);
Route::post('sendSurveyEmail', 'SurveyResultController@sendSurveyEmail');

Route::get('sendMbaTemplates', 'MbaTemplatesController@index');
Route::get('getFileFromE3melbusiness',function(){
    $data=\App\NewModulesUsersProjects::find(1152);
    $filePath=filePath();
    $file=$filePath.$data->correction;
    $file_info = new finfo(FILEINFO_MIME_TYPE);
    $content_type = $file_info->file($file);
    return \Response::make(file_get_contents($file), 200, [
        'Content-Type' => $content_type,
        'Content-Disposition' => 'attachment; ' . $data->correction,
    ]);
});

