
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    <style>
        .progress {
            position: relative;
            width: 100%;
            height: 30px !important;
            border: 1px solid #7F98B2;
            padding: 1px;
            border-radius: 3px;
        }

        .bar {
            background-color: #B4F5B4;
            width: 0%;
            height: 25px;
            border-radius: 3px;
        }

        .percent {
            position: absolute;
            display: inline-block;
            top: 3px;
            left: 48%;
            color: #7F98B2;
        }
    </style>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/website_banners') }}">{{ Lang::get('main.website_banners') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.website_banners') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.website_banners') }}</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/website_banners','id'=>'addwebsite_bannersForm','files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div id="messages"></div>
                    <div class="form-group col-lg-6">
                        <label class="control-label" for="title">{{ Lang::get('main.title') }}</label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{!! old('title') !!}" id="title" name="title" data-required="1" placeholder="{{ Lang::get('main.enter').Lang::get('main.title') }}">
                        </div>
                    </div>
                    <div class="form-group col-lg-6">
                        <label class="control-label" for="subtitle">{{ Lang::get('main.subtitle') }}</label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{!! old('subtitle') !!}" id="subtitle" name="subtitle" data-required="1" placeholder="{{ Lang::get('main.enter').Lang::get('main.subtitle') }}">
                        </div>
                    </div>
                    <div class="form-group col-lg-5">
                        <label class="control-label" for="btn_title">{{ Lang::get('main.btn_title') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{!! old('btn_title') !!}" id="btn_title" name="btn_title" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.btn_title') }}">
                        </div>
                    </div>
                    <div class="form-group col-lg-5">
                        <label class="control-label" for="name">{{ Lang::get('main.btn_link') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{!! old('btn_link') !!}" id="btn_link" name="btn_link" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.btn_link') }}">
                        </div>
                    </div>
                    <div class="form-group col-lg-2 text-center" style="margin-top:25px;">
                        <input type="checkbox" class="make-switch" name="published" value="yes" checked data-size="small"
                               data-on-color="success" data-on-text="{{ Lang::get('main.published') }}" data-off-color="default"
                               data-off-text="{{ Lang::get('main.unpublished') }}">
                    </div>

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="image">{{ Lang::get('main.image') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="file" class="form-control" value="" id="image" accept="image/*"
                                   name="image" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.image') }}">
                        </div>
                    </div>

                    @php
                        $size = [60, 61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85];
                        $colors = ['Medium Sea Green' => '#0EB759', 'Black' => '#000000', 'White' => '#ffffff','Marian Blue' => '#144394'];
                    @endphp
                    <div class="form-group col-lg-">
                        <label for="size">{{ Lang::get('main.size') }}</label>
                        <select name="size" class="module_name sel2 form-control form-filter" id="size">
                            <option value=" ">{{ Lang::get('main.select') }}{{ Lang::get('main.size') }}</option>
                            @foreach($size as $val)
                                <option @if(old('size')== $val) selected="selected" @endif value="{{ $val }}">
                                    {{ $val }} PX
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-lg-">
                        <label for="color">{{ Lang::get('main.color') }}</label>
                        <select name="color" class="module_name sel2 form-control form-filter" id="color">
                            <option value=" ">{{ Lang::get('main.select') }}{{ Lang::get('main.color') }}</option>
                            @foreach($colors as $name => $color)
                                <option @if(old('color')== $color) selected="selected" @endif value="{{ $color }}">
                                    {{ $name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-lg-">
                        <label for="show_on">{{ Lang::get('main.show_on') }}</label>
                        <select name="show_on" class="module_name sel2 form-control form-filter">
                            <option value=" ">{{ Lang::get('main.select') }}{{ Lang::get('main.show_on') }}</option>
                            <option @if(old('show_on')=='new') selected="selected" @endif value="new">new</option>
                            <option @if(old('show_on')=='subscription') selected="selected" @endif value="subscription">subscription</option>
                            <option @if(old('show_on')=='visitor') selected="selected" @endif value="visitor">visitor</option>
                            <option @if(old('show_on')=='expired') selected="selected" @endif value="expired">expired</option>
                        </select>
                    </div>


                    <div class="clearfix"></div>
                    <div class="text-center col-lg-12">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>


                <div class="clearfix"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
