@if(count($questions))
@if(request('type')=='show_order')
    <div class="dd" id="nestable">
        <ol class="dd-list">
            @foreach($questions as $question)
            <li class="dd-item" data-id="{{ $question->id }}">
                <div class="dd-handle">{{ $question->name }}</div>
            </li>
            @endforeach
        </ol>
    </div>
@else
<ol>
    @foreach($questions as $question)
        <li class="col-lg-12 question-object dd-list" id="question_{{ $question->id }}" data-id="{{ $question->id }}">
            <div class="form-group col-lg-10">
                <p class="question" id="question">{{ $question->name }}</p>
                <div class="clearfix"></div>
                @foreach($question->Options as $option)
                    <div>
                        <p>{{ $option->name }}</p>
                        <div class="clearfix"></div>
                        @foreach(\App\Models\Courses::whereIn('id',json_decode($option->courses_ids))->pluck('name','id') as $id=>$name)
                            <span class="label label-success">{{ $name }}</span>
                        @endforeach
                        @foreach(\App\Models\Diplomas::whereIn('id',json_decode($option->diplomas_ids))->pluck('name','id') as $id=>$name)
                            <span class="label label-success">{{ $name }}</span>
                        @endforeach
                        @foreach(\App\Models\TrainingProgram::whereIn('id',json_decode($option->training_programs_ids))->pluck('name','id') as $id=>$name)
                            <span class="label label-success">{{ $name }}</span>
                        @endforeach
                        @foreach(\App\Models\DBA::whereIn('id',json_decode($option->dba_ids))->pluck('name','id') as $id=>$name)
                            <span class="label label-success">{{ $name }}</span>
                        @endforeach
                        @if(json_decode($option->mba_ids))
                            <span class="label label-success">الماجستير المهني لإدارة الأعمال الاونلاين – MBA</span>
                       @endif

                        @if(json_decode($option->annual_subscribtion_ids))
                            <span class="label label-success">Annual Subscription</span>
                       @endif

                    </div>

                @endforeach
            </div>
            <div class="col-lg-2" style="padding: 0;">
                <button class="btn btn-success col-md-6 edit_question" data-type="true_false" style="border-radius: 8px 0 0 8px !important;"><i class="glyphicon glyphicon-edit"></i></button>
                <button class="btn btn-danger col-md-6 remove_question" style="border-radius: 0 8px 8px 0 !important;"><i class="glyphicon glyphicon-trash"></i></button>
            </div>
        </li>
    @endforeach
</ol>
@endif

@else
    <div class="alert alert-info">No questions added</div>
@endif
