
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.courses_views') }}</span>
            </li>
        </ul>

    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.courses_views') }}
        <small>{{ Lang::get('main.view') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
    <style>
        td {
            word-wrap: break-word;
            overflow-wrap: break-word;
        }
    </style>
    @if(PerUser('courses_quility_views'))
        <div class="row">
            <div class="col-md-12">

                <div class="btn-group pull-right">
                    <form action="{{ URL('admin/courses_view_export') }}" method="GET" id="formExport">
                        <input type="hidden" name="type" value="export">
                        <button class="btn btn-success" type="submit">{{ Lang::get('main.export') }}</button>
                    </form>
                </div>
            </div>
        </div>
    @endif
    @if(PerUser('courses_quility_views'))
        <div class="row">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-users font-dark"></i>
                        <span class="caption-subject bold uppercase">{{ Lang::get('main.courses_views') }}</span>
                    </div>
                    <div class="tools"></div>
                </div>
                <div class="portlet-body">
                    <div class="form-group col-lg-4">
                        <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                            <input type="text" class="form-control form-filter input-sm" id="time_from"
                                   name="created_time_from" placeholder="{{ Lang::get('main.from') }}">
                            <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                        </div>
                        <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                            <input type="text" class="form-control form-filter input-sm" id="time_to"
                                   name="created_time_to" placeholder="{{ Lang::get('main.to') }}">
                            <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                        </div>
                    </div>

                    <table style=" table-layout: fixed;width: 100%;" class="table table-striped table-bordered table-hover table-checkable" width="100%"
                           id="datatable_ajax">
                        <thead>
                        <tr role="row" class="heading">
                            <th>{{ Lang::get('main.course') }}</th>
                            <th>{{ Lang::get('main.instructor') }}</th>
                            <th>{{ Lang::get('main.count') }}</th>
                            {{--<th>{{ Lang::get('main.published') }}--}}
                            <th></th>
                        </tr>
                        <tr role="row" class="filter">
                            <td>
                                <input type="hidden" id="_token" name="_token" value="{{ csrf_token() }}">
                                <input type="hidden" id="created_time_from" class="form-filter" name="created_time_from" value="">
                                <input type="hidden" id="created_time_to" class="form-filter" name="created_time_to" value="">
                                <select name="course" class="module_name sel2 form-control form-filter">
                                    <option value=" ">{{ Lang::get('main.select') }}{{ Lang::get('main.course') }}</option>
                                    @foreach($courses as $id=>$name)
                                        <option value="{{$id}}">{{$name}}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <select name="instractor" class="module_name sel2 form-control form-filter">
                                    <option value=" ">{{ Lang::get('main.select') }}{{ Lang::get('main.instructor') }}</option>
                                    @foreach($instructors as $id=>$name)
                                        <option value="{{$id}}">{{$name}}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="count">
                            </td>
                            {{--<td></td>--}}
                            <td>
                                <div class="margin-bottom-5">
                                    <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                        <i class="fa fa-search"></i> {{ Lang::get('main.search') }}</button>
                                </div>
                                <button class="btn btn-sm red btn-outline filter-cancel">
                                    <i class="fa fa-times"></i> {{ Lang::get('main.reset') }}</button>
                            </td>

                        </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        </div>
    @endif
@endsection
@section('scriptCode')

    <script>
        $(document).ready(function () {
            $('.form-filter').each(function(){
                $("#formExport").append('<input type="hidden" name="'+$(this).attr('name')+'">');
            })
            $(document).on('click','.filter-submit',function(){
                $('.form-filter').each(function(){
                    $("#formExport input[name='"+$(this).attr('name')+"']").val($(this).val());
                })
            });

            $('.menu-toggler').click();
            var token = "{{ csrf_token() }}";
            {{--@if(PerUser('courses_views_publish'))--}}
            {{--$(document).on('change', '.changeStatues', function () {--}}
            {{--var statues = $(this).is(':checked');--}}
            {{--var id = $(this).attr('data-id');--}}
            {{--if (statues) {--}}
            {{--$.ajax({--}}
            {{--type: "POST",--}}
            {{--url: "{{ URL('admin/courses_views/publish') }}",--}}
            {{--data: {"published": "yes", "id": id, _token: token},--}}
            {{--success: function (msg) {--}}
            {{--$("#errors").html(msg);--}}
            {{--}--}}
            {{--});--}}
            {{--} else {--}}
            {{--$.ajax({--}}
            {{--type: "POST",--}}
            {{--url: "{{ URL('admin/courses_views/publish') }}",--}}
            {{--data: {"published": "no", "id": id, _token: token},--}}
            {{--success: function (msg) {--}}
            {{--$("#errors").html(msg);--}}
            {{--}--}}
            {{--});--}}
            {{--}--}}
            {{--});--}}
            {{--@endif--}}

            $('.fromToDate').datepicker({
                rtl: App.isRTL(),
                autoclose: true
            });

            $(document).on('change', '#time_from', function () {
                $("#created_time_from").val($(this).val());
            });
            $(document).on('change', '#time_to', function () {
                $("#created_time_to").val($(this).val());
            });

            var grid = new Datatable();
            grid.setAjaxParam("_token", "{{ csrf_token() }}");
            $(document).on('change','[name="created_time_from"],[name="created_time_to"]',function(){
                grid.setAjaxParam("created_time_from", $('[name="created_time_from"]').val());
                grid.setAjaxParam("created_time_to", $('[name="created_time_to"]').val());
            });
            // console.log(grid._token)
            grid.init({
                src: $("#datatable_ajax"),
                onSuccess: function (grid, response) {
                    // grid:        grid object
                    // response:    json object of server side ajax response
                    // execute some code after table records loaded
                },
                onError: function (grid) {
                    // execute some code on network or other general error
                },
                onDataLoad: function (grid) {
                },
                loadingMessage: '{{ Lang::get('main.loading') }}',
                dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options
                    // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                    // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                    // So when dropdowns used the scrollable div should be removed.
                    //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                    "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                    "lengthMenu": [
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) -1 @endif],
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) "All" @endif] // change per page values here
                    ],
                    "pageLength": 10, // default record count per page
                    "ajax": {
                        "url": "{{ URL('admin/courses_quility_views') }}", // ajax source

                    },
                    @if(getUserSystem('backend_lang')=='ar') "language": {"url": "{{ asset('assets/layouts/layout/datatables-arabic.json') }}"},@endif "columnDefs": [{
                        "targets": [0], // column or columns numbers
                        "orderable": true  // set orderable for selected columns

                    }],
                    "order": [
                        [0, "desc"]
                    ],// set first column as a default sort by asc
                    dom: 'Blfrtip',
                    buttons: [
                        {extend: 'print', className: 'btn dark btn-outline'},
                        {extend: 'pdf', className: 'btn green btn-outline'},
                        {extend: 'csv', className: 'btn purple btn-outline '}
                    ],
                }
            });
        });
    </script>
@endsection
