
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.new_mba_courses_user_plan') }}</span>
            </li>
        </ul>
        <!--<div class="page-toolbar">
            <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body" data-placement="bottom" data-original-title="Change dashboard date range">
                <i class="icon-calendar"></i>&nbsp;
                <span class="thin uppercase hidden-xs"></span>&nbsp;
                <i class="fa fa-angle-down"></i>
            </div>
        </div>-->
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.new_mba_courses_user_plan') }}
        <small>{{ Lang::get('main.view') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')


        <div class="row">
            <div class="col-md-12">
                @if(PerUser('new_mba_courses_user_plan_add'))
                <div class="btn-group pull-right">
                    <a href="{{ URL('admin/new_mba_courses_user_plan/create') }}" id="sample_editable_1_new" class="btn green">
                        {{ Lang::get('main.add_new') }}
                        <i class="fa fa-plus"></i>
                    </a>
                </div>
                @endif
                    @if(PerUser('new_mba_courses_user_plan_delete'))
                        <div class="btn-group pull-right">
                            <button id="remove" class="btn btn-danger" disabled>
                                {{ Lang::get('main.delete') }}
                                <span class="number"></span>
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                    @endif
            </div>
        </div>

    @if(PerUser('new_mba_courses_user_plan_view'))
        <div class="row">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-users font-dark"></i>
                        <span class="caption-subject bold uppercase">{{ Lang::get('main.new_mba_courses_user_plan') }}</span>
                    </div>
                    <div class="tools"></div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover dt-responsive" width="100%"
                           id="datatable_ajax">
                        <thead>
                        <tr role="row" class="heading">
                            <th width="8%">
                                <label class="mt-checkbox mt-checkbox-outline">
                                    <input type="checkbox" class="checkAll">
                                    <span></span>
                                </label>
                            </th>
                            <th width="8%"> #</th>
                            <th width="20%">{{ Lang::get('main.name') }}</th>
                            <th width="20%">{{ Lang::get('main.module_name') }}</th>
                            <th width="10%">{{ Lang::get('main.pic') }}</th>
                            <th width="10%">{{ Lang::get('main.related_course') }}</th>
                            <th width="10%">{{ Lang::get('main.sort') }}</th>
                            <th width="10%">{{ Lang::get('main.user') }}</th>
                            <th width="10%">{{ Lang::get('main.created_time') }}</th>
                            <th width="10%">{{ Lang::get('main.published') }}</th>
                            <th width="10%">{{ Lang::get('main.part') }}</th>
                            <th width="8%"></th>
                        </tr>
                        <tr role="row" class="filter">
                            <td></td>
                            <td>
                                <input type="number" min="1" class="form-control form-filter input-sm" name="id">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="name">
                                <input type="hidden" id="_token" name="_token" value="{{ csrf_token() }}">
                            </td>
                            <td>
                                <select name="module_name" class="module_name sel2 form-control form-filter" id="module_name">
                                    <option value=" ">{{ Lang::get('main.select') }} {{ Lang::get('main.module') }}</option>
                                    @foreach($modules as $module)
                                        <option value="{{$module->name}}">{{$module->name}}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>

                            </td>
                            <td>
                                <select name="related_course" class="module_name sel2 form-control form-filter" id="related_course">
                                    <option value=" ">{{ Lang::get('main.select') }} {{ Lang::get('main.course') }}</option>
                                    @foreach($courses as $course)
                                        <option value="{{$course->name}}">{{$course->name}}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td></td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="user">
                            </td>
                            <td>
                                <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                    <input type="text" class="form-control form-filter input-sm" readonly
                                           name="created_time_from" placeholder="{{ Lang::get('main.from') }}">
                                    <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                </div>
                                <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                    <input type="text" class="form-control form-filter input-sm" readonly
                                           name="created_time_to" placeholder="{{ Lang::get('main.to') }}">
                                    <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                </div>
                            </td>
                            <td>

                            </td>
                            <td>
                                <select name="part" class="module_name sel2 form-control form-filter" id="part">
                                    <option value=" ">{{ Lang::get('main.select') }} {{ Lang::get('main.part') }}</option>
                                    <option value="Part One" >Part One</option>
                                    <option value="Part Two" >Part Two</option>
                                </select>
                            </td>
                            <td>
                                <div class="margin-bottom-5">
                                    <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                        <i class="fa fa-search"></i> {{ Lang::get('main.search') }}</button>
                                </div>
                                <button class="btn btn-sm red btn-outline filter-cancel">
                                    <i class="fa fa-times"></i> {{ Lang::get('main.reset') }}</button>
                            </td>

                        </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- Modal -->
        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
             aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{ Lang::get('main.confirmation') }}!!</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        {{ Lang::get('main.are_you_sure_you_want_to_delete') }}
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal">{{ Lang::get('main.cancel') }}</button>
                        <button type="button" class="btn btn-primary confirm_deletion"
                                data-dismiss="modal">{{ LAng::get('main.delete') }}</button>
                    </div>
                </div>
            </div>
        </div>
        <!-- image modal -->
        <div id="image-modal" class="modal fade modal-scroll" tabindex="-1" data-replace="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    </div>

                    <div class="modal-body">
                        <img width="100%"/>
                        <div class="modal-footer">
                            <button type="button" data-dismiss="modal" class="btn dark btn-outline">{{ Lang::get('main.close') }}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        </div>
    @endif
@endsection
@section('scriptCode')

    <script>
        $(document).ready(function () {
            function getSelectedNumber(){
                let length=$(".selectedID:checked").length;
                let removeEl=$("#remove");
                if(length){
                    removeEl.removeAttr('disabled');
                    removeEl.find('.number').html(length);
                }else{
                    removeEl.attr('disabled','disabled');
                    removeEl.find('.number').html('');
                }
            }
            $(document).on('change','.selectedID',function(){
                getSelectedNumber();
            });
            $(document).on('change','.checkAll',function(){
                let isChecked=$(this).is(':checked');
                console.log('isChecked',isChecked)
                $(".selectedID").each(function(){
                    $(this).prop('checked',isChecked);
                });
                getSelectedNumber()
            });
            $(".menu-toggler.sidebar-toggler").trigger('click');
            $('.module_name').select2();
            var token = "{{ csrf_token() }}";
            @if(PerUser('new_mba_courses_user_plan_active'))
            $(document).on('change', '.changeStatues', function () {
                var statues = $(this).is(':checked');
                var id = $(this).attr('data-id');
                if (statues) {
                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/new_mba_courses_user_plan/activation') }}",
                        data: {"active": "yes", "id": id, _token: token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                } else {
                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/new_mba_courses_user_plan/activation') }}",
                        data: {"active": "no", "id": id, _token: token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }
            });
            @endif
            $('.fromToDate').datepicker({
                rtl: App.isRTL(),
                autoclose: true
            });
            var grid = new Datatable();
            grid.setAjaxParam("_token", "{{ csrf_token() }}");
            // console.log(grid._token)
            grid.init({
                src: $("#datatable_ajax"),
                onSuccess: function (grid, response) {
                    getSelectedNumber()
                    // grid:        grid object
                    // response:    json object of server side ajax response
                    // execute some code after table records loaded
                },
                onError: function (grid) {
                    // execute some code on network or other general error
                },
                onDataLoad: function (grid) {
                    getSelectedNumber()
                    {{--var $edit_drug = $('.editable-drug');--}}
                    {{--var $edit_drug_status_id = $edit_drug.attr("id");--}}
                    {{--$.fn.editable.defaults.mode = 'popup';--}}
                    {{--$.fn.editable.defaults.ajaxOptions = {type: "PUT"};--}}
                    {{--$edit_drug.editable({--}}
                        {{--source: [--}}
                            {{--{--}}
                                {{--'approved': 'Approved'--}}
                            {{--},--}}
                            {{--{--}}
                                {{--'pending': 'Pending'--}}
                            {{--}--}}
                        {{--],--}}
                        {{--url: "{{ URL('admin/mba_courses_user_plan') }}/" + $edit_drug_status_id + '/editsuccessstoriestatus',--}}
                        {{--params: function (params) {--}}
                            {{--//originally params contain pk, name and value--}}
                            {{--params._token = token;--}}
                            {{--return params;--}}
                        {{--}--}}
                    {{--});--}}
                },
                loadingMessage: '{{ Lang::get('main.loading') }}',
                dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options
                    // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                    // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                    // So when dropdowns used the scrollable div should be removed.
                    //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                    "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                    "lengthMenu": [
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) -1 @endif],
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) "All" @endif] // change per page values here
                    ],
                    "pageLength": 10, // default record count per page
                    "ajax": {
                        "url": "{{ URL('admin/new_mba_courses_user_plan_search') }}", // ajax source
                    },
                    @if(getUserSystem('backend_lang')=='ar') "language": {"url": "{{ asset('assets/layouts/layout/datatables-arabic.json') }}"},@endif
                    "columnDefs": [{
                        "targets": 0, // column or columns numbers
                        "orderable": false  // set orderable for selected columns

                    }],
                    "order": [
                        [1, "desc"]
                    ],// set first column as a default sort by asc
                    dom: 'Blfrtip',
                    buttons: [
                        {extend: 'print', className: 'btn dark btn-outline'},
                        {extend: 'pdf', className: 'btn green btn-outline'},
                        {extend: 'csv', className: 'btn purple btn-outline '}
                    ],
                }
            });
            var drug_id = null;
            $(document).on('click', '.deleteResource', function (event) {
                event.preventDefault();
                drug_id = $(this).attr("data-location");
                console.log(drug_id);

            });

            $(document).on('click', '.confirm_deletion', function (event) {
                event.preventDefault();
                console.log(grid);

                console.log(drug_id);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax(
                    {
                        url: "{{ URL('admin/new_mba_courses_user_plan') }}/" + drug_id,
                        method: "delete", // replaced from put
                        dataType: "JSON",
                        data: {
                            "id": drug_id // method and token not needed in data
                        },
                        success: function (response) {
                            console.log(response); // see the reponse sent
                            console.log('deleted'); // see the reponse sent
                            $('.filter-submit').trigger('click');
                            // window.location.href = "/admin/courses";


                        },
                        error: function (xhr) {
                            console.log(xhr.responseText); // this line will save you tons of hours while debugging
                            // do something here because of error
                        }
                    });

            });
            @if(PerUser('new_mba_courses_user_plan_delete'))
                $(document).on('click','#remove',function(){
                    let IDS=[];
                $(".selectedID:checked").each(function(){
                    IDS.push($(this).val())
                });
                if(IDS.length){
                    BootstrapDialog.show({
                        title: '{{ Lang::get('main.delete').lang::get('main.new_mba_courses_user_plan') }}',
                        message: '{{ Lang::get('main.delete_this').lang::get('main.new_mba_courses_user_plan') }} ?',
                        buttons: [
                            {
                                label: '{{ Lang::get('main.yes') }}',
                                cssClass: 'btn-primary',
                                action: function (dialogItself) {
                                    $.ajax({
                                        type: "DELETE",
                                        url: "{{ URL('admin/new_mba_courses_user_plan/delete_milty') }}",
                                        data: {"id": IDS, _token: token},
                                        success: function (msg) {
                                            grid.getDataTable().ajax.reload()
                                            dialogItself.close();

                                        }
                                    });
                                }
                            },
                            {
                                label: '{{ Lang::get('main.no') }}',
                                action: function (dialogItself) {
                                    dialogItself.close();
                                }
                            }]
                    });
                }
            })
            $(document).on('click', '.delete_this', function (event) {

                var deleted_id = $(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.new_mba_courses_user_plan') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.new_mba_courses_user_plan') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function (dialogItself) {
                                $.ajax({
                                    type: "DELETE",
                                    url: "{{ URL('admin/new_mba_courses_user_plan') }}/" + deleted_id,
                                    data: {"id": deleted_id, _token: token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $("#single-order-" + deleted_id).parent().parent().remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function (dialogItself) {
                                dialogItself.close();
                            }
                        }]
                });
            });
            @endif
            $(document).on("click", ".image-link", function () {
                $("#image-modal .modal-body img").attr('src', $(this).find('img').attr('src') );
            });
        });
    </script>
@endsection
