
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.marketers') }}</span>
            </li>
        </ul>

        <div class="page-toolbar">
            <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body" data-placement="bottom" data-original-title="Change dashboard date range">
                <i class="icon-calendar"></i>&nbsp;
                <span class="thin uppercase hidden-xs"></span>&nbsp;
                <i class="fa fa-angle-down"></i>
                <input type="hidden" id="startDate"/>
                <input type="hidden" id="endDate"/>
            </div>
            <div class="clearfix"></div>
            <select name="marketer_ids[]" multiple style="width: 100%" class="sel2" id="marketer_ids">
                @foreach(\App\Models\Marketers::pluck('name','id')->toArray() as $id=>$name)
                    <option @if(request('marketer_id')==$id) selected="selected" @endif value="{{ $id }}">{{ $name }}</option>
                @endforeach
            </select>
        </div>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.marketers') }}
        <small>{{ Lang::get('main.marketers_report') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.marketers_report') }}</span>
                </div>
                <div class="tools">

                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover dt-responsive" width="100%"
                       id="datatable_ajax">
                    <thead>
                    <tr role="row" class="heading">
                        <th width="8%"> #</th>
                        <th width="20%">{{ Lang::get('main.name') }}</th>
                        <th width="20%">first name</th>
                        <th width="20%">last name</th>
                        <th width="20%">amount</th>
                        <th width="20%">charge name</th>
                        <th width="20%">created at</th>
                    </tr>
                    <tr role="row" class="filter">
                        <td>
                            <input type="number" min="1" class="form-control form-filter input-sm" name="id">
                        </td>
                        <td>
                            <input type="text" class="form-control form-filter input-sm" name="name">
                            <input type="hidden" id="_token" name="_token" value="{{ csrf_token() }}">
                        </td>
                        <td>
                        </td>
                        <td>
                        </td>
                        <td>
                        </td>
                        <td>
                        </td>
                        <td>
                            <div class="margin-bottom-5">
                                <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                    <i class="fa fa-search"></i> {{ Lang::get('main.search') }}</button>
                            </div>
                            <button class="btn btn-sm red btn-outline filter-cancel">
                                <i class="fa fa-times"></i> {{ Lang::get('main.reset') }}</button>
                        </td>

                    </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')

    <script>
        $(document).ready(function () {
            $('#dashboard-report-range').daterangepicker({
                "ranges": {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract('days', 1), moment().subtract('days', 1)],
                    'Last 7 Days': [moment().subtract('days', 6), moment()],
                    'Last 30 Days': [moment().subtract('days', 29), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract('month', 1).startOf('month'), moment().subtract('month', 1).endOf('month')]
                },
                "locale": {
                    "format": "MM/DD/YYYY",
                    "separator": " - ",
                    "applyLabel": "Apply",
                    "cancelLabel": "Cancel",
                    "fromLabel": "From",
                    "toLabel": "To",
                    "customRangeLabel": "Custom",
                    "daysOfWeek": [
                        "Su",
                        "Mo",
                        "Tu",
                        "We",
                        "Th",
                        "Fr",
                        "Sa"
                    ],
                    "monthNames": [
                        "January",
                        "February",
                        "March",
                        "April",
                        "May",
                        "June",
                        "July",
                        "August",
                        "September",
                        "October",
                        "November",
                        "December"
                    ],
                    "firstDay": 1
                },
                //"startDate": "11/08/2015",
                //"endDate": "11/14/2015",
                opens: (App.isRTL() ? 'right' : 'left'),
            }, function(start, end, label) {
                if ($('#dashboard-report-range').attr('data-display-range') != '0') {
                    $('#dashboard-report-range span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                    $("#startDate").val(start.format('YYYY-MM-DD'))
                    $("#endDate").val(end.format('YYYY-MM-DD'))
                    grid.setAjaxParam("start_date", $("#startDate").val());
                    grid.setAjaxParam("end_date", $("#endDate").val());
                    grid.setAjaxParam("marketer_ids[]",  $("#marketer_ids").val());
                    grid.getDataTable().ajax.reload();
                }
            });
            $(document).on('change','#marketer_ids',function(){
                grid.setAjaxParam("start_date", $("#startDate").val());
                grid.setAjaxParam("end_date", $("#endDate").val());
                grid.setAjaxParam("marketer_ids[]",  $("#marketer_ids").val());
                grid.getDataTable().ajax.reload();
            });
            if ($('#dashboard-report-range').attr('data-display-range') != '0') {
                @if(request('start_date')&&request('end_date'))
                $('#dashboard-report-range span').html(moment('{{ request('start_date') }}').format('MMMM D, YYYY') + ' - ' + moment('{{ request('end_date') }}').format('MMMM D, YYYY'));
                $("#startDate").val(moment('{{ request('start_date') }}').format('YYYY-MM-DD'))
                $("#endDate").val(moment('{{ request('end_date') }}').format('YYYY-MM-DD'))
                    @else
                $('#dashboard-report-range span').html(moment().subtract('days', 29).format('MMMM D, YYYY') + ' - ' + moment().format('MMMM D, YYYY'));
                $("#startDate").val(moment().subtract('days', 29).format('YYYY-MM-DD'))
                $("#endDate").val(moment().format('YYYY-MM-DD'))
                @endif

            }
            $('#dashboard-report-range').show();
            $('.module_name').select2();
            $(".menu-toggler.sidebar-toggler").trigger('click');
            var token = "{{ csrf_token() }}";

            $('.fromToDate').datepicker({
                rtl: App.isRTL(),
                autoclose: true
            });
            var grid = new Datatable();
            grid.setAjaxParam("_token", "{{ csrf_token() }}");
            grid.setAjaxParam("start_date", $("#startDate").val());
            grid.setAjaxParam("end_date", $("#endDate").val())
            grid.setAjaxParam("marketer_ids[]",  $("#marketer_ids").val());
            // console.log(grid._token)
            grid.init({
                src: $("#datatable_ajax"),
                onSuccess: function (grid, response) {
                    // grid:        grid object
                    // response:    json object of server side ajax response
                    // execute some code after table records loaded
                },
                onError: function (grid) {
                    // execute some code on network or other general error
                },
                onDataLoad: function (grid) {
                    {{--var $edit_drug = $('.editable-drug');--}}
                    {{--var $edit_drug_status_id = $edit_drug.attr("id");--}}
                    {{--$.fn.editable.defaults.mode = 'popup';--}}
                    {{--$.fn.editable.defaults.ajaxOptions = {type: "PUT"};--}}
                    {{--$edit_drug.editable({--}}
                    {{--source: [--}}
                    {{--{--}}
                    {{--'approved': 'Approved'--}}
                    {{--},--}}
                    {{--{--}}
                    {{--'pending': 'Pending'--}}
                    {{--}--}}
                    {{--],--}}
                    {{--url: "{{ URL('admin/marketers') }}/" + $edit_drug_status_id + '/editsuccessstoriestatus',--}}
                    {{--params: function (params) {--}}
                    {{--//originally params contain pk, name and value--}}
                    {{--params._token = token;--}}
                    {{--return params;--}}
                    {{--}--}}
                    {{--});--}}
                },
                loadingMessage: '{{ Lang::get('main.loading') }}',
                dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options
                    // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                    // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                    // So when dropdowns used the scrollable div should be removed.
                    //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                    "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                    "lengthMenu": [
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) -1 @endif],
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) "All" @endif] // change per page values here
                    ],
                    @if(getUserSystem('backend_lang')=='ar')
                    "language": {
                        "url": "{{ asset('assets/layouts/layout/datatables-arabic.json') }}"
                    },
                    @endif
                    "pageLength": 10, // default record count per page
                    "ajax": {
                        "url": "{{ URL('admin/marketers/report_details') }}", // ajax source
                    },
                    @if(getUserSystem('backend_lang')=='ar') "language": {"url": "{{ asset('assets/layouts/layout/datatables-arabic.json') }}"},@endif "columnDefs": [{
                        "targets": [0], // column or columns numbers
                        "orderable": true  // set orderable for selected columns

                    }],
                    "order": [
                        [0, "desc"]
                    ],// set first column as a default sort by asc
                    dom: 'Blfrtip',
                    buttons: [
                        {extend: 'print', className: 'btn dark btn-outline'},
                        {extend: 'pdf', className: 'btn green btn-outline'},
                        {extend: 'csv', className: 'btn purple btn-outline '}
                    ],
                }
            });
            var drug_id = null;
            $(document).on('click', '.deleteResource', function (event) {
                event.preventDefault();
                drug_id = $(this).attr("data-location");
                console.log(drug_id);

            });

            $(document).on('click', '.confirm_deletion', function (event) {
                event.preventDefault();
                console.log(grid);

                console.log(drug_id);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax(
                    {
                        url: "{{ URL('admin/marketers') }}/" + drug_id,
                        method: "delete", // replaced from put
                        dataType: "JSON",
                        data: {
                            "id": drug_id // method and token not needed in data
                        },
                        success: function (response) {
                            console.log(response); // see the reponse sent
                            console.log('deleted'); // see the reponse sent
                            $('.filter-submit').trigger('click');
                            // window.location.href = "/admin/courses";


                        },
                        error: function (xhr) {
                            console.log(xhr.responseText); // this line will save you tons of hours while debugging
                            // do something here because of error
                        }
                    });

            });
            @if(PerUser('marketers_delete'))
            $(document).on('click', '.delete_this', function (event) {

                var deleted_id = $(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.new') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.new') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function (dialogItself) {
                                $.ajax({
                                    type: "DELETE",
                                    url: "{{ URL('admin/marketers') }}/" + deleted_id,
                                    data: {"id": deleted_id, _token: token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $("#single-order-" + deleted_id).parent().parent().remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function (dialogItself) {
                                dialogItself.close();
                            }
                        }]
                });
            });
            @endif
            $(document).on("click", ".image-link", function () {
                $("#image-modal .modal-body img").attr('src', $(this).find('img').attr('src') );
            });

        });
    </script>
@endsection
