
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.futurex_integration_courses') }}</span>
            </li>
        </ul>

    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.futurex_integration_courses') }}
        <small>{{ Lang::get('main.view') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
<style>
    td {
        word-wrap: break-word;
        overflow-wrap: break-word;
    }
</style>

<div class="row">
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-users font-dark"></i>
                <span class="caption-subject bold uppercase">{{ Lang::get('main.futurex_integration_courses') }}</span>
            </div>
            <div class="tools"></div>
        </div>
        <div class="portlet-body">

            {!! Form::open(['method'=>'PUT','url'=>'admin/futurex_integration/'.$course->id]) !!}
            <div class="form-group col-lg-12">
                <label class="control-label" for="name">{{ Lang::get('main.name') }}</label>
                <input type="text" disabled class="form-control" value="{{$course->name}}" name="name" data-required="1"  placeholder="{{ Lang::get('main.enter').Lang::get('main.name') }}">
            </div>

            <div class="form-group col-lg-4">
                <label for="futurex_course_category_id">{{ Lang::get('main.futurex_course_category') }}</label>
                <select id="futurex_course_category_id" name="futurex_course_category_id" style="width: 100%" class="sel2">
                    @foreach(DB::connection('mysql2')->table('futurex_course_category')->pluck('name','id')->toArray() as $id=>$name)
                    <option value="{{ $id }}" @if($futurexCourse&&$futurexCourse->futurex_course_category_id == $id) selected @endif>
                        {{ $name }}
                    </option>
                    @endforeach
                </select>
            </div>
            <div class="form-group col-lg-4">
                <label for="futurex_course_level_id">{{ Lang::get('main.futurex_course_level') }}</label>
                <select id="futurex_course_level_id" name="futurex_course_level_id" style="width: 100%" class="sel2">
                    @foreach(DB::connection('mysql2')->table('futurex_course_level')->pluck('name','id')->toArray() as $id=>$name)
                        <option value="{{ $id }}" @if($futurexCourse&&$futurexCourse->futurex_course_level_id == $id) selected @endif>
                            {{ $name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="form-group col-lg-4">
                <label for="futurex_language_id">{{ Lang::get('main.futurex_language') }}</label>
                <select id="futurex_language_id" name="futurex_language_id" style="width: 100%" class="sel2">
                    @foreach(DB::connection('mysql2')->table('futurex_language')->pluck('name','id')->toArray() as $id=>$name)
                        <option value="{{ $id }}" @if($futurexCourse&&$futurexCourse->futurex_language_id == $id) selected @endif>
                            {{ $name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="form-group col-lg-12">
                <label for="futurex_skills_ids">{{ Lang::get('main.futurex_skills') }}</label>
                <select id="futurex_skills_ids" multiple name="futurex_skills_ids[]" style="width: 100%" class="sel2">
                    @foreach(DB::connection('mysql2')->table('futurex_skills')->pluck('name','id')->toArray() as $id=>$name)
                        <option value="{{ $id }}" @if($futurexCourse&&is_array($futurexCourse->futurex_skills_ids)&&in_array($id,$futurexCourse->futurex_skills_ids)) selected @endif>
                            {{ $name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="form-group col-lg-12">
                <label for="futurex_tags_ids">{{ Lang::get('main.futurex_tags') }}</label>
                <select id="futurex_tags_ids" multiple name="futurex_tags_ids[]" style="width: 100%" class="">
                    @if($futurexCourse&&$futurexCourse->futurex_tags_ids)
                        @foreach(DB::connection('mysql2')->table('futurex_tags')->whereIn('id',$futurexCourse->futurex_tags_ids)->pluck('name','id')->toArray() as $id=>$name)
                            <option value="{{ $id }}" @if($futurexCourse&&is_array($futurexCourse->futurex_tags_ids)&&in_array($id,$futurexCourse->futurex_tags_ids)) selected @endif>
                                {{ $name }}
                            </option>
                        @endforeach
                    @endif
                </select>
            </div>


            <div class="clearfix"></div>
            <div class="text-center col-lg-12">
                <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
            </div>
            <div class="clearfix"></div>
            {!! Form::close() !!}

        </div>
    </div>
</div>
@endsection
@section('scriptCode')

    <script>
        $(document).ready(function () {
            var token = "{{ csrf_token() }}";
            $('#futurex_tags_ids').select2({
                ajax: {
                    url: '{{ request()->fullUrl() }}',
                    dataType: 'json'
                    // Additional AJAX parameters go here; see the end of this chapter for the full code of this example
                }
            })
            $(".menu-toggler.sidebar-toggler").trigger('click');
            $('.fromToDate').datepicker({
                rtl: App.isRTL(),
                autoclose: true
            });
            var grid = new Datatable();
            grid.setAjaxParam("_token", "{{ csrf_token() }}");
            // console.log(grid._token)
            grid.init({
                src: $("#datatable_ajax"),
                onSuccess: function (grid, response) {
                    // grid:        grid object
                    // response:    json object of server side ajax response
                    // execute some code after table records loaded
                },
                onError: function (grid) {
                    // execute some code on network or other general error
                },
                onDataLoad: function (grid) {
                },
                loadingMessage: '{{ Lang::get('main.loading') }}',
                dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options
                    // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                    // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                    // So when dropdowns used the scrollable div should be removed.
                    //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                    "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                    "lengthMenu": [
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) -1 @endif],
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) "All" @endif] // change per page values here
                    ],
                    "pageLength": 10, // default record count per page
                    "ajax": {
                        "url": "{{ URL('admin/futurex_integration') }}", // ajax source
                    },
                    @if(getUserSystem('backend_lang')=='ar') "language": {"url": "{{ asset('assets/layouts/layout/datatables-arabic.json') }}"},@endif "columnDefs": [{
                        "targets": [0], // column or columns numbers
                        "orderable": true  // set orderable for selected columns

                    }],
                    "order": [
                        [0, "desc"]
                    ],// set first column as a default sort by asc
                    dom: 'Blfrtip',
                    buttons: [
                        {extend: 'print', className: 'btn dark btn-outline'},
                        {extend: 'pdf', className: 'btn green btn-outline'},
                        {extend: 'csv', className: 'btn purple btn-outline '}
                    ],
                }
            });

        });
    </script>
@endsection
