
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/diploma_courses') }}">{{ Lang::get('main.diploma_courses') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.diploma_courses') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.diploma_courses') }}</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/diploma_courses','class'=>"form-horizontal",'files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div id="messages"></div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="name">{{ Lang::get('main.name') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{!! old('name') !!}" id="name" name="name" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.name') }}">
                        </div>
                    </div>

                    {{--<div class="form-group col-lg-3 text-center" style="margin-top:25px;">--}}
                        {{--<input type="checkbox" class="make-switch" name="published" value="yes" checked data-size="small"--}}
                               {{--data-on-color="success" data-on-text="{{ Lang::get('main.published') }}" data-off-color="default"--}}
                               {{--data-off-text="{{ Lang::get('main.unpublished') }}">--}}
                    {{--</div>--}}

                    @include('auth/description')

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="image">{{ Lang::get('main.image') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="file" class="form-control" value="" id="image" accept="image/*"
                                   name="image" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.image') }}">
                        </div>
                    </div>

                    <div class="form-group col-lg-12">
                        <label for="diploma">{{ Lang::get('main.diploma') }}<span
                                    class="required"> * </span></label>
                        <select name="diploma" class="module_name sel2 form-control form-filter">
                            <option value=" ">{{ Lang::get('main.select') }}{{ Lang::get('main.diploma') }}</option>
                            @foreach($diplomas as $id=>$name)
                                <option @if(old('diploma')==$id) selected="selected" @endif value="{{$id}}">{{$name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-lg-12">
                        <label for="type">{{ Lang::get('main.type') }}<span
                                    class="required"> * </span></label>
                        <select name="type" id="type" class="module_name sel2 form-control form-filter">
                            <option @if(old('type')=='normal') selected="selected" @endif value="normal">{{ Lang::get('main.normal') }}</option>
                            <option @if(old('type')=='according_to_country') selected="selected" @endif value="according_to_country">{{ Lang::get('main.according_to_country') }}</option>
                        </select>
                    </div>

                    <div class="form-group col-lg-12">
                        <label for="related_course">{{ Lang::get('main.related_course') }}<span
                                    class="required"> * </span></label>
                        <select name="related_course" class="sel2 form-control form-filter">
                            <option value=" ">{{ Lang::get('main.select') }}{{ Lang::get('main.related_course') }}</option>
                            @foreach($courses as $course)
                                <option @if(old('related_course')==$course->id) selected="selected" @endif value="{{$course->id}}">{{$course->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-lg-12 text-center hidden" id="related_course_ksa_check" style="margin-top:25px;">
                        <input type="checkbox"  id="ksa_course" class="make-switch" name="ksa_course" value="yes" checked data-size="small"
                               data-on-color="success" data-on-text="{{ Lang::get('main.related_course_ksa') }}" data-off-color="default"
                               data-off-text="{{ Lang::get('main.related_course_ksa') }}">
                    </div>

                    <div class="form-group col-lg-12 hidden" id="related_course_ksa_div">
                        <label for="related_course_ksa">{{ Lang::get('main.related_course_ksa') }}<span
                                    class="required"> * </span></label>
                        <select id="related_course_ksa" name="related_course_ksa" class="sel2 form-control form-filter">
                            <option value=" ">{{ Lang::get('main.select') }}{{ Lang::get('main.related_course_ksa') }}</option>
                            @foreach($courses as $course)
                                <option @if(old('related_course_ksa')==$course->id) selected="selected" @endif value="{{$course->id}}">{{$course->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="order">{{ Lang::get('main.sort') }}(ترتيب ظهور الكورسات لغير المشتركين)<span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{!! old('sort') !!}" id="order" name="order" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.sort') }}">
                        </div>
                    </div>

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="sort">{{ Lang::get('main.order') }}  (ترتيب نزول الكورسات فى الدبلومه)<span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{!! old('order') !!}" id="sort" name="sort" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.order') }}">
                        </div>
                    </div>




                    <div class="clearfix"></div>
                    <div class="text-center col-lg-12">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>


                <div class="clearfix"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).on('change','#type',function(){
            type=$("#type").val();
            if(type=='according_to_country'){

                    $("#related_course_ksa_div").removeClass('hidden')
                    $("#related_course_ksa_check").removeClass('hidden')
            }else{
                $("#related_course_ksa_div").addClass('hidden');
                $("#related_course_ksa_check").addClass('hidden');
            }
            $('.sel2').each(function(){
                $(this).select2('destroy')
            });
            $('.sel2').select2();
        })
        $("#ksa_course").bootstrapSwitch({
            onSwitchChange: function(e, state) {
                if(state==true){

                    $("#related_course_ksa_div").removeClass('hidden')
                }else{
                    $("#related_course_ksa_div").addClass('hidden');
                    $("#related_course_ksa").val('');
                }
                $('.sel2').each(function(){
                    $(this).select2('destroy')
                });
                $('.sel2').select2();
            }
        });
    </script>
    @endsection
