    @php
$selectors=isset($selectors)?$selectors:'.description';
$not_required=isset($not_required)?true:false;
$labels=isset($labels)?$labels:[Lang::get('main.description')];
@endphp
<script type="text/javascript" src="{{ asset('js/tinymce/tinymce.min.js?v=2') }}"></script>
{{--<script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>--}}
{{--<script src="https://cdn.tiny.cloud/1/6qkfwvv5yor5msop8j6z0dmcxdj6olb1agp1tutffba21j4o/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>--}}
<script type="text/javascript">
    const useDarkMode = window.matchMedia('(prefers-color-scheme: dark)').matches;
    const isSmallScreen = window.matchMedia('(max-width: 1023.5px)').matches;


    const example_image_upload_handler = (blobInfo, progress) => new Promise((resolve, reject) => {
        const xhr = new XMLHttpRequest();
        xhr.withCredentials = false;
        xhr.open('POST', "{{url('admin/description_upload')}}");
        var token = '{{ csrf_token() }}';
        xhr.setRequestHeader("X-CSRF-Token", token);

        xhr.upload.onprogress = (e) => {
            progress(e.loaded / e.total * 100);
        };

        xhr.onload = () => {
            if (xhr.status === 403) {
                reject({ message: 'HTTP Error: ' + xhr.status, remove: true });
                return;
            }

            if (xhr.status < 200 || xhr.status >= 300) {
                reject('HTTP Error: ' + xhr.status);
                return;
            }

            const json = JSON.parse(xhr.responseText);

            if (!json || typeof json.location != 'string') {
                reject('Invalid JSON: ' + xhr.responseText);
                return;
            }

            resolve(json.location);
        };

        xhr.onerror = () => {
            reject('Image upload failed due to a XHR Transport error. Code: ' + xhr.status);
        };

        const formData = new FormData();
        formData.append('file', blobInfo.blob(), blobInfo.filename());

        xhr.send(formData);
    });
    @foreach(explode(',',$selectors) as $key=>$value)

    tinymce.init({
        selector:"{{$value}}_container",
        plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media template codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap emoticons',
        editimage_cors_hosts: ['picsum.photos'],
        menubar: 'file edit view insert format tools table help',
        toolbar: 'undo redo | bold italic underline strikethrough | fontfamily fontsize blocks | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | insertfile image media template link anchor codesample | ltr rtl',
        autosave_ask_before_unload: true,
        autosave_interval: '30s',
        autosave_prefix: '{path}{query}-{id}-',
        autosave_restore_when_empty: false,
        autosave_retention: '2m',
        image_advtab: true,
        link_list: [
            { title: 'My page 1', value: 'https://www.tiny.cloud' },
            { title: 'My page 2', value: 'http://www.moxiecode.com' }
        ],
        image_list: [
            { title: 'My page 1', value: 'https://www.tiny.cloud' },
            { title: 'My page 2', value: 'http://www.moxiecode.com' }
        ],
        image_class_list: [
            { title: 'None', value: '' },
            { title: 'Some class', value: 'class-name' }
        ],
        importcss_append: true,
        file_picker_callback: function(callback, value, meta) {
            // Provide file and text for the link dialog
            if (meta.filetype == 'file') {
                callback('mypage.html', {text: 'My text'});
            }

            // Provide image and alt text for the image dialog
            if (meta.filetype == 'image') {
                callback('myimage.jpg', {alt: 'My alt text'});
            }

            // Provide alternative source and posted for the media dialog
            if (meta.filetype == 'media') {
                callback('movie.mp4', {source2: 'alt.ogg', poster: 'image.jpg'});
            }
        },
        images_upload_handler: example_image_upload_handler,
        video_template_callback: (data) =>
        `<iframe title="${data.title}" width="${data.width}" height="${data.height}" src="${data.source}"></iframe>`,
        templates: [
            { title: 'New Table', description: 'creates a new table', content: '<div class="mceTmpl"><table width="98%%"  border="0" cellspacing="0" cellpadding="0"><tr><th scope="col"> </th><th scope="col"> </th></tr><tr><td> </td><td> </td></tr></table></div>' },
            { title: 'Starting my story', description: 'A cure for writers block', content: 'Once upon a time...' },
            { title: 'New list with dates', description: 'New List with dates', content: '<div class="mceTmpl"><span class="cdate">cdate</span><br><span class="mdate">mdate</span><h2>My List</h2><ul><li></li><li></li></ul></div>' }
        ],
        template_cdate_format: '[Date Created (CDATE): %m/%d/%Y : %H:%M:%S]',
        template_mdate_format: '[Date Modified (MDATE): %m/%d/%Y : %H:%M:%S]',
        height: 600,
        image_caption: true,
        quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote',
        noneditable_class: 'mceNonEditable',
        toolbar_mode: 'sliding',
        contextmenu: 'link image table',
        skin: useDarkMode ? 'oxide-dark' : 'oxide',
        content_css:'default',
        content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:16px }',
        setup: function (editor) {
            editor.on('change', function () {
                @foreach(explode(',',$selectors) as $key=>$value)
                var current_context = $.trim(tinyMCE.get('{{ltrim($value,'.')}}_container').getContent());
                var current_context_text = $.trim(tinyMCE.get('{{ltrim($value,'.')}}_container').getContent({format: 'text'}));
                if(current_context_text.length == 0) {
                    $('#{{ltrim($value,'.')}}').html('');
                    $('#{{ltrim($value,'.')}}').html( current_context_text);

                }else{
                    $('#{{ltrim($value,'.')}}').html( current_context );
                }
            @endforeach
            });
        }
    });
   @endforeach
    {{--tinymce.init({--}}
    {{--    relative_urls : false,--}}
    {{--    remove_script_host : false,--}}
    {{--    document_base_url : "{{ URL('') }}",--}}

    {{--    convert_urls : false,--}}
    {{--    selector: "{{$selectors}}",--}}
    {{--    theme : "silver",--}}
    {{--    plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media template codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',--}}
    {{--    editimage_cors_hosts: ['picsum.photos'],--}}
    {{--    menubar: 'file edit view insert format tools table help',--}}
    {{--    toolbar: 'undo redo | bold italic underline strikethrough | fontselect fontsizeselect formatselect | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | insertfile image media template link anchor codesample | ltr rtl',--}}
    {{--    toolbar_sticky: true,--}}
    {{--    autosave_ask_before_unload: true,--}}
    {{--    autosave_interval: '30s',--}}
    {{--    autosave_prefix: '{path}{query}-{id}-',3--}}
    {{--    autosave_restore_when_empty: false,--}}
    {{--    autosave_retention: '2m',--}}
    {{--    image_advtab: true,--}}
    {{--    link_list: [--}}
    {{--        { title: 'My page 1', value: 'https://www.tiny.cloud' },--}}
    {{--        { title: 'My page 2', value: 'http://www.moxiecode.com' }--}}
    {{--    ],--}}
    {{--    image_list: [--}}
    {{--        { title: 'My page 1', value: 'https://www.tiny.cloud' },--}}
    {{--        { title: 'My page 2', value: 'http://www.moxiecode.com' }--}}
    {{--    ],--}}
    {{--    image_class_list: [--}}
    {{--        { title: 'None', value: '' },--}}
    {{--        { title: 'Some class', value: 'class-name' }--}}
    {{--    ],--}}
    {{--    importcss_append: true,--}}
    {{--    file_picker_callback: function (callback, value, meta) {--}}
    {{--        /* Provide file and text for the link dialog */--}}
    {{--        if (meta.filetype === 'file') {--}}
    {{--            callback('https://www.google.com/logos/google.jpg', { text: 'My text' });--}}
    {{--        }--}}

    {{--        /* Provide image and alt text for the image dialog */--}}
    {{--        if (meta.filetype === 'image') {--}}
    {{--            callback('https://www.google.com/logos/google.jpg', { alt: 'My alt text' });--}}
    {{--        }--}}

    {{--        /* Provide alternative source and posted for the media dialog */--}}
    {{--        if (meta.filetype === 'media') {--}}
    {{--            callback('movie.mp4', { source2: 'alt.ogg', poster: 'https://www.google.com/logos/google.jpg' });--}}
    {{--        }--}}
    {{--    },--}}
    {{--    templates: [--}}
    {{--        { title: 'New Table', description: 'creates a new table', content: '<div class="mceTmpl"><table width="98%%"  border="0" cellspacing="0" cellpadding="0"><tr><th scope="col"> </th><th scope="col"> </th></tr><tr><td> </td><td> </td></tr></table></div>' },--}}
    {{--        { title: 'Starting my story', description: 'A cure for writers block', content: 'Once upon a time...' },--}}
    {{--        { title: 'New list with dates', description: 'New List with dates', content: '<div class="mceTmpl"><span class="cdate">cdate</span><br /><span class="mdate">mdate</span><h2>My List</h2><ul><li></li><li></li></ul></div>' }--}}
    {{--    ],--}}
    {{--    template_cdate_format: '[Date Created (CDATE): %m/%d/%Y : %H:%M:%S]',--}}
    {{--    template_mdate_format: '[Date Modified (MDATE): %m/%d/%Y : %H:%M:%S]',--}}
    {{--    height: 600,--}}
    {{--    image_caption: true,--}}
    {{--    quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',--}}
    {{--    noneditable_class: 'mceNonEditable',--}}
    {{--    toolbar_mode: 'sliding',--}}
    {{--    contextmenu: 'link image table',--}}
    {{--    content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:16px }',--}}
    {{--    automatic_uploads: true,--}}
    {{--    images_upload_handler: function (blobInfo, success, failure) {--}}
    {{--        var xhr, formData;--}}

    {{--        xhr = new XMLHttpRequest();--}}
    {{--        xhr.withCredentials = false;--}}
    {{--        xhr.open('POST', "{{url('admin/description_upload')}}");--}}
    {{--        var token = '{{ csrf_token() }}';--}}
    {{--        xhr.setRequestHeader("X-CSRF-Token", token);--}}
    {{--        xhr.onload = function() {--}}
    {{--            var json;--}}

    {{--            if (xhr.status != 200) {--}}
    {{--                failure('HTTP Error: ' + xhr.status);--}}
    {{--                return;--}}
    {{--            }--}}

    {{--            json = JSON.parse(xhr.responseText);--}}

    {{--            if (!json || typeof json.location != 'string') {--}}
    {{--                failure('Invalid JSON: ' + xhr.responseText);--}}
    {{--                return;--}}
    {{--            }--}}

    {{--            success(json.location);--}}
    {{--        };--}}


    {{--        var description = '';--}}

    {{--        jQuery(tinymce.activeEditor.dom.getRoot()).find('img').not('.loaded-before').each(--}}
    {{--            function() {--}}
    {{--                description = $(this).attr("alt");--}}
    {{--                $(this).addClass('loaded-before');--}}
    {{--            });--}}

    {{--        formData = new FormData();--}}
    {{--        formData.append('file', blobInfo.blob(), blobInfo.filename());--}}
    {{--        formData.append('description', description); //found now))--}}

    {{--        xhr.send(formData);--}}
    {{--    },--}}
    {{--    paste_data_images : true,--}}
    {{--    setup: function (editor) {--}}
    {{--        editor.on('change', function () {--}}
    {{--            tinymce.triggerSave();--}}
    {{--        });--}}
    {{--    }--}}



    {{--});--}}
    {{--tinymce.init({--}}
    {{--    relative_urls : false,--}}
    {{--    remove_script_host : false,--}}
    {{--    document_base_url : "{{ URL('') }}",--}}
    {{--    convert_urls : true,--}}
    {{--    selector: "{{$selectors}}",--}}
    {{--    theme : "silver",--}}

    {{--    plugins: [--}}
    {{--        "advlist autolink autosave link image lists charmap print preview hr anchor pagebreak spellchecker",--}}
    {{--        "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",--}}
    {{--        "table contextmenu directionality emoticons template textcolor paste textcolor colorpicker textpattern image code "/*fullpage*/--}}
    {{--    ],--}}
    {{--    object_resizing : true,--}}
    {{--    resize: "both",--}}
    {{--    automatic_uploads: true,--}}
    {{--    file_picker_types: 'image',--}}
    {{--    /* without images_upload_url set, Upload tab won't show up*/--}}
    {{--    // without images_upload_url set, Upload tab won't show up--}}
    {{--    images_upload_url: "{{url('/upload.php')}}",--}}
    {{--    images_upload_handler: function (blobInfo, success, failure) {--}}
    {{--        var xhr, formData;--}}

    {{--        xhr = new XMLHttpRequest();--}}
    {{--        xhr.withCredentials = false;--}}
    {{--        xhr.open('POST', "{{url('/upload.php')}}");--}}

    {{--        xhr.onload = function() {--}}
    {{--            var json;--}}

    {{--            if (xhr.status != 200) {--}}
    {{--                failure('HTTP Error: ' + xhr.status);--}}
    {{--                return;--}}
    {{--            }--}}

    {{--            json = JSON.parse(xhr.responseText);--}}

    {{--            if (!json || typeof json.location != 'string') {--}}
    {{--                failure('Invalid JSON: ' + xhr.responseText);--}}
    {{--                return;--}}
    {{--            }--}}

    {{--            success(json.location);--}}
    {{--        };--}}

    {{--        formData = new FormData();--}}
    {{--        formData.append('file', blobInfo.blob(), blobInfo.filename());--}}

    {{--        xhr.send(formData);--}}
    {{--    },--}}

    {{--    file_picker_callback: function (cb, value, meta) {--}}
    {{--        var input = document.createElement('input');--}}
    {{--        input.setAttribute('type', 'file');--}}
    {{--        input.setAttribute('accept', 'image/*');--}}

    {{--        /*--}}
    {{--          Note: In modern browsers input[type="file"] is functional without--}}
    {{--          even adding it to the DOM, but that might not be the case in some older--}}
    {{--          or quirky browsers like IE, so you might want to add it to the DOM--}}
    {{--          just in case, and visually hide it. And do not forget do remove it--}}
    {{--          once you do not need it anymore.--}}
    {{--        */--}}

    {{--        input.onchange = function () {--}}
    {{--            var file = this.files[0];--}}

    {{--            var reader = new FileReader();--}}
    {{--            reader.onload = function () {--}}
    {{--                /*--}}
    {{--                  Note: Now we need to register the blob in TinyMCEs image blob--}}
    {{--                  registry. In the next release this part hopefully won't be--}}
    {{--                  necessary, as we are looking to handle it internally.--}}
    {{--                */--}}
    {{--                var id = 'blobid' + (new Date()).getTime();--}}
    {{--                var blobCache =  tinymce.activeEditor.editorUpload.blobCache;--}}
    {{--                var base64 = reader.result.split(',')[1];--}}
    {{--                var blobInfo = blobCache.create(id, file, base64);--}}
    {{--                blobCache.add(blobInfo);--}}

    {{--                /* call the callback and populate the Title field with the file name */--}}
    {{--                cb(blobInfo.blobUri(), { title: file.name });--}}
    {{--            };--}}
    {{--            reader.readAsDataURL(file);--}}
    {{--        };--}}

    {{--        input.click();--}}
    {{--    },--}}

    {{--    toolbar1: "newdocument fullpage | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify | styleselect formatselect fontselect fontsizeselect",--}}
    {{--    toolbar2: "cut copy paste | searchreplace | bullist numlist | outdent indent blockquote | undo redo | link unlink anchor image media code | insertdatetime preview | forecolor backcolor",--}}
    {{--    toolbar3: "table | hr removeformat | subscript superscript | charmap emoticons | print fullscreen | ltr rtl | spellchecker | visualchars visualblocks nonbreaking template pagebreak restoredraft",--}}
    {{--    image_advtab: true,--}}
    {{--    menubar: false,--}}
    {{--    toolbar_items_size: 'small',--}}
    {{--    style_formats: [--}}
    {{--        {title: 'Bold text', inline: 'b'},--}}
    {{--        {title: 'Red text', inline: 'span', styles: {color: '#ff0000'}},--}}
    {{--        {title: 'Red header', block: 'h1', styles: {color: '#ff0000'}},--}}
    {{--        {title: 'Example 1', inline: 'span', classes: 'example1'},--}}
    {{--        {title: 'Example 2', inline: 'span', classes: 'example2'},--}}
    {{--        {title: 'Table styles'},--}}
    {{--        {title: 'Table row 1', selector: 'tr', classes: 'tablerow1'}--}}
    {{--    ],--}}
    {{--    //content_css: ['//fonts.googleapis.com/css?family=Indie+Flower'],--}}
    {{--    font_formats: 'Cocon=cocon,Andale Mono=andale mono,monospace;Arial=arial,helvetica,sans-serif;Arial Black=arial black,sans-serif;Book Antiqua=book antiqua,palatino,serif;Comic Sans MS=comic sans ms,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,palatino,serif;Helvetica=helvetica,arial,sans-serif;Impact=impact,sans-serif;Symbol=symbol;Tahoma=tahoma,arial,helvetica,sans-serif;Terminal=terminal,monaco,monospace;Times New Roman=times new roman,times,serif;Trebuchet MS=trebuchet ms,geneva,sans-serif;Verdana=verdana,geneva,sans-serif;Webdings=webdings;Wingdings=wingdings,zapf dingbats;',--}}
    {{--    templates: [--}}
    {{--        {title: 'Test template 1', content: 'Test 1'},--}}
    {{--        {title: 'Test template 2', content: 'Test 2'}--}}
    {{--    ],--}}
    {{--    setup: function (editor) {--}}
    {{--        editor.on('change', function () {--}}
    {{--            tinymce.triggerSave();--}}
    {{--        });--}}
    {{--    }--}}



    {{--});--}}
</script>
@foreach(explode(',',$selectors) as $key=>$value)
    <div class="form-group col-lg-12">
        <label class=" control-label" for="{{ltrim($value,'.')}}">{{ $labels[$key] }}  @if(!$not_required) <span class="required"> * </span> @endif</label>
        <textarea class="form-control {{ltrim($value,'.')}}_container" style="min-height: 300px;" id="{{ltrim($value,'.')}}_container"  name="{{ltrim($value,'.')}}_container" data-required="1" placeholder="{{ Lang::get('main.enter').$labels[$key] }}">@if(old(ltrim($value,'.'))){{ old(ltrim($value,'.')) }}@elseif(isset($posts)){!! $posts[$key] !!}@endif</textarea>
        <textarea class="form-control {{ltrim($value,'.')}}" style="height: 0px; visibility: hidden;" id="{{ltrim($value,'.')}}"  name="{{ltrim($value,'.')}}" data-required="1" >@if(old(ltrim($value,'.'))){{ old(ltrim($value,'.')) }}@elseif(isset($posts)){!! $posts[$key] !!}@endif</textarea>
    </div>
@endforeach

