

{{--{{ print_r(json_decode($post->custom_views_projects)).dd() }}--}}
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    <style>
        .progress {
            position: relative;
            width: 100%;
            height: 30px !important;
            border: 1px solid #7F98B2;
            padding: 1px;
            border-radius: 3px;
        }

        .bar {
            background-color: #B4F5B4;
            width: 0%;
            height: 25px;
            border-radius: 3px;
        }

        .percent {
            position: absolute;
            display: inline-block;
            top: 3px;
            left: 48%;
            color: #7F98B2;
        }
    </style>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/dba') }}">{{ Lang::get('main.dba') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>
            <li>
                <span>{{ $dba_record->name }}</span>
            </li>

        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.dba') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.dba') }}</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/dba/'.$dba_record->id,'id'=>'addArticlesForm','files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                </div>

                <div class="form-group col-lg-6">
                    <label class="control-label" for="name">{{ Lang::get('main.name') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{{ $dba_record->name }}" id="name" name="name" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.name') }}">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="url">{{ Lang::get('main.meta_title') }} </label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{!! $dba_record->meta_title !!}" id="meta_title" name="meta_title"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.meta_title') }}">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="url">{{ Lang::get('main.meta_keywords') }} </label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{!! $dba_record->meta_keywords !!}" id="meta_keywords" name="meta_keywords"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.meta_keywords') }}">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="intro">{{ Lang::get('main.intro') }} </label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{!! $dba_record->intro !!}" id="intro" name="intro"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.intro') }}">
                    </div>
                </div>
    
                <div class="form-group col-lg-12">
                    <label class="control-label" for="url">{{ Lang::get('main.meta_description') }} </label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <textarea  class="form-control"  id="meta_description" name="meta_description"
                                  placeholder="{{ Lang::get('main.enter').Lang::get('main.meta_description') }}">{!! $dba_record->meta_description !!}</textarea>
                    </div>
                </div>
    
                @include('auth/description',['selectors'=>'.description,.doctor_file_description_download,.doctor_file_description_upload','posts' =>[$dba_record->description,$dba_record->doctor_file_description_download,$dba_record->doctor_file_description_upload],'labels'=>[Lang::get('main.description'),Lang::get('main.doctor_file_description_download'),Lang::get('main.doctor_file_description_upload')]])
                <div class="row col-lg-12">
                <div class="form-group col-lg-4">

                    <label class="control-label">{{Lang::get('main.pic')}}</label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <img style="width: 90%;" src="{{assetURL($dba_record->image) }}">
                    </div>
                </div>
                <div class="form-group col-lg-4">
                    <label class="control-label">{{Lang::get('main.banner')}}</label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <img style="width: 90%;" src="{{assetURL($dba_record->banner) }}">
                    </div>
                </div>
                <div class="form-group col-lg-4">
                    <label class="control-label">{{Lang::get('main.doctor_file')}}</label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        @if($dba_record->doctor_file)
                        <a href="{{URL('admin/dba/download_file/1')}}" class="btn btn-success btn-block" download >Download</a>

                        @endif
                    </div>
                </div>
                </div>
                <div class="form-group col-lg-4">
                    <label class="control-label" for="pic">{{ Lang::get('main.replace')}} {{Lang::get('main.pic')}}<span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="file" class="form-control" value="" id="pic" accept="image/*"
                               name="pic" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.pic') }}">
                    </div>
                </div>
                <div class="form-group col-lg-4">
                    <label class="control-label" for="pic">
                        {{ Lang::get('main.replace')}} {{Lang::get('main.banner')}}
                        <span class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="file" class="form-control" value="" id="pic" accept="image/*"
                               name="banner" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.banner') }}">
                    </div>
                </div>
                <div class="form-group col-lg-4">
                    <label class="control-label" for="pic">
                        {{ Lang::get('main.replace')}} {{Lang::get('main.doctor_file')}}
                        <span class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="file" class="form-control" value="" id="doctor_file"
                               name="doctor_file" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.doctor_file') }}">
                    </div>
                </div>
                <div class="form-group col-lg-12">
                    <div class="form-group col-lg-4">
                        <label class="control-label">{{Lang::get('main.brochure_file')}}</label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            @if($dba_record->brochure_file)
                                <a href="{{mainAssetURL('brochures/'.$dba_record->brochure_file) }}" class="btn btn-success btn-block downloaded_file" download>Download</a>
                                <a class="delete_this btn btn-danger btn-block " data-id="{{$dba_record->id}}">
                                    Delete File
                                </a>
                            @endif
                        </div>
                    </div>
                    <div class="form-group col-lg-2"></div>

                    <div class="form-group col-lg-6">
                        <label class="control-label" for="brochure_file">
                            {{ Lang::get('main.replace')}} {{Lang::get('main.brochure_file')}}
                            <span class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="file" class="form-control" value="" id="brochure_file"
                                   name="brochure_file" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.brochure_file') }}">
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <div class="text-center col-lg-12">
                    <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
                </div>
                <div class="clearfix"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>

        $(document).ready(function () {

            $('.fromToDate').datepicker({
                rtl: App.isRTL(),
                autoclose: true
            });
            @if(PerUser('dba_delete'))
            $(document).on('click', '.delete_this', function (event) {
                var token = "{{ csrf_token() }}";
                var deleted_id = $(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.brochure_file') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.brochure_file') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function (dialogItself) {
                                $.ajax({
                                    type: "get",
                                    url: "{{ URL('admin/dba/delete_file') }}/" + deleted_id,
                                    data: {"id": deleted_id, _token: token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $(".downloaded_file").remove();
                                        $(".delete_this").remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function (dialogItself) {
                                dialogItself.close();
                            }
                        }]
                });
            });
            @endif

        });

    </script>
@endsection
