
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/courses') }}">{{ Lang::get('main.courses') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.courses') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
    <style>
        .form-group {
            margin-left: 0px !important;
            margin-right: 0px !important;
        }
        .loading {
            position: relative;
        }
        .loading::after {
            position: absolute;
            background: center 1.7857142857rem no-repeat rgba(255, 255, 255, .5);
            background-image: url(https://cf2.s3.souqcdn.com/public/style/img/loading.gif);
            background-repeat: no-repeat;
            background-position: center center;
            background-color: rgba(250, 250, 250, .8);
            background-size: 1.7857142857rem auto;
        }
        .loading::after {
            display: block!important;
            width: 100%;
            height: 100%;
            left: 0;
            top: 0;
            z-index: 148;
            content: ' '!important;
            line-height: 0;
        }
        .line-through{
            text-decoration: line-through;
        }
    </style>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.courses') }}</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/courses_delete_form','class'=>"form-horizontal loading",'id'=>'submitForm','files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div id="messages"></div>
                    <div class="form-group col-lg-2">
                        <label for="course_id">{{ Lang::get('main.course') }}<span
                                    class="required"> * </span></label>
                        <select id="course_id" name="course_id" class="course_id form-control form-filter">
                            <option value=" ">{{ Lang::get('main.select') }}{{ Lang::get('main.course') }}</option>
                            @foreach(\App\Models\Courses::whereNotIn('id',\App\Models\DeleteCourseLog::pluck('course_id')->toArray())->pluck('name','id')->toArray() as $id=>$name)
                                <option @if(old('course_id')==$id) selected="selected" @endif value="{{$id}}">{{$name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-lg-2">
                        <label for="course_id">Users Watch Course</label>
                        <div class="input-group">
                            <span class="input-group-addon">
                                 <input type="checkbox" id="delete_number_of_users" class="delete-checkbox" value="1" name="delete_number_of_users">
                            </span>
                            <input type="text" disabled class="form-control" name="number_of_users" id="number_of_users"/>

                        </div>
                    </div>
                    <div class="form-group col-lg-2">
                        <label for="course_id">In Diploma</label>
                        <div class="input-group">
                            <span class="input-group-addon">
                                 <input type="checkbox" id="delete_in_diploma" class="delete-checkbox" value="1" name="delete_in_diploma">
                            </span>
                        <input type="text" disabled class="form-control" name="in_diploma" id="in_diploma"/>
                        </div>
                    </div>
                    <div class="form-group col-lg-2">
                        <label for="course_id">In Old Mba</label>
                        <div class="input-group">
                            <span class="input-group-addon">
                                 <input type="checkbox" id="delete_in_mba" class="delete-checkbox" value="1" name="delete_in_mba">
                            </span>
                        <input type="text" disabled class="form-control" name="in_mba" id="in_mba"/>
                        </div>
                    </div>
                    <div class="form-group col-lg-2">
                        <label for="course_id">In New Mba</label>
                        <div class="input-group">
                            <span class="input-group-addon">
                                 <input type="checkbox" id="delete_in_new_mba" class="delete-checkbox" value="1" name="delete_in_new_mba">
                            </span>
                            <input type="text" disabled class="form-control" name="in_new_mba" id="in_new_mba"/>
                        </div>
                    </div>
                    <div class="form-group col-lg-2">
                        <label for="course_id">In Traning</label>
                        <div class="input-group">
                            <span class="input-group-addon">
                                 <input type="checkbox" id="delete_in_training_program" class="delete-checkbox" value="1" name="delete_in_training_program">
                            </span>
                            <input type="text" disabled class="form-control" name="in_training_program" id="in_training_program"/>
                        </div>
                    </div>

                    <div class="form-group col-lg-12">
                        <label class="mt-checkbox">
                            <input type="checkbox" id="delete_for_all" value="1" name="delete_for_all"> Delete from all users
                            <span></span>
                        </label>
                        <span class="help-block"> if this checked it will remove from all users plan diploma & mba & if not checked it will remove only from users that hasn't see it </span>
                    </div>
                    <div class="form-group col-lg-12">
                        <label class="mt-checkbox">
                            <input type="checkbox" value="1" id="send_email" name="send_email"> Send email
                            <span></span>
                        </label>
                        <span class="help-block"> Send email for users that delete the course from them</span>
                    </div>
                    <div id="emailTemplate" class="hidden">
                        @include('auth/description',['selectors'=>'.description', 'labels'=>[Lang::get('main.description')], 'posts'=>[$emailTemplate] ])
                    </div>


                    <div class="clearfix"></div>
                    <div class="text-center col-lg-12">
                        <button disabled="disabled" type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>

                <div class="clearfix"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function () {
            $("#submitForm").removeClass('loading')
            $("#course_id").select2()
            $(document).on('change','.delete-checkbox',function(){
                console.log($(this).is(':checked'))
                if($(this).is(':checked')){
                    $(this).parent().parent().find('input.form-control').addClass('line-through')
                }else{
                    $(this).parent().parent().find('input.form-control').removeClass('line-through')
                }
            })
            $(document).on('change','#delete_for_all',function (){
                if($(this).is(':checked')){
                    $(".delete-checkbox").prop('checked',true).parent().parent().find('input.form-control').addClass('line-through')
                }else{
                    $(".delete-checkbox").prop('checked',false).parent().parent().find('input.form-control').removeClass('line-through')
                }
            });
            $(document).on('change','#course_id',function (){
                let el=$(this);
                let course_id=el.val();
                if(course_id){
                    el.parent().find('.select2.select2-container.select2-container--bootstrap').addClass('loading')
                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/courses_delete_form_get_data') }}",
                        data: {"course_id": course_id,"_token":"{{ csrf_token() }}","getNumbers":true},
                        success: function (msg) {
                            $("#number_of_users").val(msg.count_users);
                            $("#in_diploma").val(msg.has_diploma);
                            $("#in_mba").val(msg.has_mba);
                            $("#in_new_mba").val(msg.has_newmba);
                            $("#in_training_program").val(msg.has_training_program);
                            el.parent().find('.select2.select2-container.select2-container--bootstrap').removeClass('loading')
                            $("#submitForm button[type='submit']").removeAttr('disabled');
                        }
                    });
                }else{
                    $("#submitForm button[type='submit']").attr('disabled','disabled');
                }

            });
            $(document).on('change',"#send_email",function(){
                if($(this).is(':checked')){
                    $("#emailTemplate").removeClass('hidden')
                }else{
                    $("#emailTemplate").addClass('hidden')
                }
            })

        })

    </script>
@endsection
