

{{--{{ print_r(json_decode($post->custom_views_projects)).dd() }}--}}
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    <style>
        .progress {
            position: relative;
            width: 100%;
            height: 30px !important;
            border: 1px solid #7F98B2;
            padding: 1px;
            border-radius: 3px;
        }

        .bar {
            background-color: #B4F5B4;
            width: 0%;
            height: 25px;
            border-radius: 3px;
        }

        .percent {
            position: absolute;
            display: inline-block;
            top: 3px;
            left: 48%;
            color: #7F98B2;
        }
    </style>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/app_settings') }}">{{ Lang::get('main.app_settings') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>
            <li>
                <span></span>
            </li>

        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.app_settings') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.app_settings') }}</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/app_settings','id'=>'addAppSettingsForm','class'=>"form-horizontal",'files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                </div>
                <div class="form-group col-lg-12">
                    <label for="easy_question_percentage">{{ Lang::get('main.easy_question_percentage') }} <span
                                class="required"> * </span></label>
                    <div class="input-group">
                        <input type="number" min="0" max="100" maxlength="3" class="form-control"
                               id="easy_question_percentage" value="{{$app_settings->easy_question_percentage}}" name="easy_question_percentage"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.easy_question_percentage') }}">
                        <div class="input-group-addon">%</div>
                    </div>
                </div>

                <div class="form-group col-lg-12">
                    <label for="normal_question_percentage">{{ Lang::get('main.normal_question_percentage') }} <span
                                class="required"> * </span></label>
                    <div class="input-group">
                        <input type="number" min="0" max="100" maxlength="3" class="form-control"
                               id="normal_question_percentage" value="{{$app_settings->normal_question_percentage}}" name="normal_question_percentage"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.normal_question_percentage') }}">
                        <div class="input-group-addon">%</div>
                    </div>
                </div>

                <div class="form-group col-lg-12">
                    <label for="hard_question_percentage">{{ Lang::get('main.hard_question_percentage') }} <span
                                class="required"> * </span></label>
                    <div class="input-group">
                        <input type="number" min="0" max="100" maxlength="3" class="form-control"
                               id="hard_question_percentage" value="{{$app_settings->hard_question_percentage}}" name="hard_question_percentage"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.hard_question_percentage') }}">
                        <div class="input-group-addon">%</div>
                    </div>
                </div>

                <div class="form-group col-lg-12">
                    <label for="dollar_rate">{{ Lang::get('main.dollar_rate') }} <span
                                class="required"> * </span></label>
                    <div class="input-group">
                        <input type="number" step=".0001" class="form-control" id="dollar_rate" value="{{$app_settings->dollar_rate}}" name="dollar_rate"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.dollar_rate') }}">
                        <div class="input-group-addon">EGY</div>
                    </div>
                </div>
                <div class="form-group col-lg-12">

                <div class="form-group col-lg-4">
                    <label class="control-label">{{Lang::get('main.mba_brochure_file')}}</label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        @if($app_settings->mba_brochure_file)
                            <a href="{{mainAssetURL('brochures/'.$app_settings->mba_brochure_file) }}" class="btn btn-success btn-block downloaded_file" download>Download</a>
                            <a class="delete_this btn btn-danger btn-block " data-id="{{$app_settings->id}}">
                                Delete File
                            </a>
                           @endif

                    </div>
                </div>
                <div class="form-group col-lg-2"></div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="mba_brochure_file">
                        {{ Lang::get('main.replace')}} {{Lang::get('main.mba_brochure_file')}}
                        <span class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="file" class="form-control" value="" id="mba_brochure_file"
                               name="mba_brochure_file" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.mba_brochure_file') }}">
                    </div>
                </div>
                </div>
                <div class="clearfix"></div>
                <div class="form-group col-lg-12">

                <div class="form-group col-lg-4">
                    <label class="control-label">{{Lang::get('main.website_brochure_file')}}</label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        @if($app_settings->website_brochure_file)
                            <a href="{{mainAssetURL('brochures/'.$app_settings->website_brochure_file) }}" class="btn btn-success btn-block downloaded_file_website" download>Download</a>
                            <a class="delete_this_file btn btn-danger btn-block " data-id="{{$app_settings->id}}">
                                Delete File
                            </a>
                        @endif

                    </div>
                </div>
                <div class="form-group col-lg-2"></div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="mba_brochure_file">
                        {{ Lang::get('main.replace')}} {{Lang::get('main.website_brochure_file')}}
                        <span class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="file" class="form-control" value="" id="website_brochure_file"
                               name="website_brochure_file" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.website_brochure_file') }}">
                    </div>
                </div>

                </div>
                <div class="col-lg-12 form-group">
                    <label class="control-label" for="course_accreditation">{{ Lang::get('main.course_accreditations') }}</label>
                    {!! Form::select('course_accreditation[]', $accreditations, old('course_accreditation') ? old('course_accreditation') : $app_settings->courseAccreditation->pluck('id')->toArray(), ['class' => 'form-control form-filter select2', 'multiple' => 'multiple', 'id' => 'selectall-tag']) !!}

                    <p class="help-block"></p>
                </div>
                <div class="col-lg-12 form-group">
                    <label class="control-label" for="dba_accreditation">{{ Lang::get('main.dba_accreditations') }}</label>
                    {!! Form::select('dba_accreditation[]', $accreditations, old('dba_accreditation') ? old('dba_accreditation') : $app_settings->dbaAccreditation->pluck('id')->toArray(), ['class' => 'form-control form-filter select2', 'multiple' => 'multiple', 'id' => 'selectall-tag1']) !!}

                    <p class="help-block"></p>
                </div>
                <div class="col-lg-12 form-group">
                    <label class="control-label" for="mba_accreditation">{{ Lang::get('main.mba_accreditations') }}</label>
                    {!! Form::select('mba_accreditation[]', $accreditations, old('mba_accreditation') ? old('mba_accreditation') : $app_settings->mbaAccreditation->pluck('id')->toArray(), ['class' => 'form-control form-filter select2', 'multiple' => 'multiple', 'id' => 'selectall-tag2']) !!}

                    <p class="help-block"></p>
                </div>
                <div class="col-lg-12 form-group">
                    <label class="control-label" for="new_mba_accreditation">{{ Lang::get('main.new_mba_accreditations') }}</label>
                    {!! Form::select('new_mba_accreditation[]', $accreditations, old('new_mba_accreditation') ? old('new_mba_accreditation') : $app_settings->newmbaAccreditation->pluck('id')->toArray(), ['class' => 'form-control form-filter select2', 'multiple' => 'multiple', 'id' => 'selectall-tag3']) !!}

                    <p class="help-block"></p>
                </div>
                <div class="clearfix"></div>
                <div class="text-center">
                    <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
                </div>
                <div class="clearfix"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>

        $(document).ready(function () {
            $(document).on('change', '#all_projects', function () {
                if ($(this).is(':checked')) {
                    $("#projects_ids").attr('disabled', 'disabled');
                } else {
                    $("#projects_ids").removeAttr('disabled')
                }
            });
            $(document).on('click', '.delete_this', function (event) {
                var token = "{{ csrf_token() }}";
                var deleted_id = $(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.brochure_file') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.brochure_file') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function (dialogItself) {
                                $.ajax({
                                    type: "get",
                                    url: "{{ URL('admin/delete_file') }}",
                                    data: { _token: token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $(".downloaded_file").remove();
                                        $(".delete_this").remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function (dialogItself) {
                                dialogItself.close();
                            }
                        }]
                });
            });
            $(document).on('click', '.delete_this_file', function (event) {
                var token = "{{ csrf_token() }}";
                var deleted_id = $(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.brochure_file') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.brochure_file') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function (dialogItself) {
                                $.ajax({
                                    type: "get",
                                    url: "{{ URL('admin/delete_website_file') }}",
                                    data: { _token: token},
                                    success: function (msg) {
                                        $("#errors").html(msg);

                                        $(".downloaded_file_website").remove();
                                        $(".delete_this_file").remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function (dialogItself) {
                                dialogItself.close();
                            }
                        }]
                });
            });

        });
    </script>
@endsection
