
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/admin_activity_report') }}">{{ Lang::get('main.admin_activity_report') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.admin_activity_report_details') }}</span>
            </li>
        </ul>
        <!--<div class="page-toolbar">
            <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body" data-placement="bottom" data-original-title="Change dashboard date range">
                <i class="icon-calendar"></i>&nbsp;
                <span class="thin uppercase hidden-xs"></span>&nbsp;
                <i class="fa fa-angle-down"></i>
            </div>
        </div>-->
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.admin_activity_report_details') }}
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
    
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.admin_activity_report_details') }}</span>
                </div>
                <div class="clearfix"></div>
               <div class="col-lg-3">
                   <div class="mt-widget-1">
                       @if(PerUser('normal_user_edit'))
                           <a target="_blank" href="{{ URL('admin/normal_user/'.$user->id.'/edit') }}">
                       @endif
                       <div class="mt-img">
                           <img src="{{ assetURL($user->image?$user->image:'logo.png') }}" style="width: 50px;"> </div>
                       <div class="mt-body">
                           <h3 class="mt-username">{{ $user->FullName }}</h3>
                           <p class="mt-user-title"> {{ $user->Email }} </p>
                       </div>
                       @if(PerUser('normal_user_edit'))
                           </a>
                       @endif
                   </div>
               </div>
            </div>
            <div class="portlet-body">
                <div class="row">
                    <div class="col-lg-6">
                        <h4>Website</h4>
                        <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="datatable_ajax_website">
                            <thead>
                            <tr role="row" class="heading">
                                <th width="20%">{{ Lang::get('main.add_date') }}</th>
                                <th width="20%">{{ Lang::get('main.user_name') }}</th>
                                <th width="20%">{{ Lang::get('main.user_action') }}</th>
                                <th width="10%">{{ Lang::get('main.action_link') }}</th>
                                <th></th>
                            </tr>
                            <tr role="row" class="filter">
                                <td>
                                    <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                        <input type="text" class="form-control form-filter input-sm" readonly
                                               name="created_time_from" placeholder="{{ Lang::get('main.from') }}">
                                        <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                    </div>
                                    <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                        <input type="text" class="form-control form-filter input-sm" readonly
                                               name="created_time_to" placeholder="{{ Lang::get('main.to') }}">
                                        <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                    </div>
                                    <input type="hidden" id="_token" name="_token" value="{{ csrf_token() }}">
                                </td>
                                <td>

                                    <input type="text" class="form-control form-filter input-sm" name="user_name">
                                </td>
                                <td>
                                    <input type="text" class="form-control form-filter input-sm" name="user_action">
                                </td>
                                <td>
                                    <input type="text" class="form-control form-filter input-sm" name="action_link">
                                </td>
                                <td>
                                    <div class="margin-bottom-5">
                                        <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                            <i class="fa fa-search"></i> {{ Lang::get('main.search') }}</button>
                                    </div>
                                    <button class="btn btn-sm red btn-outline filter-cancel">
                                        <i class="fa fa-times"></i> {{ Lang::get('main.reset') }}</button>
                                </td>

                            </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                    <div class="col-lg-6">
                        <h4>Admin</h4>
                        <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="datatable_ajax_admin">
                            <thead>
                            <tr role="row" class="heading">
                                <th width="20%">{{ Lang::get('main.add_date') }}</th>
                                <th width="20%">{{ Lang::get('main.user_name') }}</th>
                                <th width="20%">{{ Lang::get('main.user_action') }}</th>
                                <th width="10%">{{ Lang::get('main.action_link') }}</th>
                                <th></th>
                            </tr>
                            <tr role="row" class="filter">
                                <td>
                                    <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                        <input type="text" class="form-control form-filter input-sm" readonly
                                               name="created_time_from" placeholder="{{ Lang::get('main.from') }}">
                                        <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                    </div>
                                    <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                        <input type="text" class="form-control form-filter input-sm" readonly
                                               name="created_time_to" placeholder="{{ Lang::get('main.to') }}">
                                        <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                    </div>
                                    <input type="hidden" id="_token" name="_token" value="{{ csrf_token() }}">
                                </td>
                                <td>

                                    <input type="text" class="form-control form-filter input-sm" name="user_name">
                                </td>
                                <td>
                                    <input type="text" class="form-control form-filter input-sm" name="user_action">
                                </td>
                                <td>
                                    <input type="text" class="form-control form-filter input-sm" name="action_link">
                                </td>
                                <td>
                                    <div class="margin-bottom-5">
                                        <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                            <i class="fa fa-search"></i> {{ Lang::get('main.search') }}</button>
                                    </div>
                                    <button class="btn btn-sm red btn-outline filter-cancel">
                                        <i class="fa fa-times"></i> {{ Lang::get('main.reset') }}</button>
                                </td>

                            </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>

                </div>

            </div>
        </div>
    </div>
@endsection
@section('scriptCode')

    <script>
        $(document).ready(function () {
            $(".menu-toggler.sidebar-toggler").trigger('click');
            $('.fromToDate').datepicker({
                rtl: App.isRTL(),
                autoclose: true,
            });
            var gridWebsite = new Datatable();
            gridWebsite.setAjaxParam("_token", "{{ csrf_token() }}");
            gridWebsite.setAjaxParam("user_id", "{{ request('user_id') }}");
            gridWebsite.setAjaxParam("ip_address", "{{ request('ip_address') }}");
            gridWebsite.setAjaxParam("type", "website");
            // console.log(grid._token)
            gridWebsite.init({
                src: $("#datatable_ajax_website"),
                onSuccess: function (grid, response) {
                    // grid:        grid object
                    // response:    json object of server side ajax response
                    // execute some code after table records loaded
                },
                onError: function (grid) {
                    // execute some code on network or other general error
                },
                onDataLoad: function (grid) {
                },
                loadingMessage: '{{ Lang::get('main.loading') }}',
                dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options
                    // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                    // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                    // So when dropdowns used the scrollable div should be removed.
                    //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                    "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                    "lengthMenu": [
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) -1 @endif],
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) "All" @endif] // change per page values here
                    ],
                    "pageLength": 10, // default record count per page
                    "ajax": {
                        "url": "{{ URL('admin/admin_activity_report/details') }}", // ajax source
                        "method":"GET",
                    },
                    @if(getUserSystem('backend_lang')=='ar') "language": {"url": "{{ asset('assets/layouts/layout/datatables-arabic.json') }}"},@endif "columnDefs": [{
                        "targets": [0], // column or columns numbers
                        "orderable": true  // set orderable for selected columns

                    }],
                    "order": [
                        [0, "desc"]
                    ],// set first column as a default sort by asc
                    dom: 'Blfrtip',
                    buttons: [
                        {extend: 'print', className: 'btn dark btn-outline'},
                        {extend: 'pdf', className: 'btn green btn-outline'},
                        {extend: 'csv', className: 'btn purple btn-outline '}
                    ],
                }
            });


            var gridAdmin = new Datatable();
            gridAdmin.setAjaxParam("_token", "{{ csrf_token() }}");
            gridAdmin.setAjaxParam("user_id", "{{ request('user_id') }}");
            gridAdmin.setAjaxParam("ip_address", "{{ request('ip_address') }}");
            gridAdmin.setAjaxParam("type", "admin");
            // console.log(grid._token)
            gridAdmin.init({
                src: $("#datatable_ajax_admin"),
                onSuccess: function (grid, response) {
                    // grid:        grid object
                    // response:    json object of server side ajax response
                    // execute some code after table records loaded
                },
                onError: function (grid) {
                    // execute some code on network or other general error
                },
                onDataLoad: function (grid) {
                },
                loadingMessage: '{{ Lang::get('main.loading') }}',
                dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options
                    // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                    // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                    // So when dropdowns used the scrollable div should be removed.
                    //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                    "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                    "lengthMenu": [
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) -1 @endif],
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) "All" @endif] // change per page values here
                    ],
                    "pageLength": 10, // default record count per page
                    "ajax": {
                        "url": "{{ URL('admin/admin_activity_report/details') }}", // ajax source
                        "method":"GET",
                    },
                    @if(getUserSystem('backend_lang')=='ar') "language": {"url": "{{ asset('assets/layouts/layout/datatables-arabic.json') }}"},@endif "columnDefs": [{
                        "targets": [0], // column or columns numbers
                        "orderable": true  // set orderable for selected columns

                    }],
                    "order": [
                        [0, "desc"]
                    ],// set first column as a default sort by asc
                    dom: 'Blfrtip',
                    buttons: [
                        {extend: 'print', className: 'btn dark btn-outline'},
                        {extend: 'pdf', className: 'btn green btn-outline'},
                        {extend: 'csv', className: 'btn purple btn-outline '}
                    ],
                }
            });
        });
    </script>
@endsection
