

{{--{{ print_r(json_decode($post->custom_views_projects)).dd() }}--}}
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/apcc') }}">{{ Lang::get('main.accreditation_partners_countries_categories') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.accreditation_partners_countries_categories') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.accreditation_partners_countries_categories') }}</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/apcc/'.$accreditation_partners_countries_categories->id,'id'=>'addAuthorForm','class'=>"form-horizontal",'files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                </div>
                <div class="form-group col-lg-12">
                    <label class="control-label" for="accreditation_country_id">{{ Lang::get('main.accreditation_country') }} <span
                                class="required"> * </span></label>
                    <select id="type" class="form-control sel2" required name="accreditation_country_id">
                        <option value=" ">{{ Lang::get('main.select') }} {{ Lang::get('main.accreditation_country') }}</option>
                        @foreach(\App\Models\AccreditationPartnersCountries::pluck('name','id')->toArray() as $id=>$name)
                        <option @if($accreditation_partners_countries_categories->accreditation_country_id==$id) selected="selected" @endif value="{{ $id }}">{{ $name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group col-lg-12">
                    <label class="control-label" for="type">{{ Lang::get('main.type') }} <span
                                class="required"> * </span></label>
                    <select id="type" class="form-control sel2" required name="type">
                        <option value=" ">{{ Lang::get('main.select') }} {{ Lang::get('main.type') }}</option>
                        <option @if($accreditation_partners_countries_categories->type=='accreditaion') selected="selected" @endif value="accreditaion">accreditaion</option>
                        <option @if($accreditation_partners_countries_categories->type=='success_partners') selected="selected" @endif value="success_partners">success_partners</option>
                        <option @if($accreditation_partners_countries_categories->type=='both') selected="selected" @endif value="both">both</option>
                    </select>
                </div>
                <div class="form-group col-lg-9">
                    <label class="control-label" for="title">{{ Lang::get('main.title') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{{$accreditation_partners_countries_categories->title}}" id="title" name="title" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.title') }}">
                    </div>
                </div>

                <div class="form-group col-lg-3 text-center" style="margin-top:25px;">
                    <input type="checkbox" class="make-switch" name="published" value="yes" data-size="small"
                           @if($accreditation_partners_countries_categories->published=="yes") checked @endif data-on-color="success" data-on-text="{{ Lang::get('main.published') }}" data-off-color="default"
                           data-off-text="{{ Lang::get('main.unpublished') }}">
                </div>
                <div class="form-group col-lg-12">
                    <label class="control-label" for="url">{{ Lang::get('main.url') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{!! $accreditation_partners_countries_categories->url !!}" id="url" name="url" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.url') }}">
                    </div>
                </div>
                <div class="form-group col-lg-12">
                    <label class="control-label" for="sort">{{ Lang::get('main.sort') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{!! $accreditation_partners_countries_categories->sort !!}" id="sort" name="sort" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.sort') }}">
                    </div>
                </div>
                <div class="form-group col-lg-12">
                    <label class="control-label" for="short_description">{{ Lang::get('main.short_description') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <textarea class="form-control" id="short_description" name="short_description" data-required="1"
                                  placeholder="{{ Lang::get('main.enter').Lang::get('main.short_description') }}">{{ $accreditation_partners_countries_categories->short_description }}</textarea>
                    </div>
                </div>
                @include('auth/description',['posts' =>[$accreditation_partners_countries_categories->description]])

                <div class="clearfix"></div>
                <div class="text-center col-lg-12">
                    <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
                </div>
                <div class="clearfix"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
