

{{--{{ print_r(json_decode($post->custom_views_projects)).dd() }}--}}
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/accreditation_partners_countries') }}">{{ Lang::get('main.accreditation_partners_countries') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.accreditation_partners_countries') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->

    <!-- END PAGE HEADER-->
@endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.accreditation_partners_countries') }}</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/accreditation_partners_countries/'.$accreditation_partners_countries->id,'id'=>'addAuthorForm','class'=>"form-horizontal",'files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                </div>
                <div class="form-group col-lg-12">
                    <label class="control-label" for="type">{{ Lang::get('main.type') }} <span
                                class="required"> * </span></label>
                    <select id="type" class="form-control sel2" required name="type">
                        <option value=" ">{{ Lang::get('main.select') }} {{ Lang::get('main.type') }}</option>
                        <option @if($accreditation_partners_countries->type=='accreditaion') selected="selected" @endif value="accreditaion">accreditaion</option>
                        <option @if($accreditation_partners_countries->type=='success_partners') selected="selected" @endif value="success_partners">success_partners</option>
                        <option @if($accreditation_partners_countries->type=='both') selected="selected" @endif value="both">both</option>
                    </select>
                </div>

                <div class="form-group col-lg-12">
                    <label class="control-label" for="partner_country_type">{{ Lang::get('main.partner_country_type') }} <span
                                class="required"> * </span></label>
                    <select id="partner_country_type" class="form-control sel2" required name="partner_country_type">
                        <option value=" ">{{ Lang::get('main.select') }} {{ Lang::get('main.partner_country_type') }}</option>
                        <option @if($accreditation_partners_countries->partner_country_type=='normal') selected="selected" @endif value="normal">normal</option>
                        <option @if($accreditation_partners_countries->partner_country_type=='event') selected="selected" @endif value="event">event</option>
                    </select>
                </div>
                <div class="form-group col-lg-9">
                    <label class="control-label" for="name">{{ Lang::get('main.name') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{{$accreditation_partners_countries->name}}" id="name" name="name" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.name') }}">
                    </div>
                </div>

                <div class="form-group col-lg-3 text-center" style="margin-top:25px;">
                    <input type="checkbox" class="make-switch" name="published" value="yes" data-size="small"
                           @if($accreditation_partners_countries->published=="yes") checked @endif data-on-color="success" data-on-text="{{ Lang::get('main.published') }}" data-off-color="default"
                           data-off-text="{{ Lang::get('main.unpublished') }}">
                </div>
                <div class="form-group col-lg-6 col-lg-offset-3">
                    <label class="control-label">Current Picture</label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <img width="100%" src="{{assetURL($accreditation_partners_countries->pic_path) }}">
                    </div>
                </div>

                <div class="form-group col-lg-12">
                    <label class="control-label" for="pic">Replace Picture <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="file" class="form-control" value="" id="pic" accept="image/*"
                               name="pic" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.pic') }}">
                    </div>
                </div>

                <div class="clearfix"></div>
                <div class="text-center col-lg-12">
                    <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
                </div>
                <div class="clearfix"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
