
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    <link rel="stylesheet" type="text/css" href="{{ asset('css/notify.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('css/prettify.css') }}">
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.academy_alumni') }}</span>
            </li>
        </ul>
        <!--<div class="page-toolbar">
            <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body" data-placement="bottom" data-original-title="Change dashboard date range">
                <i class="icon-calendar"></i>&nbsp;
                <span class="thin uppercase hidden-xs"></span>&nbsp;
                <i class="fa fa-angle-down"></i>
            </div>
        </div>-->
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.academy_alumni') }}
        <small>{{ Lang::get('main.view') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
    <style>
        td {
            word-wrap: break-word;
            overflow-wrap: break-word;
        }
    </style>
    @if(PerUser('academy_alumni_add'))
        <div class="row">
            <div class="col-md-12">
                <div class="btn-group pull-right">
                    <a href="{{ URL('admin/academy_alumni/create') }}" style="margin-right: 5px;" id="sample_editable_1_new" class="btn green">
                        {{ Lang::get('main.add_new') }}
                        <i class="fa fa-plus"></i>
                    </a>

                    <button id="importBtn" style="width: 90px;margin-right: 5px;padding: 0;height: 34px;" onclick="$('#importFile').trigger('click')" class="btn btn-success">
                            <span id="import-btn-title" class="">
                                  <i class="fa fa-upload"></i> {{ trans('main.Import') }}
                            </span>
                        <div id="importProgress" style="height: 35px;width: 90px;" class="progress hidden">
                            <div class="progress-bar" role="progressbar" style="width: 0%;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">0%</div>
                        </div>
                    </button>
                    <input type="file" class="hidden" id="importFile" accept=".csv">
                    <a download="" style="margin-right: 5px;" class="btn btn-success" href="{{ URL('templates/academy_alumni_template.csv') }}">
                        <i class="fa fa-download"></i>
                        {{ trans('main.Download Template') }}
                    </a>
                </div>
            </div>
        </div>
    @endif
    @if(PerUser('academy_alumni_view') )
        <div class="row">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-users font-dark"></i>
                        <span class="caption-subject bold uppercase">{{ Lang::get('main.academy_alumni') }}</span>
                    </div>
                    <div class="tools"></div>
                </div>
                <div class="portlet-body">
                    <table style=" table-layout: fixed;width: 100%;" class="table table-striped table-bordered table-hover dt-responsive" width="100%"
                           id="datatable_ajax">
                        <thead>
                        <tr role="row" class="heading">
                            <th> #</th>
                            <th>{{ Lang::get('main.name') }}</th>
                            <th>{{ Lang::get('main.sort') }}</th>
                            <th>{{ Lang::get('main.pic') }}</th>
                            <th>{{ Lang::get('main.linkedin') }}</th>
                            <th>{{ Lang::get('main.facebook') }}</th>
                            <th>{{ Lang::get('main.url') }}</th>
                            <th>{{ Lang::get('main.published') }}</th>
                            <th></th>
                        </tr>
                        <tr role="row" class="filter">
                            <td>
                                <input type="number" min="1" class="form-control form-filter input-sm" name="id">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="name">
                                <input type="hidden" id="_token" name="_token" value="{{ csrf_token() }}">
                            </td>
                            <td>
                                <input type="number" min="0" class="form-control form-filter input-sm" name="sort">
                            </td>
                            <td></td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="linkedin">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="facebook">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="url">
                            </td>
                            <td>

                            </td>
                            <td>
                                <div class="margin-bottom-5">
                                    <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                        <i class="fa fa-search"></i> {{ Lang::get('main.search') }}</button>
                                </div>
                                <button class="btn btn-sm red btn-outline filter-cancel">
                                    <i class="fa fa-times"></i> {{ Lang::get('main.reset') }}</button>
                            </td>

                        </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- Modal -->
        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
             aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{ Lang::get('main.confirmation') }}!!</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        {{ Lang::get('main.are_you_sure_you_want_to_delete') }}
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal">{{ Lang::get('main.cancel') }}</button>
                        <button type="button" class="btn btn-primary confirm_deletion"
                                data-dismiss="modal">{{ LAng::get('main.delete') }}</button>
                    </div>
                </div>
            </div>
        </div>
        <!-- image modal -->
        <div id="image-modal" class="modal fade modal-scroll" tabindex="-1" data-replace="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    </div>
                    <div class="modal-body">
                        <img width="100%"/>
                        <div class="modal-footer">
                            <button type="button" data-dismiss="modal" class="btn dark btn-outline">{{ Lang::get('main.close') }}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        </div>
    @endif
@endsection
@section('scriptCode')
    <script src="{{ asset('js/notify.js?v=1') }}"></script>
    <script src="{{ asset('js/prettify.js?v=1') }}"></script>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function () {

            $('.module_name').select2();
            var token = "{{ csrf_token() }}";

            $(document).on('change','#importFile',function(){
                let el=$(this);
                let file = this.files[0];
                let fileType = file.type;
                var match= [
                    /*csv*/
                    'text/csv'
                ];
                if(match.includes(fileType)){
                    data=new FormData();
                    data.append('_token',token);
                    data.append('file',file);
                    let oldTitle=$('title').text();
                    $.ajax({
                        type: 'POST',
                        url: '{{ URL('admin/academy_alumni/import') }}',
                        cache: false,
                        contentType: false,
                        processData: false,
                        data:data,
                        beforeSend: function() {
                            console.log('beforeSend');
                            $("#importProgress .progress-bar").attr('aria-valuenow',0).css({"width":0+'%'}).html(0+'%');
                            $("#importProgress").removeClass('hidden');
                            $("#import-btn-title").addClass('hidden');
                            $("#importBtn").addClass('loading').attr('disabled','disabled');
                            $('title').html('0%'+' upload file '+' |'+oldTitle);
                        },
                        xhr: function() {
                            var xhr = new window.XMLHttpRequest();
                            xhr.upload.addEventListener("progress", function(evt) {
                                if (evt.lengthComputable) {
                                    var percentComplete = Math.round((evt.loaded / evt.total) * 100);
                                    console.log(percentComplete);
                                    $("#importProgress .progress-bar").attr('aria-valuenow',percentComplete).css({"width":percentComplete+'%'}).html(percentComplete+'%');
                                    /*Do something with upload progress here*/
                                    $('title').html(percentComplete+'%'+' upload file '+' |'+oldTitle);
                                }
                            }, false);
                            return xhr;
                        },
                        success: function (data) {
                            console.log('success');
                            console.log(data);
                            $("#importProgress").addClass('hidden');
                            $("#import-btn-title").removeClass('hidden');
                            $("#importBtn").removeClass('loading').removeAttr('disabled');
                            $.notify(data.message, {blur: 0.2, delay: 0,close: true,color: "#fff", background: (data.success?"#20D67B":"#D44950"),animationType:"drop"});
                            el.val('');
                            $('title').html(data.message+' | '+oldTitle);
                            if(data.redirect){
                                window.location.href=data.redirect;
                            }
                            if(data.success){
                                $('.filter-submit').trigger('click');
                            }
                        }
                    });
                }else{
                    $.notify("Please Select Valid file must be csv!", {blur: 0.2, delay: 0,close: true,color: "#fff", background: "#D44950",animationType:"drop"});
                }
            });
            @if(PerUser('academy_alumni_publish'))
            $(document).on('change','.changeStatues',function(){
                var statues=$(this).is(':checked');
                var id=$(this).attr('data-id');
                if(statues){
                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/academy_alumni/publish') }}",
                        data: {"published": "yes", "id": id,_token:token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }else{
                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/academy_alumni/publish') }}",
                        data: {"published": "no", "id": id,_token:token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }
            });
            @endif
            $('.fromToDate').datepicker({
                rtl: App.isRTL(),
                autoclose: true
            });
            var grid = new Datatable();
            grid.setAjaxParam("_token", "{{ csrf_token() }}");
            // console.log(grid._token)
            grid.init({
                src: $("#datatable_ajax"),
                onSuccess: function (grid, response) {
                    // grid:        grid object
                    // response:    json object of server side ajax response
                    // execute some code after table records loaded
                },
                onError: function (grid) {
                    // execute some code on network or other general error
                },
                onDataLoad: function (grid) {
                    var $edit_drug = $('.editable-drug');
                    var $edit_drug_status_id = $edit_drug.attr("id");
                    $.fn.editable.defaults.mode = 'popup';
                    $.fn.editable.defaults.ajaxOptions = {type: "PUT"};
                    $edit_drug.editable({
                        source: [
                            {
                                'approved': 'Approved'
                            },
                            {
                                'pending': 'Pending'
                            }
                        ],
                        url: "{{ URL('admin/academy_alumni') }}/" + $edit_drug_status_id + '/editacademy_alumnitatus',
                        params: function (params) {
                            //originally params contain pk, name and value
                            params._token = token;
                            return params;
                        }
                    });
                },
                loadingMessage: '{{ Lang::get('main.loading') }}',
                dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options
                    // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                    // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                    // So when dropdowns used the scrollable div should be removed.
                    //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                    "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                    "lengthMenu": [
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) -1 @endif],
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) "All" @endif] // change per page values here
                    ],
                    "pageLength": 10, // default record count per page
                    "ajax": {
                        "url": "{{ URL('admin/academy_alumni_search') }}", // ajax source
                    },
                    @if(getUserSystem('backend_lang')=='ar') "language": {"url": "{{ asset('assets/layouts/layout/datatables-arabic.json') }}"},@endif "columnDefs": [{
                        "targets": [0], // column or columns numbers
                        "orderable": true  // set orderable for selected columns

                    }],
                    "order": [
                        [0, "desc"]
                    ],// set first column as a default sort by asc
                    dom: 'Blfrtip',
                    buttons: [
                        {extend: 'print', className: 'btn dark btn-outline'},
                        {extend: 'pdf', className: 'btn green btn-outline'},
                        {extend: 'csv', className: 'btn purple btn-outline '}
                    ],
                }
            });
            var drug_id = null;
            $(document).on('click', '.deleteResource', function (event) {
                event.preventDefault();
                drug_id = $(this).attr("data-location");
                console.log(drug_id);

            });

            $(document).on('click', '.confirm_deletion', function (event) {
                event.preventDefault();
                console.log(grid);

                console.log(drug_id);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax(
                    {
                        url: "{{ URL('admin/academy_alumni') }}/" + drug_id,
                        method: "delete", // replaced from put
                        dataType: "JSON",
                        data: {
                            "id": drug_id // method and token not needed in data
                        },
                        success: function (response) {
                            console.log(response); // see the reponse sent
                            console.log('deleted'); // see the reponse sent
                            $('.filter-submit').trigger('click');
                            // window.location.href = "/admin/courses";


                        },
                        error: function (xhr) {
                            console.log(xhr.responseText); // this line will save you tons of hours while debugging
                            // do something here because of error
                        }
                    });

            });
            @if(PerUser('academy_alumni_delete'))
            $(document).on('click', '.delete_this', function (event) {

                var deleted_id = $(this).attr("data-id");
                event.preventDefault();
                BootstrapDialog.show({
                    title: '{{ Lang::get('main.delete').lang::get('main.academy_alumni') }}',
                    message: '{{ Lang::get('main.delete_this').lang::get('main.academy_alumni') }} ?',
                    buttons: [
                        {
                            label: '{{ Lang::get('main.yes') }}',
                            cssClass: 'btn-primary',
                            action: function (dialogItself) {
                                $.ajax({
                                    type: "DELETE",
                                    url: "{{ URL('admin/academy_alumni') }}/" + deleted_id,
                                    data: {"id": deleted_id, _token: token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        $("#single-order-" + deleted_id).parent().parent().remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '{{ Lang::get('main.no') }}',
                            action: function (dialogItself) {
                                dialogItself.close();
                            }
                        }]
                });
            });
            @endif

            $(document).on("click", ".image-link", function () {
                $("#image-modal .modal-body img").attr('src', $(this).find('img').attr('src') );
            });
        });
    </script>
@endsection
