<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class vocationalTrainingProgram extends Model
{

    use SoftDeletes;

    public $connection = 'mysql2';

    protected $table = "vocational_training_program";

    protected $fillable = ["id","title","description","image","created_at","updated_at"];

    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            if(Auth::check()){
                log_admin_action(Auth::user()->id,Auth::user()->username,'update',$model->getTable(),$model->id,$model->toJson());
            }

        });
        static::created(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'create',$model->getTable(),$model->id,$model->toJson());
        });
        static::deleted(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'delete',$model->getTable(),$model->id,$model->toJson());
        });
    }

}
