<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;


class PackageCourse extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'packages_courses';

    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'update',$model->getTable(),$model->id,$model->toJson());
        });
        static::created(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'create',$model->getTable(),$model->id,$model->toJson());
        });
        static::deleted(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'delete',$model->getTable(),$model->id,$model->toJson());
        });
    }

    public function package()
    {
        return $this->belongsTo(Package::class, 'package_id');
    }

	public function course()
	{
		return $this->belongsTo(Courses::class, 'related_course');
	}

}
