<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class DiplomasSupplementaryTests extends Model
{
    use SoftDeletes;
    public $timestamps = false;
    protected $softDelete = true;
    public $connection = 'mysql2';
    protected $table = 'diplomas_supplementary_tests';
    protected $fillable = [
        'language',
        'questions_type',
        'type',
        'question_time',
        'diploma_id',
        'section_id',
        'questions_numbers',
        'questions_count',
        'name',
        'description',
        'createdtime',
        'modifiedtime',
        'published',
        'active',
        'sent',
        'sort',
        'file',
        'deleted_at ',
        'published_by',
        'published_date',
        'unpublished_by',
        'unpublished_date',
        'lastedit_date',
        'lastedit_date',
        'lastedit_by',
        'added_by',
        'added_date',
        'name_en',
        'update_published',
    ];

    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            $action=$model->trashed()?'delete':'update';
            log_admin_action(Auth::user()->id,Auth::user()->username,$action,$model->getTable(),$model->id,$model->toJson());
        });
        static::created(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'create',$model->getTable(),$model->id,$model->toJson());
        });
        static::deleted(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'delete',$model->getTable(),$model->id,$model->toJson());
        });
    }

}
