<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;


class DBAChargeTransaction extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'dba_charge_transaction';

    public function user()
    {
        return $this->belongsTo('App\Models\NormalUser','user_id');
    }

    protected static function boot()
    {
        parent::boot();
        if(Auth::check()){
            static::updated(function ($model) {
                sendDBAChargeTransaction($model->id);
                updateAcademyChargeTransaction($model->user_id);
                log_admin_action(Auth::user()->id,Auth::user()->username,'update',$model->getTable(),$model->id,$model->toJson());
            });
            static::created(function ($model) {
                sendDBAChargeTransaction($model->id);
                updateAcademyChargeTransaction($model->user_id);
                log_admin_action(Auth::user()->id,Auth::user()->username,'create',$model->getTable(),$model->id,$model->toJson());
            });
            static::deleted(function ($model) {
                deleteChargeTransactionFromCRM($model->id,'dba transaction');
                updateAcademyChargeTransaction($model->user_id);
                log_admin_action(Auth::user()->id,Auth::user()->username,'delete',$model->getTable(),$model->id,$model->toJson());
            });
        }

    }
}
