<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AppSettings extends Model
{
    public $connection = 'mysql2';
    protected $table = 'app_settings';

    public function courseAccreditation()
    {
        return $this->belongsToMany('App\Models\AccreditationPartnersCountriesCategoriesDetails', 'accreditation_images','details_id','category_details_id')
            ->wherePivot('type','course');
    }
    public function dbaAccreditation()
    {
        return $this->belongsToMany('App\Models\AccreditationPartnersCountriesCategoriesDetails', 'accreditation_images','details_id','category_details_id')
            ->wherePivot('type','dba');
    }
    public function mbaAccreditation()
    {
        return $this->belongsToMany('App\Models\AccreditationPartnersCountriesCategoriesDetails', 'accreditation_images','details_id','category_details_id')
            ->wherePivot('type','mba');
    }
    public function newmbaAccreditation()
    {
        return $this->belongsToMany('App\Models\AccreditationPartnersCountriesCategoriesDetails', 'accreditation_images','details_id','category_details_id')
            ->wherePivot('type','new_mba');
    }
}
