<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Admin\ChargeTransactionController;
use App\Models\ChargeTransaction;
use App\Models\CoursesCurriculumCertificates;
use App\Models\FutcherxUser;
use App\Models\FuturexIntegrationCourse;
use App\Models\NormalUser;
use App\Models\UsersCoursesVideo;
use App\Models\UsersCourseViewCompleted;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class FutcherXController extends Controller
{
    public function saveLearners(){
        $access_token=getAccessToken();
        $url=config('futcherx.url').'api/v1/providers/'.config('futcherx.provider_id').'/learners?_format=json';
        $data=[];
        $response=curlRequest($url,'GET',$data,['Authorization: Bearer '.$access_token]);
        // dd($response);
        foreach ($response->content as $item){
            $user=NormalUser::where('futcherx_user_id',$item->userId)->first();
            if(!$user){
                $user=NormalUser::create([
                    'futcherx_user_id'=>$item->userId,
                    'Email'=>$item->email,
                    'name_en'=>$item->englishName,
                    'FullName'=>$item->arabicName,
                    'Mobile'=>$item->userId,
                    'generated_code'=>Str::random(10),
                    'RegisterDate'=>date('Y-m-d H:i:s'),
                    'leadsource'=>'FUTCHERX',
                ]);
            }
            $data=[
                'futcherx_user_id'=>$item->userId,
                'user_id'=>$user->id,
                'futcherx_id'=>$item->id,
                'futcherx_email'=>$item->email,
                'futcherx_arabicName'=>$item->arabicName,
                'futcherx_englishName'=>$item->englishName,
                'futcherx_institution'=>$item->institution,
                'futcherx_licenses'=>json_encode($item->licenses),
            ];
            $futcherxUser=FutcherxUser::where(['futcherx_id'=>$item->id])->first();
            if(!$futcherxUser){
                FutcherxUser::create($data);
            }else{
                FutcherxUser::where('id',$futcherxUser->id)->update($data);
            }
            foreach ($item->licenses as $license){
                $data=[
                    'futcherx_license_id'=>$license->licenseId,
                    'futcherx_license_name'=>$license->licenseCatalogue,
                    'start_date'=>date('Y-m-d H:i:s',strtotime($license->licenseStartDate?$license->licenseStartDate:'now')),
                    'end_date'=>date('Y-m-d H:i:s',strtotime($license->licenseEndDate?$license->licenseEndDate:'now +1 year')),
                    'user_id'=>$user->id,
                ];
                $charge=ChargeTransaction::where('user_id',$user->id)->where('futcherx_license_id',$license->licenseId)->first();
                if(!$charge){
                    $data['createtime']=date('Y-m-d H:i:s');
                    $data['added_date']=date('Y-m-d H:i:s');
                    ChargeTransaction::create($data);
                    $user->update(['PaymentExpirationDate'=>$data['end_date']]);
                }else{
                    $data['lastedit_date']=date('Y-m-d H:i:s');
                    ChargeTransaction::where('id',$charge->id)->update($data);
                }
            }
//

        }
        dd(config('futcherx.url').'oauth/token','grant_type=client_credentials&client_id='.config('futcherx.client_id').'&client_secret='.config('futcherx.client_secret'),$url,$response,$access_token);
    }

    public function saveLearnersEnrollment(){

        $users=FutcherxUser::select('futcherx_users.*')->join('users','users.id','=','futcherx_users.user_id')->whereRaw("users.id IN(SELECT DISTINCT user_id FROM `users_courses_videos`)")->get();
        foreach ($users as $user){
            $courses=FuturexIntegrationCourse::select('futurex_integration_courses.*','courses.hours_numbers')->join('courses','courses.id','=','futurex_integration_courses.course_id')->whereRaw("courses.id IN(SELECT DISTINCT course_id FROM users_courses_videos)")->get();
            foreach ($courses as $course){
                $access_token=getAccessToken();
                $url=config('futcherx.url').'enrollment-progress?_format=json';
                $enrollDate=UsersCoursesVideo::where('user_id',$user->id)->where('course_id',$course->id)->min('created_date');
                $complete=UsersCourseViewCompleted::where('user_id',$user->id)->where('course_id',$course->id)->first();
                $overallProgress=0;
                $isCompleted=false;
                if($complete){
                    $overallProgress=($complete->completed/$complete->total)*100;
                    $isCompleted=$complete->completed>=$complete->completed?true:false;
                }
                $data=[
                    'courseId'=>$course->futurex_course_id,
                    'userId'=>$user->futurex_user_id,
                    'approxTotalCourseHrs'=>$course->hours_numbers,
                    'overallProgress'=>$overallProgress,
                    'membershipState'=>'MEMBER',
                    'enrolledAt'=>strtotime($enrollDate),
                    'isCompleted'=>$isCompleted,
                ];
                $response=curlRequest($url,'POST',$data,['Authorization: Bearer '.$access_token]);
            }

        }


    }
    public function saveLearnersCertificates(){
        $access_token=getAccessToken();
        $certificates=CoursesCurriculumCertificates::select('futurex_integration_courses.futurex_course_id','futcherx_users.futcherx_user_id','courses_curriculum_certificates.url')
            ->join('futurex_integration_courses','futurex_integration_courses.course_id','=','courses_curriculum_certificates.course_id')
            ->join('futcherx_users','futcherx_users.user_id','=','courses_curriculum_certificates.user_id')
        ;
        foreach ($certificates as $certificate){
            $url=config('futcherx.url').'certificate?_format=json';
            $data=[
                'courseId'=>$certificate->futurex_course_id,
                'userId'=>$certificate->futcherx_user_id,
//                'attachment',
                'url'=>$certificate->url,
            ];
            $response=curlRequest($url,'POST',$data,['Authorization: Bearer '.$access_token]);
        }

    }
}
