<?php

namespace App\Http\Controllers\Admin;

use App\Models\vocationalTrainingProgram;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class vocationalTrainingProgramController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {
        return view('auth.vocational_training_program.view');
    }


    function search(Request $request)
    {

        $data = $request->input();
        $vocationalTrainingPrograms = vocationalTrainingProgram::select('vocational_training_program.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $vocationalTrainingPrograms = $vocationalTrainingPrograms->where('vocational_training_program.id', '=', "$id");
        }
        if (isset($data['title']) && !empty($data['title'])) {
            $title = $data['title'];
            $vocationalTrainingPrograms = $vocationalTrainingPrograms->where('vocational_training_program.title', 'LIKE', "%$title%");
        }
        if (isset($data['description']) && !empty($data['description'])) {
            $description = $data['description'];
            $vocationalTrainingPrograms = $vocationalTrainingPrograms->where('vocational_training_program.description', 'LIKE', "%$description%");
        }
        if (isset($data['image']) && !empty($data['image'])) {
            $image = $data['image'];
            $vocationalTrainingPrograms = $vocationalTrainingPrograms->where('vocational_training_program.image', 'LIKE', "%$image%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $vocationalTrainingPrograms = $vocationalTrainingPrograms->whereBetween('vocational_training_program.created_at', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }


        $iTotalRecords = $vocationalTrainingPrograms->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'vocational_training_program.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'vocational_training_program.id';
                break;
            case 1:
                $columnName = 'vocational_training_program.title';
                break;
            case 2:
                $columnName = 'vocational_training_program.description';
                break;
            case 3:
                $columnName = 'vocational_training_program.image';
                break;
            case 4:
                $columnName = 'vocational_training_program.created_at';
                break;

        }
        $search = $data['search']['value'];
        if ($search) {
            $vocationalTrainingPrograms = $vocationalTrainingPrograms->where(function ($q) use ($search) {
                $q->where('vocational_training_program.title', 'LIKE', "%$search%")
                    ->orWhere('vocational_training_program.description', 'LIKE', "%$search%")
                    ->orWhere('vocational_training_program.image', 'LIKE', "%$search%")
                    ->orWhere('vocational_training_program.id', '=', $search);
            });
        }

        $vocationalTrainingPrograms = $vocationalTrainingPrograms->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($vocationalTrainingPrograms as $vocationalTrainingProgram) {
            $vocationalTrainingProgram=makeDefaultImageGeneral($vocationalTrainingProgram,'image');

            $records["data"][] = [
                $vocationalTrainingProgram->id,
                $vocationalTrainingProgram->title,
                $vocationalTrainingProgram->description,
                '<a class="image-link" href="#image-modal" data-toggle="modal"><img  style="width:70%;"  src="' . assetURL($vocationalTrainingProgram->image) . '"></a>',
                $vocationalTrainingProgram->created_at->toDateTimeString(),
                '<div class="btn-group text-center" id="single-order-' . $vocationalTrainingProgram->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('vocational_training_program_edit')) ? '<li>
                                            <a href="' . URL('admin/vocational_training_program/' . $vocationalTrainingProgram->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('vocational_training_program_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $vocationalTrainingProgram->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
//    public function create()
//    {
//        return view('auth.diplomas.add');
//    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
//    public function store(Request $request)
//    {
//        $data = $request->input();
//        $validator = Validator::make($request->all(),
//            array(
//                'name' => 'required',
//                'en_name' => 'required',
//                'code' => 'required',
//                'pic' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
//                'url' => 'required',
//                'description' => 'required',
//                'egy_sale_price' => 'required',
//                'ksa_sale_price' => 'required',
//            ));
//        if ($validator->fails()) {
//            return redirect()->back()->withErrors($validator->errors())->withInput();
//        }else {
//            $active = (isset($data['active'])) ? 'yes' : 'no';
//            $pic = $request->file('pic');
//            $picName = uploadFileToE3melbusiness($pic);
//            $diplomas = new Diplomas();
//            $diplomas->name = $data['name'];
//            $diplomas->en_name = $data['en_name'];
//            $diplomas->code = $data['code'];
//            $diplomas->egy_price = $data['egy_price'];
//            $diplomas->ksa_price = $data['ksa_price'];
//            $diplomas->description = $data['description'];
//            if( isset($data['sent']) && !empty($data['sent']) ) {
//                $diplomas->sent = $data['sent'];
//            }else {
//                $diplomas->sent = 0;
//            }
////            $diplomas->certificate_increment = $data['certificate_increment'];
//            $diplomas->egy_sale_price = $data['egy_sale_price'];
//            $diplomas->ksa_sale_price = $data['ksa_sale_price'];
//            $diplomas->tool_eg_price = $data['tool_eg_price'];
//            $diplomas->tool_ksa_price = $data['tool_ksa_price'];
//            $diplomas->sort = $data['sort'];
//            $diplomas->image = $picName;
//            $diplomas->url = str_replace(' ','-',$data['url']);
//            $diplomas->direction = $data['direction'];
//            $diplomas->published = $active;
//            if ($active == 'yes') {
//                $diplomas->published_by = Auth::user()->id;
//                $diplomas->published_date = date("Y-m-d H:i:s");
//            }
//            if ($active == 'no') {
//                $diplomas->unpublished_by = Auth::user()->id;
//                $diplomas->unpublished_date = date("Y-m-d H:i:s");
//            }
//            $diplomas->added_by = Auth::user()->id;
//            $diplomas->added_date = date("Y-m-d H:i:s");
//            $diplomas->lastedit_by = Auth::user()->id;
//            $diplomas->lastedit_date = date("Y-m-d H:i:s");
//            if ($diplomas->save()) {
//                Session::flash('success', Lang::get('main.insert') . Lang::get('main.diplomas'));
//                return Redirect::to('admin/diplomas/create');
//            }
//        }
//    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
//    public function show($id)
//    {
//        //
//    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $vocationalTrainingProgram = vocationalTrainingProgram::find($id);
        return view('auth.vocational_training_program.edit',compact('vocationalTrainingProgram'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $vocationalTrainingProgram = vocationalTrainingProgram::find($id);
        $rules=array(
            'title' => 'required',
            'description' => 'required',
        );
        if ( $request->file('image')){
            $rules['image']='mimes:jpeg,jpg,png,gif|required|max:5000';
        }
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            if ( $request->file('image')){
                $image = $request->file('image');
                $imageName = uploadFileToE3melbusiness($image);
                $vocationalTrainingProgram->image = $imageName;
            }
            $vocationalTrainingProgram->title = $data['title'];
            $vocationalTrainingProgram->description = $data['description'];
//
            if ($vocationalTrainingProgram->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.vocational_training_program'));
                return Redirect::to("admin/vocational_training_program/$vocationalTrainingProgram->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $vocationalTrainingProgram = vocationalTrainingProgram::find($id);
        if (count($vocationalTrainingProgram)) {
            $vocationalTrainingProgram->delete();
            $vocationalTrainingProgram->deleted_by = Auth::user()->id;
            $vocationalTrainingProgram->deleted_at = date("Y-m-d H:i:s");
        }
    }

//    public function activation(Request $request)
//    {
//        if ($request->ajax()) {
//            $id = $request->input('id');
//            $active = $request->input('active');
//            $diploma = Diplomas::find($id);
//            if ($active == 'no') {
//                $diploma->published = 'no';
//                $diploma->unpublished_by = Auth::user()->id;
//                $diploma->unpublished_date = date("Y-m-d H:i:s");
//            } elseif ($active == 'yes') {
//                $diploma->published = 'yes';
//                $diploma->published_by = Auth::user()->id;
//                $diploma->published_date = date("Y-m-d H:i:s");
//            }
//            $diploma->save();
//        } else {
//            return redirect(404);
//        }
//    }
}
