<?php

namespace App\Http\Controllers\Admin;

use App\Models\AccreditationPartnersCountriesCategoriesDetails;
use App\Models\OldUrls;
use App\Models\TrainingProgram;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class trainingProgramController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.training_program.view');
    }


    function search(Request $request)
    {

        $data = $request->input();
        $training_program = TrainingProgram::select('training_program.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $training_program = $training_program->where('training_program.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $training_program = $training_program->where('training_program.name', 'LIKE', "%$name%");
        }
        if (isset($data['en_name']) && !empty($data['en_name'])) {
            $en_name = $data['en_name'];
            $training_program = $training_program->where('training_program.en_name', 'LIKE', "%$en_name%");
        }
        if (isset($data['code']) && !empty($data['code'])) {
            $code = $data['code'];
            $training_program = $training_program->where('training_program.code', 'LIKE', "%$code%");
        }
        if (isset($data['pic']) && !empty($data['pic'])) {
            $pic = $data['pic'];
            $training_program = $training_program->where('training_program.image', 'LIKE', "%$pic%");
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $training_program = $training_program->where('training_program.url', 'LIKE', "%$url%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $training_program = $training_program->whereBetween('training_program.createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }


        $iTotalRecords = $training_program->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'training_program.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'training_program.id';
                break;
            case 1:
                $columnName = 'training_program.name';
                break;
            case 2:
                $columnName = 'training_program.en_name';
                break;
            case 3:
                $columnName = 'training_program.code';
                break;
            case 4:
                $columnName = 'training_program.pic';
                break;
            case 5:
                $columnName = 'training_program.url';
                break;
            case 6:
                $columnName = 'training_program.createdtime';
                break;

        }
        $search = $data['search']['value'];
        if ($search) {
            $training_program = $training_program->where(function ($q) use ($search) {
                $q->where('training_program.name', 'LIKE', "%$search%")
                    ->orWhere('training_program.en_name', 'LIKE', "%$search%")
                    ->orWhere('training_program.code', 'LIKE', "%$search%")
                    ->orWhere('training_program.image', 'LIKE', "%$search%")
                    ->orWhere('training_program.description', 'LIKE', "%$search%")
                    ->orWhere('training_program.url', 'LIKE', "%$search%")
                    ->orWhere('training_program.id', '=', $search);
            });
        }

        $training_program = $training_program->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($training_program as $trainingProgram) {
            $trainingProgram=makeDefaultImageGeneral($trainingProgram,'image');

            $records["data"][] = [
                $trainingProgram->id,
                $trainingProgram->name,
                $trainingProgram->en_name,
                $trainingProgram->code,
                '<a class="image-link" href="#image-modal" data-toggle="modal"><img  style="width:70%;"  src="' . assetURL($trainingProgram->image) . '"></a>',
                '<a href="' . e3mURL('training_program/' . $trainingProgram->url) . '" target="_blank">' . $trainingProgram->url . '</a>',
                $trainingProgram->createdtime,
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $trainingProgram->id . '" type="checkbox" ' . ((!PerUser('users_active')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('users_active')) ? 'class="changeStatues"' : '') . ' ' . (($trainingProgram->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $trainingProgram->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $trainingProgram->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('training_program_edit')) ? '<li>
                                            <a href="' . URL('admin/training_program/' . $trainingProgram->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') .'


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $accreditations = AccreditationPartnersCountriesCategoriesDetails::where('place','outer')->where('type','accreditaion')->get()->pluck('title', 'id');

        return view('auth.training_program.add',compact('accreditations'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $rules= array(
            'name' => 'required',
            'en_name' => 'required',
            'code' => 'required',
            'pic' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
            'url' => 'required',
            'description' => 'required',
            'egy_sale_price' => 'required',
            'ksa_sale_price' => 'required',
        );
        if ($request->file('brochure_file')) {
            $rules['brochure_file'] = 'mimes:pdf,doc,docx,xlsx,xls|max:5000';
        }
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $active = (isset($data['active'])) ? 'yes' : 'no';
            $pic = $request->file('pic');
            $picName = uploadFileToE3melbusiness($pic);
            $trainingPrograms = new TrainingProgram();
            $trainingPrograms->name = $data['name'];
            $trainingPrograms->en_name = $data['en_name'];
            $trainingPrograms->code = $data['code'];
            $trainingPrograms->egy_price = $data['egy_price'];
            $trainingPrograms->ksa_price = $data['ksa_price'];
            $trainingPrograms->description = $data['description'];
            if( isset($data['sent']) && !empty($data['sent']) ) {
                $trainingPrograms->sent = $data['sent'];
            }else {
                $trainingPrograms->sent = 0;
            }
            if($request->file('brochure_file')){
                $brochureName = uploadFileToE3melbusiness($request->file('brochure_file'),false,'',false,false,true);
                $trainingPrograms->brochure_file = $brochureName;
            }
//            $trainingPrograms->certificate_increment = $data['certificate_increment'];
            $trainingPrograms->egy_sale_price = $data['egy_sale_price'];
            $trainingPrograms->ksa_sale_price = $data['ksa_sale_price'];
            $trainingPrograms->tool_eg_price = $data['tool_eg_price'];
            $trainingPrograms->tool_ksa_price = $data['tool_ksa_price'];
            $trainingPrograms->sort = $data['sort'];
            $trainingPrograms->image = $picName;
            $trainingPrograms->url = str_replace(' ','-',$data['url']);
            $trainingPrograms->direction = $data['direction'];
            $trainingPrograms->published = $active;
            if ($active == 'yes') {
                $trainingPrograms->published_by = Auth::user()->id;
                $trainingPrograms->published_date = date("Y-m-d H:i:s");
            }
            if ($active == 'no') {
                $trainingPrograms->unpublished_by = Auth::user()->id;
                $trainingPrograms->unpublished_date = date("Y-m-d H:i:s");
            }
            $trainingPrograms->added_by = Auth::user()->id;
            $trainingPrograms->added_date = date("Y-m-d H:i:s");
            $trainingPrograms->lastedit_by = Auth::user()->id;
            $trainingPrograms->lastedit_date = date("Y-m-d H:i:s");
            if ($trainingPrograms->save()) {
                if(isset($data['accreditation'])){
                    $accreditations=(array)$data['accreditation'];
                    $pivotData = array_fill(0, count($accreditations), ['type' => 'training_program','details_id'=>$trainingPrograms->id]);
                    $syncData  = array_combine($accreditations, $pivotData);
                    $trainingPrograms->Accreditation()->sync($syncData);

                }
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.training_program'));
                return Redirect::to('admin/training_program/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $trainingProgram = TrainingProgram::find($id);
        $accreditations = AccreditationPartnersCountriesCategoriesDetails::where('place','outer')->where('type','accreditaion')->get()->pluck('title', 'id');

        return view('auth.training_program.edit',compact('trainingProgram','accreditations'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $trainingProgram = TrainingProgram::find($id);
        $rules=array(
            'name' => 'required',
            'en_name' => 'required',
            'code' => 'required',
            'url' => 'required',
            'description' => 'required',
            'egy_sale_price' => 'required',
            'ksa_sale_price' => 'required',
        );
        if ( $request->file('pic')){
            $rules['pic']='mimes:jpeg,jpg,png,gif|required|max:5000';
        }
        if ($request->file('brochure_file')) {
            $rules['brochure_file'] = 'mimes:pdf,doc,docx,xlsx,xls|max:5000';
        }
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            if ( $request->file('pic')){
                $pic = $request->file('pic');
                $picName = uploadFileToE3melbusiness($pic);
                $trainingProgram->image = $picName;
            }
            if($request->file('brochure_file')){
                $brochureName = uploadFileToE3melbusiness($request->file('brochure_file'),false,'',false,false,true);
                $trainingProgram->brochure_file = $brochureName;
            }
            $published = (isset($data['active'])) ? 'yes' : 'no';
            $trainingProgram->name = $data['name'];
            $trainingProgram->en_name = $data['en_name'];
            $trainingProgram->code = $data['code'];
            $trainingProgram->egy_price = $data['egy_price'];
            $trainingProgram->ksa_price = $data['ksa_price'];
            $trainingProgram->description = $data['description'];
            if( isset($data['sent']) && !empty($data['sent']) ) {
                $trainingProgram->sent = $data['sent'];
            }else {
                $trainingProgram->sent = 0;
            }
//            $trainingProgram->certificate_increment = $data['certificate_increment'];
            $trainingProgram->egy_sale_price = $data['egy_sale_price'];
            $trainingProgram->ksa_sale_price = $data['ksa_sale_price'];
            $trainingProgram->tool_eg_price = $data['tool_eg_price'];
            $trainingProgram->tool_ksa_price = $data['tool_ksa_price'];
            $trainingProgram->sort = $data['sort'];
            $old_url=$trainingProgram->url;
            $trainingProgram->url = str_replace(' ','-',$data['url']);
            $trainingProgram->direction = $data['direction'];
            if ($published == 'yes' && $trainingProgram->published=='no') {
                $trainingProgram->published_by = Auth::user()->id;
                $trainingProgram->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $trainingProgram->published=='yes') {
                $trainingProgram->unpublished_by = Auth::user()->id;
                $trainingProgram->unpublished_date = date("Y-m-d H:i:s");
            }
            $trainingProgram->published = $published;
            $trainingProgram->lastedit_by = Auth::user()->id;
            $trainingProgram->lastedit_date = date("Y-m-d H:i:s");
            if ($trainingProgram->save()) {
                if($old_url != $trainingProgram->url){
                    saveOldUrl($id,'training_program',$old_url,$trainingProgram->url,Auth::user()->id,date("Y-m-d H:i:s"));
                }
                if(isset($data['accreditation'])) {
                    $accreditations = (array)$data['accreditation'];
                    $pivotData = array_fill(0, count($accreditations), ['type' => 'training_program', 'details_id' => $trainingProgram->id]);
                    $syncData = array_combine($accreditations, $pivotData);
                    $trainingProgram->Accreditation()->sync($syncData);
                }

                Session::flash('success', Lang::get('main.update') . Lang::get('main.training_program'));
                return Redirect::to("admin/training_program/$trainingProgram->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $trainingProgram = TrainingProgram::find($id);
        if (count($trainingProgram)) {
            $old_url=$trainingProgram->url;
            $trainingProgram->url='/';
            $trainingProgram->save();
            if($old_url != $trainingProgram->url){
                saveOldUrl($id,'training_program',$old_url,$trainingProgram->url,Auth::user()->id,date("Y-m-d H:i:s"));
            }
            $trainingProgram->delete();

            $trainingProgram->deleted_by = Auth::user()->id;
            $trainingProgram->deleted_at = date("Y-m-d H:i:s");
        }
    }

    public function delete_file($id)
    {
        $trainingProgram = TrainingProgram::find($id);
        if (count($trainingProgram)) {
            $trainingProgram->brochure_file=null;
            $trainingProgram->lastedit_by = Auth::user()->id;
            $trainingProgram->lastedit_date = date("Y-m-d H:i:s");
            $trainingProgram->save();

        }
    }

    public function activation(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $active = $request->input('active');
            $trainingProgram = TrainingProgram::find($id);
            if ($active == 'no') {
                $old_url=$trainingProgram->url;
                $trainingProgram->url='/';
                $trainingProgram->published = 'no';
                $trainingProgram->unpublished_by = Auth::user()->id;
                $trainingProgram->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($active == 'yes') {
                $old_urls=OldUrls::where('table_id',$id)->where('table_name','training_program')->where('new_url','/')->first();
                $old_url='/';
                $trainingProgram->url=$old_urls->old_url;
                $trainingProgram->published = 'yes';
                $trainingProgram->published_by = Auth::user()->id;
                $trainingProgram->published_date = date("Y-m-d H:i:s");
            }
            $trainingProgram->save();
            if($old_url != $trainingProgram->url){
                saveOldUrl($id,'training_program',$old_url,$trainingProgram->url,Auth::user()->id,date("Y-m-d H:i:s"));
            }

        } else {
            return redirect(404);
        }
    }
}
