<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\WebsiteBanner;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;

class WebsiteBannersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.website_banners.view');
    }

    function search(Request $request)
    {

        $data = $request->input();
        $website_banners = WebsiteBanner::select('website_banners.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $website_banners = $website_banners->where('website_banners.id', '=', "$id");
        }
        if (isset($data['title']) && !empty($data['title'])) {
            $title = $data['title'];
            $website_banners = $website_banners->where('website_banners.title', 'LIKE', "%$title%");
        }
        if (isset($data['subtitle']) && !empty($data['subtitle'])) {
            $subtitle = $data['subtitle'];
            $website_banners = $website_banners->where('website_banners.subtitle', $subtitle);
        }
        if (isset($data['btn_title']) && !empty($data['btn_title'])) {
            $btn_title = $data['btn_title'];
            $website_banners = $website_banners->where('website_banners.btn_title', $btn_title);
        }


        if (isset($data['btn_link']) && !empty($data['btn_link'])) {
            $btn_link = $data['btn_link'];
            $website_banners = $website_banners->where('website_banners.btn_link', 'LIKE', "%$btn_link%");
        }
        if (isset($data['image']) && !empty($data['image'])) {
            $image = $data['image'];
            $website_banners = $website_banners->where('website_banners.image', 'LIKE', "%$image%");
        }
        if (isset($data['show_on']) && !empty($data['show_on'])) {
            $show_on = $data['show_on'];
            $website_banners = $website_banners->where('website_banners.show_on', 'LIKE', "%$show_on%");
        }


        $iTotalRecords = $website_banners->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'website_banners.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'website_banners.id';
                break;
            case 1:
                $columnName = 'website_banners.title';
                break;
            case 2:
                $columnName = 'website_banners.subtitle';
                break;
            case 3:
                $columnName = 'website_banners.btn_title';
                break;
            case 4:
                $columnName = 'website_banners.btn_link';
                break;
            case 5:
                $columnName = 'website_banners.image';
                break;
            case 6:
                $columnName = 'website_banners.show_on';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $website_banners = $website_banners->where(function ($q) use ($search) {
                $q->where('website_banners.title', 'LIKE', "%$search%")
                    ->orWhere('website_banners.subtitle', 'LIKE', "%$search%")
                    ->orWhere('website_banners.btn_title', 'LIKE', "%$search%")
                    ->orWhere('website_banners.btn_link', 'LIKE', "%$search%")
                    ->orWhere('website_banners.image', 'LIKE', "%$search%")
                    ->orWhere('website_banners.show_on', '=', $search);
            });
        }

        $website_banners = $website_banners->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($website_banners as $website_banner) {
            $records["data"][] = [
                $website_banner->id,
                $website_banner->title,
                $website_banner->subtitle,
                $website_banner->btn_title,
                '<a href="' . e3mURL( $website_banner->btn_link) . '" target="_blank">' . $website_banner->btn_link . '</a>',
                '<a class="image-link" href="#image-modal" data-toggle="modal"><img  style="width:100%;"  src="' . $website_banner->image . '"></a>',
                $website_banner->show_on,
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $website_banner->id . '" type="checkbox" ' . ((!PerUser('website_banners_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('website_banners_publish')) ? 'class="changeStatues"' : '') . ' ' . (($website_banner->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $website_banner->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $website_banner->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('website_banners_edit')) ? '<li>
                                            <a href="' . URL('admin/website_banners/' . $website_banner->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('website_banners_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $website_banner->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.website_banners.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));
        $validator = Validator::make($request->all(),
            array(
                'size' => 'required|numeric|min:60|max:85',
                'color' => 'required|in:#0EB759,#000000,#ffffff,#144394',
                'image' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
                'show_on' => 'nullable|in:new,subscription,visitor,expired',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $pic = $request->file('image');
            $picName = uploadFileToE3melbusiness($pic);
            $website_banners = new WebsiteBanner();
            $website_banners->title = $data['title'];
            $website_banners->subtitle = $data['subtitle'];
            $website_banners->btn_title = $data['btn_title'];
            $website_banners->btn_link = $data['btn_link'];
            $website_banners->size = $data['size'];
            $website_banners->color = $data['color'];
            $website_banners->image = assetURL($picName);
            $website_banners->show_on = isset($data['show_on'])?$data['show_on']:'new';
            $website_banners->published = $published;
            if ($published == 'yes') {
                $website_banners->published_by = Auth::user()->id;
                $website_banners->published_at = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $website_banners->unpublished_by = Auth::user()->id;
                $website_banners->unpublished_at = date("Y-m-d H:i:s");
            }

            if ($website_banners->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.website_banners'));
                return Redirect::to('admin/website_banners/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $website_banner = WebsiteBanner::find($id);
        return view('auth.website_banners.edit',compact('website_banner'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $website_banner = WebsiteBanner::findOrFail($id);
        $data = $request->input();
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));
        $rules= array(
	        'size' => 'required|numeric|min:60|max:85',
	        'color' => 'required|in:#0EB759,#000000,#ffffff,#144394',
            'show_on' => 'nullable|in:new,subscription,visitor,expired',
        );
        if ( $request->file('image')){
            $rules['image']='mimes:jpeg,jpg,png,gif|required|max:5000';
        }
        $validator = Validator::make($request->all(),$rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            if ( $request->file('image')){
                $pic = $request->file('image');
                $picName = uploadFileToE3melbusiness($pic);
                $website_banner->image = assetURL($picName);
            }
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $website_banner->title = $data['title'];
            $website_banner->subtitle = $data['subtitle'];
            $website_banner->btn_title = $data['btn_title'];
            $website_banner->btn_link = $data['btn_link'];
            $website_banner->color = $data['color'];
            $website_banner->size = $data['size'];
            $website_banner->show_on = isset($data['show_on'])?$data['show_on']:'new';
            if ($published == 'yes' && $website_banner->published=='no') {
                $website_banner->published_by = Auth::user()->id;
                $website_banner->published_at = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $website_banner->published=='yes') {
                $website_banner->unpublished_by = Auth::user()->id;
                $website_banner->unpublished_at = date("Y-m-d H:i:s");
            }
            $website_banner->published = $published;
            if ($website_banner->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.website_banners'));
                return Redirect::to("admin/website_banners/$website_banner->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $website_banner = WebsiteBanner::find($id);
        if (count($website_banner)) {
            $website_banner->delete();
        }
    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $website_banner = WebsiteBanner::find($id);
            if ($published == 'no') {
                $website_banner->published = 'no';
                $website_banner->unpublished_by = Auth::user()->id;
                $website_banner->unpublished_at = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {

                $website_banner->published = 'yes';
                $website_banner->published_by = Auth::user()->id;
                $website_banner->published_at = date("Y-m-d H:i:s");
            }
            $website_banner->save();

        } else {
            return redirect(404);
        }
    }
}
