<?php

namespace App\Http\Controllers\Admin;

use App\Models\Company;
use App\Models\Country;
use App\Http\Controllers\Controller;
use App\Models\NormalUser;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class RwaqUserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
        $companies = Company::pluck('name', 'id');
        return view('auth.rwaq_user.view',compact('companies'));
    }

    function search(Request $request) {

        $data = $request->input();

        $users = NormalUser::where("rwaq","=", '1')->select("users.id" , "users.FullName" , "users.Email" , "users.Mobile" , "users.RegisterDate");

        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $users = $users->where('users.id', '=', $id);
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $users = $users->where('users.FullName', 'LIKE', "%$name%");
        }

        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $users = $users->where('users.Email', 'LIKE', "%$email%");
        }

        if (isset($data['mobile']) && !empty($data['mobile'])) {
            $mobile = $data['mobile'];
            $users = $users->where('users.Mobile', 'LIKE', "%$mobile%");
        }

        if ( isset($data['register_date']) && !empty($data['register_date']) ) {
            $register_date = $data['register_date'];
            $users = $users->where('users.RegisterDate', "LIKE", "%$register_date%");
        }

        $iTotalRecords = $users->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'users.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'users.id';
                break;
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'users.Mobile';
                break;
            case 4:
                $columnName = 'users.RegisterDate';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $users = $users->where(function ($q) use ($search) {
                $q->where('users.FullName','LIKE',"%$search%")
                    ->orWhere('users.Email','LIKE',"%$search%")
                    ->orWhere('users.Mobile','LIKE',"%$search%")
                    ->orWhere('users.RegisterDate','LIKE',"%$search%");
                });
        }

        $users = $users->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($users as $user) {

            $records["data"][]=[
                $user->id,
                $user->FullName,
                $user->Email,
                $user->Mobile,
                $user->RegisterDate,
                '',
//                  '<div class="btn-group text-center" id="single-order-' . $user->id . '">
//                        <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
//                            <i class="fa fa-angle-down"></i>
//                        </button>
//                        <ul class="dropdown-menu pull-right">
//                        ' . ((PerUser('rwaq_user_edit')) ? '<li>
//                                <a href="' . URL('admin/rwaq_user/' . $user->id . '/edit') . '">
//                                    <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
//                                </a>
//                            </li>' : '') . '
//                        ' . ((PerUser('rwaq_user_delete')) ? '<li>
//                                <a class="delete_this" data-id="' . $user->id . '" >
//                                    <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
//                                </a>
//                            </li>' : '') . '
//                        ' . ((PerUser('rwaq_user_reset_password')) ? '<li>
//                                <a class="reset_password" data-id="' . $user->id . '" >
//                                    <i class="fa fa-comments-o"></i> ' . Lang::get('main.reset_password') . '
//                                </a>
//                            </li>' : '') . '
//
//
//                        </ul>
//                  </div>'
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = Country::pluck('arab_name', 'id');
        $companies = Company::pluck('name', 'id');
        return view('auth.rwaq_user.add',compact('countries','companies'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $rules=array(
            'name' => 'required',
            'email' => 'required|unique:mysql2.users,Email',
            'mobile' => 'required|unique:mysql2.users,Mobile',
            'image' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
            'type' => 'required|in:person,company',
            'country' => 'required|exists:mysql2.country,id',
            'type_of_subscribe' => 'required|in:default,annual,percourse,diplomas',
            'user_type' => 'required|in:corporate,individual',
            'facebook' => 'required',
            'linkedin' => 'required',
            'twitter' => 'required',
            'google' => 'required',
        );
        if( isset($data['type']) && $data['type']=='company'){
            $rules['company'] = 'required|exists:mysql2.companies,id';
        }
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $pic = $request->file('image');
            $picName = uploadFileToE3melbusiness($pic);
            $user = new NormalUser();
            $user->FullName = $data['name'];
            $user->Email = $data['email'];
            $user->Mobile = $data['mobile'];
            $user->password = $data['mobile'];
            $user->country = $data['country'];
            $user->type = $data['type'];
            if($data['type']=='company'){
                $user->company_id = $data['company'];
            }
            $user->type_of_subscribe = $data['type_of_subscribe'];
            $user->user_type = $data['user_type'];
            $user->facebook = $data['facebook'];
            $user->linkedin = $data['linkedin'];
            $user->twitter = $data['twitter'];
            $user->google = $data['google'];
            $user->PaymentExpirationDate = $data['payment_expiration_date'];
            $user->DemoExpirationDate = $data['demo_expiration_date'];
            //$user->published = $published;
            $user->image = $picName;
            $user->createdtime = date("Y-m-d H:i:s");
//            if ($published == 'yes') {
//                $user->published_by = Auth::user()->id;
//                $user->published_date = date("Y-m-d H:i:s");
//            }
//            if ($published == 'no') {
//                $user->unpublished_by = Auth::user()->id;
//                $user->unpublished_date = date("Y-m-d H:i:s");
//            }
            $user->lastedit_by = Auth::user()->id;
            $user->added_by = Auth::user()->id;
            $user->lastedit_date = date("Y-m-d H:i:s");
            $user->added_date = date("Y-m-d H:i:s");
            $user->rwaq = '1';
            if ($user->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.rwaq_user'));
                return Redirect::to('admin/rwaq_user/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = NormalUser::findOrFail($id);
        $countries = Country::pluck('arab_name', 'id');
        $companies = Company::pluck('name', 'id');
        $user=makeDefaultImageGeneral($user,'image');
        $user->DemoMedicalExpirationDate = date("Y-m-d", strtotime($user->DemoMedicalExpirationDate));
        return view('auth.rwaq_user.edit',compact('user','countries','companies'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $user = NormalUser::findOrFail($id);
        $rules=array(
            'name' => 'required',
            'email' => "required|unique:mysql2.users,Email,$id,id",
            'mobile' => "required|unique:mysql2.users,Mobile,$id,id",
            'type' => 'required|in:person,company',
//            'image' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
            'country' => 'required|exists:mysql2.country,id',
            'type_of_subscribe' => 'required|in:default,annual,percourse,diplomas',
            'user_type' => 'required|in:corporate,individual',
            'facebook' => 'required',
            'linkedin' => 'required',
            'twitter' => 'required',
            'google' => 'required',
        );
        if ( $request->file('image')){
            $rules['image'] = 'mimes:jpeg,jpg,png,gif|required|max:5000';
        }
        if( isset($data['type']) && $data['type']=='company'){
            $rules['company'] = 'required|exists:mysql2.companies,id';
        }
        if(PerUser('rwaq_user_show_password')){
            $rules['password'] = 'required';
        }
        $validator = Validator::make($request->all(),$rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            //$published = (isset($data['published'])) ? 'yes' : 'no';
            $user->FullName = $data['name'];
            $user->Email = $data['email'];
            $user->Mobile = $data['mobile'];
            $user->country = $data['country'];
            $user->type = $data['type'];
            $user->type_of_subscribe = $data['type_of_subscribe'];
            $user->user_type = $data['user_type'];
            if(PerUser('rwaq_user_show_password')) {
                $user->Password = $data['password'];
            }

            if($data['type']=='company'){
                $user->company_id = $data['company'];
            }
            elseif($data['type']=='person'){
                $user->company_id = 0;
            }
            if(PerUser('rwaq_user_edit_sponserid')) {
                $user->sponsorId = $data['sponsorId'];
            }

            $user->facebook = $data['facebook'];
            $user->linkedin = $data['linkedin'];
            $user->twitter = $data['twitter'];
            $user->google = $data['google'];
            $user->PaymentExpirationDate = $data['payment_expiration_date'];
            $user->DemoExpirationDate = $data['demo_expiration_date'];
            $user->DemoMedicalExpirationDate=date('Y-m-d H:i:s', strtotime(date("H:i:s"), strtotime( $data['demo_medical_expiration_date'])));
            if ( $request->file('image')){
                $pic = $request->file('image');
                $picName = uploadFileToE3melbusiness($pic);
                $user->image = $picName;
            }
//            if ($published == 'yes' && $user->published=='no') {
//                $user->published_by = Auth::user()->id;
//                $user->published_date = date("Y-m-d H:i:s");
//            }
//            if ($published == 'no' && $user->published=='yes') {
//                $user->unpublished_by = Auth::user()->id;
//                $user->unpublished_date = date("Y-m-d H:i:s");
//            }
//            $user->published = $published;
            $user->lastedit_by = Auth::user()->id;
            $user->lastedit_date = date("Y-m-d H:i:s");
            if ($user->save()){
                Session::flash('success', Lang::get('main.update') . Lang::get('main.rwaq_user'));
                return Redirect::to("admin/rwaq_user/$user->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $user = NormalUser::findOrFail($id);
        $user->deleted_at=date("Y-m-d H:i:s");
        $user->save();
        //$user->delete();
    }

    public function resetPassword(Request $request)
    {
        $id = $request->input('id')!==null ? $request->input('id') : null;
        $user = NormalUser::findOrFail($id);
        $user->Password=$user->Mobile;
        $user->save();
    }

//    public function publish(Request $request)
//    {
//        if ($request->ajax()) {
//            $id = $request->input('id');
//            $published = $request->input('published');
//            $user = NormalUser::findOrFail($id);
//            if ($published == 'no') {
//                $user->published = 'no';
//                $user->unpublished_by = Auth::user()->id;
//                $user->unpublished_date = date("Y-m-d H:i:s");
//            } elseif ($published == 'yes') {
//                $user->published = 'yes';
//                $user->published_by = Auth::user()->id;
//                $user->published_date = date("Y-m-d H:i:s");
//            }
//            $user->save();
//        } else {
//            return redirect(404);
//        }
//    }

    public function autoCompleteUsers(Request $request)
    {
        if($request->get('query')){
            $query=$request->get('query');
            $data = NormalUser::where('Email','LIKE', "%$query%")->take(10)->get();
            $output='<ul id="users-emails" class="dropdown-menu"
                    style="display:block; position:relative">';
            foreach ($data as $row){
                $output.='<li><a href="#">'.$row->Email.'</a></li>';
            }
            $output.='</ul>';
            echo $output;
        }
    }

    /* Start Exporting Rwaq Users */

    public function export_rwaq_users() {

        $query = "
            SELECT `users`.`id`, `users`.`FullName`,`users`.`Email`,`users`.`Mobile`,`users`.`RegisterDate`
            FROM `users` WHERE `users`.`rwaq` = '1' AND `users`.`deleted_at` IS NULL
        ";

        $result = DB::connection('mysql2')->select(DB::raw($query));

        header('Content-Type: text/csv; charset=utf-8');

        header('Content-Disposition: attachment; filename=rwaq_users_report.csv');

        $output = fopen("php://output", "w");

        fputcsv($output, array("#","Name","Email", "Mobile" ,"Register Date"));

        $x = 1;

        foreach ($result as $res) {

            fputcsv($output,[
                $res->id,
                $res->FullName,
                $res->Email,
                $res->Mobile,
                $res->RegisterDate,
            ]);

            $x++;
        }

        fclose($output);

    }

    /* End Exporting Rwaq Users */

}
