<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Page;
use Dotlogics\Grapesjs\App\Traits\EditorTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class  PagesController extends Controller
{
    use EditorTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.pages.view');
    }

    function search(Request $request)
    {
        $data = $request->input();
        $pages = Page::select('pages.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $pages = $pages->where('id', '=', $id);
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $pages = $pages->where('name', 'LIKE', "%$name%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $pages = $pages->whereBetween('created_at', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }

        $iTotalRecords = $pages->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'id';
                break;
            case 1:
                $columnName = 'name';
                break;
            case 2:
                $columnName = 'created_at';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $pages = $pages->where(function ($q) use ($search) {
                $q->where('name', 'LIKE', "%$search%")
                    ->orWhere('id', '=', $search);
            });
        }

        $pages = $pages->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($pages as $page) {
//            $page=makeDefaultImageGeneral($page,'image','ourpages/');
            $records["data"][] = [
                $page->id,
                $page->name,
                $page->created_at->format('Y-m-d H:i:s'),
               $page->status,
                '<div class="btn-group text-center" id="single-order-' . $page->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('pages_edit')) ? '<li>
                                            <a href="' . URL('admin/pages/' . $page->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                         ' . ((PerUser('pages_edit')) ? '<li>
                                            <a href="' . URL('admin/pages/' . $page->id . '/editor') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.editor') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('pages_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $page->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.pages.add_edit');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate(['name'=>'required','slug'=>'required|unique:App\Models\Page']);
        $page=Page::create(array_merge($request->only('name','slug','sort','status','type','short_description','meta_description','meta_title','meta_keywords'),['parent_id'=>$request->parent_id??0]));
        Session::flash('success', Lang::get('main.insert') . Lang::get('main.pages'));
        return Redirect::to('admin/pages/create');
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $page = Page::findOrFail($id);
        return view('auth.pages.add_edit', compact('page'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param Page $page
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Page $page)
    {
        $request->validate(['name'=>'required','slug'=>'required|unique:App\Models\Page,id,'.$page->id]);
        $page->update(array_merge($request->only('name','slug','sort','status','type','short_description','meta_description','meta_title','meta_keywords'),['parent_id'=>$request->parent_id??0]));
        Session::flash('success', Lang::get('main.update') . Lang::get('main.pages'));
        return Redirect::to("pages/$page->id/edit");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $page = Page::findOrFail($id);
        $page->delete();
    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $page = Page::findOrFail($id);
            if ($published == 'no') {
                $page->published = 'no';
                $page->unpublished_by = Auth::user()->id;
                $page->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
                $page->published = 'yes';
                $page->published_by = Auth::user()->id;
                $page->published_date = date("Y-m-d H:i:s");
            }
            $page->save();
        } else {
            return redirect(404);
        }
    }
    public function editor(Request $request, Page $page)
    {
        return $this->show_gjs_editor($request, $page);
    }
}
