<?php

namespace App\Http\Controllers\Admin;

use App\Models\AccreditationImages;
use App\Models\AccreditationPartnersCountriesCategoriesDetails;
use App\Models\packages;
use App\Models\OldUrls;
use App\Models\Package;
use Carbon\Carbon;
use Illuminate\Contracts\View\Factory;
use Illuminate\Foundation\Application;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\View\View;
use function response;

class PackagesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Application|Factory|View
     */
    public function index()
    {

        return view('auth.packages.view');
    }


    function search(Request $request)
    {
		$packages = Package::query();
        if (isset($request->id) && !empty($request->id)) {
            $id = $request->id;
            $packages =  $packages->where('id', '=', $id);
        }
        if (isset($request->name) && !empty($request->name)) {
            $name = $request->name;
            $packages = $packages->where('name', 'LIKE', "%$name%");
        }
        if (isset($request->en_name) && !empty($request->en_name)) {
            $en_name = $request->en_name;
            $packages = $packages->where('en_name', 'LIKE', "%$en_name%");
        }
        if (isset($request->code) && !empty($request->code)) {
            $code = $request->code;
            $packages = $packages->where('code', 'LIKE', "%$code%");
        }
        if (isset($request->pic) && !empty($request->pic)) {
            $pic = $request->pic;
            $packages = $packages->where('image', 'LIKE', "%$pic%");
        }
        if (isset($request->url) && !empty($request->url)) {
            $url = $request->url;
            $packages = $packages->where('url', 'LIKE', "%$url%");
        }
        if (isset($request->created_time_from) && !empty($request->created_time_from) && isset($request->created_time_to) && !empty($request->created_time_to)) {
            $created_time_from = $request->created_time_from;
            $created_time_to = $request->created_time_to;
            $packages = $packages->whereBetween('added_date', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }


        $iTotalRecords = $packages->count();
        $iDisplayLength = (int)$request->length;
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = (int)$request->start;
        $sEcho = (int)$request->draw;
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = min($iTotalRecords, $end);
        switch ($request->order[0]['column']) {
            case 0:
	        default:
                $columnName = 'id';
                break;
            case 1:
                $columnName = 'name';
                break;
            case 2:
                $columnName = 'en_name';
                break;
            case 3:
                $columnName = 'code';
                break;
            case 4:
                $columnName = 'image';
                break;
            case 5:
                $columnName = 'url';
                break;
            case 6:
                $columnName = 'added_date';
                break;

        }
        $search = $request->search['value'];
        if ($search) {
            $packages = $packages->where(function ($q) use ($search) {
                $q->where('name', 'LIKE', "%$search%")
                    ->orWhere('en_name', 'LIKE', "%$search%")
                    ->orWhere('code', 'LIKE', "%$search%")
                    ->orWhere('image', 'LIKE', "%$search%")
                    ->orWhere('description', 'LIKE', "%$search%")
                    ->orWhere('url', 'LIKE', "%$search%")
                    ->orWhere('id', '=', $search);
            });
        }

        $packages = $packages->orderBy($columnName, $request->order[0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($packages as $package) {
            $package=makeDefaultImageGeneral($package,'image');

            $records["data"][] = [
                $package->id,
                $package->name,
                $package->en_name,
                $package->code,
                '<a class="image-link" href="#image-modal" data-toggle="modal">
					<img  style="width:70%;"  src="' . assetURL($package->image) . '"></a>',
                '<a href="' . e3mURL('packages/' . $package->url) . '" target="_blank">' . $package->url . '</a>',
                $package->added_date,
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $package->id . '" type="checkbox" ' . ((!PerUser('users_active')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('users_active')) ? 'class="changeStatues"' : '') . ' ' . (($package->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $package->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $package->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('packages_edit')) ? '<li>
                                            <a href="' . URL('admin/packages/' . $package->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('packages_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $package->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($request->customActionType) && $request->customActionType === "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $request->all();
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->callback);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Application|Factory|View
     */
    public function create()
    {
	    $accreditations = AccreditationPartnersCountriesCategoriesDetails::where('place','outer')->where('type','accreditaion')->get()->pluck('title', 'id');
	    return view('auth.packages.add', compact('accreditations'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse|Response
     */
    public function store(Request $request)
    {
//		dd($request->all());
        $data = $request->input();

        $rules=[
            'name' => 'required',
            'en_name' => 'required',
            'code' => 'required',
            'image' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
            'url' => 'required|unique:mysql2.packages,url',
            'description' => 'required',
            'egy_sale_price' => 'required',
            'ksa_sale_price' => 'required',
            'egy_price' => 'required',
            'ksa_price' => 'required',
            'sort' =>'required|unique:mysql2.packages,sort'
        ];
        if ($request->file('brochure_file')) {
            $rules['brochure_file'] = 'mimes:pdf,doc,docx,xlsx,xls|max:5000';
        }
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails())
            return redirect()->back()->withErrors($validator->errors())->withInput();
        $active = (isset($request->active)) ? 'yes' : 'no';
        $pic = $request->file('image');
        $picName = uploadFileToE3melbusiness($pic);
        $packages = new Package();
        $packages->name = $request->name;
        $packages->en_name = $request->en_name;
        $packages->code = $request->code;
        $packages->egy_price = $request->egy_price;
        $packages->ksa_price = $request->ksa_price;
        $packages->description = $request->description;
        $packages->meta_description = $request->meta_description;
        $packages->sent = isset($request->sent) && !empty($request->sent) ? $request->sent : 0;
//            $packages->certificate_increment = $request->certificate_increment'];
        $packages->egy_sale_price = $request->egy_sale_price;
        $packages->ksa_sale_price = $request->ksa_sale_price;
        $packages->tool_eg_price =isset($request->tool_eg_price)?  $request->tool_eg_price:0;
        $packages->tool_ksa_price =isset($request->tool_ksa_price)?  $request->tool_ksa_price:0;
        $packages->sort = $request->sort;
        $packages->image = $picName;
        if($request->file('banner')){
            $bannerName = uploadFileToE3melbusiness($request->file('banner'),false,'packageBanners',false,false,false);
            $packages->banner = $bannerName;
        }
        if($request->file('brochure_file')){
            $brochureName = uploadFileToE3melbusiness($request->file('brochure_file'),false,'',false,false,true);
            $packages->brochure_file = $brochureName;
        }
        $packages->url = str_replace(' ','-',$request->url);
        $packages->direction = $request->direction;
        $packages->published = $active;
        if ($active == 'yes') {
            $packages->published_by = Auth::id();
            $packages->published_date = Carbon::now();
        }
        if ($active == 'no') {
            $packages->unpublished_by = Auth::id();
            $packages->unpublished_date = Carbon::now();
        }
        $packages->added_by = Auth::id();
        $packages->added_date = Carbon::now();
        $packages->lastedit_by = Auth::id();
        $packages->lastedit_date = Carbon::now();
        if ($packages->save()) {
	        if(isset($data['accreditation'])){
		        $accreditations=(array)$data['accreditation'];
		        $pivotData = array_fill(0, count($accreditations), ['type' => 'package','details_id'=>$packages->id]);
		        $syncData  = array_combine($accreditations, $pivotData);
		        $packages->Accreditation()->sync($syncData);
	        }
	        Session::flash('success', Lang::get('main.insert') . Lang::get('main.packages'));
            return Redirect::to('admin/packages/create');
        }
    }

	/**
	 * Display the specified resource.
	 *
	 * @param Package $package
	 * @return void
	 */
    public function show(Package $package)
    {
        //
    }

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param Package $package
	 * @return Factory|Application|Response|View
	 */
    public function edit(Package $package)
    {
	    $accreditations = AccreditationPartnersCountriesCategoriesDetails::where('place','outer')->where('type','accreditaion')->get()->pluck('title', 'id');
        return view('auth.packages.edit',compact('package', 'accreditations'));
    }

	/**
	 * Update the specified resource in storage.
	 *
	 * @param Request $request
	 * @param Package $package
	 * @return \Illuminate\Http\RedirectResponse|Response
	 */
    public function update(Request $request, $id)
    {
        $package = Package::find($id);
        $data = $request->input();

        $rules=[
            'name' => 'required',
            'en_name' => 'required',
            'code' => 'required',
            'url' => 'required|unique:mysql2.packages,url,'.$package->id.',id',
            'description' => 'required',
            'egy_sale_price' => 'required',
            'ksa_sale_price' => 'required',
            'egy_price' => 'required',
            'ksa_price' => 'required',
            'sort' =>'required|unique:mysql2.packages,sort,'.$package->id.',id'

        ];
        if ( $request->file('image'))
            $rules['image']='mimes:jpeg,jpg,png,gif|required|max:5000';
        if ($request->file('brochure_file'))
            $rules['brochure_file'] = 'mimes:pdf,doc,docx,xlsx,xls|max:5000';
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails())
            return redirect()->back()->withErrors($validator->errors())->withInput();
        if ( $request->file('image')){
            $pic = $request->file('image');
            $picName = uploadFileToE3melbusiness($pic);
            $package->image = $picName;
        }
        if($request->file('banner')){
            $bannerName = uploadFileToE3melbusiness($request->file('banner'),false,'packageBanners',false,false,false);
            $package->banner = $bannerName;
        } if($request->file('brochure_file')){
            $brochureName = uploadFileToE3melbusiness($request->file('brochure_file'),false,'',false,false,true);
            $package->brochure_file = $brochureName;
        }
        $published = (isset($request->active)) ? 'yes' : 'no';
        $package->name = $request->name;
        $package->en_name = $request->en_name;
        $package->code = $request->code;
        $package->egy_price = $request->egy_price;
        $package->ksa_price = $request->ksa_price;
        $package->description = $request->description;
        $package->meta_description = $request->meta_description;
	    $package->sent = isset($request->sent)? $request->sent : 0;
//            $package->certificate_increment = $request->certificate_increment'];
        $package->egy_sale_price = $request->egy_sale_price;
        $package->ksa_sale_price = $request->ksa_sale_price;
        $package->tool_eg_price =isset($request->tool_eg_price)?  $request->tool_eg_price:0;
        $package->tool_ksa_price =isset($request->tool_ksa_price)?  $request->tool_ksa_price:0;
        $package->sort = $request->sort;
        $old_url=$package->url;
        $package->url = str_replace(' ','-',$request->url);
        $package->direction = $request->direction;
        if ($published == 'yes' && $package->published=='no') {
            $package->published_by = Auth::id();
            $package->published_date = Carbon::now();
        }
        if ($published == 'no' && $package->published=='yes') {
            $package->unpublished_by = Auth::id();
            $package->unpublished_date = Carbon::now();
        }
        $package->published = $published;
        $package->lastedit_by = Auth::id();
        $package->lastedit_date = Carbon::now();
        if ($package->save()) {
            if($old_url != $package->url)
                saveOldUrl($package->id,'packages',$old_url,$package->url,Auth::id(),Carbon::now());
	        if(isset($data['accreditation'])){
		        $accreditations=(array)$data['accreditation'];
		        $pivotData = array_fill(0, count($accreditations), ['type' => 'package','details_id'=>$package->id]);
		        $syncData  = array_combine($accreditations, $pivotData);
                $package->Accreditation()->sync($syncData);
	        }
	        else{
                $package->Accreditation()->detach();
            }
			Session::flash('success', Lang::get('main.update') . Lang::get('main.packages'));
            return Redirect::to("admin/packages/$package->id/edit");
        }
    }

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param Package $package
	 * @return Response
	 */
    public function destroy($id)
    {
        $package = Package::find($id);

        try {
		    $package->delete();
	    } catch (\Exception $e) {

	    }
    }

    public function delete_file($id)
    {
        $package = Package::find($id);
        if (count($package)) {
            $package->brochure_file=null;
            $package->lastedit_by = Auth::user()->id;
            $package->lastedit_date = date("Y-m-d H:i:s");
            $package->save();
        }
    }

    public function activation(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->id;
            $active = $request->active;
            $package = Package::find($id);
            if ($active == 'no') {
                $package->published = 'no';
                $package->unpublished_by = Auth::id();
                $package->unpublished_date = Carbon::now();
            } elseif ($active == 'yes') {
                $package->published = 'yes';
                $package->published_by = Auth::id();
                $package->published_date = Carbon::now();
            }
            $package->save();
        } else {
            return redirect(404);
        }
    }
}
