<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\NewModulesQuestionsRequest;
use App\Models\Modules;
use App\Models\ModulesQuestions;
use App\Models\ModulesTrainings;
use App\Models\ModulesTrainingsQuestions;
use App\Models\NewModulesTrainings;
use App\Models\NewModulesTrainingsQuestions;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\DB;
use App\Models\NewModulesQuestionsDetails;
use Illuminate\Http\Request;
use App\Models\CurriculumQuestions;
use App\Models\CoursesCurriculum;
use App\Models\NewModulesQuestions;
use App\Models\NewModulesCourses;
use App\Models\NewModules;
use App\Models\Courses;
use App\Models\NewMba;
use App\Models\NewMbaExams;
use PhpParser\Builder;

class NewModulesQuestions2Controller extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {

        $modules=NewMba::pluck('name','id')->toArray();
        return view('auth.new_modules_questions2.view',compact('modules'));
    }

    public function getModulesQuestionsAJAX(Request $request) {
        $data = $request->input();

        $modules_questions = NewMbaExams::select('new_mba_exams.id AS exam_id','new_mba.name AS module_name', 'new_mba.partone_questions_numbers','new_mba.parttwo_questions_numbers','new_mba_exams.type AS exam_type',
            DB::raw("(SELECT COUNT(id) FROM new_mba_modules_questions WHERE new_mba_modules_questions.exam_id=new_mba_exams.id AND deleted_at IS NULL ) AS count_questions"))
            ->leftJoin('new_mba', 'new_mba.id', '=', 'new_mba_exams.module_id');

        if (isset($data['module']) && !empty($data['module'])) {
            $module = $data['module'];
            $modules_questions = $modules_questions->where('new_mba_exams.module_id', '=', "$module");
        }

        if (isset($data['exam_type']) && !empty($data['exam_type'])) {
            $exam_type = $data['exam_type'];
            $modules_questions = $modules_questions->where('new_mba_exams.type', '=', "$exam_type");
        }
        if (isset($data['question_numbers']) && !empty($data['question_numbers'])) {
            $question_numbers = $data['question_numbers'];
            $modules_questions = $modules_questions->where('new_mba.partone_questions_numbers', '=', $question_numbers)->orWhere('new_mba.parttwo_questions_numbers', '=', $question_numbers);
        }
        if (isset($data['question_count']) && !empty($data['question_count'])) {
            $question_count = $data['question_count'];
            $modules_questions = $modules_questions->where(DB::raw("(SELECT COUNT(id) FROM new_mba_modules_questions WHERE exam_id=new_mba_exams.id)"), '=', $question_count);
        }

        $iTotalRecords = $modules_questions->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'new_mba_exams.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'new_mba_exams.id';
                break;
            case 1:
                $columnName = 'new_mba.name';
                break;
            case 2:
                $columnName = 'new_mba.questions_numbers';
                break;
            case 3:
                $columnName = DB::raw("(SELECT COUNT(id) FROM new_mba_modules_questions WHERE module_id=new_mba.id AND ISNULL(deleted_at) )");
                break;
            case 4:
                $columnName = 'new_mba_exams.type';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $modules_questions = $modules_questions->where(function ($q) use ($search) {
                $q->where('new_mba.name', 'LIKE', "%$search%")
                    ->orWhere('new_mba.questions_numbers', '=', $search)
                    ->orWhere(DB::raw("(SELECT COUNT(id) FROM new_mba_modules_questions WHERE module_id=new_mba.id AND ISNULL(deleted_at) )"), '=', $search)
                      ->orWhere('new_mba_exams.type', '=', $search);
            });
        }
        $modules_questions = $modules_questions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        /*
         * Delete action
         * . ((PerUser('new_modules_questions_delete')) ? '<li>
         *                                  <a class="delete_this" data-id="' . $question->id . '" >
         *                                       <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
         *                                  </a>
          *                             </li>' : '')
         */
        foreach ($modules_questions as $question) {
            $question_numbers=0;
            if($question->exam_type=='Part One'){
                $question_numbers=$question->partone_questions_numbers;
            }elseif($question->exam_type=='Part Two'){
                $question_numbers=$question->parttwo_questions_numbers;
            }
            $records["data"][] = [
                $question->exam_id,
                $question->module_name,
                $question_numbers,
                $question->count_questions,
                $question->exam_type,
                '<div class="btn-group text-center">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('new_modules_questions_edit')) ? '<li>
                                            <a href="' . URL('admin/new_modules_questions2/' . $question->exam_id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    '  . '

                                    </ul>
                                </div>'
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        admin_activity_action( 'create', 'new_mba', '');

        $modules = NewModules::whereNotIn('id', NewModulesQuestions::groupBy('module_id')->pluck('module_id')->toArray())->get();
        if (count($modules)) {
            return view('auth.new_modules_questions2.add', compact('modules'));
        } else {
            Session::flash('error', Lang::get('main.error_no_modules_to_add_question_to_it_you_can_edit_module_only'));
            return Redirect::to('admin/new_modules_questions2');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {



        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'module_id' => 'required|not_in:0',
                'questions' => 'required',
            ));
        $validator->after(function ($validator) use ($data) {
            if (isset($data['questions'])) {
                $x = 0;
                if (isset($data['questions']['name_ar'])) {
                    foreach ($data['questions']['name_ar'] as $name) {
                        if (Input::hasFile('image.' . $x)) {
                            $valid = Validator::make($request->all(), array(
                                'image.' . $x => 'required|mimes:jpeg,bmp,png'
                            ));
                            if ($valid->fails()) {
                                $validator->errors()->add('image_' . $x, Lang::get('main.please_upload_correct_image'));
                            }
                        }
                        if (empty($name)) {
                            $validator->errors()->add('error_exams_question_name_ar_' . ($x + 1), Lang::get('main.error_exams_question_name_ar') . ($x + 1));
                        }
                        if (isset($data['questions']['type'][$x])) {
                            if ($data['questions']['type'][$x] == 'true_false' && !isset($data['questions']['answers'][$x])) {
                                $validator->errors()->add('error_exams_enter_answers_of_question' . ($x + 1), Lang::get('main.error_exams_enter_answers_of_question') . ($x + 1));
                            }
                            if ($data['questions']['type'][$x] != 'true_false') {
                                $countAnswersAR = 0;
                                $countAnswersEN = 0;
                                if (isset($data['questions_ar']['answers'][$x])) {
                                    foreach ($data['questions_ar']['answers'][$x] as $answer) {
                                        if (!empty($answer)) {
                                            $countAnswersAR++;
                                        }
                                    }
                                } else {
                                    $validator->errors()->add('error_exams_enter_answers_of_question_' . ($x + 1), Lang::get('main.error_exams_enter_answers_of_question') . ($x + 1));
                                }
                                if (isset($data['questions_en']['answers'][$x])) {
                                    foreach ($data['questions_en']['answers'][$x] as $answer) {
                                        if (!empty($answer)) {
                                            $countAnswersEN++;
                                        }
                                    }
                                } else {

                                    $validator->errors()->add('error_exams_enter_answers_of_question_' . ($x + 1), Lang::get('main.error_exams_enter_answers_of_question') . ($x + 1));
                                }
                                if ($countAnswersAR < 2) {
                                    $validator->errors()->add('error_exams_question_answer_at_less', Lang::get('main.error_exams_question_answer_at_less'));
                                }
                                if ($countAnswersEN < 2) {
                                    $validator->errors()->add('error_exams_question_answer_at_less', Lang::get('main.error_exams_question_answer_at_less'));
                                }
                                if (($data['questions']['type'][$x] == 'chose_single'|| $data['questions']['type'][$x] =='chose_single_with_images' ) && !isset($data['chose_question_answer'][$x])) {
                                    $validator->errors()->add('error_exams_select_answer_of_question_' . ($x + 1), Lang::get('main.error_exams_select_answer_of_question') . ($x + 1));
                                }
                                if ($data['questions']['type'][$x] == 'chose_multiple' || $data['questions']['type'][$x] == 'chose_multiple_with_images' ) {
                                    if (!isset($data['chose_question_answer'][$x])) {
                                        $validator->errors()->add('error_exams_select_answer_of_question_' . ($x + 1), Lang::get('main.error_exams_select_answer_of_question') . ($x + 1));
                                    }
                                    $t = 0;
                                    foreach ($data['chose_question_answer'][$x] as $a) {
                                        $t++;
                                    }
                                    if ($t <= 1) {
                                        $validator->errors()->add('error_exams_select_answer_of_question_at_less_' . ($x + 1), Lang::get('main.error_exams_select_answer_of_question_at_less') . ($x + 1));
                                    }
                                }
                            }
                        } else {
                            $validator->errors()->add('error_exams_enter_type_of_question_' . ($x + 1), Lang::get('main.error_exams_enter_type_of_question') . ($x + 1));
                        }
                        $x++;
                    }
                } else {
                    $validator->errors()->add('error_exams_enter_question_name_ar', Lang::get('main.error_exams_enter_question_name'));
                }
//                if (isset($data['questions']['name_en'])) {
//                    foreach ($data['questions']['name_en'] as $name) {
//                        if (Input::hasFile('image.' . $x)) {
//                            $valid = Validator::make($request->all(), array(
//                                'image.' . $x => 'required|mimes:jpeg,bmp,png'
//                            ));
//                            if ($valid->fails()) {
//                                $validator->errors()->add('image_' . $x, Lang::get('main.please_upload_correct_image'));
//                            }
//                        }
//                        if (empty($name)) {
//                            $validator->errors()->add('error_exams_question_name_en_' . ($x + 1), Lang::get('main.error_exams_question_name_en') . ($x + 1));
//                        }
//                        $x++;
//                    }
//                } else {
//                    $validator->errors()->add('error_exams_enter_question_name_en', Lang::get('main.error_exams_enter_question_name'));
//                }

            }

        });
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $x = 0;
            foreach ($data['questions']['name_ar'] as $name) {
                $type = $data['questions']['type'][$x];
                $part = $data['questions']['part'][$x];
                $answers_ar = isset($data['questions_ar']['answers'][$x]) ? $data['questions_ar']['answers'][$x] : null;
                $answers_en = isset($data['questions_en']['answers'][$x]) ? $data['questions_en']['answers'][$x] : null;
                $answers = (isset($data['questions']['answers'][$x])) ? $data['questions']['answers'][$x] : null;
                $images_answers=(isset($data['questions']['images_answers'][$x])) ?$data['questions']['images_answers'][$x]: null;
                $modules_questions = new NewModulesQuestions();
                $modules_questions->module_id = $data['module_id'];
                $modules_questions->type = $type;
                $modules_questions->exam_id = $part;
                $modules_questions->name_ar = $data['questions']['name_ar'][$x];
                $modules_questions->name_en = $data['questions']['name_en'][$x];
                $modules_questions->difficulty_type = $data['questions']['difficulty_type'][$x];
                if (Input::hasFile('image.' . $x)) {
                    $image = $request->file('image.' . $x);
                    $fileImage = uploadFileToE3melbusiness($image,false, 'exams_question');
                    $modules_questions->image = $fileImage;
                }

                $modules_questions->save();

                switch ($type) {
                    case'true_false':
                        $modules_questions_details = new NewModulesQuestionsDetails();
                        $modules_questions_details->question_id = $modules_questions->id;
                        $modules_questions_details->answer = $answers;
                        $modules_questions_details->save();
                        break;
                    case'chose_single':
                        for ($y = 0; $y < 4; $y++) {
                            $answer = (isset($data['chose_question_answer'][$x]) && $data['chose_question_answer'][$x] == ($y + 1)) ? 1 : 0;
                            if (!empty($answers_ar[$y]) && !empty($answers_en[$y])) {
                                $modules_questions_details = new NewModulesQuestionsDetails();
                                $modules_questions_details->question_id = $modules_questions->id;
                                $modules_questions_details->name_ar = $answers_ar[$y];
                                $modules_questions_details->name_en = $answers_en[$y];
                                $modules_questions_details->answer = $answer;
                                $modules_questions_details->save();
                            }
                        }
                        break;
                    case'chose_multiple':
                        for ($y = 0; $y < 4; $y++) {
                            $answer = (isset($data['chose_question_answer'][$x][$y])) ? 1 : 0;
                            if (!empty($answers_ar[$y]) && !empty($answers_en[$y])) {
                                $modules_questions_details = new NewModulesQuestionsDetails();
                                $modules_questions_details->question_id = $modules_questions->id;
                                $modules_questions_details->name_ar = $answers_ar[$y];
                                $modules_questions_details->name_en = $answers_en[$y];
                                $modules_questions_details->answer = $answer;
                                $modules_questions_details->save();
                            }
                        }

                        break;
                    case 'chose_single_with_images':
                        for ($y=0;$y<4;$y++) {
                            if(isset($answers[$y])){
                                $nameD=$answers[$y];
                            } elseif(isset($images_answers[$y])){
                                $nameD=$images_answers[$y];
                            } else {
                                $nameD='';
                            }
                            //$nameD=isset($answers[$y])?$answers[$y]:'';
                            if(!empty($nameD)) {
                                $answer=(isset($data['chose_question_answer'][$x])&&$data['chose_question_answer'][$x]==($y+1))?1:0;
                                $modules_questions_details = new NewModulesQuestionsDetails();
                                $modules_questions_details->question_id = $modules_questions->id;
                                if(isset($images_answers[$y])) {
                                    $img_name = $images_answers[$y];
                                    $modules_questions_details->image = $img_name;
                                } elseif(isset($answers[$y])) {
                                    $img = $answers[$y];
                                    $img_name = uploadFileToE3melbusiness($img);
                                    $modules_questions_details->image = $img_name;
                                }

                                $modules_questions_details->name_ar = '';
                                $modules_questions_details->name_en = '';
                                $modules_questions_details->answer = $answer;
                                $modules_questions_details->save();
                            }
                        }
                        break;
                    case 'chose_multiple_with_images':
                        for( $y=0;$y<4;$y++ ) {
                            $answer=(isset($data['chose_question_answer'][$x][$y]))?1:0;
                            if(isset($answers[$y])) {
                                $nameD=$answers[$y];
                            } elseif(isset($images_answers[$y])) {
                                $nameD=$images_answers[$y];
                            } else {
                                $nameD='';
                            }
                            //$nameD=isset($answers)?$answers[$y]:'';
                            if(!empty($nameD)) {
                                $modules_questions_details = new NewModulesQuestionsDetails();
                                $modules_questions_details->question_id = $modules_questions->id;
                                if(isset($images_answers[$y])) {
                                    $img_name = $images_answers[$y];
                                    $modules_questions_details->image = $img_name;
                                } elseif(isset($answers[$y])) {
                                    $img = $answers[$y];
                                    $img_name = uploadFileToE3melbusiness($img);
                                    $modules_questions_details->image = $img_name;
                                }

                                $modules_questions_details->name_ar = '';
                                $modules_questions_details->name_en = '';
                                $modules_questions_details->answer = $answer;
                                $modules_questions_details->save();
                            }
                        }
                        break;
                }
                $x++;
            }
            Session::flash('success', Lang::get('main.insert') . Lang::get('main.new_modules_questions'));
            return Redirect::to('admin/new_modules_questions2');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
     public function show($type, $id) {
         switch ($type) {
             case 'true_false':
                 $returnHTML = view('auth.new_modules_questions2.new_questions.true_false')->render();
                 return response()->json(['html'=>$returnHTML], 200);
                 break;
                 case 'chose_single':
                     $returnHTML = view('auth.new_modules_questions2.new_questions.chose_single')->render();
                     return response()->json(['html'=>$returnHTML], 200);
                     break;
                 case 'chose_multiple':
                     $returnHTML = view('auth.new_modules_questions2.new_questions.chose_multiple')->render();
                     return response()->json(['html'=>$returnHTML], 200);
                     break;
             case 'chose_single_with_images':
                 $returnHTML = view('auth.new_modules_questions2.new_questions.chose_single_with_images')->render();
                 return response()->json(['html'=>$returnHTML], 200);
                 break;
             case 'chose_multiple_with_images':
                 $returnHTML = view('auth.new_modules_questions2.new_questions.chose_multiple_with_images')->render();
                 return response()->json(['html'=>$returnHTML], 200);
                 break;
             default:
                 // code...
                 break;
         }
     }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
        $allModules = NewModules::all();
        $allMbaModules = Modules::all();
        $courses = Courses::get();
        $modules = NewMbaExams::find($id);
        //dd($modules->module_id);
        $module_info = NewModules::where("id","=", $modules->module_id)->first();
        $module_lang = $module_info->module_questions_language;
        $allTrainings = NewModulesTrainings::select('new_mba_modules_trainings.*','courses.name As course_name')->leftjoin('courses','new_mba_modules_trainings.course_id','courses.id')->get();
        $allMbaTrainings = ModulesTrainings::select('modules_trainings.*','courses.name As course_name')->leftjoin('courses','modules_trainings.course_id','courses.id')->get();
        $modules_exam_types = NewMbaExams::all();
        if (count($modules)) {
            $modules_questions = NewModulesQuestions::where([
                ["module_id","=",$modules->module_id],
                ["exam_id","=",$modules->id]
            ])->get();
            return view('auth.new_modules_questions2.edit', compact('modules', 'modules_questions', 'allModules','allMbaModules','modules_exam_types','courses','allTrainings','allMbaTrainings','module_lang'));
        } else {
            return abort(404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(NewModulesQuestionsRequest $request, $id) {
        admin_activity_action( 'update', 'new_mba', $id);

        $Question_id = $request->input('edit');
        $data = $request->input();
        $modules_question = NewModulesQuestions::find($Question_id);
        if(!count($modules_question)) {
            $modules_question = new NewModulesQuestions();
        }
//        $module_exam=NewMbaExams::find($data['part']);
//        $module_exam->language=$data['language'];
//        $module_exam->save();

        $modules_question->module_id       = $id;
        $modules_question->difficulty_type = $data['difficulty'];
        $modules_question->country = $data['country'];
        $modules_question->type            = $data['type'];
        $modules_question->name_ar         = $data['question_ar'];
        $modules_question->name_en         = $data['question_ar'];
        $modules_question->exam_id        = $data['part'];
        if (Input::hasFile('image')) {
            $image = $request->file('image');
            $fileImage = uploadFileToE3melbusiness($image, false, 'exams_question');
            $modules_question->image = $fileImage;
        }
        $modules_question->save();

        switch ($data['type']) {
            case 'true_false':
                $modules_questions_details = NewModulesQuestionsDetails::where('question_id', $Question_id)->first();
                if(!count($modules_questions_details)){
                    $modules_questions_details = new NewModulesQuestionsDetails();
                }

                $modules_questions_details->question_id = $modules_question->id;
                $modules_questions_details->answer = $data['answers'];
                $modules_questions_details->save();

                break;
            case 'chose_single':
                $orders = [];
                foreach ($data['answers_text'] as $key => $answer_text) {
                    if($Question_id == null) {
                        $modules_questions_details = new NewModulesQuestionsDetails();
                    } else {
                        $modules_questions_details = NewModulesQuestionsDetails::find($key);
                        $orders[] = $key;
                    }

                    $modules_questions_details->question_id = $modules_question->id;
                    $modules_questions_details->name_ar = $answer_text;
//                    $modules_questions_details->name_en = $data['answers_text_en'][$key];
                    $modules_questions_details->name_en =  $answer_text;
                    $modules_questions_details->answer = $data['chose_single'] == $key ? 1 : 0;

                    $modules_questions_details->save();
                }
                $curriculum_question_details = NewModulesQuestionsDetails::where('question_id', $Question_id)->whereNotIn('id', $orders)->delete();

                break;
            case 'chose_multiple':
                $orders = [];
                foreach ($data['answers_text'] as $key => $answer_text) {
                    if($Question_id == null) {
                        $modules_questions_details = new NewModulesQuestionsDetails();
                    } else {
                        $modules_questions_details = NewModulesQuestionsDetails::find($key);
                        $orders[] = $key;
                    }

                    $modules_questions_details->question_id = $modules_question->id;
                    $modules_questions_details->name_ar = $answer_text;
                    $modules_questions_details->name_en = $answer_text;
//                    $modules_questions_details->name_en = $data['answers_text_en'][$key];
                    $modules_questions_details->answer = isset($data['chose_multiple'][$key]) && $data['chose_multiple'][$key] == $key ? 1 : 0;

                    $modules_questions_details->save();
                }

                $curriculum_question_details = NewModulesQuestionsDetails::where('question_id', $Question_id)->whereNotIn('id', $orders)->delete();
                break;
            case 'chose_single_with_images':
                $delete = [];
                if($request->input('answers_images_edit') != null) {
                    $x=0;
                    foreach ($request->input('answers_images_edit') as $key => $answer_image) {
                        $modules_questions_details = NewModulesQuestionsDetails::find($key);
                        $delete[] = $key;

                        $modules_questions_details->question_id = $modules_question->id;
                        $split_image = explode('images/', $answer_image);
                        $modules_questions_details->image = $split_image[1];
                        $delete[] = $split_image[1];
                        $modules_questions_details->name_ar = '';
                        $modules_questions_details->name_en = '';
                        $modules_questions_details->answer = $data['chose_single'] == $key ? 1 : 0;
                        $modules_questions_details->save();
                        $x++;
                    }
                }
                if(Input::hasFile('answers_images')) {
                    $images = Input::file('answers_images');
                    $x=0;
                    foreach ($images as $key => $answer_image) {
                        if($Question_id == null) {
                            $modules_questions_details = new NewModulesQuestionsDetails();
                            $modules_questions_details->order = $x;
                        } else {
                            $modules_questions_details = NewModulesQuestionsDetails::find($key);
                            $delete[]=$key;
                        }
                        $modules_questions_details->question_id = $modules_question->id;
                        $img = $answer_image;
                        $img_name = uploadFileToE3melbusiness($img);
                        $modules_questions_details->image = $img_name;
                        $modules_questions_details->name_ar = '';
                        $modules_questions_details->name_en = '';
                        $modules_questions_details->answer = $data['chose_single'] == $key ? 1 : 0;
                        $modules_questions_details->save();
                        $x++;
                    }
                }
                $curriculum_question_details = NewModulesQuestionsDetails::where('question_id', $Question_id)->whereNotIn('id', $delete)->delete();


                break;
            case 'chose_multiple_with_images':
                $delete = [];
                if($request->input('answers_images_edit') != null) {
                    foreach ($request->input('answers_images_edit') as $key => $answer_image) {
                        $modules_questions_details = NewModulesQuestionsDetails::find($key);
                        $delete[] = $key;
                        $modules_questions_details->question_id = $modules_question->id;
                        $split_image = explode('images/', $answer_image);
                        $modules_questions_details->image = $split_image[1];
                        $delete[] = $split_image[1];
                        $modules_questions_details->name_ar = '';
                        $modules_questions_details->name_en = '';
                        $modules_questions_details->answer = isset($data['chose_multiple'][$key]) && $data['chose_multiple'][$key] == $key ? 1 : 0;
                        $modules_questions_details->save();
                    }
                }
                if(Input::hasFile('answers_images')) {
                    $x=0;
                    foreach (Input::file('answers_images') as $key => $answer_image) {
                        if($Question_id == null) {
                            $modules_questions_details = new NewModulesQuestionsDetails();
                            $modules_questions_details->order = $x;
                        } else {
                            $modules_questions_details = NewModulesQuestionsDetails::find($key);
                            $delete[] = $key;
                        }
                        $modules_questions_details->question_id = $modules_question->id;
                        $img = $answer_image;
                        $img_name = uploadFileToE3melbusiness($img);
                        $modules_questions_details->image = $img_name;
                        $modules_questions_details->name_ar = '';
                        $modules_questions_details->name_en = '';
                        $modules_questions_details->answer = isset($data['chose_multiple'][$key]) && $data['chose_multiple'][$key] == $key ? 1 : 0;
                        $modules_questions_details->save();
                        $x++;
                    }
                }

                $curriculum_question_details = NewModulesQuestionsDetails::where('question_id', $Question_id)->whereNotIn('id', $delete)->delete();
                break;
            default:
                break;
        }

        $modules_questions = NewModulesQuestions::where('module_id', $id)->where("exam_id", $request->input("part"))->get();
        $returnHTML = view('auth.new_modules_questions2.questions.question_body')->with(['modules_questions' => $modules_questions])->render();
        return response()->json(['html'=>$returnHTML], 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id) {
        $modules_question = NewModulesQuestions::where('module_id', $id)->where('id', $request->id)->delete();
        $details  = NewModulesQuestionsDetails::where('question_id', $request->id)->get();
        foreach ($details as $key => $value) {
            $value->delete();
        }

        if($modules_question) {
            Session::flash('success', Lang::get('main.update') . Lang::get('main.courses_questions'));
        } else {
            Session::flash('error', Lang::get('main.update') . 'Something went wrong, Please Try again in a moment!');

        }
    }

    public function hide($id, Request $request) {
        admin_activity_action( 'Hide', 'new_mba_modules_questions',$request->id);
        $question = NewModulesQuestions::where('module_id', $id)->where('id', $request->id)->first();
        if($question) {
            if(is_null($question->hide_date)){
                $question->hide_date = date("Y-m-d H:i:s");
                $question->hide_by=Auth::user()->id;

                $question->save();
                return response()->json('Un hide', 200);


            }
            else{
                $question->hide_date=null;
                $question->hide_by=Auth::user()->id;
                $question->save();
                return response()->json('Hide', 200);


            }
        } else {
            Session::flash('error', Lang::get('main.hide') . 'Something went wrong, Please Try again in a moment!');
        }
    }


    public function getModuleQuestions($id,$part) {

        $modules_questions = NewModulesQuestions::
        with('NewModulesQuestionsDetails')->with('exam')
            ->whereHas('exam', function($query) use ($part){
                return $query->where('type',$part);
            })
             ->where('module_id', $id)
            ->get();
        return response()->json($modules_questions);
    }
    public function getModuleQuestionsbytype($type) {
        $modules_questions = NewModules::Join('new_mba_exams', 'new_mba_exams.module_id', '=', 'new_mba.id')->where('new_mba_exams.type','=',"$type")->get();
        return response()->json($modules_questions);
    }

    public function importModuleQuestions(Request $request) {
        dd($request->input());
    }

    public function searchModuleQuestions(Request $request) {
        $search = $request->input('contains');
        $module_id = $request->input('module_id');
        if ($search != null) {
            $modules_questions = NewModulesQuestions::where('module_id', $module_id)->where('name_ar', 'like', "%$search%")->orWhere('name_en', 'like', "%$search%")->with('NewModulesQuestionsDetails')->get();
            if ($modules_questions->isEmpty()) {
                return response()->json(Lang::get('main.no_search_result'));
            } else {
                return response()->json($modules_questions);
            }
        } else {
            $modules_questions = NewModulesQuestions::where('module_id', $module_id)->with('NewModulesQuestionsDetails')->get();
            return response()->json($modules_questions);
        }
    }

    public function fetchQuestions(Request $request) {
        if($request->import_type=='import_courses_questions'){
            $curriculum_questions = CurriculumQuestions::whereIn('id', $request->ids)->get();

        }
        elseif($request->import_type=='import_new_mba_trainings_questions'){
            $curriculum_questions = NewModulesTrainingsQuestions::whereIn('id', $request->ids)->get();
        }
        else if($request->import_type=='import_new_mba_modules_questions'){
            $curriculum_questions = NewModulesQuestions::whereIn('id', $request->ids)->get();
        }
        else if($request->import_type=='import_mba_modules_questions'){
            $curriculum_questions = ModulesQuestions::whereIn('id', $request->ids)->get();
        }
        elseif($request->import_type=='import_mba_trainings_questions'){
            $curriculum_questions = ModulesTrainingsQuestions::whereIn('id', $request->ids)->get();
        }
        foreach ($curriculum_questions as $key => $question) {

            $modules_question = new NewModulesQuestions();
            $modules_question->module_id = $request->module;
            $modules_question->type = $question->type;
            $modules_question->exam_id  = $request->part;
            $modules_question->name_ar = isset($question->name_ar) ? $question->name_ar : $question->name;
            $modules_question->name_en = $question->name_en;
            $modules_question->difficulty_type = isset($question->difficulty_type) ? $question->difficulty_type : 'easy';
            $modules_question->save();

            if($question->type == 'true_false') {
                $modules_questions_details = new NewModulesQuestionsDetails();

                $modules_questions_details->question_id = $modules_question->id;
                if($request->import_type=='import_new_mba_modules_questions'){
                    $modules_questions_details->answer =$question->NewModulesQuestionsDetails->answer;
                }
                elseif($request->import_type=='import_courses_questions'){
                    $modules_questions_details->answer =$question->CurriculumQuestionsDetails->answer;
                }
                elseif($request->import_type=='import_new_mba_trainings_questions'){
                    $modules_questions_details->answer =$question->NewModulesTrainingsQuestionsDetails->answer;
                }
                else if($request->import_type=='import_mba_modules_questions'){
                    $modules_questions_details->answer = $question->ModulesQuestionsDetails->answer;
                }
                elseif($request->import_type=='import_mba_trainings_questions'){
                    $modules_questions_details->answer =$question->ModulesTrainingsQuestionsDetails->answer;
                }
                $modules_questions_details->save();
            } else {
                if(isset($question->NewModulesQuestionsDetails)){
                    foreach ($question->NewModulesQuestionsDetails as $subkey => $answers) {
                        $modules_questions_details = new NewModulesQuestionsDetails();

                        $modules_questions_details->question_id = $modules_question->id;
                        $modules_questions_details->name_ar =$answers->name_ar;
                        $modules_questions_details->name_en = $answers->name_en;
                        $modules_questions_details->answer = $answers->answer;
                        $modules_questions_details->save();
                    }
                }
                elseif(isset($question->NewModulesTrainingsQuestionsDetails)){
                    foreach ($question->NewModulesTrainingsQuestionsDetails as $subkey => $answers) {
                        $modules_questions_details = new NewModulesQuestionsDetails();

                        $modules_questions_details->question_id = $modules_question->id;
                        $modules_questions_details->name_ar = $answers->name_ar;
                        $modules_questions_details->name_en = $answers->name_en;
                        $modules_questions_details->answer = $answers->answer;
                        $modules_questions_details->save();
                    }
                }
                elseif(isset($question->CurriculumQuestionsDetails)){
                    foreach ($question->CurriculumQuestionsDetails as $subkey => $answers) {
                        $modules_questions_details = new NewModulesQuestionsDetails();

                        $modules_questions_details->question_id = $modules_question->id;
                        $modules_questions_details->name_ar = $answers->name;
                        $modules_questions_details->name_en = $answers->name_en;
                        $modules_questions_details->answer = $answers->answer;
                        $modules_questions_details->save();
                    }
                }
                elseif(isset($question->ModulesQuestionsDetails)){
                    foreach ($question->ModulesQuestionsDetails as $subkey => $answers) {
                        $modules_questions_details = new NewModulesQuestionsDetails();

                        $modules_questions_details->question_id = $modules_question->id;
                        $modules_questions_details->name_ar = $answers->name_ar;
                        $modules_questions_details->name_en = $answers->name_en;
                        $modules_questions_details->answer = $answers->answer;
                        $modules_questions_details->save();
                    }
                }
                elseif(isset($question->ModulesTrainingsQuestionsDetails)){
                    foreach ($question->ModulesTrainingsQuestionsDetails as $subkey => $answers) {
                        $modules_questions_details = new NewModulesQuestionsDetails();

                        $modules_questions_details->question_id = $modules_question->id;
                        $modules_questions_details->name_ar = $answers->name_ar;
                        $modules_questions_details->name_en = $answers->name_en;
                        $modules_questions_details->answer = $answers->answer;
                        $modules_questions_details->save();
                    }
                }

            }
        }
        $modules_questions = NewModulesQuestions::where('module_id', $request->module)->where('exam_id','!=',Null)->get();
        $returnHTML = view('auth.new_modules_questions2.questions.question_body')->with(['modules_questions' => $modules_questions])->render();
        return response()->json(['html' => $returnHTML], 200);
    }
    public function Filter (Request $request,$id) {

        $modules = NewMbaExams::find($id);

        $module_info = NewModules::where("id","=", $modules->module_id)->first();
        $module_lang = $module_info->module_questions_language;
        $allTrainings = NewModulesTrainings::select('new_mba_modules_trainings.*','courses.name As course_name')->leftjoin('courses','new_mba_modules_trainings.course_id','courses.id')->get();
        $allMbaTrainings = ModulesTrainings::select('modules_trainings.*','courses.name As course_name')->leftjoin('courses','modules_trainings.course_id','courses.id')->get();
        $modules_exam_types = NewMbaExams::all();
        if (count($modules)) {
            $modules_questions = NewModulesQuestions::where([
                ["module_id","=",$modules->module_id],
                ["exam_id","=",$modules->id]
            ]);
            if($request->country!='')
            $modules_questions=$modules_questions->where('country',$request->country);
            if($request->difficulty!='')
            $modules_questions=$modules_questions->where('difficulty_type',$request->difficulty);
            $modules_questions=$modules_questions->get();
            return ['html'=>view('auth.new_modules_questions2.questions.question_body', compact( 'modules_questions'))->render(),'count'=>count($modules_questions)];
        } else {
            return ['html'=>'<div class="alert alert-danger">No Data found</div>','count'=>0];
        }
    }
}
