<?php

namespace App\Http\Controllers\Admin;

use App\Models\AllCategory;
use App\Models\NewMba;
use App\Models\NewMbaCategories;
use App\Models\SubCategory;
use App\Models\new_mba;
use App\Models\NewMbaCategoriesModules;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Session;

class NewMbaCategoriesModulesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->ajax()){
            return $this->search($request);
        }
        $new_mba=NewMba::pluck('name','id')->toArray();
        return view('auth.new_mba_categories_modules.view',compact('new_mba'));
    }

    function search(Request $request)
    {

        $data = $request->input();
        $new_mba_categories_modules = NewMbaCategoriesModules::join('new_mba_categories','new_mba_categories.id','=','new_mba_categories_modules.category_id')
                                ->join('new_mba','new_mba.id','=','new_mba_categories_modules.module_id')
                                ->select('new_mba_categories_modules.*','new_mba_categories.name as category_name','new_mba.name as course_name');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $new_mba_categories_modules = $new_mba_categories_modules->where('new_mba_categories_modules.id', '=', $id);
        }
        if (isset($data['category']) && !empty($data['category'])) {
            $category = $data['category'];
            $new_mba_categories_modules = $new_mba_categories_modules->where('new_mba_categories.name','LIKE', "%$category%");
        }
        if (isset($data['mba']) && !empty($data['mba'])) {
            $mba = $data['mba'];
            $new_mba_categories_modules = $new_mba_categories_modules->where('new_mba.id','=', $mba);
        }
        if (isset($data['sort']) && !empty($data['sort'])) {
            $sort = $data['sort'];
            $new_mba_categories_modules = $new_mba_categories_modules->where('new_mba_categories_modules.sort', '=', $sort);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $new_mba_categories_modules = $new_mba_categories_modules->whereBetween('new_mba_categories_modules.createtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }

        $iTotalRecords = $new_mba_categories_modules->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'new_mba_categories_modules.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'new_mba_categories_modules.id';
                break;
            case 1:
                $columnName = 'new_mba_categories.name';
                break;
            case 2:
                $columnName = 'new_mba.name';
                break;
            case 3:
                $columnName = 'new_mba_categories_modules.createtime';
                break;
            case 4:
                $columnName = 'new_mba_categories_modules.sort';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $new_mba_categories_modules = $new_mba_categories_modules->where(function ($q) use ($search) {
                $q->where('new_mba_categories_modules.id', '=', $search)
                    ->orWhere('new_mba_categories.name', 'LIKE', "%$search%")
                    ->orWhere('new_mba_categories_modules.sort', '=', $search)
                    ->orWhere('new_mba.name', 'LIKE', "%$search%");
            });
        }

        $new_mba_categories_modules = $new_mba_categories_modules->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($new_mba_categories_modules as $course_category) {
            $category_name = $course_category->category_name;
            $course_name = $course_category->course_name;
            if(PerUser('all_categories_edit') && $category_name !=''){
                $category_name= '<a target="_blank" href="' . URL('admin/all_categories/' . $course_category->category_id . '/edit') . '">' . $category_name . '</a>';
            }
            if(PerUser('new_mba_edit') && $course_name !=''){
                $course_name= '<a target="_blank" href="' . URL('admin/new_mba/' . $course_category->course_id . '/edit') . '">' . $course_name . '</a>';
            }
            $records["data"][] = [
                $course_category->id,
                $category_name,
                $course_name,
                $course_category->createtime,
                $course_category->sort,
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $course_category->id . '" type="checkbox" ' . ((!PerUser('new_mba_categories_modules_active')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('new_mba_categories_modules_active')) ? 'class="changeStatues"' : '') . ' ' . (($course_category->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-'.$course_category->id.'">
                                    <label for="checkbox-' . $course_category->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $course_category->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('new_mba_categories_modules_edit')) ? '<li>
                                            <a href="' . URL('admin/new_mba_categories_modules/' . $course_category->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('new_mba_categories_modules_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $course_category->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '

                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = NewMbaCategories::pluck('name', 'id');
        $new_mba = NewMba::pluck('name', 'id');
        return view('auth.new_mba_categories_modules.add',compact('categories','new_mba'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'category' =>'required|exists:mysql2.categories,id',
                'mba' =>'required|exists:mysql2.new_mba,id',
                'sort' =>'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $course_category = new NewMbaCategoriesModules();
            $course_category->published = $published;
            $course_category->category_id = $data['category'];
            $course_category->module_id = $data['mba'];
            $course_category->createtime = date("Y-m-d H:i:s");
            if ($published == 'yes') {
                $course_category->published_by = Auth::user()->id;
                $course_category->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $course_category->unpublished_by = Auth::user()->id;
                $course_category->unpublished_date = date("Y-m-d H:i:s");
            }
            $course_category->lastedit_by = Auth::user()->id;
            $course_category->added_by = Auth::user()->id;
            $course_category->added_date = date("Y-m-d H:i:s");
            $course_category->lastedit_date = date("Y-m-d H:i:s");
            if ($course_category->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.course_category'));
                return Redirect::to('admin/new_mba_categories_modules/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $course_category = NewMbaCategoriesModules::findOrFail($id);
        $categories = AllCategory::pluck('name', 'id');
        $new_mba = NewMba::pluck('name', 'id');
        return view('auth.new_mba_categories_modules.edit', compact('course_category','categories','new_mba'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $course_category = NewMbaCategoriesModules::findOrFail($id);
        $rules=array(
            'category' =>'required|exists:mysql2.categories,id',
            'mba' =>'required|exists:mysql2.new_mba,id',
            'sort' =>'required',
        );
        $validator = Validator::make($request->all(),$rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $course_category->category_id = $data['category'];
            $course_category->module_id = $data['mba'];
            if ($published == 'yes' && $course_category->published=='no') {
                $course_category->published_by = Auth::user()->id;
                $course_category->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $course_category->published=='yes') {
                $course_category->unpublished_by = Auth::user()->id;
                $course_category->unpublished_date = date("Y-m-d H:i:s");
            }
            $course_category->published = $published;
            $course_category->lastedit_by = Auth::user()->id;
            $course_category->lastedit_date = date("Y-m-d H:i:s");
            if ($course_category->save()){
                Session::flash('success', Lang::get('main.update') . Lang::get('main.course_category'));
                return Redirect::to("admin/new_mba_categories_modules/$course_category->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $course_category = NewMbaCategoriesModules::findOrFail($id);
        $course_category->delete();
    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $course_category = NewMbaCategoriesModules::findOrFail($id);
            if ($published == 'no') {
                $course_category->published = 'no';
                $course_category->unpublished_by = Auth::user()->id;
                $course_category->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
                $course_category->published = 'yes';
                $course_category->published_by = Auth::user()->id;
                $course_category->published_date = date("Y-m-d H:i:s");
            }
            $course_category->save();
        } else {
            return redirect(404);
        }
    }

}
