<?php

namespace App\Http\Controllers\Admin;

use App\Models\NewMbaCategories;
use App\Models\SubCategory;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Session;

class NewMbaCategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->ajax()){
            return $this->search($request);
        }
        return view('auth.new_mba_categories.view');
    }

    function search(Request $request)
    {

        $data = $request->input();
        $new_mba_categories = NewMbaCategories::select('new_mba_categories.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $new_mba_categories = $new_mba_categories->where('new_mba_categories.id', '=', $id);
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $new_mba_categories = $new_mba_categories->where('categories.name', 'LIKE', "%$name%");
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $new_mba_categories = $new_mba_categories->where('new_mba_categories.url', 'LIKE', "%$url%");
        }
//        if (isset($data['courses_count']) && !empty($data['courses_count'])) {
//            $courses_count = $data['courses_count'];
//            $new_mba_categories = $new_mba_categories->where('categories.courses_count', '=', $courses_count);
//        }
//        if (isset($data['webinar_count']) && !empty($data['webinar_count'])) {
//            $webinar_count = $data['webinar_count'];
//            $new_mba_categories = $new_mba_categories->where('categories.webinar_count', '=', $webinar_count);
//        }
//        if (isset($data['webinar_offline_count']) && !empty($data['webinar_offline_count'])) {
//            $webinar_offline_count = $data['webinar_offline_count'];
//            $new_mba_categories = $new_mba_categories->where('categories.webinar_offline_count', '=', $webinar_offline_count);
//        }
//        if (isset($data['successstories_count']) && !empty($data['successstories_count'])) {
//            $successstories_count = $data['successstories_count'];
//            $new_mba_categories = $new_mba_categories->where('categories.successstories_count', '=', $successstories_count);
//        }
//        if (isset($data['books_count']) && !empty($data['books_count'])) {
//            $books_count = $data['books_count'];
//            $new_mba_categories = $new_mba_categories->where('categories.books_count', '=', $books_count);
//        }

        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $new_mba_categories = $new_mba_categories->whereBetween('new_mba_categories.createtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }

        $iTotalRecords = $new_mba_categories->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'new_mba_categories.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'new_mba_categories.id';
                break;
            case 1:
                $columnName = 'new_mba_categories.name';
                break;
            case 2:
                $columnName = 'new_mba_categories.url';
                break;
//            case 3:
//                $columnName = 'categories.courses_count';
//                break;
//            case 4:
//                $columnName = 'categories.webinar_count';
//                break;
//            case 5:
//                $columnName = 'categories.webinar_offline_count';
//                break;
//            case 6:
//                $columnName = 'categories.successstories';
//                break;
//            case 7:
//                $columnName = 'categories.books_count';
//                break;
            case 3:
                $columnName = 'new_mba_categories.createtime';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $new_mba_categories = $new_mba_categories->where(function ($q) use ($search) {
                $q->where('new_mba_categories.name', 'LIKE', "%$search%")
                    ->orWhere('new_mba_categories.url', 'LIKE', "%$search%")
                    ->orWhere('categories.id', '=', $search);
            });
        }

        $new_mba_categories = $new_mba_categories->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($new_mba_categories as $new_mba_category) {
            $new_mba_category=makeDefaultImageGeneral($new_mba_category,'image');
            $records["data"][] = [
                $new_mba_category->id,
                $new_mba_category->name,
                '<a href="' . e3mURL('new_mba_categories/' . $new_mba_category->url) . '" target="_blank">' . $new_mba_category->url . '</a>',
//                $new_mba_category->courses_count,
//                $new_mba_category->webinar_count,
//                $new_mba_category->webinar_offline_count,
//                $new_mba_category->successstories_count,
//                $new_mba_category->books_count,
                $new_mba_category->createtime,
                '<a class="image-link" href="#image-modal" data-toggle="modal"><img width="50%" src="' . assetURL($new_mba_category->image) . '"/></a>',
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $new_mba_category->id . '" type="checkbox" ' . ((!PerUser('new_mba_categories_active')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('new_mba_categories_active')) ? 'class="changeStatues"' : '') . ' ' . (($new_mba_category->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-'.$new_mba_category->id.'">
                                    <label for="checkbox-' . $new_mba_category->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $new_mba_category->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('new_mba_categories_edit')) ? '<li>
                                            <a href="' . URL('admin/new_mba_categories/' . $new_mba_category->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('new_mba_categories_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $new_mba_category->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.new_mba_categories.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required',
                'egy_total_hours' => 'required',
                'ksa_total_hours' => 'required',
                'url' => 'required|unique:mysql2.categories,url',
                'image' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
                'sort' => 'required|numeric',
                'description' => 'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $pic = $request->file('image');
            $picName = uploadFileToE3melbusiness($pic);
            $new_mba_category = new NewMbaCategories();
            $new_mba_category->name = $data['name'];
            $new_mba_category->egy_total_hours = $data['egy_total_hours'];
            $new_mba_category->ksa_total_hours = $data['ksa_total_hours'];
            $new_mba_category->name_ar = $data['name_ar'];
            $new_mba_category->url = str_replace(' ','-',$data['url']);
            $new_mba_category->sort = $data['sort'];
            $new_mba_category->description = $data['description'];
            $new_mba_category->meta_description = $data['meta_description'];
            $new_mba_category->published = $published;
            $new_mba_category->image = $picName;
            $new_mba_category->createtime = date("Y-m-d H:i:s");
            if ($published == 'yes') {
                $new_mba_category->published_by = Auth::user()->id;
                $new_mba_category->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $new_mba_category->unpublished_by = Auth::user()->id;
                $new_mba_category->unpublished_date = date("Y-m-d H:i:s");
            }
            $new_mba_category->lastedit_by = Auth::user()->id;
            $new_mba_category->added_by = Auth::user()->id;
            $new_mba_category->added_date = date("Y-m-d H:i:s");
            $new_mba_category->lastedit_date = date("Y-m-d H:i:s");
            if ($new_mba_category->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.all_category'));
                return Redirect::to('admin/new_mba_categories/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $new_mba_category = NewMbaCategories::findOrFail($id);
        return view('auth.new_mba_categories.edit', compact('new_mba_category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));
        $new_mba_category = NewMbaCategories::findOrFail($id);
        $rules=array(
            'name' => 'required',
            'egy_total_hours' => 'required',
            'ksa_total_hours' => 'required',
            'url' => "required|unique:mysql2.categories,url,$id,id",
            'sort' => 'required|numeric',
            'description' => 'required',
        );

        if ( $request->file('image')){
            $rules['image'] = 'mimes:jpeg,jpg,png,gif|required|max:5000';
        }

        $validator = Validator::make($request->all(),$rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            if ($request->file('image')) {
                $pic = $request->file('image');
                $picName = uploadFileToE3melbusiness($pic);
                $new_mba_category->image = $picName;
            }
            $new_mba_category->name = $data['name'];
            $new_mba_category->egy_total_hours = $data['egy_total_hours'];
            $new_mba_category->ksa_total_hours = $data['ksa_total_hours'];
            $new_mba_category->name_ar = $data['name_ar'];
            $old_url=$new_mba_category->url;
            $new_mba_category->url = str_replace(' ','-',$data['url']);
            $new_mba_category->sort = $data['sort'];
            $new_mba_category->description = $data['description'];
            $new_mba_category->meta_description = $data['meta_description'];
            if ($published == 'yes' && $new_mba_category->published=='no') {
                $new_mba_category->published_by = Auth::user()->id;
                $new_mba_category->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $new_mba_category->published=='yes') {
                $new_mba_category->unpublished_by = Auth::user()->id;
                $new_mba_category->unpublished_date = date("Y-m-d H:i:s");
            }
            $new_mba_category->published = $published;
            $new_mba_category->lastedit_by = Auth::user()->id;
            $new_mba_category->lastedit_date = date("Y-m-d H:i:s");
            if ($new_mba_category->save()){
                if($old_url != $new_mba_category->url){
                    saveOldUrl($id,'categories',$old_url,$new_mba_category->url,Auth::user()->id,date("Y-m-d H:i:s"));
                }
                Session::flash('success', Lang::get('main.update') . Lang::get('main.all_category'));
                return Redirect::to("admin/new_mba_categories/$new_mba_category->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $new_mba_category = NewMbaCategories::findOrFail($id);
        $new_mba_category->delete();
    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $new_mba_category = NewMbaCategories::findOrFail($id);
            if ($published == 'no') {
                $new_mba_category->published = 'no';
                $new_mba_category->unpublished_by = Auth::user()->id;
                $new_mba_category->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
                $new_mba_category->published = 'yes';
                $new_mba_category->published_by = Auth::user()->id;
                $new_mba_category->published_date = date("Y-m-d H:i:s");
            }
            $new_mba_category->save();
        } else {
            return redirect(404);
        }
    }

    public function getSubCategoriesByCategoryId(Request $request){
        $new_mba_category=NewMbaCategories::findOrFail($request->input('category_id'));
        $sub_categories=SubCategory::where('category_id','=',$new_mba_category->id)->get();
        if($sub_categories!==null){
            $options='';
            foreach ($sub_categories as $sub_category) {
                $options.='<option value="'.$sub_category->id.'">'.$sub_category->name.'</option>';
            }
            return $options;
        }
    }
}
