<?php

namespace App\Http\Controllers\Admin;

use App\Models\AccreditationImages;
use App\Models\AllCategory;
use App\Models\NewLandingPage;
use App\Models\DeleteCourseLog;
use App\Models\Instructors;
use App\Models\NormalUser;
use App\Models\OldUrls;
use App\Models\SubCategory;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Session;

class NewLandingPageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.new_landing_page.view');
    }

    function search(Request $request)
    {

        $data = $request->input();
        $new_landing_page = NewLandingPage::select('landing_pages_content.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $new_landing_page = $new_landing_page->where('landing_pages_content.id', '=', $id);
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $new_landing_page = $new_landing_page->where('landing_pages_content.url', 'like', "%$url%");
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $new_landing_page = $new_landing_page->where('landing_pages_content.diploma_name', 'like', "%$diploma_name%");
        }
        if (isset($data['leadsource']) && !empty($data['leadsource'])) {
            $leadsource = $data['leadsource'];
            $new_landing_page = $new_landing_page->where('landing_pages_content.leadsource', '=', $leadsource);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $new_landing_page = $new_landing_page->whereBetween('landing_pages_content.created_at', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }
        $iTotalRecords = $new_landing_page->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'landing_pages_content.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'landing_pages_content.id';
                break;
            case 1:
                $columnName = 'landing_pages_content.url';
                break;
            case 2:
                $columnName = 'landing_pages_content.diploma_name';
                break;
            case 3:
                $columnName = 'instractors.leadsource';
                break;
            case 4:
                $columnName = 'instractors.published';
                break;
            case 5:
                $columnName = 'landing_pages_content.created_at';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $new_landing_page = $new_landing_page->where(function ($q) use ($search) {
                $q->where('landing_pages_content.diploma_name','LIKE',"%$search%")
                    ->orWhere('landing_pages_content.url','LIKE',"%$search%")
                    ->orWhere('landing_pages_content.leadsource','LIKE',"%$search%")
                ;

            });
        }
        $new_landing_page = $new_landing_page->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        foreach ($new_landing_page as $new_landing) {
            $records["data"][] = [
                $new_landing->id,
                $new_landing->url,
                $new_landing->diploma_name,
                $new_landing->leadsource,
                $new_landing->created_at->format('Y-m-d H:i:s'),
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $new_landing->id . '" type="checkbox" ' . ((!PerUser('new_landing_page_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('new_landing_page_publish')) ? 'class="changeStatues"' : '') . ' ' . (($new_landing->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $new_landing->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $new_landing->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('new_landing_page_edit')) ? '<li>
                                            <a href="' . URL('admin/new_landing_page/' . $new_landing->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('new_landing_page_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $new_landing->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '
                                        ' . ((PerUser('new_landing_page_preview')) ? '<li>
                                            <a href="' . ($new_landing->show_on=='medical' ? yottaURL('new_landing/' . $new_landing->url.'?preview=1') : e3mURL('new_landing_page/' . $new_landing->url.'&preview=1')) . '" target="_blank">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.preview') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('new_landing_page_reset_password')) ? '<li>
                                            <a class="reset_password" data-id="' . $new_landing->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.reset_password') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.new_landing_page.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));
        $validator = Validator::make($request->all(),array(
            'leadsource' => 'required',
            'diploma_name' => 'required',
            'right_form_content' => 'required',
            'url' => 'required|unique:mysql2.landing_pages_content,url',
        ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $new_landing = new NewLandingPage();
            $new_landing->accreditation_categories_details_ids=json_encode($request->accreditation_categories_details_ids?$request->accreditation_categories_details_ids:[]);
            $new_landing->diploma_name = $data['diploma_name'];
            $new_landing->right_form_content = $data['right_form_content'];
            $new_landing->leadsource = $data['leadsource'];
            $new_landing->meta_title = $data['meta_title'];
            $new_landing->meta_description = $data['meta_description'];
            $new_landing->meta_keywords = $data['meta_keywords'];
            $new_landing->url = str_replace(' ','-',$data['url']);
            $new_landing->published=$published;
            if ($published == 'yes') {
                $new_landing->published_by = Auth::user()->id;
                $new_landing->published_at = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $new_landing->unpublished_by = Auth::user()->id;
                $new_landing->unpublished_at = date("Y-m-d H:i:s");
            }
            $new_landing->created_by = Auth::user()->id;
            if ($new_landing->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.new_landing'));
                return Redirect::to('admin/new_landing_page/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $new_landing = NewLandingPage::select('landing_pages_content.*');
        $new_landing=$new_landing->findOrFail($id);
        return view('auth.new_landing_page.edit',compact('new_landing'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $new_landing = NewLandingPage::findOrFail($id);
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));
        $rules=array(
            'leadsource' => 'required',
            'diploma_name' => 'required',
            'right_form_content' => 'required',
            'url' => "required|unique:mysql2.landing_pages_content,url,$id,id",
        );
        $validator = Validator::make($request->all(),$rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $new_landing->accreditation_categories_details_ids=json_encode($request->accreditation_categories_details_ids?$request->accreditation_categories_details_ids:[]);
            $new_landing->diploma_name = $data['diploma_name'];
            $new_landing->right_form_content = $data['right_form_content'];
            $new_landing->leadsource = $data['leadsource'];
            $new_landing->meta_title = $data['meta_title'];
            $new_landing->meta_description = $data['meta_description'];
            $new_landing->meta_keywords = $data['meta_keywords'];
            $new_landing->url = str_replace(' ','-',$data['url']);
            if ($published == 'yes' && $new_landing->published=='no') {
                $new_landing->published_by = Auth::user()->id;
                $new_landing->published_at = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $new_landing->published=='yes') {
                $new_landing->unpublished_by = Auth::user()->id;
                $new_landing->unpublished_at = date("Y-m-d H:i:s");
            }
            $new_landing->published = $published;
            $new_landing->updated_by = Auth::user()->id;
            $new_landing->updated_at = date("Y-m-d H:i:s");
            if ($new_landing->save()){
                Session::flash('success', Lang::get('main.update') . Lang::get('main.new_landing'));
                return Redirect::to("admin/new_landing_page/$new_landing->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $new_landing = NewLandingPage::findOrFail($id);
        $old_url=$new_landing->url;
//        $new_landing->url='/';
        $new_landing->deleted_at=date("Y-m-d H:i:s");
        $new_landing->save();
        //$new_landing->delete();
    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $new_landing = NewLandingPage::findOrFail($id);
            if ($published == 'no') {
//                $new_landing->url='/';
                $new_landing->published = 'no';
                $new_landing->unpublished_by = Auth::user()->id;
                $new_landing->unpublished_at = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
//                $old_url='/';
//                $new_landing->url=$old_urls->old_url;
                $new_landing->published = 'yes';
                $new_landing->published_by = Auth::user()->id;
                $new_landing->published_at = date("Y-m-d H:i:s");
            }
            $new_landing->save();
        } else {
            return redirect(404);
        }
    }
}
