<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use App\Models\Courses;
use App\Models\CoursesCurriculum;
use App\Models\CoursesSections;
use App\Models\FuturexIntegrationCourse;
use App\Models\Instructors;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;


class FuturexIntegrationController extends Controller
{
   public function index(Request $request){

       if($request->ajax()){
           $data = $request->input();
           $courses = Courses::leftJoin('instractors', 'instractors.id' , '=','courses.instractor')
               ->leftJoin('futurex_integration_courses','futurex_integration_courses.course_id','=','courses.id')
               ->leftJoin('futurex_course_category','futurex_course_category.id','=','futurex_integration_courses.futurex_course_category_id')
               ->leftJoin('futurex_course_level','futurex_course_level.id','=','futurex_integration_courses.futurex_course_level_id')
               ->leftJoin('futurex_language','futurex_language.id','=','futurex_integration_courses.futurex_language_id')
               ->select('courses.*',
                   'futurex_course_category.name AS futurex_course_category_name',
                   'futurex_course_level.name AS futurex_course_level_name',
                   'futurex_language.name AS futurex_language_name',
                   'futurex_integration_courses.created_at',
                   'futurex_integration_courses.last_sent_at',
                   DB::raw("(SELECT Group_CONCAT(futurex_skills.name) FROM futurex_skills WHERE JSON_CONTAINS(futurex_integration_courses.futurex_skills_ids, futurex_skills.id, '$')) AS futurex_skills"),
                   DB::raw("(SELECT Group_CONCAT(futurex_tags.name) FROM futurex_tags WHERE JSON_CONTAINS(futurex_integration_courses.futurex_tags_ids, futurex_tags.id, '$')) AS futurex_tags")
               );
           if($request->not_sent){
               $courses=$courses->whereNull('futurex_integration_courses.last_sent_at');
           }
           if($request->not_completed){
               $courses=$courses->whereNull('futurex_integration_courses.id');
           }
           if(PerUser('remove_medical')){
               $courses=$courses->where('show_on','!=','medical');
           }
           if (isset($data['id']) && !empty($data['id'])) {
               $id = $data['id'];
               $courses = $courses->where('courses.id', '=', $id);
           }
           if (isset($data['course_name']) && !empty($data['course_name'])) {
               $course_name = $data['course_name'];
               $courses = $courses->where('courses.name', 'like', "%$course_name%");
           }
           if (isset($data['url']) && !empty($data['url'])) {
               $url = $data['url'];
               $courses = $courses->where('courses.url', 'like', "%$url%");
           }
           if (isset($data['futurex_category']) && !empty($data['futurex_category'])) {
               $futurex_category = $data['futurex_category'];
               $courses = $courses->where('futurex_course_category.name', 'like', "%$futurex_category%");
           }
           if (isset($data['futurex_level']) && !empty($data['futurex_level'])) {
               $futurex_level = $data['futurex_level'];
               $courses = $courses->where('futurex_course_level.name', 'like', "%$futurex_level%");
           }
           if (isset($data['futurex_language']) && !empty($data['futurex_category'])) {
               $futurex_language = $data['futurex_language'];
               $courses = $courses->where('futurex_language.name', 'like', "%$futurex_language%");
           }
           if (isset($data['futurex_skills']) && !empty($data['futurex_skills'])) {
               $futurex_skills = $data['futurex_skills'];
               $courses = $courses->whereRaw("EXISTS ( SELECT 1 FROM futurex_skills WHERE JSON_CONTAINS(futurex_integration_courses.futurex_skills_ids, futurex_skills.id, '$') AND futurex_skills.name LIKE '%$futurex_skills%' )");
           }
           if (isset($data['futurex_tags']) && !empty($data['futurex_tags'])) {
               $futurex_tags = $data['futurex_tags'];
               $courses = $courses->whereRaw("EXISTS ( SELECT 1 FROM futurex_tags WHERE JSON_CONTAINS(futurex_integration_courses.futurex_tags_ids, futurex_tags.id, '$') AND futurex_tags.name LIKE '%$futurex_tags%' )");
           }
           if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
               $created_time_from = $data['created_time_from'];
               $created_time_to = $data['created_time_to'];
               $courses = $courses->whereBetween('courses.createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
           }
//           dd(getEloquentSqlWithBindings($courses));
           $iTotalRecords = $courses->count();
           $iDisplayLength = intval($data['length']);
           $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
           $iDisplayStart = intval($data['start']);
           $sEcho = intval($data['draw']);
           $records = [];
           $records["data"] = [];
           $end = $iDisplayStart + $iDisplayLength;
           $end = $end > $iTotalRecords ? $iTotalRecords : $end;
           $columnName = 'courses.id';
           switch ($data['order'][0]['column']) {
               case 0:
                   $columnName = 'courses.id';
                   break;
               case 1:
                   $columnName = 'courses.name';
                   break;
               case 2:
                   $columnName = 'courses.url';
                   break;
               case 3:
                   $columnName = 'futurex_category.name';
                   break;
               case 4:
                   $columnName = 'futurex_level.name';
                   break;
               case 5:
                   $columnName = 'futurex_language.name';
                   break;
               case 6:
                   $columnName = DB::raw("(SELECT Group_CONCAT(futurex_skills.name) FROM futurex_skills WHERE JSON_CONTAINS(futurex_integration_courses.futurex_skills_ids, futurex_skills.id, '$'))");
                   break;
               case 7:
                   $columnName = DB::raw("SELECT Group_CONCAT(futurex_tags.name) FROM futurex_tags WHERE JSON_CONTAINS(futurex_integration_courses.futurex_tags_ids, futurex_tags.id, '$')");
                   break;
               case 8:
                   $columnName = 'futurex_integration_courses.created_at';
                   break;
               case 9:
                   $columnName = 'futurex_integration_courses.last_sent_at';
                   break;
           }

           $search = $data['search']['value'];
           if ($search) {
               $courses = $courses->where(function ($q) use ($search) {
                   $q->where('courses.name','LIKE',"%$search%")
                       ->orWhere('courses.url','LIKE',"%$search%")
                       ->orWhere('instractors.name','LIKE',"%$search%")
                       ->orWhere('courses.id', '=', $search)
                       ->orWhere('courses.en_name', 'LIKE', "%$search%")
                       ->orWhere('courses.rating', '=', $search)
                       ->orWhere('courses.rating_count', '=', $search)
                       ->orWhere('courses.view', '=', $search)
                       ->orWhere('courses.sent', '=', $search)
                       ->orWhere('courses.sort', '=', $search)
                       ->orWhere('courses.certificate_increment', '=', $search)
                       ->orWhere('courses.show_on', '=', $search);

               });
           }
           $courses = $courses->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
               ->get();
           foreach ($courses as $course) {
               $instructor_name = $course->instructor_name;
               if(PerUser('instructors_edit') && $instructor_name !=''){
                   $instructor_name= '<a target="_blank" href="' . URL('admin/instructors/' . $course->instractor . '/edit') . '">' . $instructor_name . '</a>';
               }
               $records["data"][] = [
                   $course->id,
                   '<a target="_blank" href="'.URL('admin/courses/'.$course->id.'/edit').'">'.$course->name.'</a>',
                   '<a href="' . ($course->show_on=='medical' ? yottaURL('course/' . $course->url.'?preview=1') : e3mURL('courses/' . $course->url.'&preview=1')) . '" target="_blank">' . $course->url . '</a>',
                   $course->futurex_course_category_name,
                   $course->futurex_course_level_name,
                   $course->futurex_language_name,
                   $course->futurex_skills,
                   $course->futurex_tags,
                   $course->created_at,
                   $course->last_sent_at,

                   '<div class="btn-group text-center" id="single-order-' . $course->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    <li>
                                            <a href="' . URL('admin/futurex_integration/' . $course->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <button data-id="'.$course->id.'" class="btn btn-info btn-block sendToFutcherX" style="margin-top: 10px;">Send FutcherX</button>',
               ];
           }
           if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
               $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
               $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
           }
           $records["draw"] = $sEcho;
           $records["recordsTotal"] = $iTotalRecords;
           $records["recordsFiltered"] = $iTotalRecords;
           $records['postData'] = $data;
           //return response()->json($data)->setCallback($request->input('callback'));
           return response()->json($records)->setCallback($request->input('callback'));
       }
       return view('auth.futurex_integration_courses.view');
   }
   public function edit($course_id,Request $request){
       $futurexCourse=FuturexIntegrationCourse::where('course_id',$course_id)->first();
       $course=Courses::findOrFail($course_id);
       if($request->ajax()){
           if($request->_type=='query'){
               $futurex_tags=DB::connection('mysql2')->table('futurex_tags')->select('id','name AS text');
               if($request->q){
                   $futurex_tags=$futurex_tags->where('name','LIKE',"%$request->q%");
               }
               $futurex_tags=$futurex_tags->take(50)->get();
               return response()->json(['results'=>$futurex_tags]);
           }
       }
       return view('auth.futurex_integration_courses.edit',compact('course','futurexCourse'));

   }
   public function update($course_id,Request $request){
       $dataUpdate=array_merge($request->only('futurex_course_category_id','futurex_course_level_id','futurex_language_id','futurex_skills_ids','futurex_tags_ids'),[
           'course_id'=>$course_id,
       ]);
       $futurexCourse=FuturexIntegrationCourse::where('course_id',$course_id)->first();
       if(!$futurexCourse){
           $futurexCourse=FuturexIntegrationCourse::create($dataUpdate);
       }else{
           $futurexCourse->update($dataUpdate);
       }
       $query="UPDATE `futurex_integration_courses` SET futurex_skills_ids=REPLACE(futurex_skills_ids,'\"',''),futurex_tags_ids=REPLACE(futurex_tags_ids,'\"','');";
       DB::connection('mysql2')->unprepared($query);
       $course=Courses::find($course_id);
//       createCourseInFutureX($course,$futurexCourse);
       Session::flash('success', Lang::get('main.update') . Lang::get('main.course'));
       return Redirect::to('admin/futurex_integration/'.$course_id.'/edit');
   }


   public function testUpdateCourse(){
        $course_id=862;
        $course=Courses::find($course_id);
       $futurexCourse=FuturexIntegrationCourse::where('course_id',$course_id)->first();
       createCourseInFutureX($course,$futurexCourse);
   }
   public function sendCourse(Request $request){
       $course_id=$request->course_id;
       $course=Courses::find($course_id);
       if($course->published=='yes'){
           $courseSections=CoursesSections::where('course_id',$course_id)->where('published','yes')->count();
           if($courseSections){
               $courseCurriculum=CoursesCurriculum::where('course_id',$course_id)->where('published','yes')->count();
               if($courseCurriculum){
                   $futurexCourse=FuturexIntegrationCourse::where('course_id',$course_id)->first();
                   if($futurexCourse){
                       $futurexCourse->update([
                           'last_sent_at'=>now(),
                       ]);
                       createCourseInFutureX($course,$futurexCourse);
                       return response()->json(['success'=>true,'message'=>'course send successfully']);
                   }else{
                       return response()->json(['success'=>false,'message'=>'this course not updated with futcherx data']);
                   }
               }else{
                   return response()->json(['success'=>false,'message'=>'this course not have any curriculum published']);
               }
           }else{
               return response()->json(['success'=>false,'message'=>'this course not have any sections published']);
           }
       }else{
           return response()->json(['success'=>false,'message'=>'this course is not published']);
       }
   }

}
