<?php

namespace App\Http\Controllers\Admin;

use App\Models\Instructors;
use App\Models\Encountersvideos;
use App\Models\OldUrls;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class EncountersvideosController extends Controller
{
    //  Index function

    public function index()
    {

        return view('auth.encountersvideos.view');

    }


    // Search function

    function search(Request $request)
    {

                $data = $request->input();

                // query search
                $encountersvideos = Encountersvideos::select('encounters_videos.*','instractors.name AS instructor_name','instractors.url AS instructor_url')
                ->leftJoin('instractors','encounters_videos.instractor','=','instractors.id');

                // by id
                if (isset($data['id']) && !empty($data['id'])) {
                    $id = $data['id'];
                    $encountersvideos = $encountersvideos->where('encounters_videos.id', '=', "$id");
                }

                // by name
                if (isset($data['name']) && !empty($data['name'])) {
                    $name = $data['name'];
                    $encountersvideos = $encountersvideos->where('encounters_videos.name', 'LIKE', "%$name%");
                }

                // by ceated date
                if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
                    $created_time_from = $data['created_time_from'];
                    $created_time_to = $data['created_time_to'];
                    $encountersvideos = $encountersvideos->whereBetween('encounters_videos.createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
                }

                // by instractor
                if (isset($data['instructor']) && !empty($data['instructor'])) {
                    $instructor = $data['instructor'];
                    $encountersvideos = $encountersvideos->where('instractors.name', 'LIKE', "%$instructor%");
                }

                // by location
                if (isset($data['location']) && !empty($data['location'])) {
                    $location = $data['location'];
                    $encountersvideos = $encountersvideos->where('encounters_videos.location', 'LIKE', "%$location%");
                }

                // by url
                if (isset($data['url']) && !empty($data['url'])) {
                    $url = $data['url'];
                    $encountersvideos = $encountersvideos->where('encounters_videos.url', 'LIKE', "%$url%");
                }

                 // check vars
                $iTotalRecords = $encountersvideos->count();
                $iDisplayLength = intval($data['length']);
                $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
                $iDisplayStart = intval($data['start']);
                $sEcho = intval($data['draw']);
                $records = [];
                $records["data"] = [];
                $end = $iDisplayStart + $iDisplayLength;
                $end = $end > $iTotalRecords ? $iTotalRecords : $end;
                $columnName = 'encountersvideos.id';

                 // column and order for table
                switch ($data['order'][0]['column']) {
                    case 0:
                        $columnName = 'encounters_videos.id';
                        break;
                    case 1:
                        $columnName = 'encounters_videos.name';
                        break;
                    case 2:
                        $columnName = 'instractors.name';
                        break;
                    case 3:
                        $columnName = 'encounters_videos.location';
                        break;
                    case 4:
                        $columnName = 'encounters_videos.url';
                        break;
                    case 5:
                        $columnName = 'encounters_videos.createdtime';
                        break;
                }

                $search = $data['search']['value'];


                 // search method
                if ($search) {
                    $encountersvideos = $encountersvideos->where(function ($q) use ($search) {
                          $q->where('encounters_videos.name', 'LIKE', "%$search%")
                            ->orWhere('encounters_videos.name', 'LIKE', "%$search%")
                            ->orWhere('encounters_videos.location', 'LIKE', "%$search%")
                            ->orWhere('encounters_videos.meta_description', 'LIKE', "%$search%")
                            ->orWhere('encounters_videos.description', 'LIKE', "%$search%")
                            ->orWhere('encounters_videos.id', '=', $search);
                    });
                            }

                 // data query
                    $encountersvideos = $encountersvideos->orderBy($columnName, $data['order'][0]['dir'])
                    ->skip($iDisplayStart)
                    ->take($iDisplayLength)
                    ->get();

                 // loop fetch data
            foreach ($encountersvideos as $encountersvideo) {

            $instructor_name = $encountersvideo->instructor_name;

                 // permission user
                if(PerUser('instructors_edit') && $instructor_name !=''){
                    $instructor_name= '<a target="_blank" href="' . URL('admin/instructors/' . $encountersvideo->instractor . '/edit') . '">' . $instructor_name . '</a>';
                }

                // record data
                $records["data"][] = [
                    $encountersvideo->id,
                    $encountersvideo->name,
                    $instructor_name,
                    $encountersvideo->location,
                    '<a target="_blank" href="' . e3mURL('encountersvideos/' . $encountersvideo->url) . '">' . $encountersvideo->url . '</a>',
                    $encountersvideo->createdtime,
                               '<td class="text-center">
                                    <div class="checkbox-nice checkbox-inline">
                                        <input data-id="' . $encountersvideo->id . '" type="checkbox" ' . ((!PerUser('encountersvideos_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('encountersvideos_publish')) ? 'class="changeStatues"' : '') . ' ' . (($encountersvideo->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                        <label for="checkbox-' . $encountersvideo->id . '">
                                        </label>
                                    </div>
                                </td>',
                               '<div class="btn-group text-center" id="single-order-' . $encountersvideo->id . '">
                                        <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                            <i class="fa fa-angle-down"></i>
                                        </button>
                                        <ul class="dropdown-menu pull-right">
                                        ' . ((PerUser('encountersvideos_edit')) ? '<li>
                                                <a href="' . URL('admin/encountersvideos/' . $encountersvideo->id . '/edit') . '">
                                                    <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                                </a>
                                            </li>' : '') . '
                                        ' . ((PerUser('encountersvideos_delete')) ? '<li>
                                                <a class="delete_this" data-id="' . $encountersvideo->id . '" >
                                                    <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                                </a>
                                            </li>' : '') . '


                                        </ul>
                                    </div>',
                ];
        }

                if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                    $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                    $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
                }

                $records["draw"] = $sEcho;
                $records["recordsTotal"] = $iTotalRecords;
                $records["recordsFiltered"] = $iTotalRecords;
                $records['postData'] = $data;

        return response()->json($records)->setCallback($request->input('callback'));

    }


    // create page

    public function create()
    {
        $instructors = Instructors::select('instractors.id', 'instractors.name')->get();

        return view('auth.encountersvideos.add',compact('instructors'));
    }



    // store method

    public function store(Request $request)
    {

        $data = $request->input();
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));

        // validate inputs
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required',
                'instructor' => 'required|exists:mysql2.instractors,id',
                'short_description' => 'required',
                'description' => 'required',
                'pic' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
                'url' => 'required|unique:mysql2.successtories,url',
                'meta_description' => 'required',
                'location' => 'required|in:egy,ksa',
            ));

        // insert method
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $pic = $request->file('pic');
            $picName = uploadFileToE3melbusiness($pic);
            $encountersvideos = new Encountersvideos();
            $encountersvideos->name = $data['name'];
            $encountersvideos->short_description = $data['short_description'];
            $encountersvideos->description = $data['description'];
            $encountersvideos->link = $data['v_url'];
            $encountersvideos->image = $picName;
            $encountersvideos->duetime = $data['duetime'];
            $encountersvideos->instractor = $data['instructor'];
            $encountersvideos->level = $data['level'];
            $encountersvideos->location = $data['location'];
            $encountersvideos->url = str_replace(' ','-',$data['url']);
            $encountersvideos->ispublic != $data['ispublic']?'no':'';
            $encountersvideos->meta_description = $data['meta_description'];
            $encountersvideos->createdtime = date("Y-m-d H:i:s");
            $encountersvideos->published = $published;

            if ($published == 'yes') {
                $encountersvideos->published_by = Auth::user()->id;
                $encountersvideos->published_date = date("Y-m-d H:i:s");
            }

            if ($published == 'no') {
                $encountersvideos->unpublished_by = Auth::user()->id;
                $encountersvideos->unpublished_date = date("Y-m-d H:i:s");
            }

            $encountersvideos->lastedit_by = Auth::user()->id;
            $encountersvideos->lastedit_date = date("Y-m-d H:i:s");
            $encountersvideos->added_by = Auth::user()->id;
            $encountersvideos->added_date = date("Y-m-d H:i:s");

            if ($encountersvideos->save()) {

                Session::flash('success', Lang::get('main.insert') . Lang::get('main.successtory'));

                return Redirect::to('admin/encountersvideos/create');
            }
        }
    }


    // show method

    public function show($id)
    {
        //
    }


    //edit method

    public function edit($id)
    {
        $encountersvideos = Encountersvideos::find($id);

       // dd($encountersvideos);

        $instructors = Instructors::select('instractors.id', 'instractors.name')->get();
        return view('auth.encountersvideos.edit', compact('instructors', 'encountersvideos'));
    }


    // update method

    public function update(Request $request, $id)
    {
        $data = $request->input();
        $encountersvideos = Encountersvideos::find($id);
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));

        // validation
        $rules=array(
            'name' => 'required',
            'description' => 'required',
            'instructor' => 'required|exists:mysql2.instractors,id',
            'url' => "required|unique:mysql2.successtories,url,$id,id",
            'short_description' => 'required',
            'meta_description' => 'required',
            'location' => 'required|in:egy,ksa',
        );

        if ( $request->file('pic')){
            $rules['pic']='mimes:jpeg,jpg,png,gif|required|max:5000';
        }

        $validator = Validator::make($request->all(),$rules);

        // edit method
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {

            if ( $request->file('pic')){
                $pic = $request->file('pic');
                $picName = uploadFileToE3melbusiness($pic);
                $encountersvideos->image = $picName;
            }

            $published = (isset($data['published'])) ? 'yes' : 'no';
            $encountersvideos->name = $data['name'];
            $encountersvideos->short_description = $data['short_description'];
            $encountersvideos->description = $data['description'];
            $encountersvideos->link = $data['v_url'];
            $encountersvideos->duetime = $data['duetime'];
            $encountersvideos->instractor = $data['instructor'];
            $encountersvideos->level = $data['level'];
            $encountersvideos->location = $data['location'];
            $old_url=$encountersvideos->url;
            $encountersvideos->url = str_replace(' ','-',$data['url']);
            $encountersvideos->ispublic = $data['ispublic'];
            $encountersvideos->meta_description = $data['meta_description'];

            if ($published == 'yes' && $encountersvideos->published=='no') {
                $encountersvideos->published_by = Auth::user()->id;
                $encountersvideos->published_date = date("Y-m-d H:i:s");
            }

            if ($published == 'no' && $encountersvideos->published=='yes') {
                $encountersvideos->unpublished_by = Auth::user()->id;
                $encountersvideos->unpublished_date = date("Y-m-d H:i:s");
            }

            $encountersvideos->published = $published;
            $encountersvideos->lastedit_by = Auth::user()->id;
            $encountersvideos->lastedit_date = date("Y-m-d H:i:s");
            $encountersvideos->modifiedtime = date("Y-m-d H:i:s");

            if ($encountersvideos->save()) {
                if($old_url != $encountersvideos->url){
                    saveOldUrl($id,'encountersvideos',$old_url,$encountersvideos->url,Auth::user()->id,date("Y-m-d H:i:s"));
                }
                Session::flash('success', Lang::get('main.update') . Lang::get('main.encountersvideos'));
                return Redirect::to("admin/encountersvideos/$encountersvideos->id/edit");
            }
        }
    }

     // delete method
    public function destroy($id)
    {
        $encountersvideos = Encountersvideos::find($id);
        if (count($encountersvideos)) {
            $old_url=$encountersvideos->url;
            $encountersvideos->url='/';
            $encountersvideos->save();
            if($old_url != $encountersvideos->url){
                saveOldUrl($id,'encountersvideos',$old_url,$encountersvideos->url,Auth::user()->id,date("Y-m-d H:i:s"));
            }
            $encountersvideos->delete();
            $encountersvideos->deleted_by = Auth::user()->id;
            $encountersvideos->deleted_at = date("Y-m-d H:i:s");
        }
    }

    // publish method

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $encountersvideos = Encountersvideos::find($id);
            if ($published == 'no') {
                $old_url=$encountersvideos->url;
                $encountersvideos->url='/';
                $encountersvideos->published = 'no';
                $encountersvideos->unpublished_by = Auth::user()->id;
                $encountersvideos->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
                $old_urls=OldUrls::where('table_id',$id)->where('table_name','encountersvideos')->where('new_url','/')->first();

                $old_url='/';
                $encountersvideos->url=$old_urls->old_url;
                $encountersvideos->published = 'yes';
                $encountersvideos->published_by = Auth::user()->id;
                $encountersvideos->published_date = date("Y-m-d H:i:s");
            }
            $encountersvideos->save();
            if($old_url != $encountersvideos->url){
                saveOldUrl($id,'encountersvideos',$old_url,$encountersvideos->url,Auth::user()->id,date("Y-m-d H:i:s"));
            }
        } else {
            return redirect(404);
        }
    }



}
