<?php

namespace App\Http\Controllers\Admin;

use App\Models\AllCategory;
use App\Models\EncountersvideosCategory;
use App\Models\SubCategory;
use App\Models\Encountersvideos;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Session;

class EncountersvideosCategoryController extends Controller
{

    // index method
    public function index()
    {
        return view('auth.encountersvideos_categories.view');
    }

    //search method
    function search(Request $request)
    {
        $data = $request->input();

        $encountersvideos_categories = EncountersvideosCategory::leftjoin('categories','categories.id','=','encounters_videos_categories.category_id')

            ->leftjoin('sup_categories','sup_categories.id','=','encountersvideos_categories.sup_category_id')

            ->leftjoin('encountersvideos','encountersvideos.id','=','encounters_videos_categories.encountersvideos_id')

            ->select('encounters_videos_categories.*','categories.name as category_name','sup_categories.name as

            sub_category_name','encountersvideos.name as encountersvideos_name');

        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $encountersvideos_categories = $encountersvideos_categories->where('encounters_videos_categories.id', '=', $id);
        }

        if (isset($data['category']) && !empty($data['category'])) {
            $category = $data['category'];
            $encountersvideos_categories = $encountersvideos_categories->where('categories.name','LIKE', "%$category%");
        }

        if (isset($data['sub_category']) && !empty($data['sub_category'])) {
            $sub_category = $data['sub_category'];
            $encountersvideos_categories = $encountersvideos_categories->where('sup_categories.name','LIKE', "%$sub_category%");
        }

        if (isset($data['encountersvideos']) && !empty($data['encountersvideos'])) {
            $encountersvideos = $data['encountersvideos'];
            $encountersvideos_categories = $encountersvideos_categories->where('encountersvideos.name','LIKE', "%$encountersvideos%");
        }

        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $encountersvideos_categories = $encountersvideos_categories->whereBetween('encounters_videos_categories.createtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }

        $iTotalRecords = $encountersvideos_categories->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'encounters_videos_categories.id';

        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'encounters_videos_categories.id';
                break;
            case 1:
                $columnName = 'categories.name';
                break;
            case 2:
                $columnName = 'sup_categories.name';
                break;
            case 3:
                $columnName = 'encountersvideos.name';
                break;
            case 4:
                $columnName = 'encounters_videos_categories.createtime';
                break;
        }

        $search = $data['search']['value'];

        if ($search) {
            $encountersvideos_categories = $encountersvideos_categories->where(function ($q) use ($search) {
                $q->where('encounters_videos_categories.id', '=', $search)
                    ->orWhere('categories.name', 'LIKE', "%$search%")
                    ->orWhere('sup_categories.name', 'LIKE', "%$search%")
                    ->orWhere('encountersvideos.name', 'LIKE', "%$search%");
            });
        }

        $encountersvideos_categories = $encountersvideos_categories->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($encountersvideos_categories as $encountersvideo_category) {

            $category_name = $encountersvideo_category->category_name;
            $sub_category_name = $encountersvideo_category->sub_category_name;
            $encountersvideo_name = $encountersvideo_category->encountersvideo_name;

            if(PerUser('all_categories_edit') && $category_name !=''){
                $category_name= '<a target="_blank" href="' . URL('admin/all_categories/' . $encountersvideo_category->category_id . '/edit') . '">' . $category_name . '</a>';
            }

            if(PerUser('sub_categories_edit') && $sub_category_name !=''){
                $sub_category_name= '<a target="_blank" href="' . URL('admin/sub_categories/' . $encountersvideo_category->sup_category_id . '/edit') . '">' . $sub_category_name . '</a>';
            }

            if(PerUser('encountersvideos_edit') && $encountersvideo_name !=''){
                $successtory_name= '<a target="_blank" href="' . URL('admin/encountersvideos/' . $encountersvideo_category->successtory_id . '/edit') . '">' . $encountersvideo_name . '</a>';
            }

            $records["data"][] = [
                $encountersvideo_category->id,
                $category_name,
                $sub_category_name,
                $successtory_name,
                $encountersvideo_category->createtime,

                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $encountersvideo_category->id . '" type="checkbox" ' . ((!PerUser('successtories_categories_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('successtories_categories_publish')) ? 'class="changeStatues"' : '') . ' ' . (($encountersvideo_category->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $encountersvideo_category->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $encountersvideo_category->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('successtories_categories_edit')) ? '<li>
                                            <a href="' . URL('admin/successtories_categories/' . $encountersvideo_category->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('successtories_categories_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $encountersvideo_category->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];

        }

        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    // create method
    public function create()
    {
        $categories = AllCategory::pluck('name', 'id');
        $sub_categories = SubCategory::pluck('name', 'id');
        $encountersvideos = Encountersvideos::pluck('name', 'id');
        return view('auth.encountersvideos_categories.add',compact('categories','sub_categories','encountersvideos'));
    }


    // store method
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make($request->all(),

            array(
                'category' =>'required|exists:mysql2.categories,id',
                'sub_category' =>'required|exists:mysql2.sup_categories,id',
                'encountersvideo' =>'required|exists:mysql2.successtories,id',
            ));

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {

            $published = (isset($data['published'])) ? 'yes' : 'no';
            $encountersvideo_category = new Encountersvideos();
            $encountersvideo_category->published = $published;
            $encountersvideo_category->category_id = $data['category'];
            $encountersvideo_category->sup_category_id = $data['sub_category'];
            $encountersvideo_category->successtory_id = $data['successtory'];
            $encountersvideo_category->createtime = date("Y-m-d H:i:s");

            if ($published == 'yes') {
                $encountersvideo_category->published_by = Auth::user()->id;
                $encountersvideo_category->published_date = date("Y-m-d H:i:s");
            }

            if ($published == 'no') {
                $encountersvideo_category->unpublished_by = Auth::user()->id;
                $encountersvideo_category->unpublished_date = date("Y-m-d H:i:s");
            }

            $encountersvideo_category->lastedit_by = Auth::user()->id;
            $encountersvideo_category->added_by = Auth::user()->id;
            $encountersvideo_category->lastedit_date = date("Y-m-d H:i:s");
            $encountersvideo_category->added_date = date("Y-m-d H:i:s");
            if ($encountersvideo_category->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.successtory_category'));
                return Redirect::to('admin/encountersvideos_categories/create');
            }
        }
    }


    // show method
    public function show($id)
    {
        //
    }


    //edit method
    public function edit($id)
    {
        $encountersvideo_category = EncountersvideosCategory::findOrFail($id);
        $categories = AllCategory::pluck('name', 'id');
        $sub_categories = SubCategory::where('category_id','=',$encountersvideo_category->category_id)->pluck('name', 'id');
        $encountersvideos = Encountersvideos::pluck('name', 'id');
        return view('auth.encountersvideos_categories.edit', compact('encountersvideo_category','categories','sub_categories','encountersvideos'));
    }


    // update method
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $encountersvideo_category = EncountersvideosCategory::findOrFail($id);

        $rules=array(
            'category' =>'required|exists:mysql2.categories,id',
            'sub_category' =>'required|exists:mysql2.sup_categories,id',
            'encountersvideo' =>'required|exists:mysql2.successtories,id',
        );

        $validator = Validator::make($request->all(),$rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $encountersvideo_category->category_id = $data['category'];
            $encountersvideo_category->sup_category_id = $data['sub_category'];
            $encountersvideo_category->successtory_id = $data['successtory'];

            if ($published == 'yes' && $encountersvideo_category->published=='no') {
                $encountersvideo_category->published_by = Auth::user()->id;
                $encountersvideo_category->published_date = date("Y-m-d H:i:s");
            }

            if ($published == 'no' && $encountersvideo_category->published=='yes') {
                $encountersvideo_category->unpublished_by = Auth::user()->id;
                $encountersvideo_category->unpublished_date = date("Y-m-d H:i:s");
            }

            $encountersvideo_category->published = $published;
            $encountersvideo_category->lastedit_by = Auth::user()->id;
            $encountersvideo_category->lastedit_date = date("Y-m-d H:i:s");
            if ($encountersvideo_category->save()){
                Session::flash('success', Lang::get('main.update') . Lang::get('main.successtory_category'));
                return Redirect::to("admin/encountersvideos_categories/$encountersvideo_category->id/edit");
            }
        }
    }


    // delete method
    public function destroy($id)
    {
        $encountersvideo_category = EncountersvideosCategory::findOrFail($id);
        $encountersvideo_category->delete();
    }


    // publish method
    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $encountersvideo_category = EncountersvideosCategory::findOrFail($id);

            if ($published == 'no') {
                $encountersvideo_category->published = 'no';
                $encountersvideo_category->unpublished_by = Auth::user()->id;
                $encountersvideo_category->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
                $encountersvideo_category->published = 'yes';
                $encountersvideo_category->published_by = Auth::user()->id;
                $encountersvideo_category->published_date = date("Y-m-d H:i:s");
            }

            $encountersvideo_category->save();
        } else {
            return redirect(404);
        }
    }

    // subcats method
    public function getSubCategoriesByCategoryId(Request $request){
        $category=AllCategory::findOrFail($request->input('category_id'));
        $sub_categories=SubCategory::where('category_id','=',$category->id)->get();

        if($sub_categories!==null){
            $options='';
            foreach ($sub_categories as $sub_category) {
                $options.='<option value="'.$sub_category->id.'">'.$sub_category->name.'</option>';
            }
            return $options;
        }
    }
}
