<?php

namespace App\Http\Controllers\Admin;

use App\Models\DBAUsersQuestions;
use App\Http\Controllers\Controller;
use App\Models\NormalUser;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;

class DBAUsersQuestionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.dba_users_questions.view');
    }


    function search(Request $request)
    {
        $data = $request->input();
        $users_questions = DBAUsersQuestions::select('dba_users_questions.*','users.FullName AS user_name')
            ->leftJoin('users', 'users.id', '=', 'dba_users_questions.user_id');

        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $users_questions = $users_questions->where('dba_users_questions.id', '=', $id);
        }

        if (isset($data['user_name']) && !empty($data['user_name'])) {
            $user_name = $data['user_name'];
            $users_questions = $users_questions->where('users.FullName','LIKE' ,"%$user_name%");
        }

        if (isset($data['user_id']) && !empty($data['user_id'])) {
            $user_id = $data['user_id'];
            $users_questions = $users_questions->where('dba_users_questions.user_id',"$user_id");
        }
        if (isset($data['question']) && !empty($data['question'])) {
            $question = $data['question'];
            $users_questions = $users_questions->where('dba_users_questions.question', 'LIKE', "%$question%");
        }
        if (isset($data['answer']) && !empty($data['answer'])) {
            $answer = $data['answer'];
            $users_questions = $users_questions->where('dba_users_questions.answer', 'LIKE', "%$answer%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $users_questions = $users_questions->whereBetween('dba_users_questions.createtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }

        $iTotalRecords = $users_questions->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'dba_users_questions.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'dba_users_questions.id';
                break;
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'dba_users_questions.user_id';
                break;
            case 3:
                $columnName = 'dba_users_questions.question';
                break;
            case 4:
                $columnName = 'dba_users_questions.answer';
                break;
            case 5:
                $columnName = 'dba_users_questions.createtime';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $users_questions = $users_questions->where(function ($q) use ($search) {
                $q->where('dba_users_questions.id', '=', $search)
                    ->orWhere('users.FullName', 'Like', "%$search%")
                    ->orWhere('dba_users_questions.user_id', 'Like', "%$search%")
                    ->orWhere('dba_users_questions.answer', 'Like', "%$search%")
                    ->orWhere('dba_users_questions.question', 'Like', "%$search%");
            });
        }

        $users_questions = $users_questions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($users_questions as $question) {
            $records["data"][] = [
                $question->id,
                $question->user_name,
                $question->user_id,
                $question->question,
                $question->answer,
                $question->createtime,
                '<div class="btn-group text-center" id="single-order-' . $question->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('dba_users_questions_edit')) ? '<li>
                                            <a href="' . URL('admin/dba_users_questions/' . $question->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '

                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $question = DBAUsersQuestions::find($id);
        $user = NormalUser::find($question->user_id);
        return view('auth.dba_users_questions.edit',compact('question','user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $question = DBAUsersQuestions::findOrFail($id);
        $rules = array(
            'answer' => 'required',
        );
        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $question->answer = $data['answer'];
            $question->answer_date = date("Y-m-d H:i:s");
            if ($question->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.dba_users_questions'));
                return Redirect::to("admin/dba_users_questions/$question->id/edit");
            }
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

}

