<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\NewMba;
use App\Models\NewModulesProjects;
use App\Models\DBAUsersDoctorFiles;
use App\Models\NewModulesUsersSummary;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class DBAUsersDoctorFilesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.dba_users_doctor_files.view');
    }

    function search(Request $request)
    {

        $data = $request->input();
        $dba_users_doctor_files = DBAUsersDoctorFiles::select('dba_users_doctor_files.*', 'users.FullName AS user_name', 'users.Email AS user_email', 'users.Mobile AS user_phone')

            ->leftJoin('users', 'dba_users_doctor_files.user_id', '=', 'users.id');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $dba_users_doctor_files = $dba_users_doctor_files->where('dba_users_doctor_files.id', '=', "$id");
        }
        if (isset($data['project_status']) && !empty($data['project_status'])&& $data['project_status']!='empty') {
            $project_status = $data['project_status'];
            $dba_users_doctor_files = $dba_users_doctor_files->where('dba_users_doctor_files.approved', "$project_status");
        }
        if (isset($data['project_status']) && $data['project_status']=='empty') {
            $dba_users_doctor_files = $dba_users_doctor_files->where('dba_users_doctor_files.result', Null)->where('dba_users_doctor_files.approved',Null);
        }
        if (isset($data['user_name']) && !empty($data['user_name'])) {
            $user_name = $data['user_name'];
            $dba_users_doctor_files = $dba_users_doctor_files->where('users.FullName', 'LIKE', "%$user_name%");
        }
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $user_email = $data['user_email'];
            $dba_users_doctor_files = $dba_users_doctor_files->where('users.Email', 'LIKE', "%$user_email%");
        }
        if (isset($data['user_phone']) && !empty($data['user_phone'])) {
            $user_phone = $data['user_phone'];
            $dba_users_doctor_files = $dba_users_doctor_files->where('users.Mobile', 'LIKE', "%$user_phone%");
        }
        if (isset($data['file']) && !empty($data['file'])) {
            $file = $data['file'];
            $dba_users_doctor_files = $dba_users_doctor_files->where('dba_users_doctor_files.file', 'LIKE', "%$file%");
        }
        if (isset($data['result']) && !empty($data['result'])) {
            $result = $data['result'];
            $dba_users_doctor_files = $dba_users_doctor_files->where('dba_users_doctor_files.result', '=', $result);
        }
        if (isset($data['status_date_from']) && !empty($data['status_date_from']) && isset($data['status_date_to']) && !empty($data['status_date_to'])) {
            $status_date_from = $data['status_date_from'];
            $status_date_to = $data['status_date_to'];
            $dba_users_doctor_files = $dba_users_doctor_files->whereBetween('dba_users_doctor_files.approved_date', [$status_date_from, $status_date_to]);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $dba_users_doctor_files = $dba_users_doctor_files->whereBetween('dba_users_doctor_files.createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }


        $iTotalRecords = $dba_users_doctor_files->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'dba_users_doctor_files.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'dba_users_doctor_files.id';
                break;
            /*case 3:
                $columnName = 'users.FullName';
                break;*/
            case 1:
                $columnName = 'users.Email';
                break;
          /*  case 5:
                $columnName = 'users.Mobile';
                break;*/
            case 2:
                $columnName = 'dba_users_doctor_files.file';
                break;
            case 3:
                $columnName = 'dba_users_doctor_files.result';
                break;
            case 4:
                $columnName = 'dba_users_doctor_files.approved';
                break;
            /*case 7:
                $columnName = 'dba_users_doctor_files.approved_date';
                break;*/
            case 5:
                $columnName = 'dba_users_doctor_files.createdtime';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $dba_users_doctor_files = $dba_users_doctor_files->where(function ($q) use ($search) {
                $q->where('users.FullName', 'LIKE', "%$search%")
                    ->orWhere('users.Email', 'LIKE', "%$search%")
                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
                    ->orWhere('dba_users_doctor_files.approved', 'LIKE', "%$search%")
                    ->orWhere('dba_users_doctor_files.file', 'LIKE', "%$search%")
                    ->orWhere('dba_users_doctor_files.result', 'LIKE', "%$search%")
                    ->orWhere('dba_users_doctor_files.id', '=', $search);
            });
        }

        $dba_users_doctor_files = $dba_users_doctor_files->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($dba_users_doctor_files as $project) {
            $records["data"][] = [
                '<span '.(($project->has_another)?'class="has_another"':'').'>'.$project->id.'</span>',
                //'<span '.(($project->has_another)?'class="has_another"':'').'>'.$project->user_name.'</span>',
                '<span '.(($project->has_another)?'class="has_another"':'').'>'.$project->user_email.'</span>',
                //'<span '.(($project->has_another)?'class="has_another"':'').'>'.$project->user_phone.'</span>',
                //'<span '.(($project->has_another)?'class="has_another"':'').'>'.'<a href="' . assetURL($project->file) . '">' . $project->file . '</a>'.'</span>',
                '<span '.(($project->has_another)?'class="has_another"':'').'>'.'<a href="' . URL('admin/dba_users_doctor_files/download_file/'.$project->id) . '">' . $project->file . '</a>'.'</span>',
                '<span '.(($project->has_another)?'class="has_another"':'').'>'.'<a href="javascript:;" class="editable-result editable-click" id="' . $project->id . '"data-original-title="Select result" data-type="select" data-pk="1" data-value="' . $project->result . '">' . $project->result . '</a>'.'</span>',
                '<span '.(($project->has_another)?'class="has_another"':'').'>'.'<a href="javascript:;" class="editable-project editable-click" id="' . $project->id . '" data-original-title="Select status" data-type="select" data-pk="1"  data-value="' . $project->approved . '">' . $project->approved . '</a>'.'</span>',
                //$project->approved_date,
                '<span '.(($project->has_another)?'class="has_another"':'').'>'.$project->createdtime.'</span>',
                ''
//                '<div><input type="file" class="uploadCorrection hidden" data-id="'.$project->id.'" id="uploadFile-'.$project->id.'"><button onclick="$(\'#uploadFile-'.$project->id.'\').trigger(\'click\')" class="btn btn-success">'.Lang::get('main.upload_correction').'</button></div>'.(($project->correction)?'<a target="_blank" href="'.assetURL($project->correction).'">'.$project->correction.'</a>':'')
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    // Start Edit Project Status

    public function editProjectStatus($id, Request $request) {
        $data = $request->input();
        if (isset($data['name'], $data['value'])) {
            $project_id = $data['name'];
            $project_status = $data['value'];
            $project = DBAUsersDoctorFiles::find($project_id);
            $userId = $project->user_id;
            $moduleId = $project->module_id;
            if (count($project)) {

                if($project_status == "Project Error") {
                    $project->project_error_date = date("Y-m-d H:i:s");
                    $summary = NewModulesUsersSummary::where([
                        ["user_id","=",$userId],
                        ["module_id","=",$moduleId]
                    ])->first();
                    if(count($summary)) {
                        $summary->project_upload = $summary->project_upload + 1;
                        $summary->project_error_status = '1';
                        $summary->save();
                    }
                }else {
                    $project->project_error_date = NULL;
                    $summary = NewModulesUsersSummary::where([
                        ["user_id","=",$userId],
                        ["module_id","=",$moduleId]
                    ])->first();
                    if(count($summary)) {
                        $summary->project_error_status = '0';
                        $summary->save();
                    }
                }
                $project->approved = $project_status;
                $project->approved_by=Auth::user()->id;
                $project->approved_date = date("Y-m-d H:i:s");
                $project->save();
            }
        }
    }

    // End Edit Project Status

    public function editProjectResult($id, Request $request)
    {
        $data = $request->input();
        if (isset($data['name'], $data['value'])) {
            $project_id = $data['name'];
            $project_result = $data['value'];
            $project = DBAUsersDoctorFiles::find($project_id);
            if (count($project)) {
                $project->result = $project_result;
                $project->result_by=Auth::user()->id;
                $project->result_date=date('Y-m-d H:i:s');
//                if($project_result<=50){
//                    $summary = NewModulesUsersSummary::where([
//                        ["user_id","=",$project->user_id],
//                        ["module_id","=",$project->module_id]
//                    ])->first();
//                    if(count($summary)) {
//                        $summary->project_upload = $summary->project_upload + 1;
//                        $summary->save();
//                    }
//                }
                $project->save();
            }
        }
    }
    public function uploadCorrection(Request $request){
        $validator = Validator::make($request->all(),
            array(
                'project_id' => 'required',
                'file' => 'required|mimes:pdf,doc,docx,ppt,xlsx,xls|max:15000',
            ));
        if ($validator->fails()) {
            //return redirect()->back()->withErrors($validator->errors())->withInput();
            $messsage = '<div class="alert alert-danger"><ul>';
            foreach ($validator->errors()->all() as $m) {
                $messsage .= '<li>' . $m . '</li>';
            }
            $messsage .= '</ul></div>';
            return response()->json(['message' => $messsage, 'success' => false])->setCallback($request->input('callback'));
        } else {
            $project_id=$request->project_id;
            $project = DBAUsersDoctorFiles::find($project_id);
            if(count($project)){
               /* if($project->correction){
                    if(file_exists(filePath().$project->correction)&&!empty($project->correction)){
                        unlink(filePath().$project->correction);
                    }
                }*/
                $file = $request->file('file');
                $fileName = uploadFileToE3melbusiness($file);
                $project->correction=$fileName;
                $project->correction_by=Auth::user()->id;
                $project->correction_date=date('Y-m-d H:i:s');
                $project->save();
                return response()->json(['message' => '<div class="alert alert-success">'.Lang::get('main.success_upload_correction').'</div>', 'success' => true])->setCallback($request->input('callback'));
            }else{
                return response()->json(['message' => '<div class="alert alert-danger">'.Lang::get('main.no_project_found').'</div>', 'success' => false])->setCallback($request->input('callback'));
            }

        }
    }
    public function downloadFile($id){
        $project = DBAUsersDoctorFiles::find($id);
        if(count($project)){
            if(file_exists(filePath().$project->file)){
                return Response::download(filePath().$project->file,$project->file);
            }
        }
        return abort(404);
    }
}
