<?php

namespace App\Http\Controllers\Admin;

use App\Models\Courses;
use App\Models\DBAFaq;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Session;

class DBAFaqController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.dba_faq.view');
    }

    function search(Request $request)
    {

        $data = $request->input();
        $dba_faqs = DBAFaq::select('dba_faq.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $dba_faqs = $dba_faqs->where('dba_faq.id', '=', $id);
        }
        if (isset($data['question']) && !empty($data['question'])) {
            $question = $data['question'];
            $dba_faqs = $dba_faqs->where('dba_faq.question', 'LIKE', "%$question%");
        }
        if (isset($data['answer']) && !empty($data['answer'])) {
            $answer = $data['answer'];
            $dba_faqs = $dba_faqs->where('dba_faq.answer', 'LIKE', "%$answer%");
        }

        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $dba_faqs = $dba_faqs->whereBetween('dba_faq.createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }

        $iTotalRecords = $dba_faqs->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'dba_faq.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'dba_faq.id';
                break;
            case 1:
                $columnName = 'dba_faq.question';
                break;
            case 2:
                $columnName = 'dba_faq.answer';
                break;
            case 3:
                $columnName = 'dba_faq.createdtime';
                break;

        }

        $search = $data['search']['value'];
        if ($search) {
            $dba_faqs = $dba_faqs->where(function ($q) use ($search) {
                $q->where('dba_faq.question', 'LIKE', "%$search%")
                    ->orWhere('dba_faq.answer', 'LIKE', "%$search%")
                    ->orWhere('dba_faq.id', '=', $search);
            });
        }

        $dba_faqs = $dba_faqs->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($dba_faqs as $dba_faq) {
            $records["data"][] = [
                $dba_faq->id,
                $dba_faq->question,
                $dba_faq->answer,
                $dba_faq->createdtime,
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $dba_faq->id . '" type="checkbox" ' . ((!PerUser('dba_faq_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('dba_faq_publish')) ? 'class="changeStatues"' : '') . ' ' . (($dba_faq->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $dba_faq->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $dba_faq->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('dba_faq_edit')) ? '<li>
                                            <a href="' . URL('admin/dba_faq/' . $dba_faq->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('dba_faq_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $dba_faq->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.dba_faq.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'question' => 'required',
                'answer' => 'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $dba_faq = new DBAFaq();
            $dba_faq->question = $data['question'];
            $dba_faq->answer = $data['answer'];
            $dba_faq->published = $published;
            $dba_faq->createdtime = date("Y-m-d H:i:s");
            if ($published == 'yes') {
                $dba_faq->published_by = Auth::user()->id;
                $dba_faq->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $dba_faq->unpublished_by = Auth::user()->id;
                $dba_faq->unpublished_date = date("Y-m-d H:i:s");
            }
            if ($dba_faq->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.dba_faq'));
                return Redirect::to('admin/dba_faq/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $dba_faq = DBAFaq::findOrFail($id);
        return view('auth.dba_faq.edit', compact('dba_faq'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $dba_faq = DBAFaq::findOrFail($id);
        $validator = Validator::make($request->all(),
            array(
                'question' => 'required',
                'answer' => 'required',
            ));

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $dba_faq->question = $data['question'];
            $dba_faq->answer = $data['answer'];
            if ($published == 'yes' && $dba_faq->published=='no') {
                $dba_faq->published_by = Auth::user()->id;
                $dba_faq->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $dba_faq->published=='yes') {
                $dba_faq->unpublished_by = Auth::user()->id;
                $dba_faq->unpublished_date = date("Y-m-d H:i:s");
            }
            $dba_faq->published = $published;
            if ($dba_faq->save()){
                Session::flash('success', Lang::get('main.update') . Lang::get('main.dba_faq'));
                return Redirect::to("admin/dba_faq/$dba_faq->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $dba_faq = DBAFaq::findOrFail($id);
        $dba_faq->delete();
    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $dba_faq = DBAFaq::findOrFail($id);
            if ($published == 'no') {
                $dba_faq->published = 'no';
                $dba_faq->unpublished_by = Auth::user()->id;
                $dba_faq->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
                $dba_faq->published = 'yes';
                $dba_faq->published_by = Auth::user()->id;
                $dba_faq->published_date = date("Y-m-d H:i:s");
            }
            $dba_faq->save();
        } else {
            return redirect(404);
        }
    }
}
