<?php

namespace App\Http\Controllers\Admin;

use App\Models\DBA;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class DBAController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.dba.view');
    }

    function search(Request $request)
    {

        $data = $request->input();
        $dba = DBA::select('*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $dba = $dba->where('dba.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $dba = $dba->where('dba.name', 'LIKE', "%$name%");
        }
        if (isset($data['pic']) && !empty($data['pic'])) {
            $image = $data['pic'];
            $dba = $dba->where('dba.image', 'LIKE', "%$image%");
        }
        if (isset($data['meta_title']) && !empty($data['meta_title'])) {
            $meta_title = $data['meta_title'];
            $dba = $dba->where('dba.meta_title', 'LIKE', "%$meta_title%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $dba = $dba->whereBetween('dba.createtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }


        $iTotalRecords = $dba->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'dba.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'dba.id';
                break;
            case 1:
                $columnName = 'dba.name';
                break;
            case 2:
                $columnName = 'dba.image';
                break;
            case 3:
                $columnName = 'dba.meta_title';
                break;
            case 4:
                $columnName = 'dba.createtime';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $dba = $dba->where(function ($q) use ($search) {
                $q->where('dba.name', 'LIKE', "%$search%")
                    ->orWhere('dba.image', 'LIKE', "%$search%")
                    ->orWhere('dba.meta_title', 'LIKE', "%$search%")
                    ->orWhere('dba.id', '=', $search);
            });
        }

        $dba = $dba->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        foreach ($dba as $dba_record) {
            $dba_record = makeDefaultImageGeneral($dba_record, 'image');
            $records["data"][] = [
                $dba_record->id,
                $dba_record->name,
                '<a class="image-link" href="#image-modal" data-toggle="modal"><img style="width:50%; " src="' . assetURL($dba_record->image) . '"></a>',
                $dba_record->meta_title,
                $dba_record->createtime,
                '<div class="btn-group text-center" id="single-order-' . $dba_record->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('dba_edit')) ? '<li>
                                            <a href="' . URL('admin/dba/' . $dba_record->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '

                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.dba.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $rules= array(
            'name' => 'required',
            'description' => 'required',
            'pic' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
            'banner' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
//                'intro' => 'required',
        );
        if ($request->file('brochure_file')) {
            $rules['brochure_file'] = 'mimes:pdf,doc,docx,xlsx,xls|max:5000';
        }
        $validator = Validator::make($request->all(),$rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }

        $pic = $request->file('pic');
        $picName = uploadFileToE3melbusiness($pic);
        $banner = $request->file('banner');
        $bannerName = uploadFileToE3melbusiness($banner);
        $dba = new DBA();
        $dba->name = $data['name'];
        $dba->description = $data['description'];
        $dba->meta_description = $data['meta_description'];
        $dba->meta_title = $data['meta_title'];
        $dba->intro = $data['intro'];
        $dba->image = $picName;
        $dba->banner = $bannerName;
        if($request->file('brochure_file')){
            $brochureName = uploadFileToE3melbusiness($request->file('brochure_file'),false,'',false,false,true);
            $dba->brochure_file = $brochureName;
        }
        $dba->createtime = date("Y-m-d H:i:s");
        if ($dba->save()) {
            Session::flash('success', Lang::get('main.insert') . Lang::get('main.dba'));
            return Redirect::to('admin/dba/create');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $dba_record = DBA::find($id);
        return view('auth.dba.edit', compact('dba_record'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $dba_record = DBA::find($id);
        $rules = array(
            'name' => 'required',
//            'intro' => 'required',
        );
        if ($request->file('pic')) {
            $rules['pic'] = 'mimes:jpeg,jpg,png,gif|required|max:5000';
        }
        if ($request->file('banner')) {
            $rules['banner'] = 'mimes:jpeg,jpg,png,gif|required|max:5000';
        }
        if ($request->file('doctor_file')) {
            $rules['doctor_file'] = 'mimes:pdf,doc,docx,xlsx,xls|required|max:5000';
        }
        if ($request->file('brochure_file')) {
            $rules['brochure_file'] = 'mimes:pdf,doc,docx,xlsx,xls|max:5000';
        }
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }
        if ($request->file('pic')) {
            $pic = $request->file('pic');
            $picName = uploadFileToE3melbusiness($pic);
            $dba_record->image = $picName;
        }
		if ($request->file('banner')) {
			$banner = $request->file('banner');
			$bannerName = uploadFileToE3melbusiness($banner);
			$dba_record->banner = $bannerName;
        }
        if ($request->file('doctor_file')) {
            $banner = $request->file('doctor_file');
            $bannerName = uploadFileToE3melbusiness($banner);
            $dba_record->doctor_file = $bannerName;
        }
        if($request->file('brochure_file')){
            $brochureName = uploadFileToE3melbusiness($request->file('brochure_file'),false,'',false,false,true);
            $dba_record->brochure_file = $brochureName;
        }
        $dba_record->name = $data['name'];
        $dba_record->description = $data['description'];
        $dba_record->meta_description = $data['meta_description'];
        $dba_record->meta_title = $data['meta_title'];
        $dba_record->intro = $data['intro'];
        $dba_record->doctor_file_description_download = $data['doctor_file_description_download'];
        $dba_record->doctor_file_description_upload = $data['doctor_file_description_upload'];

        if ($dba_record->save()) {

            Session::flash('success', Lang::get('main.update') . Lang::get('main.dba'));
            return Redirect::to("admin/dba/$dba_record->id/edit");
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $dba_record = DBA::find($id);
        if (count($dba_record)) {
            $dba_record->delete();
        }
    }
    public function delete_file($id)
    {
        $dba = DBA::find(1);
        if (count($dba)) {
            $dba->brochure_file=null;
            $dba->save();

        }
    }
    public function downloadFile($id){


        $file = DBA::find(1);
        if(count($file)){
            if(file_exists(filePath().$file->doctor_file)){
                return Response::download(filePath().$file->doctor_file,$file->doctor_file);
            }
        }
        return abort(404);
    }


}
