<?php

namespace App\Http\Controllers\Admin;

use App\Models\DBAChecklist;
use App\Models\DBAChecklistsUsersPlan;
use App\Models\NormalUser;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;

class DBAChecklistsUserPlanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        return view('auth.dba_checklists_user_plan.view');
    }

    public function search(Request $request)
    {
        $data = $request->input();
        $dba_checklists_user_plan = DBAChecklistsUsersPlan::leftjoin('users','users.id','=','dba_checklists_user_plan.user_id')->
        select('dba_checklists_user_plan.*','users.Email as user_email');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $dba_checklists_user_plan = $dba_checklists_user_plan->where('dba_checklists_user_plan.id', '=', $id);
        }
        if (isset($data['user']) && !empty($data['user'])) {
            $user = $data['user'];
            $transactions = $dba_checklists_user_plan->where('users.Email','LIKE', "%$user%");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $dba_checklists_user_plan = $dba_checklists_user_plan->where('dba_checklists_user_plan.name', 'LIKE', "%$name%");
        }

        $iTotalRecords = $dba_checklists_user_plan->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'dba_checklists_user_plan.id';
                break;
            case 1:
                $columnName = 'dba_checklists_user_plan.name';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
                case 3:
                $columnName = 'dba_checklists_user_plan.checked';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $dba_checklists_user_plan = $dba_checklists_user_plan->where(function ($q) use ($search) {
                $q->where('dba_checklists_user_plan.name', 'LIKE', "%$search%")
                    ->orWhere('users.Email', 'LIKE', "%$search%")
                    ->orWhere('dba_checklists_user_plan.id', '=', $search);
            });
        }
        $dba_checklists_user_plan=$dba_checklists_user_plan->groupBy('users.Email');
        $dba_checklists_user_plan = $dba_checklists_user_plan->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        foreach ($dba_checklists_user_plan as $dba_checklist) {
            $user = $dba_checklist->user_email;
            if(PerUser('normal_user_edit') && $user !=''){
                $user= '<a target="_blank" href="' . URL('admin/normal_user/' . $dba_checklist->user_id . '/edit') . '">' . $user . '</a>';
            }
            $records["data"][] = [
                $user,
                '<div class="btn-group text-center" id="single-order-' . $dba_checklist->user_id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('dba_checklists_user_plan_edit')) ? '<li>
                                            <a href="' . URL('admin/dba_checklists_user_plan/' . $dba_checklist->user_id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('dba_checklists_user_plan_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $dba_checklist->user_id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $dba_checklists=DBAChecklist::all();

        return view('auth.dba_checklists_user_plan.add',compact('dba_checklists'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'user' => 'required|exists:mysql2.users,Email',
                'checklists'=>'required'
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $dba_checklists=DBAChecklist::all();
            $user_id=NormalUser::where('Email', $data['user'])->first()->id;

            foreach ($dba_checklists as $checklist){
                $dba_checklists_user_plan=new DBAChecklistsUsersPlan();
                $dba_checklists_user_plan->name=$checklist->name;
                $dba_checklists_user_plan->checklist_id=$checklist->id;
                $dba_checklists_user_plan->checked=(in_array($checklist->id,($data['checklists'])))?1:0;
                $dba_checklists_user_plan->user_id=$user_id;
                $dba_checklists_user_plan->createtime=date("Y-m-d H:i:s");
                $dba_checklists_user_plan->save();
            }
            if($dba_checklists_user_plan->save()){
                Session::flash('success', Lang::get('main.insert').Lang::get('main.dba_checklists_user_plan'));
                return Redirect::to('admin/dba_checklists_user_plan/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($user_id)
    {
        //
        $post=DBAChecklistsUsersPlan::where('user_id',$user_id)->get();
        $user=NormalUser::where('id', $user_id)->first();
        if(count((array)$post)){
            return view('auth.dba_checklists_user_plan.edit',compact('post','user'));
        }else{
            return abort(404);
        }

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $user_id)
    {
        //
        $data=$request->input();
        $dba_checklists_user_plan= DBAChecklistsUsersPlan::where('user_id',$user_id)->get();
        if(count((array)$dba_checklists_user_plan)){
            $validator = Validator::make($request->all(),
                array(
                    'user' => 'required|exists:mysql2.users,Email',
                    'checklists'=>'required',
                ));
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }else {
                foreach ($dba_checklists_user_plan as $dba){
                    $dba->checked=(in_array($dba->checklist_id,($data['checklists'])))?1:0;
                    $dba->save();
                }

                if($dba->save()){
                    Session::flash('success', Lang::get('main.insert').Lang::get('main.dba_checklists_user_plan'));
                    return Redirect::to("admin/dba_checklists_user_plan/$user_id/edit");
                }
            }
        }else{
            return abort(404);
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $dba_checklists_user_plan=DBAChecklistsUsersPlan::where('user_id',$id)->get();
        if(count((array)$dba_checklists_user_plan)){
            foreach ($dba_checklists_user_plan as $dba){
                $dba->delete();
            }
        }
    }

    public function autoCompleteUsers(Request $request)
    {
        if($request->get('query')){
            $query=$request->get('query');
            $data = NormalUser::where('Email','LIKE', "%$query%")->take(10)->get();
            $output='<ul id="users-emails" class="dropdown-menu"
                    style="display:block; position:relative">';
            foreach ($data as $row){
                $output.='<li><a href="#">'.$row->Email.'</a></li>';
            }
            $output.='</ul>';
            echo $output;
        }
    }

}
