<?php

namespace App\Http\Controllers\Admin;

use App\Models\Courses;
use App\Models\CustomChargeTransaction;
use App\Models\custom;
use App\Models\customUserCourse;
use App\Models\CustomUsersCourses;
use App\Models\NormalUser;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class CustomUserCourseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $courses = Courses::pluck('name','id')->toArray();
        $transaction = CustomChargeTransaction::pluck('id')->toArray();
        return view('auth.custom_user_courses.view',compact('courses','transaction'));
    }

    function search(Request $request)
    {
        $data = $request->input();
        $custom_user_courses = CustomUsersCourses::leftjoin('users','users.id','=','custom_users_courses.user_id')
            ->leftjoin('courses','courses.id','=','custom_users_courses.course_id')
            ->select('custom_users_courses.*','users.Email as user_email','courses.name as course_name');
        if (isset($data['id']) && !empty($dcustom)) {
            $id = $data['id'];
            $custom_user_courses = $custom_user_courses->where('custom_users_courses.id', '=', "$id");
        }
        if (isset($data['diploma']) && !empty($data['diploma'])) {
            $diploma = $data['diploma'];
            $custom_user_courses = $custom_user_courses->where('diplomas.name','LIKE', "%$diploma%");
        }

        if (isset($data['course']) && !empty($data['course'])) {
            $course = $data['course'];
            $custom_user_courses = $custom_user_courses->where('courses.id','=', $course);
        }
        if (isset($data['user']) && !empty($data['user'])) {
            $user = $data['user'];
            $custom_user_courses = $custom_user_courses->where('users.Email','LIKE', "%$user%");
        }

        if (isset($data['sort']) && !empty($data['sort'])) {
            $sort = $data['sort'];
            $custom_user_courses = $custom_user_courses->where('custom_users_courses.sort', '=', $sort);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $custom_time_to = $data['created_time_to'];
            $custom_user_courses = $custom_user_courses->whereBetween('custom_users_courses.createtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }

        $iTotalRecords = $custom_user_courses->count();
        $iDisplayLength = (int)$data['length'];
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = (int)$data['start'];
        $sEcho = (int)$data['draw'];
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = min($end, $iTotalRecords);
        switch ($data['order'][0]['column']) {
            case 0:
	        default:
                $columnName = 'custom_users_courses.id';
                break;
            case 2:
                $columnName = 'custom_users_courses.createtime';
                break;
            case 3:
                $columnName = 'courses.name';
                break;
            case 4:
                $columnName = 'users.Email';
                break;
            case 5:
                $columnName = 'custom_users_courses.sort';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $custom_user_courses = $custom_user_courses->where(function ($q) use ($search) {
                $q->Where('custom_users_courses.id', '=', $search)
                    ->orWhere('courses.name', 'LIKE', "%$search%")
                    ->orWhere('users.Email', 'LIKE', "%$search%")
                    ->orWhere('custom_users_courses.sort', '=', $search);
            });
        }

        $custom_user_courses=$custom_user_courses->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        foreach ($custom_user_courses as $custom_user_course) {
            $course_name = $custom_user_course->course_name;
            $user_email = $custom_user_course->user_email;
            if(PerUser('courses_edit') && $course_name !=''){
                $course_name= '<a target="_blank" href="' . URL('admin/courses/' . $custom_user_course->course_id . '/edit') . '">' . $course_name . '</a>';
            }
            if(PerUser('normal_user_edit') && $user_email !=''){
                $user_email= '<a target="_blank" href="' . URL('admin/normal_user/' . $custom_user_course->user_id . '/edit') . '">' . $user_email . '</a>';
            }
            $records["data"][] = [
                $custom_user_course->id,
                $custom_user_course->createtime,
                $course_name,
                $user_email,
                $custom_user_course->sort,
//                '<td class="text-center">
//                                <div class="checkbox-nice checkbox-inline">
//                                    <input data-id="' . $custom_user_course->id . '" type="checkbox" ' . ((!PerUser('custom_user_courses_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('custom_user_courses_publish')) ? 'class="changeStatues"' : '') . ' ' . (($custom_user_course->published == "yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
//                                    <label for="checkbox-' . $custom_user_course->id . '">
//                                    </label>
//                                </div>
//                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $custom_user_course->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('custom_user_courses_edit')) ? '<li>
                                            <a href="' . URL('admin/custom_user_courses/' . $custom_user_course->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('custom_user_courses_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $custom_user_course->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '
                                        ' . ((PerUser('custom_user_courses_delete_all')) ? '<li>
                                            <a class="delete_all_this" data-id="' . $custom_user_course->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete_all') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('custom_user_courses_copy')) ? '<li>
                                            <a href="'.URL('admin/custom_user_courses/copy/'.$custom_user_course->id).'" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.copy') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $transaction = CustomChargeTransaction::pluck('name', 'id');
        $courses = Courses::pluck('name', 'id');
        return view('auth.custom_user_courses.add', compact('customs', 'transaction'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'course' => 'required|exists:mysql2.courses,id',
                'user' => 'required|exists:mysql2.users,Email',
                'sort' => 'required|integer',
                'exam' => 'required|in:not exam,pass,fail',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            //$published = (isset($data['published'])) ? 'yes' : 'no';
            $custom_user_course = new CustomUsersCourses();
            $custom_user_course->course_id = $data['course'];
            $custom_user_course->user_id = NormalUser::where('Email', $data['user'])->first()->id;
            $custom_user_course->sort = $data['sort'];
            $custom_user_course->exam = $data['exam'];
            //$custom_user_course->published = $published;
            $custom_user_course->createtime = date("Y-m-d H:i:s");
//            if ($published == 'yes') {
//                $custom_user_course->published_by = Auth::user()->id;
//                $custom_user_course->published_date = date("Y-m-d H:i:s");
//            }
//            if ($published == 'no') {
//                $custom_user_course->unpublished_by = Auth::user()->id;
//                $custom_user_course->unpublished_date = date("Y-m-d H:i:s");
//            }
            $custom_user_course->lastedit_by = Auth::user()->id;
            $custom_user_course->added_by = Auth::user()->id;
            $custom_user_course->lastedit_date = date("Y-m-d H:i:s");
            $custom_user_course->added_date = date("Y-m-d H:i:s");
            if ($custom_user_course->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.custom_user_course'));
                return Redirect::to('admin/custom_user_courses/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $custom_user_course = CustomUsersCourses::findOrFail($id);
        $courses = Courses::pluck('name', 'id');
        $user=$custom_user_course->user;
        $user=isset($custom_user_course->user)?$custom_user_course->user->Email:'';
        return view('auth.custom_user_courses.edit', compact('custom_user_course','courses','user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $custom_user_course = CustomUsersCourses::findOrFail($id);
        $rules = array(
            'course' => 'required|exists:mysql2.courses,id',
            'user' => 'required|exists:mysql2.users,Email',
            'sort' => 'required|integer',
            'exam' => 'required|in:not exam,pass,fail',
        );

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            //$published = (isset($data['published'])) ? 'yes' : 'no';
//            $custom_user_course->custom_transaction_id = $data['custom'];
            $custom_user_course->course_id = $data['course'];
            $custom_user_course->user_id = NormalUser::where('Email', $data['user'])->first()->id;
            $custom_user_course->sort = $data['sort'];
            $custom_user_course->exam = $data['exam'];
//            if ($published == 'yes' && $custom_user_course->published=='no') {
//                $custom_user_course->published_by = Auth::user()->id;
//                $custom_user_course->published_date = date("Y-m-d H:i:s");
//            }
//            if ($published == 'no' && $custom_user_course->published=='yes') {
//                $custom_user_course->unpublished_by = Auth::user()->id;
//                $custom_user_course->unpublished_date = date("Y-m-d H:i:s");
//            }
//            $custom_user_course->published = $published;
            $custom_user_course->lastedit_by = Auth::user()->id;
            $custom_user_course->lastedit_date = date("Y-m-d H:i:s");
            if ($custom_user_course->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.custom_user_course'));
                return Redirect::to("admin/custom_user_courses/$custom_user_course->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $custom_user_course = CustomUsersCourses::findOrFail($id);
        $custom_user_course->delete();
    }

//    public function publish(Request $request)
//    {
//        if ($request->ajax()) {
//            $id = $request->input('id');
//            $published = $request->input('published');
//            $custom_user_course = customUserCourse::findOrFail($id);
//            if ($published == 'no') {
//                $custom_user_course->published = 'no';
//                $custom_user_course->unpublished_by = Auth::user()->id;
//                $custom_user_course->unpublished_date = date("Y-m-d H:i:s");
//            } elseif ($published == 'yes') {
//                $custom_user_course->published = 'yes';
//                $custom_user_course->published_by = Auth::user()->id;
//                $custom_user_course->published_date = date("Y-m-d H:i:s");
//            }
//            $custom_user_course->save();
//        } else {
//            return redirect(404);
//        }
//    }
    public function copy($id)
    {
        $custom_user_course = CustomUsersCourses::findOrFail($id);
        $custom_user_course->createtime = date("Y-m-d H:i:s");
        $custom_user_course->replicate()->save();
        return Redirect::to('admin/custom_user_courses/'.$custom_user_course->id.'/edit');
    }
    public function delete_all(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $custom_user_courses= CustomUsersCourses::findOrFail($id);
	        CustomUsersCourses::where('user_id',$custom_user_courses->user_id)->delete();

        } else {
            return redirect(404);
        }
    }

}
