<?php

namespace App\Http\Controllers\Admin;

use App\Models\Consulting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class ConsultingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.consulting.view');
    }


    function search(Request $request)
    {

        $data = $request->input();

        $consulting = Consulting::select('consulting.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $consulting = $consulting->where('consulting.id', '=', "$id");
        }
        if (isset($data['title']) && !empty($data['title'])) {
            $title = $data['title'];
            $consulting = $consulting->where('consulting.title', 'LIKE', "%$title%");
        }
        $iTotalRecords = $consulting->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'consulting.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'consulting.id';
                break;
            case 1:
                $columnName = 'consulting.title';
                break;


        }
        $search = $data['search']['value'];
        if ($search) {
            $consulting = $consulting->where(function ($q) use ($search) {
                $q->where('consulting.title', 'LIKE', "%$search%")
                ;
            });
        }

        $consulting = $consulting->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($consulting as $consulting) {
            $records["data"][] = [
                $consulting->id,
                $consulting->title,
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $consulting->id . '" type="checkbox" ' . ((!PerUser('consulting_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('consulting_publish')) ? 'class="changeStatues"' : '') . ' ' . (($consulting->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $consulting->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $consulting->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('consulting_edit')) ? '<li>
                                            <a href="' . URL('admin/consulting/' . $consulting->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('consulting_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $consulting->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '
                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.consulting.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'title' => 'required',
                'short_description' => 'required',
                'description' => 'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $consulting = new Consulting();
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $consulting->title = $data['title'];
            $consulting->short_description = $data['short_description'];
            $consulting->description = $data['description'];
            $consulting->added_by = Auth::user()->id;
            $consulting->added_date = date("Y-m-d H:i:s");
            $consulting->published = $published;
            if ($published == 'yes') {
                $consulting->published_by = Auth::user()->id;
                $consulting->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $consulting->unpublished_by = Auth::user()->id;
                $consulting->unpublished_date = date("Y-m-d H:i:s");
            }
            if ($consulting->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.consulting'));
                return Redirect::to('admin/consulting/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $consulting = Consulting::find($id);
        return view('auth.consulting.edit',compact('consulting'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $consulting = Consulting::find($id);
        $validator = Validator::make($request->all(),
            array(
                'title' => 'required',
                'short_description' => 'required',
                'description' => 'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $consulting->title = $data['title'];
            $consulting->short_description = $data['short_description'];
            $consulting->description = $data['description'];
            if ($published == 'yes' && $consulting->published=='no') {
                $consulting->published_by = Auth::user()->id;
                $consulting->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $consulting->published=='yes') {
                $consulting->unpublished_by = Auth::user()->id;
                $consulting->unpublished_date = date("Y-m-d H:i:s");
            }
            $consulting->published = $published;
            $consulting->lastedit_by = Auth::user()->id;
            $consulting->lastedit_date = date("Y-m-d H:i:s");
            if ($consulting->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.consulting'));
                return Redirect::to("admin/consulting/$consulting->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $consulting = Consulting::findOrFail($id);
        $consulting->delete();
    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $consulting = Consulting::findOrFail($id);
            if ($published == 'no') {
                $consulting->published = 'no';
                $consulting->unpublished_by = Auth::user()->id;
                $consulting->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
                $consulting->published = 'yes';
                $consulting->published_by = Auth::user()->id;
                $consulting->published_date = date("Y-m-d H:i:s");
            }
            $consulting->save();
        } else {
            return redirect(404);
        }
    }
}
