<?php

namespace App\Http\Controllers\Admin;

use App\Models\BrochuresTracking;
use App\Models\sessionUsers;
use App\Models\NormalUser;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Session;
use DB;

class BrochuresTrackingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->ajax()){
            $data=$request->input();
            $brochures_tracking=BrochuresTracking::select(
                'brochures_tracking.id',
                'users.FullName',
                'users.Email',
                'brochures_tracking.type',
                'brochures_tracking.filename',
                'brochures_tracking.full_path',
                'brochures_tracking.user_agent',
                'brochures_tracking.current_url',
                'brochures_tracking.created_at'
            )->leftJoin('users','users.id','=','brochures_tracking.user_id');
            if (isset($data['id']) && !empty($data['id'])) {
                $id = $data['id'];
                $brochures_tracking = $brochures_tracking->where('brochures_tracking.id', '=', $id);
            }
            if (isset($data['FullName']) && !empty($data['FullName'])) {
                $FullName = $data['FullName'];
                $brochures_tracking = $brochures_tracking->where('users.FullName', 'LIKE', '%'.$FullName.'%');
            }
            if (isset($data['Email']) && !empty($data['Email'])) {
                $Email = $data['Email'];
                $brochures_tracking = $brochures_tracking->where('users.Email', 'LIKE', '%'.$Email.'%');
            }
            if (isset($data['type']) && !empty($data['type'])) {
                $type = $data['type'];
                $brochures_tracking = $brochures_tracking->where('brochures_tracking.type', 'LIKE', '%'.$type.'%');
            }
            if (isset($data['filename']) && !empty($data['filename'])) {
                $filename = $data['filename'];
                $brochures_tracking = $brochures_tracking->where('brochures_tracking.filename', 'LIKE', '%'.$filename.'%');
            }
            if (isset($data['full_path']) && !empty($data['full_path'])) {
                $full_path = $data['full_path'];
                $brochures_tracking = $brochures_tracking->where('brochures_tracking.full_path', 'LIKE', '%'.$full_path.'%');
            }
            if (isset($data['user_agent']) && !empty($data['user_agent'])) {
                $user_agent = $data['user_agent'];
                $brochures_tracking = $brochures_tracking->where('brochures_tracking.user_agent', 'LIKE', '%'.$user_agent.'%');
            }
            if (isset($data['current_url']) && !empty($data['current_url'])) {
                $current_url = $data['current_url'];
                $brochures_tracking = $brochures_tracking->where('brochures_tracking.current_url', 'LIKE', '%'.$current_url.'%');
            }
            if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
                $created_time_from = $data['created_time_from'];
                $created_time_to = $data['created_time_to'];
                $brochures_tracking = $brochures_tracking->whereBetween('brochures_tracking.created_at', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
            }


            $iTotalRecords = $brochures_tracking->get()->count();
            $iDisplayLength = intval($data['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($data['start']);
            $sEcho = intval($data['draw']);
            $records = [];
            $records["data"] = [];
            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            $columnName = 'brochures_tracking.id';
            switch ($data['order'][0]['column']) {
                case 0:
                    $columnName = 'brochures_tracking.id';
                    break;
                case 1:
                    $columnName = 'users.FullName';
                    break;
                case 2:
                    $columnName = 'users.Email';
                    break;
                case 3:
                    $columnName = 'brochures_tracking.type';
                    break;
                case 4:
                    $columnName = 'brochures_tracking.filename';
                    break;
                case 5:
                    $columnName = 'brochures_tracking.full_path';
                    break;
                case 6:
                    $columnName = 'brochures_tracking.user_agent';
                    break;
                case 7:
                    $columnName = 'brochures_tracking.current_url';
                    break;
                case 8:
                    $columnName = 'brochures_tracking.created_at';
                    break;

            }

            $search = $data['search']['value'];
            if ($search) {
                $brochures_tracking = $brochures_tracking->where(function ($q) use ($search) {
                    $q->where('users.Email', 'LIKE', "%$search%")
                        ->orWhere('users.id', '=', $search);
                });
            }
            $brochures_tracking = $brochures_tracking->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
                ;//->get();
            $brochures_tracking=$brochures_tracking->get();
            foreach ($brochures_tracking as $item) {
                $records["data"][] = [
                    $item->id,
                    $item->FullName,
                    $item->Email,
                    $item->type,
                    $item->filename,
                    $item->full_path,
                    $item->user_agent,
                    $item->current_url,
                    $item->created_at->format('Y-m-d H:i:s'),
                    '',
                ];
            }
            if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }
            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $records['postData'] = $data;
            //return response()->json($data)->setCallback($request->input('callback'));
            return response()->json($records)->setCallback($request->input('callback'));

        }
        return view('auth.brochures_tracking.view');
    }

    function search(Request $request)
    {
        $data = $request->input();
        $abuses = sessionUsers::join('users','users.id','=','session_users.user_id')
                    ->select('users.id','users.id as user_id','users.Email as user_email',DB::raw('COUNT(session_users.id) as abuses_count'))->groupBy('session_users.user_id');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $abuses = $abuses->where('users.id', '=', $id);
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $abuses = $abuses->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['date_from']) && !empty($data['date_from']) && isset($data['date_to']) && !empty($data['date_to'])) {
            $date_from = $data['date_from'];
            $date_to = $data['date_to'];
            $abuses = $abuses->whereBetween('session_users.createdtime', [$date_from .' 00:00:00', $date_to.' 23:59:59']);
        }
        if (isset($data['count']) && !empty($data['count'])) {
            $abuses_count = $data['count'];
            $abuses = $abuses->havingRaw("COUNT(*)=$abuses_count"); //where('abuses_count', '=', "$abuses_count");
        }
        $iTotalRecords = $abuses->get()->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'users.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'users.id';
                break;
            case 1:
                $columnName = 'users.Email';
                break;
            case 2:
                $columnName = 'abuses_count';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $abuses = $abuses->where(function ($q) use ($search) {
                $q->where('users.Email', 'LIKE', "%$search%")
                    ->orWhere('users.id', '=', $search);
            });
        }

        $abuses = $abuses->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($abuses as $abuse) {
            $user_email = $abuse->user_email;
            if(PerUser('users_edit') && $user_email !=''){
                $user_email= '<a target="_blank" href="' . URL('admin/normal_user/' . $abuse->user_id . '/edit') . '">' . $user_email . '</a>';
            }
            $records["data"][] = [
                $abuse->user_id,
                $user_email,
                $abuse->abuses_count,
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

}
