<?php

namespace App\Http\Controllers\Admin;

use App\Models\AccreditationPartnersCountries;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class AccreditationPartnersCountriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.accreditation_partners_countries.view');
    }


    function search(Request $request)
    {

        $data = $request->input();

        $accreditation_partners_countries = AccreditationPartnersCountries::select('accreditation_partners_countries.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $accreditation_partners_countries = $accreditation_partners_countries->where('accreditation_partners_countries.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $accreditation_partners_countries = $accreditation_partners_countries->where('accreditation_partners_countries.name', 'LIKE', "%$name%");
        }
        if (isset($data['type']) && !empty($data['type'])) {
            $type = $data['type'];
            $accreditation_partners_countries = $accreditation_partners_countries->where('accreditation_partners_countries.type',$type);
        }if (isset($data['partner_country_type']) && !empty($data['partner_country_type'])) {
            $partner_country_type = $data['partner_country_type'];
            $accreditation_partners_countries = $accreditation_partners_countries->where('accreditation_partners_countries.partner_country_type',$partner_country_type);
        }
        $iTotalRecords = $accreditation_partners_countries->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'accreditation_partners_countries.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'accreditation_partners_countries.id';
                break;
            case 1:
                $columnName = 'accreditation_partners_countries.type';
                break;
            case 2:
                $columnName = 'accreditation_partners_countries.partner_country_type';
                break;
            case 3:
                $columnName = 'accreditation_partners_countries.name';
                break;

        }
        $search = $data['search']['value'];
        if ($search) {
            $accreditation_partners_countries = $accreditation_partners_countries->where(function ($q) use ($search) {
                $q->where('accreditation_partners_countries.name', 'LIKE', "%$search%")
                    ->orWhere('accreditation_partners_countries.type', 'LIKE', "%$search%")
                ;
            });
        }

        $accreditation_partners_countries = $accreditation_partners_countries->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($accreditation_partners_countries as $accreditation_partners_countries) {
            $records["data"][] = [
                $accreditation_partners_countries->id,
                $accreditation_partners_countries->type,
                $accreditation_partners_countries->partner_country_type,
                $accreditation_partners_countries->name,
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $accreditation_partners_countries->id . '" type="checkbox" ' . ((!PerUser('accreditation_partners_countries_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('accreditation_partners_countries_publish')) ? 'class="changeStatues"' : '') . ' ' . (($accreditation_partners_countries->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $accreditation_partners_countries->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $accreditation_partners_countries->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('accreditation_partners_countries_edit')) ? '<li>
                                            <a href="' . URL('admin/accreditation_partners_countries/' . $accreditation_partners_countries->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('accreditation_partners_countries_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $accreditation_partners_countries->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '
                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.accreditation_partners_countries.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required',
                'type' => 'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $accreditation_partners_countries = new AccreditationPartnersCountries();
            if ($request->hasFile('pic')) {
                $pic = $request->file('pic');
                $picName = uploadFileToE3melbusiness($pic);
                $accreditation_partners_countries->pic_path = $picName;
            }
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $accreditation_partners_countries->name = $data['name'];
            $accreditation_partners_countries->url = str_slug($data['name'], '-');
            $accreditation_partners_countries->partner_country_type = $data['partner_country_type'];
            $accreditation_partners_countries->type = $data['type'];
            $accreditation_partners_countries->added_by = Auth::user()->id;
            $accreditation_partners_countries->added_date = date("Y-m-d H:i:s");
            $accreditation_partners_countries->published = $published;
            if ($published == 'yes') {
                $accreditation_partners_countries->published_by = Auth::user()->id;
                $accreditation_partners_countries->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $accreditation_partners_countries->unpublished_by = Auth::user()->id;
                $accreditation_partners_countries->unpublished_date = date("Y-m-d H:i:s");
            }
            if ($accreditation_partners_countries->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.accreditation_partners_countries'));
                return Redirect::to('admin/accreditation_partners_countries/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $accreditation_partners_countries = AccreditationPartnersCountries::find($id);
        return view('auth.accreditation_partners_countries.edit',compact('accreditation_partners_countries'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $accreditation_partners_countries = AccreditationPartnersCountries::find($id);
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required',
                'type' => 'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            if ($request->hasFile('pic')) {
                $pic = $request->file('pic');
                $picName = uploadFileToE3melbusiness($pic);
                $accreditation_partners_countries->pic_path = $picName;
            }
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $accreditation_partners_countries->name = $data['name'];
            $accreditation_partners_countries->partner_country_type = $data['partner_country_type'];
            $accreditation_partners_countries->type = $data['type'];
            if ($published == 'yes' && $accreditation_partners_countries->published=='no') {
                $accreditation_partners_countries->published_by = Auth::user()->id;
                $accreditation_partners_countries->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $accreditation_partners_countries->published=='yes') {
                $accreditation_partners_countries->unpublished_by = Auth::user()->id;
                $accreditation_partners_countries->unpublished_date = date("Y-m-d H:i:s");
            }
            $accreditation_partners_countries->published = $published;
            $accreditation_partners_countries->lastedit_by = Auth::user()->id;
            $accreditation_partners_countries->lastedit_date = date("Y-m-d H:i:s");
            if ($accreditation_partners_countries->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.accreditation_partners_countries'));
                return Redirect::to("admin/accreditation_partners_countries/$accreditation_partners_countries->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $accreditation_partners_countries = AccreditationPartnersCountries::findOrFail($id);
        $accreditation_partners_countries->delete();
    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $accreditation_partners_countries = AccreditationPartnersCountries::findOrFail($id);
            if ($published == 'no') {
                $accreditation_partners_countries->published = 'no';
                $accreditation_partners_countries->unpublished_by = Auth::user()->id;
                $accreditation_partners_countries->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
                $accreditation_partners_countries->published = 'yes';
                $accreditation_partners_countries->published_by = Auth::user()->id;
                $accreditation_partners_countries->published_date = date("Y-m-d H:i:s");
            }
            $accreditation_partners_countries->save();
        } else {
            return redirect(404);
        }
    }
}
