<?php

namespace App\Http\Controllers\Admin;

use App\Models\AccreditationPartnersCountriesCategories;
use App\Models\AccreditationPartnersCountriesCategoriesDetails;
use App\Models\AccreditationPartnersDetailsImages;
use Exception;
use Illuminate\Foundation\Application;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class AccreditationPartnersCountriesCategoriesDetailsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        return view('auth.accreditation_partners_countries_categories_details.view');
    }


    function search(Request $request)
    {

        $data = $request->input();

        $accreditation_partners_countries_categories_details = AccreditationPartnersCountriesCategoriesDetails::select('accreditation_partners_countries_categories_details.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $accreditation_partners_countries_categories_details = $accreditation_partners_countries_categories_details->where('accreditation_partners_countries_categories_details.id', '=', "$id");
        }
        if (isset($data['title']) && !empty($data['title'])) {
            $title = $data['title'];
            $accreditation_partners_countries_categories_details = $accreditation_partners_countries_categories_details->where('accreditation_partners_countries_categories_details.title', 'LIKE', "%$title%");
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $accreditation_partners_countries_categories_details = $accreditation_partners_countries_categories_details->where('accreditation_partners_countries_categories_details.url', 'LIKE', "%$url%");
        }
        if (isset($data['type']) && !empty($data['type'])) {
            $type = $data['type'];
            $accreditation_partners_countries_categories_details = $accreditation_partners_countries_categories_details->where('accreditation_partners_countries_categories_details.type',$type);
        }if (isset($data['place']) && !empty($data['place'])) {
            $place = $data['place'];
            $accreditation_partners_countries_categories_details = $accreditation_partners_countries_categories_details->where('accreditation_partners_countries_categories_details.place',$place);
        }
        $iTotalRecords = $accreditation_partners_countries_categories_details->count('accreditation_partners_countries_categories_details.id');
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'accreditation_partners_countries_categories_details.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'accreditation_partners_countries_categories_details.id';
                break;
            case 1:
                $columnName = 'accreditation_partners_countries_categories_details.type';
                break;
            case 2:
                $columnName = 'accreditation_partners_countries_categories_details.title';
                break;
            case 3:
                $columnName = 'accreditation_partners_countries_categories_details.url';
                break;

        }
        $search = $data['search']['value'];
        if ($search) {
            $accreditation_partners_countries_categories_details = $accreditation_partners_countries_categories_details->where(function ($q) use ($search) {
                $q->where('accreditation_partners_countries_categories_details.title', 'LIKE', "%$search%")
                    ->orWhere('accreditation_partners_countries_categories_details.type', 'LIKE', "%$search%")
                    ->orWhere('accreditation_partners_countries_categories_details.url', 'LIKE', "%$search%")
                ;
            });
        }

        $accreditation_partners_countries_categories_details = $accreditation_partners_countries_categories_details->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($accreditation_partners_countries_categories_details as $accreditation_partners_countries_categories_details) {
            $records["data"][] = [
                $accreditation_partners_countries_categories_details->id,
                $accreditation_partners_countries_categories_details->type,
                $accreditation_partners_countries_categories_details->title,
                $accreditation_partners_countries_categories_details->url,
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $accreditation_partners_countries_categories_details->id . '" type="checkbox" ' . ((!PerUser('accreditation_partners_countries_categories_details_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('accreditation_partners_countries_categories_details_publish')) ? 'class="changeStatues"' : '') . ' ' . (($accreditation_partners_countries_categories_details->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $accreditation_partners_countries_categories_details->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $accreditation_partners_countries_categories_details->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('accreditation_partners_countries_categories_details_edit')) ? '<li>
                                            <a href="' . URL('admin/apccd/' . $accreditation_partners_countries_categories_details->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('accreditation_partners_countries_categories_details_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $accreditation_partners_countries_categories_details->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '
                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        return view('auth.accreditation_partners_countries_categories_details.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function store(Request $request)
    {
//        print_r($request->all());die();
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'category' => 'required',
                'type' => 'required',
                'title' => 'required',
                'url' => 'required',
                'description' => 'required',
                'place' => 'required',
                'logo' => 'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $accreditation_partners_countries_categories_details = new AccreditationPartnersCountriesCategoriesDetails();
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $accreditation_partners_countries_categories_details->category_id = $data['category'];
            $accreditation_partners_countries_categories_details->type = $data['type'];
            $accreditation_partners_countries_categories_details->title = $data['title'];
            $accreditation_partners_countries_categories_details->url = $data['url'];
            $accreditation_partners_countries_categories_details->sort = $data['sort'];
            $accreditation_partners_countries_categories_details->place = $data['place'];
            if ($request->hasFile('logo')) {
                $pic = $request->file('logo');
                $picName = uploadFileToE3melbusiness($pic);
                $accreditation_partners_countries_categories_details->logo = $picName;
            }
            $accreditation_partners_countries_categories_details->description = $data['description'];
            $accreditation_partners_countries_categories_details->added_by = Auth::user()->id;
            $accreditation_partners_countries_categories_details->added_date = date("Y-m-d H:i:s");
            $accreditation_partners_countries_categories_details->published = $published;
            if ($published == 'yes') {
                $accreditation_partners_countries_categories_details->published_by = Auth::user()->id;
                $accreditation_partners_countries_categories_details->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $accreditation_partners_countries_categories_details->unpublished_by = Auth::user()->id;
                $accreditation_partners_countries_categories_details->unpublished_date = date("Y-m-d H:i:s");
            }
            if ($accreditation_partners_countries_categories_details->save()) {
                if ($request->hasFile('images')) {
                    $pics = $request->file('images');
                    foreach ($pics as $pic) {
                        $accreditation_partners_details_images = new AccreditationPartnersDetailsImages();
                        $picName = uploadFileToE3melbusiness($pic);
                        $accreditation_partners_details_images->image = $picName;
                        $accreditation_partners_details_images->category_details_id = $accreditation_partners_countries_categories_details->id;
                        $accreditation_partners_details_images->save();
                    }
                }
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.accreditation_partners_countries_categories_details'));
                return Redirect::to('admin/apccd/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $accreditation_partners_countries_categories_details = AccreditationPartnersCountriesCategoriesDetails::find($id);
        return view('auth.accreditation_partners_countries_categories_details.edit',compact('accreditation_partners_countries_categories_details'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param  int  $id
     * @return Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $accreditation_partners_countries_categories_details = AccreditationPartnersCountriesCategoriesDetails::find($id);
        $validator = Validator::make($request->all(),
            array(
                'category' => 'required',
                'type' => 'required',
                'title' => 'required',
                'url' => 'required',
                'description' => 'required',
                'place' => 'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $accreditation_partners_countries_categories_details->category_id = $data['category'];
            $accreditation_partners_countries_categories_details->type = $data['type'];
            $accreditation_partners_countries_categories_details->title = $data['title'];
            $accreditation_partners_countries_categories_details->url = $data['url'];
            $accreditation_partners_countries_categories_details->sort = $data['sort'];
            $accreditation_partners_countries_categories_details->place = $data['place'];
            if ($request->hasFile('logo')) {
                $pic = $request->file('logo');
                $picName = uploadFileToE3melbusiness($pic);
                $accreditation_partners_countries_categories_details->logo = $picName;
            }
            $accreditation_partners_countries_categories_details->description = $data['description'];
            $accreditation_partners_countries_categories_details->added_by = Auth::user()->id;
            $accreditation_partners_countries_categories_details->added_date = date("Y-m-d H:i:s");
            $accreditation_partners_countries_categories_details->published = $published;
            if ($published == 'yes') {
                $accreditation_partners_countries_categories_details->published_by = Auth::user()->id;
                $accreditation_partners_countries_categories_details->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $accreditation_partners_countries_categories_details->unpublished_by = Auth::user()->id;
                $accreditation_partners_countries_categories_details->unpublished_date = date("Y-m-d H:i:s");
            }
            if ($accreditation_partners_countries_categories_details->save()) {
                if ($request->hasFile('images')) {
                    $pics = $request->file('images');
                    foreach ($pics as $pic) {
                        $accreditation_partners_details_images = new AccreditationPartnersDetailsImages();
                        $picName = uploadFileToE3melbusiness($pic);
                        $accreditation_partners_details_images->image = $picName;
                        $accreditation_partners_details_images->category_details_id = $accreditation_partners_countries_categories_details->id;
                        $accreditation_partners_details_images->save();
                    }
                }
                Session::flash('success', Lang::get('main.update') . Lang::get('main.accreditation_partners_countries_categories_details'));
                return Redirect::to('admin/apccd/'.$accreditation_partners_countries_categories_details->id.'/edit');
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws Exception
     */
    public function deleteImage(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $accreditation_partners_details_images = AccreditationPartnersDetailsImages::find($id);
            if (file_exists(assetURL($accreditation_partners_details_images->image)))
                unlink(assetURL($accreditation_partners_details_images->image));
            $accreditation_partners_details_images->delete();
            return \response()->json(['status' => true, 'message' => 'success']);
        }
        else {
            return \response()->json(['status' => false, 'message' => 'can not delete!']);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return void
     * @throws Exception
     */
    public function destroy($id)
    {
        $accreditation_partners_countries_categories_details = AccreditationPartnersCountriesCategoriesDetails::findOrFail($id);
        $accreditation_partners_countries_categories_details->delete();
    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $accreditation_partners_countries_categories_details = AccreditationPartnersCountriesCategoriesDetails::findOrFail($id);
            if ($published == 'no') {
                $accreditation_partners_countries_categories_details->published = 'no';
                $accreditation_partners_countries_categories_details->unpublished_by = Auth::user()->id;
                $accreditation_partners_countries_categories_details->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
                $accreditation_partners_countries_categories_details->published = 'yes';
                $accreditation_partners_countries_categories_details->published_by = Auth::user()->id;
                $accreditation_partners_countries_categories_details->published_date = date("Y-m-d H:i:s");
            }
            $accreditation_partners_countries_categories_details->save();
        } else {
            return redirect(404);
        }
    }
}
