<?php

namespace App\Http\Controllers\Admin;

use App\Models\AccreditationPartnersCertificates;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class AccreditationPartnersCertificatesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.accreditation_certificates.view');
    }


    function search(Request $request)
    {

        $data = $request->input();

        $accreditation_certificates = AccreditationPartnersCertificates::select('accreditation_partners_certificates.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $accreditation_certificates = $accreditation_certificates->where('accreditation_partners_certificates.id', '=', "$id");
        }
        if (isset($data['link']) && !empty($data['link'])) {
            $link = $data['link'];
            $accreditation_certificates = $accreditation_certificates->where('accreditation_partners_certificates.link',$link);
        }
        $iTotalRecords = $accreditation_certificates->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'accreditation_partners_countries.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'accreditation_partners_certificates.id';
                break;
            case 1:
                $columnName = 'accreditation_partners_certificates.link';
                break;

        }
        $search = $data['search']['value'];
        if ($search) {
            $accreditation_certificates = $accreditation_certificates->where(function ($q) use ($search) {
                $q->where('accreditation_partners_certificates.link', 'LIKE', "%$search%");
            });
        }

        $accreditation_certificates = $accreditation_certificates->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($accreditation_certificates as $accreditation_partners_certificate) {
            $records["data"][] = [
                $accreditation_partners_certificate->id,
                $accreditation_partners_certificate->link,
                '<a class="image-link" href="#image-modal" data-toggle="modal"><img  style="width:100%;"  src="'.assetURL($accreditation_partners_certificate->image).'"></a>',
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $accreditation_partners_certificate->id . '" type="checkbox" ' . ((!PerUser('accreditation_certificates_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('accreditation_certificates_publish')) ? 'class="changeStatues"' : '') . ' ' . (($accreditation_partners_certificate->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $accreditation_partners_certificate->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $accreditation_partners_certificate->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('accreditation_certificates_edit')) ? '<li>
                                            <a href="' . URL('admin/accreditation_certificates/' . $accreditation_partners_certificate->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('accreditation_certificates_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $accreditation_partners_certificate->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '
                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.accreditation_certificates.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'image' => 'required|file',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $accreditation_certificates = new AccreditationPartnersCertificates();
            if ($request->hasFile('image')) {
                $pic = $request->file('image');
                $picName = uploadFileToE3melbusiness($pic);
                $accreditation_certificates->image = $picName;
                $accreditation_certificates->link = str_slug(explode('.', $picName)[0], '-');
            }
            $published = (isset($data['published'])) ? 'yes' : 'no';
            if ($published == 'yes') {
                $accreditation_certificates->published_at = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $accreditation_certificates->unpublished_at = date("Y-m-d H:i:s");
            }
            if ($accreditation_certificates->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.accreditation_certificates'));
                return Redirect::to('admin/accreditation_certificates/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $accreditation_certificates = AccreditationPartnersCertificates::find($id);
        return view('auth.accreditation_certificates.edit',compact('accreditation_certificates'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $accreditation_certificates = AccreditationPartnersCertificates::find($id);

            if ($request->hasFile('image')) {
                $pic = $request->file('image');
                $picName = uploadFileToE3melbusiness($pic);
                $accreditation_certificates->image = $picName;
            }
            $published = (isset($data['published'])) ? 'yes' : 'no';
            if ($published == 'yes' && $accreditation_certificates->published=='no') {
                $accreditation_certificates->published_at = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $accreditation_certificates->published=='yes') {
                $accreditation_certificates->unpublished_at = date("Y-m-d H:i:s");
            }
            $accreditation_certificates->published = $published;
            if ($accreditation_certificates->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.accreditation_certificates'));
                return Redirect::to("admin/accreditation_certificates/ $accreditation_certificates->id/edit");
            }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $accreditation_certificates = AccreditationPartnersCertificates::findOrFail($id);
        $accreditation_certificates->delete();
    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $accreditation_certificates = AccreditationPartnersCertificates::findOrFail($id);
            if ($published == 'no') {
                $accreditation_certificates->published = 'no';
                $accreditation_certificates->unpublished_at = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
                $accreditation_certificates->published = 'yes';
                $accreditation_certificates->published_at = date("Y-m-d H:i:s");
            }
            $accreditation_certificates->save();
        } else {
            return redirect(404);
        }
    }
}
