<?php

namespace App\Http\Controllers\Admin;

use App\Models\AcademyAlumni;
use App\Http\Controllers\Controller;
use App\Models\academy_alumni;
use App\Models\OldUrls;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;

class AcademyAlumniController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.academy_alumni.view');
    }

    function search(Request $request)
    {

        $data = $request->input();
        $academy_alumni = AcademyAlumni::select('academy_alumni.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $academy_alumni = $academy_alumni->where('academy_alumni.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $academy_alumni = $academy_alumni->where('academy_alumni.name', 'LIKE', "%$name%");
        }
        if (isset($data['sort']) && !empty($data['sort'])) {
            $sort = $data['sort'];
            $academy_alumni = $academy_alumni->where('academy_alumni.sort', $sort);
        }
        if (isset($data['pic']) && !empty($data['pic'])) {
            $pic = $data['pic'];
            $academy_alumni = $academy_alumni->where('academy_alumni.pic', 'LIKE', "%$pic%");
        }
        if (isset($data['linkedin']) && !empty($data['linkedin'])) {
            $linkedin = $data['linkedin'];
            $academy_alumni = $academy_alumni->where('academy_alumni.linkedin', 'LIKE', "%$linkedin%");
        }
        if (isset($data['facebook']) && !empty($data['facebook'])) {
            $facebook = $data['facebook'];
            $academy_alumni = $academy_alumni->where('academy_alumni.facebook', 'LIKE', "%$facebook%");
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $academy_alumni = $academy_alumni->where('academy_alumni.url', 'LIKE', "%$url%");
        }


        $iTotalRecords = $academy_alumni->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'academy_alumni.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'academy_alumni.id';
                break;
            case 1:
                $columnName = 'academy_alumni.name';
                break;
            case 2:
                $columnName = 'academy_alumni.sort';
                break;
            case 3:
                $columnName = 'academy_alumni.pic';
                break;
            case 4:
                $columnName = 'academy_alumni.linkedin';
                break;
            case 5:
                $columnName = 'academy_alumni.facebook';
                break;
            case 6:
                $columnName = 'academy_alumni.url';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $academy_alumni = $academy_alumni->where(function ($q) use ($search) {
                $q->where('academy_alumni.name', 'LIKE', "%$search%")
                    ->orWhere('academy_alumni.pic', 'LIKE', "%$search%")
                    ->orWhere('academy_alumni.linkedin', 'LIKE', "%$search%")
                    ->orWhere('academy_alumni.facebook', 'LIKE', "%$search%")
                    ->orWhere('academy_alumni.url', 'LIKE', "%$search%")
                    ->orWhere('academy_alumni.description', 'LIKE', "%$search%")
                    ->orWhere('academy_alumni.id', '=', $search);
            });
        }

        $academy_alumni = $academy_alumni->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($academy_alumni as $academy_alumni) {
            $academy_alumni=makeDefaultImageGeneral($academy_alumni,'pic');
            $records["data"][] = [
                $academy_alumni->id,
                $academy_alumni->name,
                $academy_alumni->sort,
                '<a class="image-link" href="#image-modal" data-toggle="modal"><img  style="width:100%;"  src="' . assetURL($academy_alumni->pic) . '"></a>',
                '<a href="' . $academy_alumni->linkedin . '" target="_blank">' . $academy_alumni->linkedin . '</a>',
                '<a href="' . $academy_alumni->facebook . '" target="_blank">' . $academy_alumni->facebook . '</a>',
                '<a href="' . e3mURL('instractor/' . $academy_alumni->url) . '" target="_blank">' . $academy_alumni->url . '</a>',
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $academy_alumni->id . '" type="checkbox" ' . ((!PerUser('academy_alumni_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('academy_alumni_publish')) ? 'class="changeStatues"' : '') . ' ' . (($academy_alumni->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $academy_alumni->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $academy_alumni->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('academy_alumni_edit')) ? '<li>
                                            <a href="' . URL('admin/academy_alumni/' . $academy_alumni->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('academy_alumni_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $academy_alumni->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.academy_alumni.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required',
                'short_description' => 'required',
                'description' => 'required',
                'pic' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
                'cv' => 'mimes:pdf|required|max:5000',
                'url' => 'required|unique:mysql2.academy_alumni,url',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $facebook = (isset($data['facebook'])) ? $data['facebook'] : '';
            $linkedin = (isset($data['linkedin'])) ? $data['linkedin'] : '';
            $pic = $request->file('pic');
            $cv = $request->file('cv');
            $picName = uploadFileToE3melbusiness($pic);
            $cvName = uploadFileToCustomFolderE3melbusiness($cv,'assets/academy_alumni/');
            $academy_alumni = new AcademyAlumni();
            $academy_alumni->sort = $request->sort?$request->sort:0;
            $academy_alumni->name = $data['name'];
            $academy_alumni->description = $data['description'];
            $academy_alumni->short_description = $data['short_description'];
            $academy_alumni->pic = $picName;
            $academy_alumni->cv = $cvName;
            $academy_alumni->linkedin = $linkedin;
            $academy_alumni->facebook = $facebook;
            $academy_alumni->url = str_replace(' ','-',$data['url']);
            $academy_alumni->published = $published;
            if ($published == 'yes') {
                $academy_alumni->published_by = Auth::user()->id;
                $academy_alumni->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $academy_alumni->unpublished_by = Auth::user()->id;
                $academy_alumni->unpublished_date = date("Y-m-d H:i:s");
            }
            $academy_alumni->added_by = Auth::user()->id;
            $academy_alumni->added_date = date("Y-m-d H:i:s");
            $academy_alumni->lastedit_by = Auth::user()->id;
            $academy_alumni->lastedit_date = date("Y-m-d H:i:s");
            if ($academy_alumni->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.academy_alumni'));
                return Redirect::to('admin/academy_alumni/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $academy_alumni = AcademyAlumni::find($id);
        return view('auth.academy_alumni.edit',compact('academy_alumni'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $academy_alumni = AcademyAlumni::findOrFail($id);
        $data = $request->input();
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));
        $rules= array(
            'name' => 'required',
            'short_description' => 'required',
            'description' => 'required',
            'url' => "required|unique:mysql2.academy_alumni,url,$id,id",
        );
        if ( $request->file('pic')){
            $rules['pic']='mimes:jpeg,jpg,png,gif|required|max:5000';
        }
        if ( $request->file('cv')){
            $rules['cv']='mimes:pdf|required|max:5000';
        }
        $validator = Validator::make($request->all(),$rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            if ( $request->file('pic')){
                $pic = $request->file('pic');
                $picName = uploadFileToE3melbusiness($pic);
                $academy_alumni->pic = $picName;
            }
            if ( $request->file('cv')){
                $cv = $request->file('cv');
                $cvName = uploadFileToCustomFolderE3melbusiness($cv,'assets/academy_alumni/');
                $academy_alumni->cv = $cvName;
            }
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $facebook = (isset($data['facebook'])) ? $data['facebook'] : '';
            $linkedin = (isset($data['linkedin'])) ? $data['linkedin'] : '';
            $academy_alumni->sort = $request->sort?$request->sort:0;
            $academy_alumni->name = $data['name'];
            $academy_alumni->short_description = $data['short_description'];
            $academy_alumni->description = $data['description'];
            $academy_alumni->linkedin = $linkedin;
            $academy_alumni->facebook = $facebook;
            $old_url=$academy_alumni->url;
            $academy_alumni->url = str_replace(' ','-',$data['url']);
            if ($published == 'yes' && $academy_alumni->published=='no') {
                $academy_alumni->published_by = Auth::user()->id;
                $academy_alumni->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $academy_alumni->published=='yes') {
                $academy_alumni->unpublished_by = Auth::user()->id;
                $academy_alumni->unpublished_date = date("Y-m-d H:i:s");
            }
            $academy_alumni->published = $published;
            $academy_alumni->lastedit_by = Auth::user()->id;
            $academy_alumni->lastedit_date = date("Y-m-d H:i:s");
            if ($academy_alumni->save()) {
                if($old_url != $academy_alumni->url){
                    saveOldUrl($id,'academy_alumni',$old_url,$academy_alumni->url,Auth::user()->id,date("Y-m-d H:i:s"));
                }
                Session::flash('success', Lang::get('main.update') . Lang::get('main.academy_alumni'));
                return Redirect::to("admin/academy_alumni/$academy_alumni->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $academy_alumni = AcademyAlumni::find($id);
        if (count($academy_alumni)) {
            $academy_alumni->update(['deleted_at'=>date('Y-m-d H:i:s'),'deleted_by'=>auth()->id()]);
        }
    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $academy_alumni = AcademyAlumni::find($id);
            if ($published == 'no') {
                $old_url=$academy_alumni->url;
                $academy_alumni->url='/';
                $academy_alumni->published = 'no';
                $academy_alumni->unpublished_by = Auth::user()->id;
                $academy_alumni->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
                $old_urls=OldUrls::where('table_id',$id)->where('table_name','academy_alumni')->where('new_url','/')->first();
                $old_url='/';
                $academy_alumni->url=$old_urls->old_url;
                $academy_alumni->published = 'yes';
                $academy_alumni->published_by = Auth::user()->id;
                $academy_alumni->published_date = date("Y-m-d H:i:s");
            }
            $academy_alumni->save();
            if($old_url != $academy_alumni->url){
                saveOldUrl($id,'academy_alumni',$old_url,$academy_alumni->url,Auth::user()->id,date("Y-m-d H:i:s"));
            }
        } else {
            return redirect(404);
        }
    }
    public function import(Request  $request){
        $validator = Validator::make($request->all(),[
            'file'=>'required|mimes:csv,txt|max:'.return_bytes(ini_get('upload_max_filesize')),
        ]);
//        dd($request->file('file')->getMimeType());
        if ($validator->fails()) {
            $messages='';
            foreach($validator->errors()->all() as $error){
                $messages.=$error.' ';
            }
            return response()->json(['success'=>false,'message'=>$messages]);
        }else {
            $file=$request->file('file');
            $folder_name='academy_alumni';
            $path = '/import/'.$folder_name.'/' . date('Y/m/d').'/';
            if (!file_exists(public_path() . $path)) {
                File::makeDirectory(public_path() . $path, $mode = 0777, true, true);
            }
            $file_name=fileNewName($file->getClientOriginalName(),public_path($path));
            $file->move(public_path($path), $file_name);
            $data = [];
            if (($handle = fopen(public_path($path.$file_name), "r")) !== FALSE) {
                $headers = fgetcsv($handle, 1000, ",");
                while (($row = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    $data[] = array_combine($headers, $row);
                }
                fclose($handle);
            }
            if(!count($data)){
                return response()->json(['success'=>true,'message'=>'No data found in file uploaded']);
            }
            if(!array_key_exists('name',$data[0])
                ||!array_key_exists('short_description',$data[0])
                ||!array_key_exists('description',$data[0])
                ||!array_key_exists('linkedin',$data[0])
                ||!array_key_exists('facebook',$data[0])
                ||!array_key_exists('url',$data[0])
                ||!array_key_exists('sort',$data[0])
                ||!array_key_exists('published',$data[0])
            ){
                return response()->json(['success'=>true,'message'=>'The file you uploaded not content correct header please download the template to see the different']);
            }

            $created=0;
            $notCreated=0;

            foreach ($data as $item){
                if(!in_array($item['published'],['yes','no'])){
                    $item['published']='no';
                }
                if (strpos($item['url'], ' ') !== false) {
                    $item['url']=str_replace(' ','-',trim($item['url']));
                }
                $itemDataCollection=collect($item)->only('name','short_description','description','linkedin','facebook','url','sort','published')->toArray();
                if(!AcademyAlumni::where(collect($item)->only('name','url')->toArray())->count()){
                    AcademyAlumni::create($itemDataCollection);
                    $created++;
                }else{
                    $notCreated++;
                }
            }
            return response()->json(['success'=>true,'message'=>'Importing '.count($data).', '.$created.' has been created and '.$notCreated.' are already exist']);
        }
    }
}
